/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class FastPlotChartDraw
extends ChartDraw {
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point prev = null;
    Point next = null;
    Point last = null;
    Rectangle r = null;
    public static final int TOP_EDGE = 8;
    public static final int BOTTOM_EDGE = 4;
    public static final int RIGHT_EDGE = 2;
    public static final int LEFT_EDGE = 1;

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    public void draw(Graphics graphics, int n, int n2) {
        try {
            if (this.seriesList == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            boolean bl = false;
            if (n >= 0 && n2 >= 0 && n2 >= n) {
                bl = true;
            }
            Graphics graphics2 = graphics.create();
            boolean bl2 = this.xaxis.isLogarithmic();
            boolean bl3 = this.yaxis.isLogarithmic();
            int n3 = 0;
            int n4 = this.seriesList.size();
            int n5 = n3;
            while (n5 < n4) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n5);
                if (chartDataViewSeries.isVisible() && chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                    JCChartStyle jCChartStyle;
                    if (!bl) {
                        n = chartDataViewSeries.getFirstPoint();
                        n2 = chartDataViewSeries.getLastPoint();
                    } else {
                        int n6 = chartDataViewSeries.getLastPoint();
                        if (n < n6) {
                            n = n6;
                        }
                    }
                    double[] dArray = chartDataViewSeries.getX();
                    double[] dArray2 = chartDataViewSeries.getY();
                    double d = 0.0;
                    double d2 = this.holeValue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (bl && n > 0) {
                        d = dArray[n - 1];
                        d2 = dArray2[n - 1];
                    }
                    if ((jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                        boolean bl6 = false;
                        if (!jCLineStyle.updateGraphics(graphics2)) {
                            bl6 = true;
                        }
                        Line2D.Double double_ = new Line2D.Double();
                        JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
                        boolean bl7 = jCSymbolStyle.getShape() == 0;
                        PlotPoint plotPoint = new PlotPoint();
                        plotPoint.valid = false;
                        PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                        int n7 = n;
                        while (n7 <= n2) {
                            double d3 = dArray[n7];
                            if (bl2 && d3 <= 0.0) {
                                d3 = this.holeValue;
                            }
                            double d4 = dArray2[n7];
                            if (bl3 && d4 <= 0.0) {
                                d4 = this.holeValue;
                            }
                            plotPointArray[0].valid = false;
                            plotPointArray[1].valid = false;
                            bl4 = this.plotClip(d, d2, d3, d4, this.xlim, this.ylim, plotPointArray, bl4, this.inverted);
                            int n8 = 0;
                            while (n8 < plotPointArray.length) {
                                Color color;
                                if (!bl6 && plotPointArray[n8].valid && plotPoint.valid && this.chartType == 0) {
                                    color = null;
                                    if (this.dataObject.getColorHandler() != null) {
                                        color = this.dataObject.getColorHandler().getColor(d, d2, d3, d4);
                                        if (color == null) {
                                            color = jCLineStyle.getColor();
                                        }
                                        if (!graphics2.getColor().equals(color)) {
                                            graphics2.setColor(color);
                                        }
                                    }
                                    double_.setLine(plotPoint.px, plotPoint.py, plotPointArray[n8].px, plotPointArray[n8].py);
                                    ((Graphics2D)graphics2).draw(double_);
                                }
                                if (n8 == 0 || plotPointArray[n8].valid) {
                                    if (plotPoint.valid && plotPoint.drawPoint && !bl7) {
                                        color = null;
                                        if (this.dataObject.getColorHandler() != null) {
                                            color = this.dataObject.getColorHandler().getColor(d, d2);
                                        }
                                        jCSymbolStyle.draw(graphics, plotPoint.px, plotPoint.py, color);
                                    }
                                    plotPoint.px = plotPointArray[n8].px;
                                    plotPoint.py = plotPointArray[n8].py;
                                    plotPoint.drawPoint = plotPointArray[n8].drawPoint;
                                    plotPoint.valid = plotPointArray[n8].valid;
                                }
                                ++n8;
                            }
                            if (!bl4) {
                                plotPoint.valid = false;
                            }
                            d = d3;
                            d2 = d4;
                            ++n7;
                        }
                        if (plotPoint.valid && plotPoint.drawPoint && !bl7) {
                            Color color = null;
                            if (this.dataObject.getColorHandler() != null) {
                                color = this.dataObject.getColorHandler().getColor(d, d2);
                            }
                            jCSymbolStyle.draw(graphics, plotPoint.px, plotPoint.py, color);
                        }
                    }
                }
                ++n5;
            }
            graphics2.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        return jCDataIndex.dataView.getXAxis().vertical ? n - this.r.x : n2 - this.r.y;
    }

    public JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        int n4 = -1;
        int n5 = -1;
        JCDataIndex jCDataIndex = null;
        double d = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        int n6 = 0;
        int n7 = this.seriesList.size();
        double d2 = 0.0;
        double d3 = 0.0;
        try {
            int n8 = n6;
            while (n8 < n7) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n8);
                if (chartDataViewSeries != null && chartDataViewSeries.isVisible()) {
                    int n9 = chartDataViewSeries.getFirstPoint();
                    int n10 = chartDataViewSeries.getLastPoint();
                    if (n9 != Integer.MAX_VALUE && n10 != Integer.MAX_VALUE) {
                        double[] dArray = chartDataViewSeries.getX();
                        double[] dArray2 = chartDataViewSeries.getY();
                        int n11 = n9;
                        while (n11 <= n10) {
                            d2 = dArray[n11];
                            d3 = dArray2[n11];
                            if (!(d2 == this.holeValue || d3 == this.holeValue || d2 > this.xlim.max || d2 < this.xlim.min || d3 > this.ylim.max || d3 < this.ylim.min || bl && d2 <= 0.0 || bl2 && d3 <= 0.0)) {
                                double d4 = Double.MAX_VALUE;
                                switch (n) {
                                    case 1: {
                                        int n12 = this.xaxis.toPixel(d2, this.drawFront);
                                        d4 = this.inverted ? Math.abs(n12 - n3) : Math.abs(n12 - n2);
                                        break;
                                    }
                                    case 2: {
                                        int n13 = this.yaxis.toPixel(d3, this.drawFront);
                                        d4 = this.inverted ? Math.abs(n13 - n2) : Math.abs(n13 - n3);
                                        break;
                                    }
                                    default: {
                                        int n12 = this.xaxis.toPixel(d2, this.drawFront);
                                        int n13 = this.yaxis.toPixel(d3, this.drawFront);
                                        double d5 = d4 = this.inverted ? Math.sqrt((n13 - n2) * (n13 - n2) + (n12 - n3) * (n12 - n3)) : Math.sqrt((n12 - n2) * (n12 - n2) + (n13 - n3) * (n13 - n3));
                                    }
                                }
                                if (d4 < d) {
                                    n4 = n8;
                                    n5 = n11;
                                    d = d4;
                                }
                            }
                            ++n11;
                        }
                    }
                }
                ++n8;
            }
            if (n4 >= 0 && n5 >= 0) {
                jCDataIndex = new JCDataIndex(n5, (ChartDataViewSeries)this.seriesList.get(n4), n4);
                jCDataIndex.distance = (int)d;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    boolean plotClip(double d, double d2, double d3, double d4, MinMax minMax, MinMax minMax2, PlotPoint[] plotPointArray, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        double d5 = minMax.min;
        double d6 = minMax.max;
        double d7 = minMax2.min;
        double d8 = minMax2.max;
        boolean bl3 = true;
        boolean bl4 = true;
        int n6 = 0;
        int n7 = 0;
        boolean bl5 = false;
        boolean bl6 = true;
        if (!bl) {
            if (d2 == this.holeValue || d == this.holeValue) {
                n6 = 1;
                bl6 = false;
                bl5 = true;
            } else {
                n5 = (d > d6 ? 1 : 0) << 1;
                n4 = d < d5 ? 1 : 0;
                n3 = (d2 > d8 ? 1 : 0) << 3;
                n2 = (d2 < d7 ? 1 : 0) << 2;
                n6 = n5 | n4 | n3 | n2;
            }
        } else {
            n5 = (d > d6 ? 1 : 0) << 1;
            n4 = d < d5 ? 1 : 0;
            n3 = (d2 > d8 ? 1 : 0) << 3;
            n2 = (d2 < d7 ? 1 : 0) << 2;
            n6 = n5 | n4 | n3 | n2;
        }
        if (d4 == this.holeValue || d3 == this.holeValue) {
            n7 = 1;
            bl6 = false;
            bl5 = true;
        } else {
            n5 = d3 > d6 ? 1 : 0;
            n4 = n5 << 1;
            n3 = d3 < d5 ? 1 : 0;
            n2 = (d4 > d8 ? 1 : 0) << 3;
            n = (d4 < d7 ? 1 : 0) << 2;
            n7 = n4 | n3 | n2 | n;
        }
        n5 = n6;
        n4 = n7;
        while (bl6 && (n5 | n4) != 0 && (n5 & n4) == 0) {
            double d9;
            double d10;
            int n8 = n3 = n5 != 0 ? n5 : n4;
            if ((n3 & 1) != 0) {
                d10 = d2 + (d4 - d2) * (d5 - d) / (d3 - d);
                d9 = d5;
                n2 = (d10 > d8 ? 1 : 0) << 3;
                n = (d10 < d7 ? 1 : 0) << 2;
                n3 = n2 | n;
            } else if ((n3 & 2) != 0) {
                d10 = d2 + (d4 - d2) * (d6 - d) / (d3 - d);
                d9 = d6;
                n2 = (d10 > d8 ? 1 : 0) << 3;
                n = (d10 < d7 ? 1 : 0) << 2;
                n3 = n2 | n;
            } else if ((n3 & 4) != 0) {
                d9 = d + (d3 - d) * (d7 - d2) / (d4 - d2);
                d10 = d7;
                n2 = (d9 > d6 ? 1 : 0) << 1;
                n = d9 < d5 ? 1 : 0;
                n3 = n2 | n;
            } else {
                d9 = d + (d3 - d) * (d8 - d2) / (d4 - d2);
                d10 = d8;
                n2 = (d9 > d6 ? 1 : 0) << 1;
                n = d9 < d5 ? 1 : 0;
                n3 = n2 | n;
            }
            if (n5 != 0) {
                n5 = n3;
                d = d9;
                d2 = d10;
                bl3 = false;
                continue;
            }
            n4 = n3;
            d3 = d9;
            d4 = d10;
            bl4 = false;
        }
        int n9 = n3 = bl || !bl5 || n6 != 0 && n7 != 0 ? 0 : 1;
        if ((n5 | n4) == 0 || n3 != 0) {
            if (bl) {
                if (!bl5) {
                    this.addClippedPoint(plotPointArray, 0, d3, d4, this.xaxis, this.yaxis, bl2, bl4);
                    bl = n7 == 0;
                } else {
                    bl = false;
                }
            } else {
                if (n3 != 0 && n7 == 0) {
                    d = d3;
                    d2 = d4;
                    bl3 = bl4;
                }
                this.addClippedPoint(plotPointArray, 0, d, d2, this.xaxis, this.yaxis, bl2, bl3);
                if (n3 == 0) {
                    this.addClippedPoint(plotPointArray, 1, d3, d4, this.xaxis, this.yaxis, bl2, bl4);
                }
                bl = n7 == 0;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n, int n2) {
        this.recalc(n, n2, -1);
    }

    public void recalc(int n, int n2, int n3) {
        super.recalc();
        boolean bl = false;
        if (n >= 0 && n2 >= 0 && n2 >= n) {
            bl = true;
        }
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.inverted = this.xaxis.vertical;
        this.holeValue = this.dataObject.getHoleValue();
        if (bl) {
            int n4 = 0;
            int n5 = this.seriesList.size();
            int n6 = n4;
            while (n6 < n5) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n6);
                if (chartDataViewSeries.isVisible() && chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                    double[] dArray = chartDataViewSeries.getX();
                    double[] dArray2 = chartDataViewSeries.getY();
                    int n7 = n;
                    while (n7 <= n2) {
                        this.xlim.setMinMax(dArray[n7], this.holeValue, this.xaxis.isLogarithmic());
                        this.ylim.setMinMax(dArray2[n7], this.holeValue, this.yaxis.isLogarithmic());
                        ++n7;
                    }
                }
                ++n6;
            }
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        } else if (n3 == -1 || n3 == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = bl ? new Point(n, jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.last.x = n;
        } else {
            this.last.y = n2;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d;
        double d2;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        int n = jCDataIndex.series.getDrawingOrder();
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        int n2 = jCDataIndex.point;
        if (n2 - 1 >= 0) {
            d2 = jCDataIndex.series.getX(n2 - 1);
            d = jCDataIndex.series.getY(n2 - 1);
            if (d2 != Double.MAX_VALUE && d != Double.MAX_VALUE && d2 != this.dataObject.getHoleValue() && d != this.dataObject.getHoleValue() && JCNumberUtil.locateXY(d2, d, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max) == 0) {
                Point point = this.prev = this.inverted ? new Point(this.yaxis.toPixel(d) + this.r.x, this.xaxis.toPixel(d2) + this.r.y) : new Point(this.xaxis.toPixel(d2) + this.r.x, this.yaxis.toPixel(d) + this.r.y);
            }
        }
        if (n2 + 1 <= jCDataIndex.series.getLastPoint()) {
            d2 = jCDataIndex.series.getX(n2 + 1);
            d = jCDataIndex.series.getY(n2 + 1);
            if (d2 != Double.MAX_VALUE && d != Double.MAX_VALUE && d2 != this.dataObject.getHoleValue() && d != this.dataObject.getHoleValue() && JCNumberUtil.locateXY(d2, d, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max) == 0) {
                this.next = this.inverted ? new Point(this.yaxis.toPixel(d) + this.r.x, this.xaxis.toPixel(d2) + this.r.y) : new Point(this.xaxis.toPixel(d2) + this.r.x, this.yaxis.toPixel(d) + this.r.y);
            }
        }
    }

    public Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }
}

