/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.JCDataInterpreter;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JCXMLDataInterpreter
extends JCDataInterpreter
implements Serializable {
    public static final String JCChartDataDTD = "<!-- DTD for JClass Chart data source -->\n<!ELEMENT JCChartData ((PointLabel*, Series+) | (SeriesLabel*, Point+)) >\n<!ATTLIST JCChartData Name CDATA #IMPLIED\n                      Hole CDATA #IMPLIED>\n\n<!ELEMENT Series (SeriesLabel?, XData*, YData+)>\n\n<!ELEMENT Point (PointLabel?, XData?, YData+)>\n\n<!ELEMENT XData (#PCDATA)>\n<!ELEMENT YData (#PCDATA)>\n<!ELEMENT SeriesLabel (#PCDATA)>\n<!ELEMENT PointLabel (#PCDATA)>\n\n";
    public static final String XML_DS = "JCChartData";
    public static final String XML_DS_ATT_NAME = "Name";
    public static final String XML_DS_ATT_HOLE = "Hole";
    public static final String XML_DS_SERIES = "Series";
    public static final String XML_DS_SERIESLABEL = "SeriesLabel";
    public static final String XML_DS_POINT = "Point";
    public static final String XML_DS_POINTLABEL = "PointLabel";
    public static final String XML_DS_XDATA = "XData";
    public static final String XML_DS_YDATA = "YData";
    static final String ERRMSG_FILE_FORMAT = "Error in data file format - ";

    public JCXMLDataInterpreter() {
    }

    public JCXMLDataInterpreter(BaseDataSource baseDataSource) throws IOException {
        super(baseDataSource);
    }

    protected void ctor(Reader reader) throws IOException {
        this.interpret(new InputSource(reader));
    }

    private void displayErrorMessage(int n, String string) {
        String string2 = "";
        switch (n) {
            case 1: {
                string2 = String.valueOf(string2) + "Data must start with ARRAY or GENERAL and not";
                break;
            }
            case 2: {
                string2 = String.valueOf(string2) + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string2 = String.valueOf(string2) + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (string != null && string.length() > 0) {
            string2 = String.valueOf(string2) + "'";
            string2 = String.valueOf(string2) + string;
            string2 = String.valueOf(string2) + "'";
        }
        System.err.println(string2);
    }

    private double getNextDouble(String string) throws IOException {
        if (string == null || string.equalsIgnoreCase("HOLE")) {
            return this.baseDS.holeValue;
        }
        if (string.equalsIgnoreCase("MAX")) {
            return Double.MAX_VALUE;
        }
        if (string.equalsIgnoreCase("MIN")) {
            return Double.MIN_VALUE;
        }
        double d = 0.0;
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            this.displayErrorMessage(2, string);
            throw new IOException(ERRMSG_FILE_FORMAT);
        }
        return d;
    }

    private synchronized void interpret(InputSource inputSource) throws IOException {
        Node node;
        Object object;
        XmlDocumentBuilder xmlDocumentBuilder;
        XmlDocument xmlDocument = null;
        try {
            xmlDocumentBuilder = new XmlDocumentBuilder();
            object = new ValidatingParser();
            inputSource.setSystemId("file:/template.xml");
            object.setErrorHandler((ErrorHandler)new JCXMLErrorPrinter());
            object.setEntityResolver((EntityResolver)((Object)new DTDResolver()));
            object.setDocumentHandler((DocumentHandler)xmlDocumentBuilder);
            object.parse(inputSource);
            xmlDocument = xmlDocumentBuilder.getDocument();
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
            throw new IOException("XML Parsing Error");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
            throw new IOException("XML Error");
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw iOException;
        }
        if (xmlDocument == null) {
            return;
        }
        xmlDocumentBuilder = new TreeWalker((Node)xmlDocument);
        object = xmlDocumentBuilder.getNextElement(XML_DS);
        object.normalize();
        NamedNodeMap namedNodeMap = object.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(XML_DS_ATT_NAME);
        if (node2 != null) {
            this.baseDS.name = new String(node2.getNodeValue());
        }
        if ((node = namedNodeMap.getNamedItem(XML_DS_ATT_HOLE)) != null) {
            this.baseDS.holeValue = this.getNextDouble(node.getNodeValue());
        }
        xmlDocumentBuilder.reset();
        Element element = null;
        element = xmlDocumentBuilder.getNextElement(XML_DS_SERIES);
        if (element != null) {
            this.interpretSeries((TreeWalker)xmlDocumentBuilder, element);
            return;
        }
        xmlDocumentBuilder.reset();
        element = xmlDocumentBuilder.getNextElement(XML_DS_POINT);
        if (element != null) {
            this.interpretPoint((TreeWalker)xmlDocumentBuilder, element);
            return;
        }
    }

    private void interpretPoint(TreeWalker treeWalker, Element element) throws IOException {
        Node node;
        Element element2;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        Element element3 = element;
        while (element3 != null) {
            ++n2;
            TreeWalker treeWalker2 = new TreeWalker((Node)element3);
            element2 = treeWalker2.getNextElement(XML_DS_XDATA);
            if (element2 != null) {
                bl = true;
            }
            treeWalker2.reset();
            int n3 = 0;
            node = treeWalker2.getNextElement(XML_DS_YDATA);
            while (node != null) {
                ++n3;
                node = treeWalker2.getNextElement(XML_DS_YDATA);
            }
            n = Math.max(n, n3);
            element3 = treeWalker.getNextElement(XML_DS_POINT);
        }
        this.baseDS.xvalues = new double[1][n2];
        this.baseDS.yvalues = new double[n][n2];
        this.baseDS.seriesLabels = new String[n];
        this.baseDS.pointLabels = new String[n2];
        treeWalker.reset();
        int n4 = 0;
        element2 = treeWalker.getNextElement(XML_DS_POINT);
        while (element2 != null) {
            TreeWalker treeWalker3 = new TreeWalker((Node)element2);
            node = treeWalker3.getNextElement(XML_DS_POINTLABEL);
            this.baseDS.pointLabels[n4] = node != null ? ((node = node.getFirstChild()) != null && node instanceof Text ? node.getNodeValue() : "") : null;
            if (bl) {
                double d = this.baseDS.holeValue;
                treeWalker3.reset();
                Node node2 = treeWalker3.getNextElement(XML_DS_XDATA);
                if (node2 != null && (node2 = node2.getFirstChild()) != null && node2 instanceof Text) {
                    d = this.getNextDouble(node2.getNodeValue());
                }
                this.baseDS.xvalues[0][n4] = d;
            } else {
                this.baseDS.xvalues[0][n4] = n4 + 1;
            }
            treeWalker3.reset();
            int n5 = 0;
            while (n5 < this.baseDS.yvalues.length) {
                double d = this.baseDS.holeValue;
                Node node3 = treeWalker3.getNextElement(XML_DS_YDATA);
                if (node3 != null && (node3 = node3.getFirstChild()) != null && node3 instanceof Text) {
                    d = this.getNextDouble(node3.getNodeValue());
                }
                this.baseDS.yvalues[n5][n4] = d;
                ++n5;
            }
            ++n4;
            element2 = treeWalker.getNextElement(XML_DS_POINT);
        }
        treeWalker.reset();
        int n6 = 0;
        while (n6 < this.baseDS.seriesLabels.length) {
            Node node4;
            node = treeWalker.getNextElement(XML_DS_SERIESLABEL);
            this.baseDS.seriesLabels[n6] = node != null ? ((node4 = node.getFirstChild()) != null && node4 instanceof Text ? node4.getNodeValue() : "") : null;
            ++n6;
        }
    }

    private void interpretSeries(TreeWalker treeWalker, Element element) throws IOException {
        int n;
        Object object;
        Node node;
        TreeWalker treeWalker2;
        int n2;
        Element element2;
        int n3 = 0;
        int n4 = 0;
        Element element3 = element;
        while (element3 != null) {
            ++n4;
            TreeWalker treeWalker3 = new TreeWalker((Node)element3);
            element2 = treeWalker3.getNextElement(XML_DS_XDATA);
            if (element2 != null) {
                ++n3;
            }
            element3 = treeWalker.getNextElement(XML_DS_SERIES);
        }
        if (n3 > 1) {
            this.baseDS.xvalues = new double[n4][];
            this.baseDS.yvalues = new double[n4][];
        }
        int n5 = 0;
        treeWalker.reset();
        int n6 = 0;
        element2 = treeWalker.getNextElement(XML_DS_SERIES);
        while (element2 != null) {
            n2 = 0;
            int n7 = 0;
            treeWalker2 = new TreeWalker((Node)element2);
            node = treeWalker2.getNextElement(XML_DS_XDATA);
            while (node != null) {
                ++n2;
                node = treeWalker2.getNextElement(XML_DS_XDATA);
            }
            treeWalker2.reset();
            object = treeWalker2.getNextElement(XML_DS_YDATA);
            while (object != null) {
                ++n7;
                object = treeWalker2.getNextElement(XML_DS_YDATA);
            }
            n = Math.max(n2, n7);
            if (n3 > 1) {
                this.baseDS.xvalues[n6] = new double[n];
                this.baseDS.yvalues[n6] = new double[n];
            }
            n5 = Math.max(n5, n);
            ++n6;
            element2 = treeWalker.getNextElement(XML_DS_SERIES);
        }
        if (n3 == 0 || n3 == 1) {
            this.baseDS.xvalues = new double[1][n5];
            this.baseDS.yvalues = new double[n4][n5];
        }
        this.baseDS.seriesLabels = new String[n4];
        this.baseDS.pointLabels = new String[n5];
        treeWalker.reset();
        n2 = 0;
        n6 = 0;
        Element element4 = treeWalker.getNextElement(XML_DS_SERIES);
        while (element4 != null) {
            treeWalker2 = new TreeWalker((Node)element4);
            node = treeWalker2.getNextElement(XML_DS_SERIESLABEL);
            this.baseDS.seriesLabels[n6] = node != null ? ((node = node.getFirstChild()) != null && node instanceof Text ? node.getNodeValue() : "") : null;
            treeWalker2.reset();
            object = n3 == 0 || n3 == 1 ? (n2 != 0 ? null : (Object)this.baseDS.xvalues[0]) : (Object)this.baseDS.xvalues[n6];
            n = 0;
            while (object != null && n < ((Object)object).length) {
                if (n3 > 0) {
                    Node node2 = treeWalker2.getNextElement(XML_DS_XDATA);
                    double d = this.baseDS.holeValue;
                    if (node2 != null) {
                        if ((node2 = node2.getFirstChild()) != null && node2 instanceof Text) {
                            d = this.getNextDouble(node2.getNodeValue());
                        }
                        n2 = 1;
                    }
                    object[n] = n3 == 1 ? (Object)d : (Object)d;
                } else {
                    if (n6 == 0) {
                        object[n] = (double)(n + 1);
                    }
                    n2 = 1;
                }
                ++n;
            }
            treeWalker2.reset();
            int n8 = 0;
            while (n8 < this.baseDS.yvalues[n6].length) {
                Node node3 = treeWalker2.getNextElement(XML_DS_YDATA);
                double d = this.baseDS.holeValue;
                if (node3 != null && (node3 = node3.getFirstChild()) != null && node3 instanceof Text) {
                    d = this.getNextDouble(node3.getNodeValue());
                }
                this.baseDS.yvalues[n6][n8] = d;
                ++n8;
            }
            ++n6;
            element4 = treeWalker.getNextElement(XML_DS_SERIES);
        }
        treeWalker.reset();
        int n9 = 0;
        while (n9 < this.baseDS.pointLabels.length) {
            node = treeWalker.getNextElement(XML_DS_POINTLABEL);
            this.baseDS.pointLabels[n9] = node != null ? ((object = node.getFirstChild()) != null && object instanceof Text ? object.getNodeValue() : "") : null;
            ++n9;
        }
    }

    static class DTDResolver
    extends Resolver {
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2.indexOf("JCChartData.dtd") != -1) {
                return new InputSource(new StringReader(JCXMLDataInterpreter.JCChartDataDTD));
            }
            return super.resolveEntity(string, string2);
        }
    }
}

