/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.ServerRenderable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class ServerRenderer {
    public static Image createNewImage(Component component, int n) {
        Image image;
        try {
            image = new BufferedImage(component.getSize().width, component.getSize().height, n);
        }
        catch (Exception exception) {
            Frame frame = new Frame();
            frame.addNotify();
            image = frame.createImage(component.getSize().width, component.getSize().height);
        }
        return image;
    }

    public static void paintComponent(Graphics graphics, Component component) {
        if (!(component instanceof ServerRenderable)) {
            return;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)component);
        serverRenderable.setGraphics(graphics);
        component.doLayout();
        component.paint(graphics);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount() - 1;
            while (n >= 0) {
                Component component2 = container.getComponent(n);
                if (component2.isVisible()) {
                    Rectangle rectangle = component2.getBounds();
                    graphics.translate(rectangle.x, rectangle.y);
                    component2.paint(graphics);
                    graphics.translate(-rectangle.x, -rectangle.y);
                }
                --n;
            }
        }
        serverRenderable.setGraphics(null);
    }

    public static Image snapshot(Component component) {
        Image image = ServerRenderer.createNewImage(component, 2);
        ServerRenderer.snapshot(component, image);
        return image;
    }

    public static boolean snapshot(Component component, Image image) {
        if (!(component instanceof ServerRenderable)) {
            return false;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)component);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, component.getSize().width, component.getSize().height);
            serverRenderable.serverPaint(graphics);
        }
        return true;
    }
}

