/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.util.ArrayList;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.JNIIFcontrol;
import sanproject.serverux.data.RmiClassLibVersionSx;
import sanproject.serverux.data.RmiConObjErr;
import sanproject.serverux.data.RmiConObjInFile;
import sanproject.serverux.data.RmiConObjOutFile;
import sanproject.serverux.data.RmiTimeoutValue;
import sanproject.serverux.data.SetTimeoutValue;
import sanproject.serverux.data.StringControl;

public class RmiConObjEnvInfo {
    final int ENV_IDX_MAX_CONNECT = 0;
    final int ENV_IDX_MAX_USR_ACCOUNT = 1;
    final int ENV_IDX_Reserve_2 = 2;
    final int ENV_IDX_Reserve_3 = 3;
    final int ENV_IDX_Reserve_4 = 4;
    final int ENV_IDX_NUM_LINES_WRAP_ROUND = 5;
    final int ENV_IDX_Reserve_6 = 6;
    final int ENV_IDX_SERVER_VERSION = 7;
    final int ENV_IDX_LOGMAINTE_TIME = 8;
    final int ENV_IDX_LOGLINE_NUMBER = 9;
    final int ENV_IDX_LOGLEVEL = 10;
    final int ENV_IDX_HEALTHCHECK_TIMER = 11;
    final int ENV_IDX_SURVEILLANCE_TIMER = 13;
    final int ENV_IDX_SURVEILLANCE_TIMEOUT = 14;
    final int ENV_IDX_SOCKET_TIMEOUT = 15;
    final int ENV_IDX_FT_TIMEOUT = 16;
    final int ENV_IDX_IP_SURVEIL = 17;
    final int ENV_IDX_APPLY_WAIT = 18;
    final int ENV_IDX_APPLY_STANDBY = 19;
    final int CGI_ENV_IDX_Reserve_0 = 0;
    final int CGI_ENV_IDX_Reserve_1 = 1;
    final int CGI_ENV_IDX_AUTO_ELMINATE_TIME = 2;
    final int CGI_ENV_IDX_LOCK_OBSERVE_INTERVAL = 3;
    final int CGI_ENV_IDX_ERR_STS_GET_INTERVAL = 4;
    final int CGI_ENV_IDX_WEB_PROTOCOL = 7;
    final int CGI_ENV_IDX_LOCK_TIMER = 9;
    final int CGI_ENV_IDX_HIDDEN_STATUS = 11;
    final int CGI_ENV_IDX_PASSWD_LENGTH = 12;
    final int CGI_ENV_IDX_LOGIN_RETRY_COUNT = 13;
    final int CGI_ENV_IDX_LOGIN_RETRY_WAIT = 14;
    static final int MIN_LOCK_TIMER = 0;
    static final int DEFAULT_LOCK_TIMER = 30;
    static final int MAX_LOCK_TIMER = 1280;
    static final int MIN_LOGOFF_TIME = 0;
    static final int MAX_LOGOFF_TIME = 2880;
    static final int DEFAULT_LOGMAINTE_TIME = 3;
    static final int DEFAULT_TIMER_INTERVAL = 20;
    static final int DEFAULT_LOG_INTERVAL = 60;
    static final int DEFAULT_DEL_LOG_CNT = 30;
    static final int DEFAULT_LIMIT_LOG_CNT = 300;
    static final int DEFAULT_SOCKET_TIMEOUT = 60;
    static final int DEFAULT_FT_TIMEOUT = 10;
    static final int DEFAULT_IP_SURVEIL = 60;
    static final int DEFAULT_APPLY_WAIT = 30;
    static final int DEFAULT_APPLY_STANDBY = 30;
    static final int DEFAULT_WEB_PROTOCOL = 1;
    static final int DEFAULT_STATUS_HIDDEN = 0;
    static final int DEFAULT_PASSWD_LENGTH_MIN = 6;
    static final int DEFAULT_LOGIN_RETRY_COUNT = 3;
    static final int DEFAULT_LOGIN_RETRY_WAIT = 1;
    private ArrayList envInfo;
    private ArrayList envInfo_rmi;
    static final int SN2OPT_NO_PP_INFO_CACHE = 11;
    private boolean bNoPPInfocache = false;
    private boolean init_NoPPInfocache = false;

    private boolean _checkRange(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    private GetRmiException outRange() {
        return RmiConObjErr.makeException(5522);
    }

    private void readEnvFile(String string, String string2) throws GetRmiException {
        RmiConObjInFile rmiConObjInFile;
        RmiConObjInFile rmiConObjInFile2;
        try {
            rmiConObjInFile2 = new RmiConObjInFile(string, false);
            this.envInfo = rmiConObjInFile2.getArrayList();
            rmiConObjInFile2.clear();
        }
        catch (GetRmiException getRmiException) {
            string = string.substring(0, string.length() - 3).concat("bak");
            rmiConObjInFile = new RmiConObjInFile(string, false);
            this.envInfo = rmiConObjInFile.getArrayList();
            rmiConObjInFile.clear();
        }
        try {
            rmiConObjInFile2 = new RmiConObjInFile(string2, false);
            this.envInfo_rmi = rmiConObjInFile2.getArrayList();
            rmiConObjInFile2.clear();
        }
        catch (GetRmiException getRmiException) {
            string2 = string2.substring(0, string2.length() - 3).concat("bak");
            rmiConObjInFile = new RmiConObjInFile(string2, false);
            this.envInfo_rmi = rmiConObjInFile.getArrayList();
            rmiConObjInFile.clear();
        }
    }

    void _resetEnvInfo(String string, String string2) throws GetRmiException {
        RmiConObjInFile rmiConObjInFile = new RmiConObjInFile(string, false);
        this.envInfo = rmiConObjInFile.getArrayList();
        rmiConObjInFile.clear();
        RmiConObjInFile rmiConObjInFile2 = new RmiConObjInFile(string2, false);
        this.envInfo_rmi = rmiConObjInFile2.getArrayList();
        rmiConObjInFile2.clear();
    }

    synchronized void _makeEnvFile(String string) throws Exception {
        RmiConObjOutFile rmiConObjOutFile = new RmiConObjOutFile(string);
        String string2 = this.envInfo.toString();
        string2 = string2.substring(1, string2.length() - 1);
        string2 = StringControl.replace((String)string2, (String)" ", (String)"");
        rmiConObjOutFile.putOneLine(string2);
    }

    synchronized void _setEnvData(SetTimeoutValue[] setTimeoutValueArray) throws Exception {
        for (int i = setTimeoutValueArray.length - 1; i >= 0; --i) {
            int n = setTimeoutValueArray[i].nTimeoutValue;
            if (setTimeoutValueArray[i].strTimeoutName.equals(RmiTimeoutValue.TIMEOUT_LOGOFF)) {
                this.setAutoElmTime(n);
                continue;
            }
            if (setTimeoutValueArray[i].strTimeoutName.equals(RmiTimeoutValue.TIMEOUT_MODIFY)) {
                this.setLockTimer(n);
                continue;
            }
            throw RmiConObjErr.makeException(5521);
        }
    }

    String _getEnv() {
        return "env.csv " + this.envInfo.toString();
    }

    String _getRmiEnv() {
        return "rmienv.csv " + this.envInfo_rmi.toString();
    }

    protected RmiConObjEnvInfo(String string, String string2) throws GetRmiException {
        this.readEnvFile(string, string2);
    }

    public String getMaxConnect() {
        return (String)this.envInfo_rmi.get(0);
    }

    public String getMaxUsrAccnt() {
        return (String)this.envInfo_rmi.get(1);
    }

    int getLimitLogCount() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(2));
        }
        catch (Exception exception) {
            n = 300;
        }
        return n;
    }

    int getDelAtOnceCount() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(3));
        }
        catch (Exception exception) {
            n = 30;
        }
        return n;
    }

    int getLogCheckInterval() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(4));
        }
        catch (Exception exception) {
            n = 60;
        }
        return n;
    }

    public String getNumLinesWrapRound() {
        return (String)this.envInfo_rmi.get(5);
    }

    int getTimerCheckInterval() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(6));
        }
        catch (Exception exception) {
            n = 20;
        }
        return n;
    }

    public String getServerVersion() {
        RmiClassLibVersionSx rmiClassLibVersionSx = new RmiClassLibVersionSx();
        return rmiClassLibVersionSx.strRmiIFVersion;
    }

    public int getLogMainteTime() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(8));
        }
        catch (Exception exception) {
            n = 3;
        }
        return n;
    }

    public int getLogLine() {
        return Integer.parseInt((String)this.envInfo_rmi.get(9));
    }

    public int getLogLevel() {
        return Integer.parseInt((String)this.envInfo_rmi.get(10));
    }

    public int getHealthChkTimer() {
        return Integer.parseInt((String)this.envInfo_rmi.get(11));
    }

    public int getSurveillanceTimer() {
        return Integer.parseInt((String)this.envInfo_rmi.get(13));
    }

    public int getSurveillanceTimeOut() {
        return Integer.parseInt((String)this.envInfo_rmi.get(14));
    }

    public int getSocketTimeOut() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(15));
        }
        catch (Exception exception) {
            n = 60;
        }
        return n;
    }

    public int getFTClientTimeOut() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(16));
        }
        catch (Exception exception) {
            n = 10;
        }
        return n;
    }

    protected int getIPSurveilTime() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(17));
        }
        catch (Exception exception) {
            n = 60;
        }
        return n;
    }

    protected int getApplyWaitTime() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(18));
        }
        catch (Exception exception) {
            n = 30;
        }
        return n;
    }

    protected int getApplyStandbyTime() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo_rmi.get(19));
        }
        catch (Exception exception) {
            n = 30;
        }
        return n;
    }

    public String getAutoElmTime() {
        return (String)this.envInfo.get(2);
    }

    public String getLockObsInterval() {
        return (String)this.envInfo.get(3);
    }

    public String getErrStsGetInterval() {
        return (String)this.envInfo.get(4);
    }

    int getWebserverProtocol() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo.get(7));
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    int getLockTimer() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo.get(9));
        }
        catch (Exception exception) {
            n = 30;
        }
        return n;
    }

    int getHiddenStatus() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo.get(11));
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    int getPasswdLength() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo.get(12));
        }
        catch (Exception exception) {
            n = 6;
        }
        return n;
    }

    int getLoginRetryCount() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo.get(13));
        }
        catch (Exception exception) {
            n = 3;
        }
        return n;
    }

    int getLoginRetryWait() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.envInfo.get(14));
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    void setAutoElmTime(int n) throws Exception {
        if (!this._checkRange(n, 0, 2880)) {
            throw this.outRange();
        }
        this.envInfo.set(2, new Integer(n));
    }

    void setLockTimer(int n) throws Exception {
        if (!this._checkRange(n, 0, 1280)) {
            throw this.outRange();
        }
        this.envInfo.set(9, new Integer(n));
    }

    public synchronized boolean getNoPPInfocache() {
        if (!this.init_NoPPInfocache) {
            this.bNoPPInfocache = JNIIFcontrol.GetSN2SystemOption((int)11);
            this.init_NoPPInfocache = true;
        }
        return this.bNoPPInfocache;
    }
}

