/*
 * Decompiled with CFR 0.152.
 */
package sanproject.trlog.utility.com;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import sanproject.trlog.utility.com.TRLogComUty;

public class TRLogLockUty {
    private File lockFile = null;
    private FileOutputStream fos = null;
    private FileLock lock = null;

    public TRLogLockUty(String path) {
        this.lockFile = new File(path);
    }

    public synchronized void getLock() {
        try {
            this.fos = new FileOutputStream(this.lockFile);
            FileChannel fc = this.fos.getChannel();
            this.lock = fc.lock();
        }
        catch (Exception e) {
            this.releaseLock();
        }
    }

    public synchronized void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.release();
                this.lock = null;
            }
            catch (Exception e) {
                TRLogComUty.outException(e);
            }
        }
        if (this.fos != null) {
            try {
                this.fos.close();
                this.fos = null;
            }
            catch (Exception e) {
                TRLogComUty.outException(e);
            }
        }
    }
}

