/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import com.ws.utilities.WSIStandardMessages;
import com.ws.wbem.jserver.CIMRepository;
import javax.cim.CIMClass;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifier;
import javax.wbem.WBEMException;
import org.wbemservices.wbem.repository.CIMOMUtils;
import org.wbemservices.wbem.repository.MethodVerification;
import org.wbemservices.wbem.repository.PropertyChecker;

class ClassChecker {
    private final CIMRepository mPCHandle;
    private final CIMOMUtils cu;
    private final PropertyChecker propCheck;
    private final MethodVerification methCheck;

    public ClassChecker(CIMRepository handle) {
        this.mPCHandle = handle;
        this.cu = new CIMOMUtils(handle);
        this.propCheck = new PropertyChecker(this.cu);
        this.methCheck = new MethodVerification(this.cu, handle);
    }

    CIMClass checkClassSanity(String namespace, CIMClass cc, CIMClass parentClass) throws WBEMException {
        CIMQualifier<?> qe;
        if (cc.getName().indexOf("_") < 0) {
            Object[] o = new Object[]{cc.getName()};
            String message = WSIStandardMessages.getMessage((String)"ERROR_CLASS_INVALID_NAME", (Object[])o);
            throw new WBEMException(1, message);
        }
        int keysRequired = 0;
        int refsRequired = 0;
        int curLevel = 1;
        CIMClass superclass = parentClass;
        if (superclass == null && cc.getSuperClassName() != null && cc.getSuperClassName().length() != 0) {
            try {
                superclass = this.mPCHandle.getClass(new CIMObjectPath(null, null, null, cc.getObjectPath().getNamespace(), cc.getSuperClassName(), null), false, true);
            }
            catch (WBEMException we) {
                if (we.getID() == 6) {
                    Object[] o = new Object[]{cc.getSuperClassName(), cc.getName()};
                    String message = WSIStandardMessages.getMessage((String)"ERROR_CLASS_INVALID_SUPERCLASS", (Object[])o);
                    throw new WBEMException(10, message);
                }
                throw we;
            }
        }
        CIMQualifier[] qualifiers = cc.getQualifiers();
        if (superclass != null) {
            qualifiers = this.cu.assignInheritedQualifiers(qualifiers, superclass.getQualifiers());
        }
        if ((qe = cc.getQualifier("association")) == null) {
            if (superclass != null && superclass.isAssociation()) {
                Object[] o = new Object[]{cc.getName(), superclass.getName()};
                String message = WSIStandardMessages.getMessage((String)"ERROR_CLASS_NOT_ASSOCIATION", (Object[])o);
                throw new WBEMException(1, message);
            }
            qe = this.cu.createDefaultQualifier(namespace, "association");
        } else {
            qe = this.cu.checkQualifier(namespace, qe);
        }
        Object Tmp = qe.getValue();
        if (Tmp != null && Tmp.equals(Boolean.TRUE)) {
            if (!(cc = new CIMClass(cc.getObjectPath(), cc.getSuperClassName(), cc.getQualifiers(), cc.getProperties(), cc.getMethods(), true, cc.isKeyed())).isAssociation()) {
                String message = WSIStandardMessages.getMessage((String)"ERROR_CLASS_NOT_ASSOCIATION", null);
                throw new WBEMException(1, message);
            }
            curLevel = 2;
            if (superclass != null && !superclass.isAssociation()) {
                Object[] o = new Object[]{cc.getName(), superclass.getName()};
                String message = WSIStandardMessages.getMessage((String)"ERROR_CLASS_ASSOCIATION_SUPERCLASS_NOT_ASSOCIATION", (Object[])o);
                throw new WBEMException(1, message);
            }
            if (superclass == null) {
                refsRequired = 2;
            }
        }
        qualifiers = this.cu.doCommonQualifierChecks(namespace, cc.getName(), qualifiers, curLevel);
        if (superclass != null && superclass.isKeyed()) {
            cc = new CIMClass(cc.getObjectPath(), cc.getSuperClassName(), cc.getQualifiers(), cc.getProperties(), cc.getMethods(), cc.isAssociation(), true);
        }
        if ((qe = cc.getQualifier("abstract")) == null) {
            qe = this.cu.createDefaultQualifier(namespace, "abstract");
        }
        if (qe.getValue().equals(Boolean.TRUE)) {
            if (cc.getQualifier("Terminal") != null) {
                Object[] o = new Object[]{cc.getName()};
                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_ABSTRACT_TERMINAL", (Object[])o));
            }
        } else {
            keysRequired = cc.isKeyed() ? -1 : 1;
        }
        boolean isIndication = false;
        try {
            qe = cc.getQualifier("indication");
            qe = qe == null ? this.cu.createDefaultQualifier(namespace, "indication") : this.cu.checkQualifier(namespace, qe);
            Tmp = qe.getValue();
            if (Tmp != null && Tmp.equals(Boolean.TRUE)) {
                keysRequired = -1;
                isIndication = true;
            }
        }
        catch (WBEMException message) {
            // empty catch block
        }
        try {
            cc = this.propCheck.checkPropertiesSanity(namespace, cc, keysRequired, refsRequired, superclass, isIndication);
            cc = this.methCheck.verifyAndUpdateMethod(namespace, cc, superclass);
        }
        catch (IllegalArgumentException ex) {
            throw new WBEMException(1, ex.getLocalizedMessage());
        }
        return cc;
    }
}

