/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import com.ws.wbem.jserver.CIMRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMClass;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;
import org.wbemservices.wbem.repository.ReadersWriter;

class EventHelper {
    private final String CLASS_DEFINITION = "ClassDefinition";
    private final String INDICATION_TIME = "IndicationTime";
    private final String SOURCEINSTANCE = "SourceInstance";
    static final String INSTANCEMODIFICATION = "cim_instmodification";
    static final String INSTANCECREATION = "cim_instcreation";
    static final String INSTANCEDELETION = "cim_instdeletion";
    public static final String INSTANCEMETHODCALL = "cim_instmethodcall";
    static final String INSTANCEREAD = "cim_instread";
    static final String CLASSCREATION = "cim_classcreation";
    static final String CLASSDELETION = "cim_classdeletion";
    static final String CLASSMODIFICATION = "cim_classmodification";
    static final int INSTANCECREATIONTYPE = 0;
    static final int INSTANCEDELETIONTYPE = 1;
    static final int INSTANCEMODIFICATIONTYPE = 2;
    static final int INSTANCEREADTYPE = 3;
    static final int INSTANCEMETHODCALLTYPE = 4;
    static final int CLASSCREATIONTYPE = 5;
    static final int CLASSDELETIONTYPE = 6;
    static final int CLASSMODIFICATIONTYPE = 7;
    static boolean verbose = false;
    private final ReadersWriter concurrentObj;
    private final Logger mLogger;
    private final ProviderHandle mProviderHandle;
    private final Map<String, Integer> classIndicationMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Integer> instCreationMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Integer> instDeletionMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Integer> instModificationMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Integer> instReadMap = Collections.synchronizedMap(new HashMap());

    EventHelper(ReadersWriter concurrentObj, ProviderHandle pch) {
        this.mProviderHandle = pch;
        this.mLogger = Logger.getLogger("com.ws.wbem.jserver");
        this.concurrentObj = concurrentObj;
    }

    void classCreation(String namespace, CIMClass cc) {
        try {
            if (this.classIndicationMap.containsKey(this.cleanNameSpace(namespace) + "::" + CLASSCREATION)) {
                CIMObjectPath cop = new CIMObjectPath(null, null, null, namespace, CLASSCREATION, null);
                CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty("ClassDefinition", CIMDataType.CLASS_T, (Object)cc, false), new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, null, false)};
                CIMInstance indication = new CIMInstance(cop, cpArray);
                this.mProviderHandle.deliverEvent(indication, null);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "classCreation Event Exception", e);
        }
    }

    void classDeletion(String namespace, CIMClass cc) {
        try {
            if (this.classIndicationMap.containsKey(this.cleanNameSpace(namespace) + "::" + CLASSDELETION)) {
                CIMObjectPath cop = new CIMObjectPath(null, null, null, namespace, CLASSDELETION, null);
                CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty("ClassDefinition", CIMDataType.CLASS_T, (Object)cc, false), new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, null, false)};
                CIMInstance indication = new CIMInstance(cop, cpArray);
                this.mProviderHandle.deliverEvent(indication, null);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "classDeletion Event Exception", e);
        }
    }

    void classModification(String namespace, CIMClass oldcc, CIMClass cc) {
        try {
            if (this.classIndicationMap.containsKey(this.cleanNameSpace(namespace) + "::" + CLASSMODIFICATION)) {
                CIMObjectPath cop = new CIMObjectPath(null, null, null, namespace, CLASSMODIFICATION, null);
                CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty("ClassDefinition", CIMDataType.CLASS_T, (Object)cc, false), new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, null, false), new CIMProperty("PreviousClassDefinition", CIMDataType.CLASS_T, (Object)oldcc, false)};
                CIMInstance indication = new CIMInstance(cop, cpArray);
                this.mProviderHandle.deliverEvent(indication, null);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "classModification Event Exception", e);
        }
    }

    void instanceRead(String namespace, CIMInstance ci) {
        try {
            if (null != ci && null != ci.getClassName() && this.instReadMap.containsKey(this.cleanNameSpace(namespace) + ":" + ci.getClassName().toLowerCase())) {
                CIMObjectPath cop = new CIMObjectPath(null, null, null, namespace, INSTANCEREAD, null);
                CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty("SourceInstance", CIMDataType.OBJECT_T, (Object)ci, false)};
                CIMInstance indication = new CIMInstance(cop, cpArray);
                this.mProviderHandle.deliverEvent(indication, null);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "instanceRead Event Exception", e);
        }
    }

    void instanceEnumerate(CIMObjectPath op, final ArrayList<CIMInstance> instanceList) {
        try {
            if (null != op) {
                final String localns = this.cleanNameSpace(op.getNamespace());
                if (null != op.getObjectName() && this.instReadMap.containsKey(localns + ":" + op.getObjectName().toLowerCase())) {
                    new Thread(){

                        @Override
                        public void run() {
                            for (CIMInstance ci : instanceList) {
                                EventHelper.this.instanceRead(localns, ci.filterProperties(null));
                            }
                        }
                    }.start();
                }
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "instanceEnumerate Event Exception", e);
        }
    }

    void instanceAddition(String namespace, CIMInstance ci) {
        try {
            if (null != ci && null != ci.getClassName() && this.instCreationMap.containsKey(namespace + ":" + ci.getClassName().toLowerCase())) {
                CIMObjectPath cop = new CIMObjectPath(null, null, null, namespace, INSTANCECREATION, null);
                CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty("SourceInstance", CIMDataType.OBJECT_T, (Object)ci, false)};
                CIMInstance indication = new CIMInstance(cop, cpArray);
                this.mProviderHandle.deliverEvent(indication, null);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "instanceAddition Event Exception", e);
        }
    }

    void instanceDeletion(String namespace, CIMInstance ci) {
        String SOURCEINSTANCE = "SourceInstance";
        try {
            if (null != ci && null != ci.getClassName() && this.instDeletionMap.containsKey(namespace + ":" + ci.getClassName().toLowerCase())) {
                CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty("SourceInstance", CIMDataType.OBJECT_T, (Object)ci, false)};
                CIMInstance indication = new CIMInstance(new CIMObjectPath(null, null, null, namespace, INSTANCEDELETION, null), cpArray);
                this.mProviderHandle.deliverEvent(indication, null);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "instanceDeletion Event Exception", e);
        }
    }

    void instanceModification(String namespace, CIMInstance oldci, CIMInstance ci) {
        try {
            if (null != ci && null != ci.getClassName() && this.instModificationMap.containsKey(namespace + ":" + ci.getClassName().toLowerCase())) {
                CIMObjectPath cop = new CIMObjectPath(null, null, null, namespace, INSTANCEMODIFICATION, null);
                CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty("SourceInstance", CIMDataType.OBJECT_T, (Object)ci, false), new CIMProperty("PreviousInstance", CIMDataType.OBJECT_T, (Object)oldci, false)};
                CIMInstance indication = new CIMInstance(cop, cpArray);
                this.mProviderHandle.deliverEvent(indication, null);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "instanceModification Event Exception", e);
        }
    }

    void additionTriggerActivate(String namespace, String className) {
        this.incrementMap(this.instCreationMap, namespace + ":" + className);
    }

    void deletionTriggerActivate(String namespace, String className) {
        this.incrementMap(this.instDeletionMap, namespace + ":" + className);
    }

    void modificationTriggerActivate(String namespace, String className) {
        this.incrementMap(this.instModificationMap, namespace + ":" + className);
    }

    void readTriggerActivate(String namespace, String className) {
        this.incrementMap(this.instReadMap, namespace + ":" + className);
    }

    void additionTriggerDeActivate(String namespace, String className) {
        this.decrementMap(this.instCreationMap, namespace + ":" + className);
    }

    void deletionTriggerDeActivate(String namespace, String className) {
        this.decrementMap(this.instDeletionMap, namespace + ":" + className);
    }

    void modificationTriggerDeActivate(String namespace, String className) {
        this.decrementMap(this.instModificationMap, namespace + ":" + className);
    }

    void readTriggerDeActivate(String namespace, String className) {
        this.decrementMap(this.instReadMap, namespace + ":" + className);
    }

    void classTriggerActivate(String namespace, String eventType) {
        this.incrementMap(this.classIndicationMap, namespace + "::" + eventType);
    }

    void classTriggerDeActivate(String namespace, String eventType) {
        this.decrementMap(this.classIndicationMap, namespace + "::" + eventType);
    }

    void incrementMap(Map<String, Integer> pMap, String key) {
        this.concurrentObj.writeLock();
        Integer count = pMap.get(key);
        if (null == count) {
            count = new Integer(1);
        } else {
            pMap.remove(key);
            count = new Integer(count + 1);
        }
        pMap.put(key, count);
        this.concurrentObj.writeUnlock();
    }

    void decrementMap(Map<String, Integer> pMap, String key) {
        this.concurrentObj.writeLock();
        Integer count = pMap.get(key);
        if (null != count) {
            int newCount = count - 1;
            pMap.remove(key);
            if (newCount > 0) {
                pMap.put(key, new Integer(newCount));
            }
        }
        this.concurrentObj.writeUnlock();
    }

    private String cleanNameSpace(String nSpace) {
        if (nSpace.startsWith("/")) {
            return nSpace.substring(1).toLowerCase();
        }
        return nSpace.toLowerCase();
    }

    public static int determineEventType(CIMRepository ps, String namespace, String eventTypeString) {
        if (EventHelper.isTypeOf(ps, namespace, eventTypeString, INSTANCEMODIFICATION)) {
            return 2;
        }
        if (EventHelper.isTypeOf(ps, namespace, eventTypeString, INSTANCEDELETION)) {
            return 1;
        }
        if (EventHelper.isTypeOf(ps, namespace, eventTypeString, INSTANCECREATION)) {
            return 0;
        }
        if (EventHelper.isTypeOf(ps, namespace, eventTypeString, INSTANCEMETHODCALL)) {
            return 4;
        }
        if (EventHelper.isTypeOf(ps, namespace, eventTypeString, INSTANCEREAD)) {
            return 3;
        }
        if (EventHelper.isTypeOf(ps, namespace, eventTypeString, CLASSCREATION)) {
            return 5;
        }
        if (EventHelper.isTypeOf(ps, namespace, eventTypeString, CLASSDELETION)) {
            return 6;
        }
        if (EventHelper.isTypeOf(ps, namespace, eventTypeString, CLASSMODIFICATION)) {
            return 7;
        }
        return -1;
    }

    public static boolean isTypeOf(CIMRepository ps, String namespace, String className, String parentClassName) {
        if (className.equalsIgnoreCase(parentClassName)) {
            return true;
        }
        try {
            CloseableIterator iCOP = ps.enumerateClassNames(new CIMObjectPath(null, null, null, namespace, parentClassName, null), true);
            while (iCOP.hasNext()) {
                CIMObjectPath cop = (CIMObjectPath)iCOP.next();
                if (!className.equalsIgnoreCase(cop.getObjectName())) continue;
                return true;
            }
        }
        catch (WBEMException e) {
            return false;
        }
        return false;
    }

    public static boolean isInstanceIndication(int eventType) {
        return eventType >= 0 && eventType <= 4;
    }

    public static boolean isClassIndication(int eventType) {
        return eventType >= 5 && eventType <= 6;
    }

    public static boolean isProcessIndication(int eventType) {
        return eventType == -1;
    }
}

