/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

public class ReadersWriter {
    private int activeReaders = 0;
    private int waitingWriters = 0;
    private boolean activeWriter = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readerWait(Object notifier, long time) {
        try {
            Object object = notifier;
            synchronized (object) {
                this.readUnlock();
                notifier.wait(time);
            }
        }
        catch (InterruptedException e) {
            throw new ConcurrentLockException("read wait interrupted in thread");
        }
        finally {
            this.readLock();
        }
    }

    public synchronized void readLock() {
        while (this.activeWriter || this.waitingWriters != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new ConcurrentLockException("read lock interrupted in thread");
            }
        }
        ++this.activeReaders;
    }

    public synchronized void readUnlock() {
        --this.activeReaders;
        if (this.activeReaders == 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waiterNotify(Object notifier) {
        Object object = notifier;
        synchronized (object) {
            notifier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeLock() {
        while (this.activeWriter || this.activeReaders != 0) {
            try {
                ++this.waitingWriters;
                try {
                    this.wait();
                }
                finally {
                    --this.waitingWriters;
                }
            }
            catch (InterruptedException e) {
                throw new ConcurrentLockException("write lock interrupted in thread");
            }
        }
        this.activeWriter = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writerWait(Object notifier, long time) {
        try {
            Object object = notifier;
            synchronized (object) {
                this.writeUnlock();
                notifier.wait(time);
            }
        }
        catch (InterruptedException e) {
            throw new ConcurrentLockException("write wait interrupted in thread");
        }
        finally {
            this.writeLock();
        }
    }

    public synchronized void writeUnlock() {
        this.activeWriter = false;
        this.notifyAll();
    }

    public static class ConcurrentLockException
    extends RuntimeException {
        private static final long serialVersionUID = 7027246653257040584L;

        public ConcurrentLockException() {
        }

        public ConcurrentLockException(String s) {
            super(s);
        }
    }
}

