/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataInternalUtility;
import com.hitachi.sanproject.rmi.server.SanRemoteObject;
import com.hitachi.sanproject.rmi.server.managers.SanAuditLogManager;
import com.hitachi.sanproject.rmi.server.managers.SanAuthenticationManager;
import com.hitachi.sanproject.rmi.server.managers.SanResourcelockManager;
import com.hitachi.sanproject.util.SanLogger;
import com.hitachi.sanproject.util.SanProcess;
import com.hitachi.sanproject.util.SanProperties;
import com.hitachi.sanproject.util.SanTRLog;
import java.io.File;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Logger;

public class SanRmiServer {
    public static final String DIRNAME_RMISERVER = "rmiserver";
    public static final String SETTING_PROPERTIES_FILE = "cnf" + File.separator + "setting.properties";
    public static final String SETTING_PROPERTIES_FILE_DEFAULT = "cnf" + File.separator + "default" + File.separator + "setting.properties";
    public static final String KEY_COMMAND_JAVA = "com.hitachi.sanproject.command.java";
    public static final String KEY_COMMAND_CLASS = "com.hitachi.sanproject.command.class";
    public static final String KEY_COMMAND_CLASSPATH = "com.hitachi.sanproject.command.cp";
    public static final String KEY_COMMAND_PROCESS_PARAM1 = "com.hitachi.sanproject.command.param1";
    public static final String KEY_PROCESS_STARTUP = "com.hitachi.sanproject.process.startup";
    public static final String KEY_PROCESS_UPGRADING = "com.hitachi.sanproject.process.upgrading";
    public static final String KEY_SECURITY_POLICY = "java.security.policy";
    public static final String WORK_DIR = ".." + File.separator + "..";
    public static final String DKCMAN_DIR = WORK_DIR + File.separator + "supervisor" + File.separator + "dkcman";
    public static final String ENV_PROPERTIES_FILE = DKCMAN_DIR + File.separator + "cnf" + File.separator + "env.properties";
    public static final String KEY_RMIREGISTRY_HOST = "com.hitachi.sanproject.registry.host";
    public static final String KEY_RMIREGISTRY_PRIVATEPORT = "com.hitachi.sanproject.registry.privateport";
    public static final String KEY_RMIREGISTRY_PUBLICPORT = "com.hitachi.sanproject.registry.publicport";
    public static final String DKC_DIR = "..";
    public static final String DKC_PROPERTIES_FILE = ".." + File.separator + "dkc.properties";
    public static final String KEY_STORAGE_DKCID = "com.hitachi.sanproject.storage.dkcid";
    public static final String KEY_STORAGE_MODEL = "com.hitachi.sanproject.storage.model";
    public static final String KEY_STORAGE_SERIALNUMBER = "com.hitachi.sanproject.storage.serialnumber";
    public static final String KEY_SOFTWARE_VERSION = "com.hitachi.sanproject.software.version";
    public static final String KEY_CONFIG_VERSION = "com.hitachi.sanproject.config.version";
    public static final String LOG_DIR = "log";
    public static final String LOG_FILE = "rmiserver";
    public static final String DIRNAME_DATA = "define_data";
    public static final String DIRNAME_INTERFACE = "define_interface";
    public static final String DIRNAME_AUDITLOG = "define_auditlog";
    public static final String DIRNAME_LIB = "lib";
    public static final String DIRNAME_DEBUG = "debug";
    public static final String DIRNAME_RESPONSE = "preset_response";
    public static final String KEY_DEFINE_DEBUG = "com.hitachi.sanproject.define.debug";
    protected static int status = 0;
    protected static String processName = null;
    protected static SanProperties settingProperties = null;
    protected static SanProperties envProperties = null;
    protected static SanProperties dkcProperties = null;
    protected static Registry privateRegistry = null;
    protected static SanRemoteObject robj = null;
    protected static SanProcess process = null;
    protected static Logger logger = null;
    protected static SanData generalParameter = null;
    protected static SanAuthenticationManager authenticationManager = null;
    protected static SanResourcelockManager resourcelockManager = null;
    protected static SanAuditLogManager auditlogManager = null;

    private SanRmiServer() {
    }

    public static int getStatus() {
        return status;
    }

    public static String getProcessName() {
        return processName;
    }

    public static SanProperties getSettingProperties() {
        return settingProperties;
    }

    public static SanProperties getEnvProperties() {
        return envProperties;
    }

    public static SanProperties getDkcProperties() {
        return dkcProperties;
    }

    public static Registry getPrivateRegistry() {
        return privateRegistry;
    }

    public static SanRemoteObject getRemoteObject() {
        return robj;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static SanData getGeneralParameter() {
        if (generalParameter != null) {
            return generalParameter.clone();
        }
        return null;
    }

    public static SanAuthenticationManager getAuthenticationManager() {
        return authenticationManager;
    }

    public static SanResourcelockManager getResourcelockManager() {
        return resourcelockManager;
    }

    public static SanAuditLogManager getAuditLogManager() {
        return auditlogManager;
    }

    public static void main(String[] stringArray) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SanRmiServer.stopServer();
                }
            });
            if (!SanRmiServer.startServer()) {
                return;
            }
        }
        catch (Exception exception) {
            if (logger != null) {
                logger.severe(SanLogger.getStackTrace((Throwable)exception));
            }
            exception.printStackTrace();
        }
    }

    public static boolean startServer() throws SecurityException, IOException {
        String string2;
        File file;
        File file2 = new File(SanProcess.FILENAME_STOPFORCIBLY);
        if (file2.exists()) {
            return false;
        }
        status = 2;
        SanTRLog.write((Logger)logger, (SanTRLog)SanTRLog.DKC_START, (Object[])new Object[0]);
        File file3 = new File(DKC_PROPERTIES_FILE);
        if (file3.exists()) {
            dkcProperties = new SanProperties(file3);
        }
        if (dkcProperties != null) {
            int n = Integer.parseInt(dkcProperties.getProperty(KEY_STORAGE_MODEL));
            int n2 = Integer.parseInt(dkcProperties.getProperty(KEY_STORAGE_SERIALNUMBER));
            processName = SanProcess.createName((int)n, (int)n2, (String)"rmiserver");
        }
        if ((file = new File(SETTING_PROPERTIES_FILE)).exists()) {
            settingProperties = new SanProperties(file);
        }
        SanLogger.deleteLckFile((String)LOG_DIR);
        logger = SanLogger.getLogger((SanProperties)settingProperties, (String)processName, (String)LOG_DIR, (String)"rmiserver");
        logger.info(String.format("start Process : processName=%s", processName));
        logger.info(String.format("loggerName=%s, logdir=%s , logfile=%s", processName, LOG_DIR, "rmiserver"));
        logger.info(String.format("java.library.path=%s", System.getProperty("java.library.path")));
        if (dkcProperties == null) {
            logger.severe("dkc.properties doesn't exist !");
            status = 4;
            SanTRLog.write((Logger)logger, (SanTRLog)SanTRLog.DKC_FAILED_READ_DKCPRO, (Object[])new Object[0]);
            return false;
        }
        logger.info(dkcProperties.toString());
        if (settingProperties == null) {
            logger.severe("setting.properties doesn't exist !");
            status = 4;
            SanTRLog.write((Logger)logger, (SanTRLog)SanTRLog.DKC_FAILED_READ_SETTINGPRO, (Object[])new Object[0]);
            return false;
        }
        logger.info(settingProperties.toString());
        for (String string2 : settingProperties.stringPropertyNames()) {
            if (!string2.startsWith("java.") && !string2.startsWith("sun.")) continue;
            System.setProperty(string2, settingProperties.getProperty(string2));
        }
        logger.info("java.security.policy = " + System.getProperty(KEY_SECURITY_POLICY));
        File file4 = new File(ENV_PROPERTIES_FILE);
        if (!file4.exists()) {
            logger.severe("env.properties doesn't exist !");
            status = 4;
            SanTRLog.write((Logger)logger, (SanTRLog)SanTRLog.DKC_FAILED_READ_ENVPRO, (Object[])new Object[0]);
            return false;
        }
        envProperties = new SanProperties(file4);
        System.setSecurityManager(new RMISecurityManager());
        string2 = envProperties.getProperty(KEY_RMIREGISTRY_PRIVATEPORT);
        try {
            logger.info(String.format("get PrivateRegistry : port=%s", string2));
            privateRegistry = LocateRegistry.getRegistry(Integer.valueOf(string2));
        }
        catch (RemoteException remoteException) {
            logger.warning("Don't get PrivateRegistry !");
            logger.warning(SanLogger.getStackTrace((Throwable)remoteException));
            status = 4;
            SanTRLog.write((Logger)logger, (SanTRLog)SanTRLog.DKC_PRIVATE_REGISTRY_NULL, (Object[])new Object[]{string2});
            return false;
        }
        authenticationManager = new SanAuthenticationManager();
        resourcelockManager = new SanResourcelockManager();
        auditlogManager = new SanAuditLogManager();
        SanRmiServer.createLoggerOfRmiCommunication();
        try {
            if (privateRegistry != null) {
                robj = new SanRemoteObject();
                logger.info(String.format("privateRegistry.rebind : bindname=%s", processName));
                privateRegistry.rebind(processName, robj);
            }
        }
        catch (Exception exception) {
            logger.warning("Failed Private RemoteObject creation !");
            logger.warning(SanLogger.getStackTrace((Throwable)exception));
            status = 4;
            SanTRLog.write((Logger)logger, (SanTRLog)SanTRLog.DKC_PRIVATE_ROBJ_NULL, (Object[])new Object[]{string2});
            try {
                if (robj != null) {
                    UnicastRemoteObject.unexportObject(robj, true);
                }
            }
            catch (Exception exception2) {
                logger.warning(SanLogger.getStackTrace((Throwable)exception2));
            }
            robj = null;
            privateRegistry = null;
            return false;
        }
        robj.readDatas();
        robj.readInterfaces();
        if (Boolean.valueOf(settingProperties.getProperty(KEY_DEFINE_DEBUG)).booleanValue()) {
            robj.readDatas(new File(DIRNAME_DATA));
            robj.readInterfaces(new File(DIRNAME_INTERFACE));
        }
        if ((generalParameter = robj.getGeneralParameter()) == null) {
            logger.warning("generalParameter == null");
            status = 5;
        } else {
            try {
                generalParameter.newObj("ClientInfo").putString("HostName", processName);
                SanDataInternalUtility.clearHiddenMembersOfGeneralParameter((SanData)generalParameter);
            }
            catch (SanDataException sanDataException) {
                logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
                status = 5;
            }
        }
        authenticationManager.initialize();
        resourcelockManager.initialize();
        auditlogManager.initialize();
        if (status == 2) {
            status = 1;
        }
        logger.info("RMI Server is starting !" + SanRmiServer.getMemoryInfo());
        SanTRLog.write((Logger)logger, (SanTRLog)SanTRLog.DKC_START_READY, (Object[])new Object[0]);
        return true;
    }

    public static void stopServer() {
        try {
            if (privateRegistry != null) {
                privateRegistry.unbind(processName);
            }
            if (robj != null) {
                UnicastRemoteObject.unexportObject(robj, true);
            }
            logger.info("RMI Server stopped !");
        }
        catch (Exception exception) {
            logger.warning(SanLogger.getStackTrace((Throwable)exception));
        }
    }

    public static String getMemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        long l3 = runtime.maxMemory();
        return String.format("[VM MemorySize{total=%dbyte(s), used=%dbyte(s), free=%dbyte(s), max=%dbyte(s)}]", l, l - l2, l2, l3);
    }

    protected static void createLoggerOfRmiCommunication() {
        try {
            String[] stringArray = new String[]{"sun.rmi.transport.tcp"};
            SanProperties sanProperties = SanRmiServer.getSettingProperties();
            SanProperties sanProperties2 = new SanProperties();
            sanProperties.copyTo(sanProperties2);
            sanProperties2.setProperty("com.hitachi.sanproject.util.logging.level", "FINEST");
            for (String string : stringArray) {
                SanLogger.getLogger((SanProperties)sanProperties2, (String)string, (String)LOG_DIR, (String)string);
            }
        }
        catch (SecurityException securityException) {
            logger.warning(SanLogger.getStackTrace((Throwable)securityException));
        }
        catch (IOException iOException) {
            logger.warning(SanLogger.getStackTrace((Throwable)iOException));
        }
    }
}

