/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server.functions;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.server.SanRmiServer;
import com.hitachi.sanproject.util.SanLogger;
import com.hitachi.sanproject.util.SanProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class JNIFunctions {
    public static String LOG_FILE = "native";
    protected static Logger logger;
    protected static Logger nativelogger;
    protected static ArrayList<String> libs;

    private JNIFunctions() {
    }

    public static Logger getNativeLogger() {
        return nativelogger;
    }

    public static boolean initialize() {
        logger = SanRmiServer.getLogger();
        try {
            nativelogger = SanLogger.getLogger((SanProperties)SanRmiServer.getSettingProperties(), (String)String.format("%s.%s", JNIFunctions.class.getCanonicalName(), LOG_FILE), (String)"log", (String)LOG_FILE);
        }
        catch (IOException | SecurityException exception) {
            logger.warning(SanLogger.getStackTrace((Throwable)exception));
        }
        libs = new ArrayList();
        if (!JNIFunctions.loadLibrary("SanDataAccessor")) {
            return false;
        }
        return JNIFunctions.loadLibrary("NativeMAINFunctions");
    }

    public static boolean loadLibrary(String string) {
        if (!libs.contains(string)) {
            boolean bl = false;
            logger.info(String.format("start : libName=%s", string));
            for (int i = 0; i < 30; ++i) {
                try {
                    System.loadLibrary(string);
                    libs.add(string);
                    bl = true;
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    logger.warning(SanLogger.getStackTrace((Throwable)unsatisfiedLinkError));
                }
                catch (Throwable throwable) {
                    logger.warning(SanLogger.getStackTrace((Throwable)throwable));
                    break;
                }
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    logger.warning(SanLogger.getStackTrace((Throwable)interruptedException));
                }
            }
            if (bl) {
                logger.info(String.format("end : libName=%s", string));
            } else {
                logger.severe(String.format("end : couldn't load %s", string));
            }
            return bl;
        }
        return true;
    }

    public static native short startLoadingNativeFunctions(int var0);

    public static native short endLoadingNativeFunctions();

    public static native int loadNativeFunctions(String var0, String var1);

    public static native short nativeinvoke(int var0, SanData var1, SanRequest var2, SanResponse var3);
}

