/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.common;

import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseLoginModule;
import sanproject.sn2.base.authentication.module.external.common.SJbaseParamater;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosLoginModule;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapLoginModule;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusLoginModule;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.fileuty.exception.SJcFileUtyException;

public class SJbaseExternalLoginModule {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseExternalLoginModule";
    private Properties properties = new Properties();
    private SJbaseExternalAccountInfo account;
    private SJbaseParamater paramater;

    public SJbaseExternalLoginModule() throws SJbaseExCommunicationException {
        String method = "constructor";
        logger.info(module, method, "", "start");
        try {
            SJcFileUty.decryptFile("base\\setting\\extAuth\\", "ExtarnalAuth_Config.properties", "base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
        }
        catch (Exception ex) {
            logger.error(module, method, "ExtarnalAuth_Config.properties decrypt", "failed", ex);
            throw new SJbaseExCommunicationException();
        }
        try {
            this.properties = SJcFileUty.loadProperties("base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
        }
        catch (SJcFileUtyException e) {
            logger.error(module, method, "load a configuration file", "failed", e);
            throw new SJbaseExCommunicationException();
        }
        logger.info(module, method, "", "end");
    }

    public SJbaseExternalLoginModule(Properties prop) {
        String method = "constructor2";
        logger.info(module, method, "", "start");
        this.properties = prop;
        logger.info(module, method, "", "end");
    }

    public SJbaseExternalAccountInfo login(String userId, String password) throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        SJbaseLoginModule loginModule;
        String method = "login";
        logger.info(module, method, "", "start");
        if (this.properties == null) {
            logger.warn(module, method, "check the configuration object field", "object field is null");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        String serverType = this.properties.getProperty("auth.server.type");
        if (serverType == null) {
            logger.error(module, method, "check the server type", "server type is null");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        if (serverType.equalsIgnoreCase("ldap")) {
            logger.info(module, method, "check the server type", "ldap is selected");
            loginModule = new SJbaseLdapLoginModule(userId, password, this.properties);
        } else if (serverType.equalsIgnoreCase("radius")) {
            logger.info(module, method, "check the server type", "radius is selected");
            loginModule = new SJbaseRadiusLoginModule(userId, password, this.properties);
        } else if (serverType.equalsIgnoreCase("kerberos")) {
            logger.info(module, method, "check the server type", "kerberos is selected");
            loginModule = new SJbaseKerberosLoginModule(userId, password, this.properties);
        } else {
            logger.error(module, method, "check the server type", "improper type is selected");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        this.paramater = loginModule.authenticate();
        this.account = this.paramater.getAccount();
        logger.info(module, method, "", "end");
        return this.account;
    }
}

