/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.session;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import sanproject.session.client.SJsessionClient;
import sanproject.session.client.exception.SJsessionAuthenticationException;
import sanproject.session.client.exception.SJsessionClientException;
import sanproject.sn2.base.SJbaseConst;
import sanproject.sn2.base.session.SJbaseLoginEntry;
import sanproject.sn2.base.session.SJbaseUserSessionLockManager;
import sanproject.sn2.base.session.SJbaseUserSessionManagerStatus;
import sanproject.sn2.base.session.exception.SJbaseInvalidSessionException;
import sanproject.sn2.base.session.exception.SJbaseSessionIPNumOverException;
import sanproject.sn2.base.session.exception.SJbaseSessionInitUserDirException;
import sanproject.sn2.base.session.exception.SJbaseSessionLoginEntryParameterException;
import sanproject.sn2.base.session.exception.SJbaseSessionMemoryOverException;
import sanproject.sn2.base.session.exception.SJbaseSessionNumOverException;
import sanproject.sn2.base.session.exception.SJbaseSessionTomcatNumOverException;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.base.system.inf.SJbaseSystemInterface;
import sanproject.sn2.base.system.inf.SJbaseSystemStatusInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.SJcAuditLoggerNOP;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSystemUty;
import sanproject.sn2.com.utility.SJcUserUniqIDUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;

public class SJbaseUserSessionManager
implements SJbaseSystemInterface {
    private final String LOG_FUNCTION = "SessionManager";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private final String FNAME_TIME_LOGIN = "login.obj";
    private final String FNAME_TIME_LOGOUT = "logout.obj";
    private List<SJbaseUserSessionInterfaceInternal> sessionList;
    private SJbaseUserSessionManagerStatus status = new SJbaseUserSessionManagerStatus();
    private String userSessionPath;
    private String userDataPath;
    private String initDataDirPath;
    private long limitMemByteSizeExternal = 0L;
    private long limitMemByteSizeInternal = 0L;
    private int limitSessionNumPerAddr = -1;
    private int limitSessionNumPerTomcat = -1;
    private int limitSessionNum = 32;
    private int limitSVPSessionNum = 0;
    private String sessionClassName = null;
    private int sessionAliveCycle = -1;
    private long sessionMaintenanceInterval = 21600000L;
    private int sessionMaintananceKeepCount = 64;
    private long sessionTimeOutInterval = 60000L;
    private long sessionTimeOutExpireTime = 300000L;
    private SJbaseUserSessionWatchThread sessionMaintenanceTaskThread = null;
    private boolean stopSessionMaintenanceTaskThread;
    private SJbaseUserSessionWatchThread sessionTimeoutTaskThread = null;
    private boolean stopSessionTimeoutTaskThread;
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger();
    private SJcLoggerInterface systemLogger = SJcLogUty.getLogger("SN_System.log");
    String IMAGE_URL_KEY = "IMAGE_URL";
    private SJsessionClient client = null;

    @Override
    public void initialize() {
        String LOG_SUBTITLE = "initialize";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "initialize", "Start.");
        this.status.setPhase(1);
        this.status.setFatal(false);
        this.initEnvironment();
        this.cleanupPrestartProcess();
        this.sessionList = new ArrayList<SJbaseUserSessionInterfaceInternal>();
        this.startSessionMaintenanceTask();
        if (this.sessionTimeOutInterval >= 0L) {
            this.startSessionTimeoutTask();
        } else {
            stdLogger.info("SessionManager", this.LOG_TITLE, "initialize", "Session timeout interval is invalid.");
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("APPLICATIONID", "StorageNavigator2");
        try {
            this.client = SJsessionClient.getInstance(info);
        }
        catch (Exception e) {
            stdLogger.error("SessionManager", this.LOG_TITLE, "initialize", "Authentication module initialize is failed!");
        }
        this.status.setPhase(2);
        if (this.client == null) {
            this.status.setFatal(true);
        } else {
            this.status.setFatal(false);
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initialize", "End.");
    }

    @Override
    public void finish() {
        String LOG_SUBTITLE = "finish";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "Start.");
        this.status.setPhase(3);
        this.status.setFatal(false);
        this.logoutAll();
        this.stopSessionTimeoutTask();
        this.stopSessionMaintenanceTask();
        this.cleanUserSessionDirectory();
        if (this.client != null) {
            this.client.finish();
        }
        this.status.setPhase(4);
        this.status.setFatal(false);
        stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "End.");
    }

    @Override
    public SJbaseSystemStatusInterface getStatus() {
        String LOG_SUBTITLE = "getStatus";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.trace("SessionManager", this.LOG_TITLE, "getStatus", "Start.");
        stdLogger.trace("SessionManager", this.LOG_TITLE, "getStatus", "End. - phase:" + this.status.getPhase() + ",fatal" + this.status.isFatal());
        return this.status;
    }

    @Override
    public void abort_initialize() {
        String LOG_SUBTITLE = "abort_initialize";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "abort_initialize", "Start.");
        this.stopSessionTimeoutTask();
        this.stopSessionMaintenanceTask();
        this.status.setPhase(0);
        this.status.setFatal(false);
        stdLogger.info("SessionManager", this.LOG_TITLE, "abort_initialize", "End.");
    }

    @Override
    public void abort_finish() {
        String LOG_SUBTITLE = "abort_finish";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "abort_finish", "Start.");
        this.stopSessionTimeoutTask();
        this.stopSessionMaintenanceTask();
        this.status.setPhase(4);
        this.status.setFatal(false);
        stdLogger.info("SessionManager", this.LOG_TITLE, "abort_finish", "End.");
    }

    @Override
    public boolean destroy() {
        String LOG_SUBTITLE = "destroy";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.trace("SessionManager", this.LOG_TITLE, "destroy", "Start.");
        stdLogger.trace("SessionManager", this.LOG_TITLE, "destroy", "End.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJbaseUserSessionInterface login(SJbaseLoginEntry loginEntry) throws SJcException {
        String LOG_SUBTITLE = "login";
        String userId = "";
        if (loginEntry != null && loginEntry.getUserid() != null) {
            userId = loginEntry.getUserid();
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "login", "Start. User ID:" + userId);
        SJbaseUserSessionInterfaceInternal ret = null;
        if (null == loginEntry) {
            throw new SJbaseSessionLoginEntryParameterException("107040");
        }
        loginEntry.checkParameter();
        SJbaseUserSessionInterfaceInternal session = null;
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            this.checkLimit(loginEntry);
            session = (SJbaseUserSessionInterfaceInternal)this.addSession(loginEntry);
        }
        if (null != session) {
            Object obj;
            Object object = obj = SJbaseUserSessionLockManager.acquire(session.getUserID());
            synchronized (object) {
                HashMap<Object, Object> authResult = null;
                try {
                    try {
                        authResult = this.loginToAuthModule(loginEntry);
                    }
                    catch (SJcException sjex) {
                        List<SJbaseUserSessionInterfaceInternal> list2 = this.sessionList;
                        synchronized (list2) {
                            this.sessionList.remove(session);
                        }
                        if (sjex instanceof SJsessionAuthenticationException) {
                            HashMap loginFailedObj = ((SJsessionAuthenticationException)sjex).getAuthResult();
                            session.setUserName((String)loginFailedObj.get("AUTHENTICATION_USERID"));
                            session.setSessionIdentificationID((Integer)loginFailedObj.get("IDENTICAL_USERID"));
                        }
                        if (!session.getLoginType().equals("SVP")) {
                            this.LoginErrAdtLogWrite(session, sjex);
                        }
                        this.stdLogger.info("SessionManager", this.LOG_TITLE, "login", "Login failed.");
                        throw sjex;
                    }
                    HashMap userInfo = (HashMap)authResult.get("AUTHENTICATION_OBJECT");
                    session.setAuthObject(userInfo);
                    session.setSessionID((String)authResult.get("GLOBALSESSIONID"));
                    session.setPassword((String)authResult.get("AUTHORIZED_PASSWORD"));
                    session.setGroupID((String[])authResult.get("USERGROUPS"));
                    session.setRoleResourceInfo((SJcRoleResourceContainer)authResult.get("RESOURCE_ROLE"));
                    session.setUserID(loginEntry.getUserid());
                    session.setUserName((String)authResult.get("DISPLAY_USERID"));
                    session.setRequestDataObject(this.makeInitialDataObject(session));
                    session.setAuthSystemName((String)authResult.get("AUTHENTICATION_NAME"));
                    session.setUserUniqID((String)authResult.get("USER_IDENTICALNAME"));
                    this.initUserDirectory((String)authResult.get("USER_IDENTICALNAME"));
                    this.updateLoginTimeFile(session.getLoginTime(), (String)authResult.get("USER_IDENTICALNAME"));
                    session.setSessionIdentificationID((Integer)authResult.get("IDENTICAL_USERID"));
                    this.LoginAdtLogWrite(session, session.getLoginType());
                    session.initialize();
                }
                catch (SJcException sjex) {
                    List<SJbaseUserSessionInterfaceInternal> list3 = this.sessionList;
                    synchronized (list3) {
                        this.sessionList.remove(session);
                    }
                    if (!(sjex instanceof SJsessionClientException)) {
                        this.logoutToAuthModule(session);
                        if (!session.getLoginType().equals("SVP")) {
                            this.destroyAuditLog(session);
                        }
                        this.stdLogger.error("SessionManager", this.LOG_TITLE, "login", "Session initialization failed.");
                    }
                    throw sjex;
                }
                finally {
                    SJbaseUserSessionLockManager.release(obj);
                }
            }
        }
        ret = session;
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "login", "End. User ID:" + userId);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJbaseUserSessionInterface loginForRegularBackup(SJbaseLoginEntry loginEntry) throws SJcException {
        String LOG_SUBTITLE = "loginForRegularBackup";
        if (null == loginEntry) {
            throw new SJbaseSessionLoginEntryParameterException("107040");
        }
        String userId = "";
        if (loginEntry.getUserid() != null) {
            userId = loginEntry.getUserid();
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "loginForRegularBackup", "Start. User ID:" + userId);
        SJbaseUserSessionInterfaceInternal ret = null;
        loginEntry.checkParameterForRegularBackup();
        SJbaseUserSessionInterfaceInternal session = null;
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            this.checkLimitForRegularBackup();
            session = (SJbaseUserSessionInterfaceInternal)this.addSessionForRegularBackup(loginEntry);
        }
        if (null != session) {
            Object obj;
            Object object = obj = SJbaseUserSessionLockManager.acquire(session.getUserID());
            synchronized (object) {
                HashMap<Object, Object> authResult = null;
                try {
                    try {
                        authResult = this.loginToAuthModuleForRegularBackup(loginEntry);
                    }
                    catch (SJcException sjex) {
                        List<SJbaseUserSessionInterfaceInternal> list2 = this.sessionList;
                        synchronized (list2) {
                            this.sessionList.remove(session);
                        }
                        if (sjex instanceof SJsessionAuthenticationException) {
                            HashMap loginFailedObj = ((SJsessionAuthenticationException)sjex).getAuthResult();
                            session.setUserName((String)loginFailedObj.get("AUTHENTICATION_USERID"));
                            session.setSessionIdentificationID((Integer)loginFailedObj.get("IDENTICAL_USERID"));
                        }
                        this.stdLogger.info("SessionManager", this.LOG_TITLE, "loginForRegularBackup", "Login failed.");
                        throw sjex;
                    }
                    HashMap userInfo = (HashMap)authResult.get("AUTHENTICATION_OBJECT");
                    session.setAuthObject(userInfo);
                    session.setSessionID((String)authResult.get("GLOBALSESSIONID"));
                    session.setPassword((String)authResult.get("AUTHORIZED_PASSWORD"));
                    session.setGroupID((String[])authResult.get("USERGROUPS"));
                    session.setRoleResourceInfo((SJcRoleResourceContainer)authResult.get("RESOURCE_ROLE"));
                    session.setUserID(loginEntry.getUserid());
                    session.setUserName((String)authResult.get("DISPLAY_USERID"));
                    session.setRequestDataObject(this.makeInitialDataObject(session));
                    session.setAuthSystemName((String)authResult.get("AUTHENTICATION_NAME"));
                    session.setUserUniqID((String)authResult.get("USER_IDENTICALNAME"));
                    this.initUserDirectory((String)authResult.get("USER_IDENTICALNAME"));
                    this.updateLoginTimeFile(session.getLoginTime(), (String)authResult.get("USER_IDENTICALNAME"));
                    session.setSessionIdentificationID((Integer)authResult.get("IDENTICAL_USERID"));
                    SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger(session);
                    session.setAuditLogger(adtLogger);
                    session.initializeForRegularBackup();
                }
                catch (SJcException sjex) {
                    List<SJbaseUserSessionInterfaceInternal> list3 = this.sessionList;
                    synchronized (list3) {
                        this.sessionList.remove(session);
                    }
                    if (!(sjex instanceof SJsessionClientException)) {
                        this.logoutToAuthModule(session);
                        this.destroyAuditLog(session);
                        this.stdLogger.error("SessionManager", this.LOG_TITLE, "loginForRegularBackup", "Session initialization failed.");
                    }
                    throw sjex;
                }
                finally {
                    SJbaseUserSessionLockManager.release(obj);
                }
            }
        }
        ret = session;
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "loginForRegularBackup", "End. User ID:" + userId);
        return ret;
    }

    private SJctrRequestDataObject makeInitialDataObject(SJbaseUserSessionInterfaceInternal session) {
        SJctrRequestDataObject dataObject = new SJctrRequestDataObject();
        dataObject.setData("SNB_GLOBAL_SESSION_ID", (Object)session.getSessionID());
        dataObject.setData("SNB_LOGIN_USER_ID", (Object)session.getUserName());
        dataObject.setData("SNB_SESSION_ALIVE_TIME", (Object)this.sessionAliveCycle);
        dataObject.setData("SNB_IMAGE_URL", (Object)this.getImageURL(session));
        return dataObject;
    }

    private String[] getImageURL(SJbaseUserSessionInterfaceInternal session) {
        String LOG_SUBTITLE = "getImageURL";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getImageURL", "Start.");
        Object[] imageURL = null;
        if (session != null) {
            if (session.getAuthObject() != null) {
                try {
                    imageURL = (String[])session.getAuthObject().get(this.IMAGE_URL_KEY);
                }
                catch (ClassCastException e) {
                    this.stdLogger.info("SessionManager", this.LOG_TITLE, "getImageURL", "The exception was generated by IMAGE_URL_KEY. ");
                }
            } else {
                this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getImageURL", "userInfo is null");
            }
        } else {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "getImageURL", "session is null");
        }
        if (imageURL == null) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "getImageURL", "imageURL :" + imageURL);
        } else {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "getImageURL", "imageURL :" + Arrays.toString(imageURL));
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getImageURL", "End.");
        return imageURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String sessionID) throws SJcException {
        String LOG_SUBTITLE = "logout";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logout", "Start. - sessionID:" + sessionID);
        SJbaseUserSessionInterfaceInternal session = null;
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            session = this.getUserSessionPrm(sessionID);
        }
        if (null != session) {
            this.logoutSession(session);
            list = this.sessionList;
            synchronized (list) {
                this.sessionList.remove(session);
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logout", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutForRegularBackup(String sessionID) throws SJcException {
        String LOG_SUBTITLE = "logoutForRegularBackup";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutForRegularBackup", "Start. - sessionID:" + sessionID);
        SJbaseUserSessionInterfaceInternal session = null;
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            session = this.getUserSessionPrm(sessionID);
        }
        if (null != session) {
            this.logoutSessionForRegularBackup(session);
            list = this.sessionList;
            synchronized (list) {
                this.sessionList.remove(session);
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutForRegularBackup", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutIPAddress(InetAddress ipaddress) {
        String LOG_SUBTITLE = "logoutIPAddress";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutIPAddress", "Start. - ipaddress:" + ipaddress);
        SJbaseUserSessionInterfaceInternal[] wkSessionArray = null;
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            wkSessionArray = new SJbaseUserSessionInterfaceInternal[this.sessionList.size()];
            this.sessionList.toArray(wkSessionArray);
        }
        for (int i = 0; i < wkSessionArray.length; ++i) {
            if (!wkSessionArray[i].getAddress().equals(ipaddress)) continue;
            try {
                this.logoutSession(wkSessionArray[i]);
            }
            catch (SJcException sjex) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutIPAddress", "Failed to logout. sessionID:" + wkSessionArray[i].getSessionID());
            }
            List<SJbaseUserSessionInterfaceInternal> list2 = this.sessionList;
            synchronized (list2) {
                this.sessionList.remove(wkSessionArray[i]);
                continue;
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutIPAddress", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutOthers(String sessionID) {
        String LOG_SUBTITLE = "logoutOthers";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutOthers", "Start. - sessionID:" + sessionID);
        SJbaseUserSessionInterfaceInternal[] wkSessionArray = null;
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            wkSessionArray = new SJbaseUserSessionInterfaceInternal[this.sessionList.size()];
            this.sessionList.toArray(wkSessionArray);
        }
        for (int i = 0; i < wkSessionArray.length; ++i) {
            String acquiredSessionID = wkSessionArray[i].getSessionID();
            if (acquiredSessionID == null || acquiredSessionID.equals(sessionID)) continue;
            try {
                this.logoutSession(wkSessionArray[i]);
            }
            catch (SJcException sjex) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutOthers", "Failed to logout. sessionID:" + wkSessionArray[i].getSessionID());
            }
            List<SJbaseUserSessionInterfaceInternal> list2 = this.sessionList;
            synchronized (list2) {
                this.sessionList.remove(wkSessionArray[i]);
                continue;
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutOthers", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutAll() {
        String LOG_SUBTITLE = "logoutAll";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutAll", "Start.");
        SJbaseUserSessionInterfaceInternal[] wkSessionArray = null;
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            wkSessionArray = new SJbaseUserSessionInterfaceInternal[this.sessionList.size()];
            this.sessionList.toArray(wkSessionArray);
        }
        for (int i = 0; i < wkSessionArray.length; ++i) {
            try {
                this.logoutSession(wkSessionArray[i]);
            }
            catch (SJcException sjex) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutAll", "Failed to logout. sessionID:" + wkSessionArray[i].getSessionID());
            }
            List<SJbaseUserSessionInterfaceInternal> list2 = this.sessionList;
            synchronized (list2) {
                this.sessionList.remove(wkSessionArray[i]);
                continue;
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutAll", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutSession(SJbaseUserSessionInterfaceInternal session) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "logoutSession";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutSession", "Start. - sessionID:" + session.getSessionID());
        Object object = obj = SJbaseUserSessionLockManager.acquire(session.getUserID());
        synchronized (object) {
            block17: {
                try {
                    String sessionID = session.getSessionID();
                    if (null == sessionID) break block17;
                    try {
                        session.finish();
                        long logoutTime = System.currentTimeMillis();
                        this.updateLogoutTimeFile(logoutTime, session.getUserUniqID());
                        session.setLogoutTime(logoutTime);
                        session.setSessionID(null);
                        HashMap<String, String> logoutInfo = new HashMap<String, String>();
                        logoutInfo.put("GLOBALSESSIONID", sessionID);
                        try {
                            this.client.logout(logoutInfo);
                        }
                        catch (Throwable e) {
                            this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutSession", "Logout error occured.");
                        }
                    }
                    catch (SJcException sjce) {
                        this.logoutToAuthModule(session);
                        throw sjce;
                    }
                    catch (Exception e) {
                        this.logoutToAuthModule(session);
                        this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutSession", "Failed to finish session", e);
                    }
                    finally {
                        if (!session.getLoginType().equals("SVP")) {
                            this.LogoutAdtLogWrite(session);
                        }
                    }
                }
                catch (SJcException sjex) {
                    throw sjex;
                }
                finally {
                    SJbaseUserSessionLockManager.release(obj);
                }
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutSession", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutSessionForRegularBackup(SJbaseUserSessionInterfaceInternal session) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "logoutSessionForRegularBackup";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutSessionForRegularBackup", "Start. - sessionID:" + session.getSessionID());
        Object object = obj = SJbaseUserSessionLockManager.acquire(session.getUserID());
        synchronized (object) {
            block15: {
                try {
                    String sessionID = session.getSessionID();
                    if (null == sessionID) break block15;
                    try {
                        session.finishForRegularBackup();
                        long logoutTime = System.currentTimeMillis();
                        this.updateLogoutTimeFile(logoutTime, session.getUserUniqID());
                        session.setLogoutTime(logoutTime);
                        session.setSessionID(null);
                        HashMap<String, String> logoutInfo = new HashMap<String, String>();
                        logoutInfo.put("GLOBALSESSIONID", sessionID);
                        try {
                            this.client.logout(logoutInfo);
                        }
                        catch (Throwable e) {
                            this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutSessionForRegularBackup", "Logout error occured.");
                        }
                    }
                    catch (SJcException sjce) {
                        this.logoutToAuthModule(session);
                        throw sjce;
                    }
                    catch (Exception e) {
                        this.logoutToAuthModule(session);
                        this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutSessionForRegularBackup", "Failed to finish session", e);
                    }
                }
                catch (SJcException sjex) {
                    throw sjex;
                }
                finally {
                    SJbaseUserSessionLockManager.release(obj);
                }
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutSessionForRegularBackup", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SJbaseUserSessionInterface> getAllUserSession() {
        String LOG_SUBTITLE = "getAllUserSession";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getAllUserSession", "Start.");
        ArrayList<SJbaseUserSessionInterface> ret = new ArrayList<SJbaseUserSessionInterface>();
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            ListIterator<SJbaseUserSessionInterfaceInternal> iterator = this.sessionList.listIterator();
            while (iterator.hasNext()) {
                SJbaseUserSessionInterface session = iterator.next();
                ret.add(session);
            }
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getAllUserSession", "End.");
        return ret;
    }

    public SJbaseUserSessionInterface getUserSession(String sessionID) {
        String LOG_SUBTITLE = "getUserSession";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserSession", "Start. - sessionID:" + sessionID);
        SJbaseUserSessionInterfaceInternal ret = this.getUserSessionPrm(sessionID);
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserSession", "End.");
        return ret;
    }

    public long getLastLoginTime(String userUniqID) {
        String LOG_SUBTITLE = "getLastLoginTime";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getLastLoginTime", "Start. - userUniqID:" + userUniqID);
        long ret = -1L;
        if (null != userUniqID) {
            String dir = SJcFileUty.concatFolderPath(this.userDataPath, userUniqID);
            String data = null;
            try {
                data = SJcFileUty.loadText(dir, "login.obj");
            }
            catch (SJcException e) {
                this.stdLogger.info("SessionManager", this.LOG_TITLE, "getLastLoginTime", "Failed to read login time file. userUniqID:" + userUniqID);
            }
            if (null != data) {
                try {
                    ret = Long.parseLong(data);
                }
                catch (NumberFormatException e) {
                    this.stdLogger.error("SessionManager", this.LOG_TITLE, "getLastLoginTime", "Failed to parse login time file data. userUniqID:" + userUniqID + ",data:" + data, e);
                }
            }
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getLastLoginTime", "End. - return:" + ret);
        return ret;
    }

    public long getLastLogoutTime(String userUniqID) {
        String LOG_SUBTITLE = "getLastLogoutTime";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getLastLogoutTime", "Start. - userUniqID:" + userUniqID);
        long ret = -1L;
        if (null != userUniqID) {
            String dir = SJcFileUty.concatFolderPath(this.userDataPath, userUniqID);
            String data = null;
            try {
                data = SJcFileUty.loadText(dir, "logout.obj");
            }
            catch (SJcException e) {
                this.stdLogger.info("SessionManager", this.LOG_TITLE, "getLastLogoutTime", "Failed to read logout time file. userUniqID:" + userUniqID);
            }
            if (null != data) {
                try {
                    ret = Long.parseLong(data);
                }
                catch (NumberFormatException e) {
                    this.stdLogger.error("SessionManager", this.LOG_TITLE, "getLastLogoutTime", "Failed to parse logout time file data. userUniqID:" + userUniqID + ",data:" + data, e);
                }
            }
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getLastLogoutTime", "End. - return:" + ret);
        return ret;
    }

    private void cleanupPrestartProcess() {
        String LOG_SUBTITLE = "cleanupPrestartProcess";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "cleanupPrestartProcess", "Start.");
        this.cleanUserSessionDirectory();
        stdLogger.info("SessionManager", this.LOG_TITLE, "cleanupPrestartProcess", "End.");
    }

    private void cleanUserSessionDirectory() {
        String LOG_SUBTITLE = "cleanUserSessionDirectory";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "cleanUserSessionDirectory", "Start.");
        String[] dlist = null;
        try {
            dlist = SJcFileUty.getDirectoryList(this.userSessionPath);
        }
        catch (Exception e) {
            stdLogger.error("SessionManager", this.LOG_TITLE, "cleanUserSessionDirectory", "Failed to list directories usersession path. direcotry:" + this.userSessionPath, e);
        }
        if (null != dlist) {
            for (int i = 0; i < dlist.length; ++i) {
                try {
                    SJcFileUty.deleteFile(this.userSessionPath, dlist[i]);
                    continue;
                }
                catch (SJcException e) {
                    stdLogger.error("SessionManager", this.LOG_TITLE, "cleanUserSessionDirectory", "Failed to cleanup tmp userdata. direcotry:" + dlist[i], e);
                }
            }
        }
        String[] flist = null;
        try {
            flist = SJcFileUty.getFileList(this.userSessionPath);
        }
        catch (Exception e) {
            stdLogger.error("SessionManager", this.LOG_TITLE, "cleanUserSessionDirectory", "Failed to list files usersession path. direcotry:" + this.userSessionPath, e);
        }
        if (null != flist) {
            for (int i = 0; i < flist.length; ++i) {
                try {
                    SJcFileUty.deleteFile(this.userSessionPath, flist[i]);
                    continue;
                }
                catch (SJcException e) {
                    stdLogger.error("SessionManager", this.LOG_TITLE, "cleanUserSessionDirectory", "Failed to cleanup tmp userdata. file:" + flist[i], e);
                }
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "cleanUserSessionDirectory", "End.");
    }

    private void startSessionMaintenanceTask() {
        String LOG_SUBTITLE = "startSessionMaintenanceTask";
        final SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "startSessionMaintenanceTask", "Start.");
        if (this.sessionMaintenanceInterval < 0L) {
            stdLogger.info("SessionManager", this.LOG_TITLE, "startSessionMaintenanceTask", "Interval time of session maintenance task is invalid. Session maintenance task does not start.");
        } else if (this.sessionMaintananceKeepCount < 0) {
            stdLogger.info("SessionManager", this.LOG_TITLE, "startSessionMaintenanceTask", "Keep count is invalid. Session maintenance task does not start.");
        } else {
            this.sessionMaintenanceTaskThread = new SJbaseUserSessionWatchThread(){

                @Override
                public void run() {
                    try {
                        SJbaseUserSessionManager.this.maintenanceTaskPolling();
                    }
                    catch (InterruptedException e) {
                        stdLogger.info("SessionManager", SJbaseUserSessionManager.this.LOG_TITLE, "startSessionMaintenanceTask", "Thread interrupted.");
                        Thread.currentThread().interrupt();
                    }
                }
            };
            this.stopSessionMaintenanceTaskThread = false;
            this.sessionMaintenanceTaskThread.start();
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "startSessionMaintenanceTask", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintenanceTaskPolling() throws InterruptedException {
        String LOG_SUBTITLE = "maintenanceTaskPolling";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Start.");
        while (!this.stopSessionMaintenanceTaskThread && null != this.sessionMaintenanceTaskThread) {
            stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Loop Start.");
            SJbaseUserSessionWatchThread sJbaseUserSessionWatchThread = this.sessionMaintenanceTaskThread;
            synchronized (sJbaseUserSessionWatchThread) {
                stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Wait Start.");
                this.sessionMaintenanceTaskThread.wait(this.sessionMaintenanceInterval);
                stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Wait Return.");
            }
            if (this.stopSessionMaintenanceTaskThread) break;
            String[] userUniqIDs = SJcUserUniqIDUty.getUserUniqIDList();
            ArrayList<SJbaseUserSessionUniqDirInfo> targetUniqIDDirList = new ArrayList<SJbaseUserSessionUniqDirInfo>();
            int loginCount = 0;
            List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
            synchronized (list) {
                String[] uniqIDDirs = null;
                try {
                    uniqIDDirs = SJcFileUty.getDirectoryList(this.userDataPath);
                }
                catch (Exception e) {
                    stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Failed to list userdata directory.", e);
                    continue;
                }
                for (int i = 0; i < uniqIDDirs.length; ++i) {
                    String userUniqId = uniqIDDirs[i];
                    if (this.isUserLogined(userUniqId)) {
                        ++loginCount;
                        continue;
                    }
                    if (this.isUserAccountDeleted(userUniqId, userUniqIDs)) {
                        try {
                            stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Deleting :" + userUniqId);
                            SJcFileUty.deleteFile(this.userDataPath, userUniqId);
                        }
                        catch (SJcException e) {
                            stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Failed to delete user directory already deleted account.", e);
                        }
                        continue;
                    }
                    long timeStamp = 0L;
                    try {
                        String path = SJcFileUty.concatFolderPath(this.userDataPath, userUniqId);
                        String timeStampStr = SJcFileUty.loadText(path, "logout.obj");
                        timeStamp = Long.parseLong(timeStampStr);
                    }
                    catch (SJcException e) {
                        stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Failed to read userdata logout time file.", e);
                    }
                    SJbaseUserSessionUniqDirInfo dirInfo = new SJbaseUserSessionUniqDirInfo();
                    dirInfo.setDirName(userUniqId);
                    dirInfo.setTimeStamp(timeStamp);
                    targetUniqIDDirList.add(dirInfo);
                }
                Collections.sort(targetUniqIDDirList);
                int deleteCount = targetUniqIDDirList.size() - (this.sessionMaintananceKeepCount + loginCount);
                if (deleteCount < 0) {
                    deleteCount = 0;
                }
                int executeCount = 0;
                ListIterator iterator = targetUniqIDDirList.listIterator();
                while (iterator.hasNext() && executeCount < deleteCount) {
                    SJbaseUserSessionUniqDirInfo dirInfo = (SJbaseUserSessionUniqDirInfo)iterator.next();
                    try {
                        stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Deleting :" + dirInfo.getDirName());
                        SJcFileUty.deleteFile(this.userDataPath, dirInfo.getDirName());
                    }
                    catch (SJcException e) {
                        stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "Failed to delete expired user data directory. dir:" + dirInfo.getDirName(), e);
                    }
                    finally {
                        ++executeCount;
                    }
                }
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "maintenanceTaskPolling", "End.");
    }

    private boolean isUserLogined(String userUniqID) {
        boolean ret = false;
        ListIterator<SJbaseUserSessionInterfaceInternal> iterator = this.sessionList.listIterator();
        while (iterator.hasNext()) {
            SJbaseUserSessionInterfaceInternal session = iterator.next();
            if (session.getUserUniqID() == null || !session.getUserUniqID().equals(userUniqID)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean isUserAccountDeleted(String targetUserUniqID, String[] userUniqIDs) {
        boolean ret = true;
        if (null != userUniqIDs) {
            for (int i = 0; i < userUniqIDs.length; ++i) {
                if (!targetUserUniqID.equals(userUniqIDs[i])) continue;
                ret = false;
                break;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSessionMaintenanceTask() {
        String LOG_SUBTITLE = "stopSessionMaintenanceTask";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionMaintenanceTask", "Start.");
        if (null == this.sessionMaintenanceTaskThread) {
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionMaintenanceTask", "Thread is already null.");
            return;
        }
        SJbaseUserSessionWatchThread sJbaseUserSessionWatchThread = this.sessionMaintenanceTaskThread;
        synchronized (sJbaseUserSessionWatchThread) {
            this.stopSessionMaintenanceTaskThread = true;
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionMaintenanceTask", "Thread notify start.");
            this.sessionMaintenanceTaskThread.notify();
        }
        try {
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionMaintenanceTask", "Thread join start.");
            this.sessionMaintenanceTaskThread.join();
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionMaintenanceTask", "Thread join end.");
        }
        catch (InterruptedException e) {
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionMaintenanceTask", "Join interrupted.");
            Thread.currentThread().interrupt();
        }
        this.sessionMaintenanceTaskThread = null;
        stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionMaintenanceTask", "End.");
    }

    private void startSessionTimeoutTask() {
        String LOG_SUBTITLE = "startSessionTimeoutTask";
        final SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "startSessionTimeoutTask", "Start.");
        this.sessionTimeoutTaskThread = new SJbaseUserSessionWatchThread(){

            @Override
            public void run() {
                try {
                    SJbaseUserSessionManager.this.timeoutTaskPolling();
                }
                catch (InterruptedException e) {
                    stdLogger.info("SessionManager", SJbaseUserSessionManager.this.LOG_TITLE, "startSessionTimeoutTask", "Thread interrupted.");
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.stopSessionTimeoutTaskThread = false;
        this.sessionTimeoutTaskThread.start();
        stdLogger.info("SessionManager", this.LOG_TITLE, "startSessionTimeoutTask", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutTaskPolling() throws InterruptedException {
        String LOG_SUBTITLE = "timeoutTaskPolling";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.info("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "Start.");
        while (!this.stopSessionTimeoutTaskThread && null != this.sessionTimeoutTaskThread) {
            SJbaseUserSessionWatchThread sJbaseUserSessionWatchThread = this.sessionTimeoutTaskThread;
            synchronized (sJbaseUserSessionWatchThread) {
                stdLogger.info("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "Wait Start.");
                this.sessionTimeoutTaskThread.wait(this.sessionTimeOutInterval);
                stdLogger.info("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "Wait Return.");
            }
            if (this.stopSessionTimeoutTaskThread) break;
            SJbaseUserSessionInterfaceInternal[] wkSessionArray = null;
            List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
            synchronized (list) {
                wkSessionArray = new SJbaseUserSessionInterfaceInternal[this.sessionList.size()];
                this.sessionList.toArray(wkSessionArray);
            }
            for (int i = 0; i < wkSessionArray.length; ++i) {
                long lastAccessTime = wkSessionArray[i].getLastAccessTime();
                long currentTime = System.nanoTime() / 1000000L;
                if (this.sessionTimeOutExpireTime < 0L) {
                    stdLogger.trace("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "Ignore session timeout. sessionID:" + wkSessionArray[i].getSessionID());
                    continue;
                }
                if (currentTime - lastAccessTime < this.sessionTimeOutExpireTime && currentTime - lastAccessTime >= 0L) continue;
                if (currentTime - lastAccessTime < 0L) {
                    stdLogger.warn("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "System progress time went around. CurrentTime:" + currentTime + " LastAccessTime:" + lastAccessTime);
                }
                stdLogger.info("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "Session is timeout. sessionID:" + wkSessionArray[i].getSessionID());
                stdLogger.info("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "CurrentTime:" + currentTime + " LastAccessTime:" + lastAccessTime);
                try {
                    this.logoutSession(wkSessionArray[i]);
                }
                catch (SJcException e) {
                    stdLogger.error("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "Failed to logout. sessionID:" + wkSessionArray[i].getSessionID());
                }
                List<SJbaseUserSessionInterfaceInternal> list2 = this.sessionList;
                synchronized (list2) {
                    this.sessionList.remove(wkSessionArray[i]);
                    continue;
                }
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "timeoutTaskPolling", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSessionTimeoutTask() {
        String LOG_SUBTITLE = "stopSessionTimeoutTask";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.trace("SessionManager", this.LOG_TITLE, "stopSessionTimeoutTask", "Start.");
        if (null == this.sessionTimeoutTaskThread) {
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionTimeoutTask", "Thread is already null.");
            return;
        }
        SJbaseUserSessionWatchThread sJbaseUserSessionWatchThread = this.sessionTimeoutTaskThread;
        synchronized (sJbaseUserSessionWatchThread) {
            this.stopSessionTimeoutTaskThread = true;
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionTimeoutTask", "Thread notify start.");
            this.sessionTimeoutTaskThread.notify();
        }
        try {
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionTimeoutTask", "Thread join start.");
            this.sessionTimeoutTaskThread.join();
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionTimeoutTask", "Thread join end.");
        }
        catch (InterruptedException e) {
            stdLogger.info("SessionManager", this.LOG_TITLE, "stopSessionTimeoutTask", "Join interrupted.");
            Thread.currentThread().interrupt();
        }
        this.sessionTimeoutTaskThread = null;
        stdLogger.trace("SessionManager", this.LOG_TITLE, "stopSessionTimeoutTask", "End.");
    }

    private void initEnvironment() {
        String LOG_SUBTITLE = "initEnvironment";
        SJcLoggerInterface stdLogger = this.systemLogger;
        stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
        this.initDataDirPath = SJbaseConst.SN_DIRECTORY_BASE_USERDATA_INIT;
        this.userSessionPath = SJbaseConst.SN_DIRECTORY_BASE_TMP_USERSESSION;
        this.userDataPath = SJbaseConst.SN_DIRECTORY_BASE_USERDATA;
        String key = "SN_Base_LimitMemLoginExternal";
        String val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.limitMemByteSizeExternal = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_LimitMemLoginInternal";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.limitMemByteSizeInternal = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_LimitSessionPerAddress";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.limitSessionNumPerAddr = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_OneSession_LimitNum";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.limitSessionNumPerTomcat = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_LimitSessionNum";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.limitSessionNum = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_LimitSVPSessionNum";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.limitSVPSessionNum = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Failed to get limitSVPSessionNum.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_UserSession";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            this.sessionClassName = val;
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_StockUserInfoClearInterval";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.sessionMaintenanceInterval = Long.parseLong(val) * 1000L;
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_StockUserInfo";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.sessionMaintananceKeepCount = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_SessionTimeoutCheckInterval";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.sessionTimeOutInterval = Long.parseLong(val) * 1000L;
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_SessionExpireTime";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.sessionTimeOutExpireTime = Long.parseLong(val) * 1000L;
            }
            catch (NumberFormatException e) {
                stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
            }
        }
        stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "End.");
    }

    private void checkLimit(SJbaseLoginEntry loginEntry) throws SJcException {
        String LOG_SUBTITLE = "checkLimit";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimit", "Start.");
        this.checkLimitMemory(loginEntry);
        this.checkLimitSessionTomcat(loginEntry);
        this.checkLimitSessionSystem(loginEntry);
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimit", "End.");
    }

    private void checkLimitForRegularBackup() throws SJcException {
        String LOG_SUBTITLE = "checkLimitForRegularBackup";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitForRegularBackup", "Start.");
        this.checkLimitMemoryForRegularBackup();
        this.checkLimitSessionSystemForRegularBackup();
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitForRegularBackup", "End.");
    }

    private void checkLimitMemory(SJbaseLoginEntry loginEntry) throws SJcException {
        long freeMemory;
        String LOG_SUBTITLE = "checkLimitMemory";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitMemory", "Start.");
        InetAddress remoteAddr = this.getAddressFromHttpRequest(loginEntry.getHttpRequest());
        long needMemory = SJcSystemUty.chkIP_Myself(remoteAddr) ? this.limitMemByteSizeInternal : this.limitMemByteSizeExternal;
        if (0L <= needMemory && (freeMemory = SJcSystemUty.getFreeMemory()) <= needMemory) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkLimitMemory", "Not enough memory to login. free:" + freeMemory);
            throw new SJbaseSessionMemoryOverException("107036");
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitMemory", "End.");
    }

    private void checkLimitMemoryForRegularBackup() throws SJcException {
        long freeMemory;
        String LOG_SUBTITLE = "checkLimitMemoryForRegularBackup";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitMemoryForRegularBackup", "Start.");
        long needMemory = this.limitMemByteSizeInternal;
        if (0L <= needMemory && (freeMemory = SJcSystemUty.getFreeMemory()) <= needMemory) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkLimitMemoryForRegularBackup", "Not enough memory to login. free:" + freeMemory);
            throw new SJbaseSessionMemoryOverException("107036");
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitMemoryForRegularBackup", "End.");
    }

    private void checkLimitSessionIPAddr(SJbaseLoginEntry loginEntry) throws SJcException {
        String LOG_SUBTITLE = "checkLimitSessionIPAddr";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitSessionIPAddr", "Start.");
        if (SJcSystemUty.chkIP_Myself(this.getAddressFromHttpRequest(loginEntry.getHttpRequest()))) {
            if (this.isLocalhostLoggedin()) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkLimitSessionIPAddr", "Already logged in from localhost.");
                throw new SJbaseSessionIPNumOverException("107037");
            }
        } else if (0 <= this.limitSessionNumPerAddr) {
            InetAddress remoteAddr = this.getAddressFromHttpRequest(loginEntry.getHttpRequest());
            ListIterator<SJbaseUserSessionInterfaceInternal> iterator = this.sessionList.listIterator();
            int counter = 0;
            while (iterator.hasNext()) {
                SJbaseUserSessionInterfaceInternal session = iterator.next();
                if (!remoteAddr.equals(session.getAddress())) continue;
                ++counter;
            }
            if (this.limitSessionNumPerAddr <= counter) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkLimitSessionIPAddr", "Sessions of same address are full. sessions:" + counter);
                throw new SJbaseSessionIPNumOverException("107037");
            }
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitSessionIPAddr", "End.");
    }

    private void checkLimitSessionTomcat(SJbaseLoginEntry loginEntry) throws SJcException {
        String LOG_SUBTITLE = "checkLimitSessionTomcat";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitSessionTomcat", "Start.");
        if (0 <= this.limitSessionNumPerTomcat) {
            String remoteTMCsession = loginEntry.getHttpRequest().getSession().getId();
            ListIterator<SJbaseUserSessionInterfaceInternal> iterator = this.sessionList.listIterator();
            int counter = 0;
            while (iterator.hasNext()) {
                SJbaseUserSessionInterfaceInternal session = iterator.next();
                if (!remoteTMCsession.equals(session.getHttpSession().getId())) continue;
                ++counter;
            }
            if (this.limitSessionNumPerTomcat <= counter) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkLimitSessionTomcat", "Sessions of same tomcat session are full. sessions:" + counter);
                throw new SJbaseSessionTomcatNumOverException("107038");
            }
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitSessionTomcat", "End.");
    }

    private void checkLimitSessionSystem(SJbaseLoginEntry loginEntry) throws SJcException {
        String LOG_SUBTITLE = "checkLimitSessionSystem";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitSessionSystem", "Start.");
        if (0 <= this.limitSessionNum) {
            int size;
            int maxSessionNum = this.limitSessionNum;
            if (SJcSystemUty.chkIP_Myself(this.getAddressFromHttpRequest(loginEntry.getHttpRequest())) && 0 < this.limitSessionNum && this.getSVPSessionNum() < this.limitSVPSessionNum) {
                maxSessionNum = this.limitSessionNum + this.limitSVPSessionNum;
            }
            if (maxSessionNum <= (size = this.sessionList.size())) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkLimitSessionSystem", "Session count is over the limit. session:" + size);
                throw new SJbaseSessionNumOverException("107039");
            }
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitSessionSystem", "End.");
    }

    private void checkLimitSessionSystemForRegularBackup() throws SJcException {
        String LOG_SUBTITLE = "checkLimitSessionSystemForRegularBackup";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitSessionSystemForRegularBackup", "Start.");
        if (0 <= this.limitSessionNum) {
            int size;
            int maxSessionNum = this.limitSessionNum;
            if (0 < this.limitSessionNum && this.getSVPSessionNum() < this.limitSVPSessionNum) {
                maxSessionNum = this.limitSessionNum + this.limitSVPSessionNum;
            }
            if (maxSessionNum <= (size = this.sessionList.size())) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkLimitSessionSystemForRegularBackup", "Session count is over the limit. session:" + size);
                throw new SJbaseSessionNumOverException("107039");
            }
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkLimitSessionSystemForRegularBackup", "End.");
    }

    private InetAddress getAddressFromHttpRequest(HttpServletRequest req) {
        String LOG_SUBTITLE = "getAddressFromHttpRequest";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getAddressFromHttpRequest", "Start.");
        InetAddress ret = null;
        try {
            ret = InetAddress.getByName(req.getRemoteAddr());
        }
        catch (UnknownHostException e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "getAddressFromHttpRequest", "Failed to create InetAddress from address of HttpServletRequest", e);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getAddressFromHttpRequest", "End. - ret:" + ret);
        return ret;
    }

    private boolean isLocalhostLoggedin() {
        String LOG_SUBTITLE = "isLocalhostLoggedin";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "isLocalhostLoggedin", "Start.");
        boolean ret = false;
        ListIterator<SJbaseUserSessionInterfaceInternal> iterator = this.sessionList.listIterator();
        while (iterator.hasNext()) {
            SJbaseUserSessionInterfaceInternal session = iterator.next();
            if (!SJcSystemUty.chkIP_Myself(session.getAddress())) continue;
            ret = true;
            break;
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "isLocalhostLoggedin", "End. - ret:" + ret);
        return ret;
    }

    private int getSVPSessionNum() {
        int ret = 0;
        ListIterator<SJbaseUserSessionInterfaceInternal> iterator = this.sessionList.listIterator();
        while (iterator.hasNext()) {
            SJbaseUserSessionInterfaceInternal session = iterator.next();
            if (!SJcSystemUty.chkIP_Myself(session.getAddress())) continue;
            ++ret;
        }
        return ret;
    }

    private SJbaseUserSessionInterface addSession(SJbaseLoginEntry loginEntry) throws SJcException {
        SJbaseUserSessionInterfaceInternal ret = null;
        String LOG_SUBTITLE = "addSession";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "addSession", "Start.");
        try {
            Class<?> clazz = Class.forName(this.sessionClassName);
            ret = (SJbaseUserSessionInterfaceInternal)clazz.newInstance();
            ret.setSessionID(null);
            ret.setUserID(loginEntry.getUserid());
            ret.setPassword(loginEntry.getPassword());
            ret.setHttpSession(loginEntry.getHttpRequest().getSession());
            ret.setLanguageType(loginEntry.getLang());
            ret.setAddress(this.getAddressFromHttpRequest(loginEntry.getHttpRequest()));
            ret.setLoginType(loginEntry.getLoginType());
            long currentTime = System.currentTimeMillis();
            ret.setLoginTime(currentTime);
            ret.setLogoutTime(0L);
            ret.setLastAccessTime(System.nanoTime() / 1000000L);
            this.sessionList.add(ret);
        }
        catch (Exception e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "addSession", "Not found class name for user session. name:" + this.sessionClassName, e);
            throw new SJbaseInvalidSessionException("107042");
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "addSession", "End. - ret:" + ret);
        return ret;
    }

    private SJbaseUserSessionInterface addSessionForRegularBackup(SJbaseLoginEntry loginEntry) throws SJcException {
        SJbaseUserSessionInterfaceInternal ret = null;
        String LOG_SUBTITLE = "addSessionForRegularBackup";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "addSessionForRegularBackup", "Start.");
        try {
            Class<?> clazz = Class.forName(this.sessionClassName);
            ret = (SJbaseUserSessionInterfaceInternal)clazz.newInstance();
            ret.setSessionID(null);
            ret.setUserID(loginEntry.getUserid());
            ret.setPassword(loginEntry.getPassword());
            ret.setLanguageType(loginEntry.getLang());
            ret.setAddress(InetAddress.getLocalHost());
            ret.setLoginType(loginEntry.getLoginType());
            long currentTime = System.currentTimeMillis();
            ret.setLoginTime(currentTime);
            ret.setLogoutTime(0L);
            ret.setLastAccessTime(System.nanoTime() / 1000000L);
            this.sessionList.add(ret);
        }
        catch (Exception e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "addSessionForRegularBackup", "Not found class name for user session. name:" + this.sessionClassName, e);
            throw new SJbaseInvalidSessionException("107042");
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "addSessionForRegularBackup", "End. - ret:" + ret);
        return ret;
    }

    private void initUserDirectory(String userUniqID) throws SJcException {
        String LOG_SUBTITLE = "initUserDirectory";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initUserDirectory", "Start. - userUniqID:" + userUniqID);
        String userUniqDirPath = SJcFileUty.concatFolderPath(this.userDataPath, userUniqID);
        try {
            if (!SJcFileUty.exists(userUniqDirPath)) {
                if (!SJcFileUty.makeDirectory(userUniqDirPath)) {
                    throw new SJcException();
                }
                SJcFileUty.copyFile("", this.initDataDirPath, "", userUniqDirPath);
            } else {
                String[] initFileList;
                for (String initFile : initFileList = SJcFileUty.getFileList(this.initDataDirPath)) {
                    String path = userUniqDirPath + initFile;
                    if (SJcFileUty.exists(path)) continue;
                    SJcFileUty.copyFile(this.initDataDirPath, initFile, "", path);
                }
            }
        }
        catch (SJcException sjex) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "initUserDirectory", "Failed to init user directory.");
            throw new SJbaseSessionInitUserDirException("107044");
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initUserDirectory", "End.");
    }

    private void updateLoginTimeFile(long time, String userUniqID) {
        String LOG_SUBTITLE = "updateLoginTimeFile";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "updateLoginTimeFile", "Start. - time:" + time + ",userUniqID:" + userUniqID);
        String data = String.valueOf(time);
        String dir = SJcFileUty.concatFolderPath(this.userDataPath, userUniqID);
        try {
            if (!SJcFileUty.exists(dir)) {
                SJcFileUty.makeDirectory(dir);
            }
            SJcFileUty.saveText(dir, "login.obj", data);
        }
        catch (SJcException e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "updateLoginTimeFile", "Failed to update login time file. userUniqID:" + userUniqID, e);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "updateLoginTimeFile", "End.");
    }

    private void updateLogoutTimeFile(long time, String userUniqID) {
        String LOG_SUBTITLE = "updateLogoutTimeFile";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "updateLogoutTimeFile", "Start. - time:" + time + ",userUniqID:" + userUniqID);
        String data = String.valueOf(time);
        String dir = SJcFileUty.concatFolderPath(this.userDataPath, userUniqID);
        try {
            if (!SJcFileUty.exists(dir)) {
                SJcFileUty.makeDirectory(dir);
            }
            SJcFileUty.saveText(dir, "logout.obj", data);
        }
        catch (SJcException e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "updateLogoutTimeFile", "Failed to update logout time file. userUniqID:" + userUniqID, e);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "updateLogoutTimeFile", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SJbaseUserSessionInterfaceInternal getUserSessionPrm(String sessionID) {
        SJbaseUserSessionInterfaceInternal ret = null;
        if (this.sessionList == null) {
            return ret;
        }
        List<SJbaseUserSessionInterfaceInternal> list = this.sessionList;
        synchronized (list) {
            ListIterator<SJbaseUserSessionInterfaceInternal> iterator = this.sessionList.listIterator();
            while (iterator.hasNext()) {
                SJbaseUserSessionInterfaceInternal session = iterator.next();
                String acquiredSessionID = session.getSessionID();
                if (acquiredSessionID == null || !acquiredSessionID.equals(sessionID)) continue;
                ret = session;
                break;
            }
        }
        return ret;
    }

    private synchronized void LoginAdtLogWrite(SJbaseUserSessionInterfaceInternal session, String loginType) {
        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger(session);
        session.setAuditLogger(adtLogger);
        if (!loginType.equals("SVP")) {
            adtLogger.login(null);
        }
    }

    private synchronized void LoginErrAdtLogWrite(SJbaseUserSessionInterfaceInternal session, SJcException ex) {
        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger(session);
        adtLogger.login(ex);
        adtLogger.destroy();
    }

    private synchronized void LogoutAdtLogWrite(SJbaseUserSessionInterfaceInternal session) {
        SJcAuditLoggerInterface adtLogger = session.getAuditLogger();
        if (adtLogger != null) {
            adtLogger.logout(null);
            adtLogger.destroy();
            session.setAuditLogger(new SJcAuditLoggerNOP());
        }
    }

    private synchronized void destroyAuditLog(SJbaseUserSessionInterfaceInternal session) {
        SJcAuditLoggerInterface adtLogger = session.getAuditLogger();
        if (adtLogger != null) {
            adtLogger.destroy();
            session.setAuditLogger(new SJcAuditLoggerNOP());
        }
    }

    public String getUserSessionkey(String globalID) {
        return "SNUser_" + globalID;
    }

    public String getLastResponseKey(String globalID) {
        return "SNRes_" + globalID;
    }

    public String getThreadMapKey(String globalID) {
        return "FlexBridgeThreadMap_" + globalID;
    }

    private HashMap<Object, Object> loginToAuthModule(SJbaseLoginEntry loginEntry) {
        String LOG_SUBTITLE = "loginToAuthModule";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "loginToAuthModule", "Start.");
        HashMap<String, String> loginInfo = new HashMap<String, String>();
        loginInfo.put("AUTHENTICATION_USERID", loginEntry.getUserid());
        loginInfo.put("AUTHENTICATION_PASSWORD", loginEntry.getPassword());
        loginInfo.put("LOGINTYPE", loginEntry.getLoginType());
        loginInfo.put("LANG", loginEntry.getLang());
        loginInfo.put("ADDRESS", loginEntry.getHttpRequest().getRemoteHost());
        loginInfo.put("LOGINDEMAND", "LOGIN_SN2USER");
        HashMap clientLoginResult = null;
        try {
            clientLoginResult = this.client.login(loginInfo);
        }
        catch (Exception e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "loginToAuthModule", "Failed to login to authentication base. user:" + loginEntry.getUserid());
            throw (SJcException)e;
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "loginToAuthModule", "End.");
        return clientLoginResult;
    }

    private HashMap<Object, Object> loginToAuthModuleForRegularBackup(SJbaseLoginEntry loginEntry) {
        String LOG_SUBTITLE = "loginToAuthModuleForRegularBackup";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "loginToAuthModuleForRegularBackup", "Start.");
        HashMap<String, String> loginInfo = new HashMap<String, String>();
        loginInfo.put("AUTHENTICATION_USERID", loginEntry.getUserid());
        loginInfo.put("AUTHENTICATION_PASSWORD", loginEntry.getPassword());
        loginInfo.put("LOGINTYPE", loginEntry.getLoginType());
        loginInfo.put("LANG", loginEntry.getLang());
        HashMap clientLoginResult = null;
        try {
            InetAddress inet = InetAddress.getLocalHost();
            loginInfo.put("ADDRESS", inet.getHostAddress().toString());
            clientLoginResult = this.client.login(loginInfo);
        }
        catch (Exception e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "loginToAuthModuleForRegularBackup", "Failed to login to authentication base. user:" + loginEntry.getUserid());
            throw (SJcException)e;
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "loginToAuthModuleForRegularBackup", "End.");
        return clientLoginResult;
    }

    private void logoutToAuthModule(SJbaseUserSessionInterfaceInternal session) {
        String LOG_SUBTITLE = "logoutToAuthModule";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutToAuthModule", "Start. - sessionID:" + session.getSessionID());
        String sessionID = session.getSessionID();
        if (null != sessionID) {
            HashMap<String, String> logoutInfo = new HashMap<String, String>();
            logoutInfo.put("GLOBALSESSIONID", sessionID);
            try {
                this.client.logout(logoutInfo);
            }
            catch (Throwable e) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutToAuthModule", "Logout error occured.");
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutToAuthModule", "End.");
    }

    protected class SJbaseUserSessionUniqDirInfo
    implements Comparable<SJbaseUserSessionUniqDirInfo> {
        private String dirName;
        private long timeStamp;

        public void setDirName(String dirName) {
            this.dirName = dirName;
        }

        public String getDirName() {
            return this.dirName;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public int compareTo(SJbaseUserSessionUniqDirInfo o) {
            int ret = (int)(this.timeStamp - o.timeStamp);
            return ret;
        }
    }

    protected class SJbaseUserSessionWatchThread
    extends Thread {
    }
}

