/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.plugin;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcPluginList {
    private final String LOG_FUNCTION = "PluginUtility";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private List<SJcPluginItem> pluginItemList;
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger();

    public List<SJcPluginItem> getPluginList() {
        return this.pluginItemList;
    }

    public boolean loadFile(String filename) {
        String LOG_SUBTITLE = "loadFile";
        this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "loadFile", "Start. - filename:" + filename);
        boolean ret = false;
        this.pluginItemList = new ArrayList<SJcPluginItem>();
        Properties props = this.readProperties(filename);
        if (null != props) {
            String pluginList = props.getProperty("list");
            this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "loadFile", "List:" + pluginList);
            if (null != pluginList) {
                String[] plugins = pluginList.split(",");
                for (int i = 0; i < plugins.length; ++i) {
                    String plugin = plugins[i].trim();
                    this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "loadFile", "Plugin:" + plugin);
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    String namekey = plugin + ".name";
                    String classKey = plugin + ".class";
                    String name = props.getProperty(namekey, plugin);
                    attributes.put(".name", name);
                    this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "loadFile", "  Name:" + name);
                    String clazz = props.getProperty(classKey);
                    attributes.put(".class", clazz);
                    this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "loadFile", "  Class:" + clazz);
                    String[] addSfxKeys = this.getAdditionalSuffixKeys();
                    if (null != addSfxKeys) {
                        for (int j = 0; j < addSfxKeys.length; ++j) {
                            String key = plugin + addSfxKeys[j];
                            String value = props.getProperty(key);
                            attributes.put(addSfxKeys[j], value);
                            this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "loadFile", "  " + addSfxKeys[j] + ":" + value);
                        }
                    }
                    SJcPluginItem item = this.getItem(plugin, attributes);
                    item.setKey(plugin);
                    this.pluginItemList.add(item);
                    this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "loadFile", "  Item:" + item.getClass().getName());
                    ret = true;
                }
            }
        }
        this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "loadFile", "End. - return:" + ret);
        return ret;
    }

    protected String[] getAdditionalSuffixKeys() {
        return null;
    }

    protected SJcPluginItem getItem(String name, HashMap<String, String> attributes) {
        SJcPluginItem item = new SJcPluginItem();
        String LOG_SUBTITLE = "getItem";
        this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "getItem", "Start. - name:" + name);
        String itemName = attributes.get(".name");
        item.setName(itemName);
        String className = attributes.get(".class");
        item.setClassName(className);
        this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "getItem", "End. - return:" + item.getClass().getName());
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readProperties(String filename) {
        String LOG_SUBTITLE = "readProperties";
        this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "readProperties", "Start. - filename:" + filename);
        Properties props = null;
        FileInputStream inStream = null;
        try {
            props = new Properties();
            inStream = new FileInputStream(filename);
            props.load(inStream);
        }
        catch (FileNotFoundException fnfe) {
            this.stdLogger.error("PluginUtility", this.LOG_TITLE, "readProperties", "FileNotFoundException occured.", fnfe);
            props = null;
        }
        catch (IOException ioe) {
            this.stdLogger.error("PluginUtility", this.LOG_TITLE, "readProperties", "IOException occured." + props.toString(), ioe);
            props = null;
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    this.stdLogger.error("PluginUtility", this.LOG_TITLE, "readProperties", "Failed to inStream close.", e);
                }
            }
        }
        this.stdLogger.trace("PluginUtility", this.LOG_TITLE, "readProperties", "End. - return:" + props);
        return props;
    }
}

