/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.product;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import sanproject.serverux.data.RmiClassLibVersionSx;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcWordUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.product.SJcProductConst;
import sanproject.sn2.com.utility.product.inf.SJcProductInterface;

public class SJcProductData
implements SJcProductInterface {
    private final String LOG_FUNCTION = "SJcProductData";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private String szMsg;

    @Override
    public String getVenderName() {
        String LOG_SUBTITLE = "getVenderName";
        try {
            SJcGuidanceHandleInterface clsGuid = SJcWordUty.getGuidanceInfo("EN");
            return clsGuid.getGuidance("COMMON", "VENDERNAME");
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getVenderName", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public String getVenderID() {
        String LOG_SUBTITLE = "getVenderID";
        try {
            String configVer = this.getProperties("com.hitachi.sanproject.config.version");
            String venderIDStr = configVer.substring(9, 11);
            String result = "HIE";
            for (int i = 0; i < SJcProductConst.CnvVenderList.length; ++i) {
                if (!SJcProductConst.CnvVenderList[i][0].equals(venderIDStr)) continue;
                result = SJcProductConst.CnvVenderList[i][1];
                break;
            }
            return result;
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getVenderID", this.szMsg, e);
            return "HIE";
        }
    }

    @Override
    public String getSerialNumber() {
        String LOG_SUBTITLE = "getSerialNumber";
        try {
            String shortSerialNum = this.getShortSerialNumber();
            int size = shortSerialNum.length();
            int remain = 10 - size;
            StringBuffer buf = new StringBuffer();
            if (remain > 0) {
                for (int i = 0; i < remain; ++i) {
                    buf.append("0");
                }
            }
            buf.append(shortSerialNum);
            return buf.toString();
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getSerialNumber", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public String getShortSerialNumber() {
        String LOG_SUBTITLE = "getShortSerialNumber";
        try {
            return this.getProperties("com.hitachi.sanproject.storage.serialnumber");
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getShortSerialNumber", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public String getProductName() {
        String LOG_SUBTITLE = "getProductName";
        try {
            SJcGuidanceHandleInterface clsGuid = SJcWordUty.getGuidanceInfo("EN");
            return clsGuid.getGuidance("COMMON", "MACHINETYPENAME");
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getProductName", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public String getManagerAppName() {
        String LOG_SUBTITLE = "getManagerAppName";
        try {
            SJcGuidanceHandleInterface clsGuid = SJcWordUty.getGuidanceInfo("EN");
            return clsGuid.getGuidance("COMMON", "PRODUCTNAME");
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getManagerAppName", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public String getUserSystemName() {
        String LOG_SUBTITLE = "getUserSystemName";
        try {
            String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_INIT;
            String szFile = "ProductData.properties";
            Properties prop = SJcFileUty.loadProperties(szDirectory, szFile);
            return prop.getProperty("UserSystemName", "UNKNOWN");
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getUserSystemName", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public String getUserLocation() {
        String LOG_SUBTITLE = "getUserLocation";
        try {
            String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_INIT;
            String szFile = "ProductData.properties";
            Properties prop = SJcFileUty.loadProperties(szDirectory, szFile);
            return prop.getProperty("UserLocation", "UNKNOWN");
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getUserLocation", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public String getUserContact() {
        String LOG_SUBTITLE = "getUserContact";
        try {
            String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_INIT;
            String szFile = "ProductData.properties";
            Properties prop = SJcFileUty.loadProperties(szDirectory, szFile);
            return prop.getProperty("UserContact", "UNKNOWN");
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getUserContact", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public HashMap<String, String> getMicroVersionList() {
        String LOG_SUBTITLE = "getMicroVersionList";
        try {
            HashMap<String, String> mpRet = new HashMap<String, String>();
            String sSvpVer = this.getProperties("com.hitachi.sanproject.software.version");
            String sConfigVer = this.getProperties("com.hitachi.sanproject.config.version");
            mpRet.put("SVP", sSvpVer);
            mpRet.put("CONFIG", sConfigVer);
            return mpRet;
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getMicroVersionList", this.szMsg, e);
            return null;
        }
    }

    @Override
    public String getLanguageList() {
        String LOG_SUBTITLE = "getLanguageList";
        try {
            String venderID = this.getVenderID();
            String result = "EN";
            for (int i = 0; i < SJcProductConst.CnvLangList.length; ++i) {
                if (!SJcProductConst.CnvLangList[i][0].equals(venderID)) continue;
                result = SJcProductConst.CnvLangList[i][1];
                break;
            }
            return result;
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getLanguageList", this.szMsg, e);
            return "EN";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperties(String Key2) {
        String LOG_SUBTITLE = "getProperties";
        InputStream inputStream = null;
        try {
            String dkcPropertiesFilePath = SJcEnvUty.getSnBasePath() + "..\\dkc.properties";
            Properties prop = new Properties();
            inputStream = new FileInputStream(new File(dkcPropertiesFilePath));
            prop.load(inputStream);
            String string = prop.getProperty(Key2, "UNKNOWN");
            return string;
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getProperties", this.szMsg, e);
            String string = "UNKNOWN";
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public String getCopylight() {
        String LOG_SUBTITLE = "getCopylight";
        try {
            String szRet = "UNKNOWN";
            RmiClassLibVersionSx clsRCLV = new RmiClassLibVersionSx();
            String szVenderID = this.getVenderID();
            szRet = szVenderID.equals("HPE") ? clsRCLV.strCopyrightHP : clsRCLV.strCopyright;
            return szRet;
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getCopylight", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    private String getFullModel() {
        String LOG_SUBTITLE = "getFullModel";
        try {
            return this.getProperties("com.hitachi.sanproject.storage.model");
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getFullModel", this.szMsg, e);
            return "UNKNOWN";
        }
    }

    @Override
    public String getModel() {
        String LOG_SUBTITLE = "getModel";
        try {
            String fullModel = this.getFullModel();
            return fullModel.substring(2, 4);
        }
        catch (Exception e) {
            this.szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcProductData", this.LOG_TITLE, "getModel", this.szMsg, e);
            return "UNKNOWN";
        }
    }
}

