/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.extauth.hic;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.authentication.def.SJbaseRole;
import sanproject.sn2.base.authentication.exception.SJbaseHICAuthenticationMaxUserException;
import sanproject.sn2.base.authentication.plugin.SJbaseHICAuthentication;
import sanproject.sn2.base.authentication.plugin.def.SJbaseRoleGroupSpec;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.SJcAuditLogSSOElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcRoleInfoUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;

public class SJsvlGenerateOnetimeKeyServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private static final String LOG_FUNCTION = "HIC Authentication";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();
    public static final String HIC_KEY_USER_ID = "USER_ID";
    public static final String HIC_KEY_GROUP_ID = "GROUP_ID";
    public static final String HIC_KEY_HDVM_USER_ID = "HDVM_USER_ID";
    public static final String HIC_KEY_SESSION_ID = "SESSION_ID";
    public static final String HIC_KEY_ROLE_ID = "ROLE_ID";
    public static final String HIC_KEY_RSG_ID = "RSG_ID";
    public static final String HIC_KEY_ALL_RSG = "ALL_RSG";
    public static final String HIC_KEY_LOCALIZATION_MODE = "LOCALIZATION_MODE";
    private static final int MAX_SESSIONLENGTH = 32;
    private static final String ENCODE = "UTF-8";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doGet";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "doGet", "Start. - request:" + request + ", response:" + response);
        this.doPost(request, response);
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "doGet", "End.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "doPost", "Start. - request:" + request + ", response:" + response);
        HashMap<String, Object> userInfoMap = this.readHashMapFromRequest(request);
        if (null == userInfoMap) {
            response.sendError(400);
        } else {
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "doPost", "HDvM SSO Information: " + this.getHICUserInfoStr(userInfoMap));
            if (this.checkSessionID((String)userInfoMap.get(HIC_KEY_SESSION_ID))) {
                if (this.checkLocalization((String)userInfoMap.get(HIC_KEY_LOCALIZATION_MODE))) {
                    this.logout((String)userInfoMap.get(HIC_KEY_SESSION_ID));
                    String ontimeKey = null;
                    try {
                        ontimeKey = SJbaseHICAuthentication.registUserInfo(userInfoMap);
                    }
                    catch (SJbaseHICAuthenticationMaxUserException e) {
                        STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "doPost", "Failed to regist user data.", e);
                        response.sendError(404);
                        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
                        String userName = (String)userInfoMap.get(HIC_KEY_USER_ID);
                        String hostName = request.getRemoteAddr();
                        SJcAuditLogSSOElemCon ec = SJcAuditLogSSOElemCon.createSSOElemCon("HCSSO SetOneTimeKey", "OneTimeKey EntryOver", userName, hostName, "Error", e.getMsg());
                        adtLogger.putLog(ec);
                        return;
                    }
                    catch (SJcException e) {
                        STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "doPost", "Failed to local authentication.", e);
                        response.sendError(404);
                        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
                        String userName = (String)userInfoMap.get(HIC_KEY_USER_ID);
                        String hostName = request.getRemoteAddr();
                        SJcAuditLogSSOElemCon ec = SJcAuditLogSSOElemCon.createSSOElemCon("HCSSO SetOneTimeKey", "Authentication", userName, hostName, "Error", e.getMsg());
                        adtLogger.putLog(ec);
                        return;
                    }
                    if (null != ontimeKey) {
                        boolean result = this.writeOnetimeKeyToResponse(ontimeKey, response);
                        if (!result) {
                            response.sendError(404);
                        }
                    } else {
                        response.sendError(404);
                    }
                } else {
                    response.sendError(404);
                }
            } else {
                response.sendError(404);
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "doPost", "End.");
    }

    private SJbaseRoleGroupSpec getRoleGroupSpec(HashMap<String, Object> userInfoMap) {
        SJbaseRoleGroupSpec spec = null;
        spec = this.isNullGroupID(userInfoMap) ? SJbaseRoleGroupSpec.ROLE : SJbaseRoleGroupSpec.GROUP;
        return spec;
    }

    private boolean checkRoleGroup(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "checkRoleGroup";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkRoleGroup", "Start.");
        String[] keys = new String[]{HIC_KEY_ROLE_ID, HIC_KEY_ALL_RSG, HIC_KEY_RSG_ID, HIC_KEY_GROUP_ID};
        this.printMap(userInfoMap, keys);
        boolean returnValue = false;
        try {
            boolean result = false;
            result = this.checkRelationRoleID(userInfoMap);
            if (result) {
                this.setNullGroupID(userInfoMap);
                STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkRoleGroup", "RoleID is designated normally. - result:" + result);
            } else {
                result = this.checkGroupID(userInfoMap);
                if (result) {
                    this.setNullRoleID(userInfoMap);
                    STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkRoleGroup", "GroupID is designated normally. - result:" + result);
                }
            }
            returnValue = result;
        }
        catch (Throwable th) {
            STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "checkRoleGroup", "End. Throwable occured.", th);
            return returnValue;
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkRoleGroup", "End. - result:" + returnValue);
        return returnValue;
    }

    private boolean checkRelationRoleID(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "checkRelationRoleID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkRelationRoleID", "Start.");
        boolean result = false;
        if (!this.checkRoleID(userInfoMap)) {
            return result;
        }
        if (this.isNullAllResourcesFlag(userInfoMap)) {
            return result;
        }
        if (this.isAllResourcesFlag(userInfoMap)) {
            result = true;
        } else if (!this.isNullResourceGroupID(userInfoMap)) {
            result = true;
        } else {
            STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "checkRelationRoleID", "ALL Resources Flag is false and ResourceGroupID is null. - result:" + result);
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkRelationRoleID", "End. - result:" + result);
        return result;
    }

    private boolean checkRoleID(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "checkRoleID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkRoleID", "Start.");
        boolean result = false;
        if (!this.isNullRoleID(userInfoMap)) {
            if (this.existRoleID(userInfoMap)) {
                result = true;
            } else {
                STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "checkRoleID", "RoleID is not exist. - result:" + result);
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkRoleID", "End. - result:" + result);
        return result;
    }

    private void setNullRoleID(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "setNullRoleID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "setNullRoleID", "Start.");
        userInfoMap.put(HIC_KEY_ROLE_ID, null);
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "setNullRoleID", "End.");
    }

    private void setNullGroupID(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "setNullGroupID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "setNullGroupID", "Start.");
        userInfoMap.put(HIC_KEY_GROUP_ID, null);
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "setNullGroupID", "End.");
    }

    private boolean isAllResourcesFlag(HashMap<String, Object> userInfoMap) {
        boolean result = false;
        Object obj = userInfoMap.get(HIC_KEY_ALL_RSG);
        if (obj == null) {
            return result;
        }
        result = (Boolean)obj;
        return result;
    }

    private boolean isNullAllResourcesFlag(HashMap<String, Object> userInfoMap) {
        boolean result = false;
        Object obj = userInfoMap.get(HIC_KEY_ALL_RSG);
        if (obj == null) {
            result = true;
        }
        return result;
    }

    private boolean isNullResourceGroupID(HashMap<String, Object> userInfoMap) {
        boolean result = false;
        BitSet rsgSet = (BitSet)userInfoMap.get(HIC_KEY_RSG_ID);
        if (rsgSet == null) {
            result = true;
        }
        return result;
    }

    private boolean isNullRoleID(HashMap<String, Object> userInfoMap) {
        boolean result = false;
        String[] roles = this.getHicRoleIDs(userInfoMap);
        if (roles == null) {
            result = true;
        }
        return result;
    }

    private boolean isNullGroupID(HashMap<String, Object> userInfoMap) {
        boolean result = false;
        String[] groups = this.getHicGroupIDs(userInfoMap);
        if (groups == null) {
            result = true;
        }
        return result;
    }

    private String[] getHicRoleIDs(HashMap<String, Object> userInfoMap) {
        Object obj = userInfoMap.get(HIC_KEY_ROLE_ID);
        if (obj == null) {
            return null;
        }
        String[] hicRoleIDs = (String[])obj;
        return hicRoleIDs;
    }

    private String[] getHicGroupIDs(HashMap<String, Object> userInfoMap) {
        Object obj = userInfoMap.get(HIC_KEY_GROUP_ID);
        if (obj == null) {
            return null;
        }
        String[] hicGroupIDs = (String[])obj;
        return hicGroupIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Object> readHashMapFromRequest(HttpServletRequest request) {
        String LOG_SUBTITLE = "readHashMapFromRequest";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "readHashMapFromRequest", "Start. - request:" + request);
        HashMap ret = null;
        ServletInputStream inStream = null;
        ObjectInputStream iStream = null;
        try {
            inStream = request.getInputStream();
            iStream = new ObjectInputStream((InputStream)inStream);
            Object obj = iStream.readObject();
            ret = (HashMap)obj;
            this.closeStream(iStream);
            this.closeStream((Closeable)inStream);
        }
        catch (Exception e) {
            try {
                STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "readHashMapFromRequest", "Failed to read object from stream.", e);
                this.closeStream(iStream);
                this.closeStream((Closeable)inStream);
            }
            catch (Throwable throwable) {
                this.closeStream(iStream);
                this.closeStream((Closeable)inStream);
                throw throwable;
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "readHashMapFromRequest", "End.");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writeOnetimeKeyToResponse(String onetimeKey, HttpServletResponse response) {
        String LOG_SUBTITLE = "writeOnetimeKeyToResponse";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "writeOnetimeKeyToResponse", "Start. - onetimeKey:" + onetimeKey + ", response:" + response);
        boolean ret = false;
        ServletOutputStream outStream = null;
        PrintStream pStream = null;
        try {
            outStream = response.getOutputStream();
            pStream = new PrintStream((OutputStream)outStream, false, ENCODE);
            pStream.print(onetimeKey);
            ret = true;
            this.closeStream(pStream);
            this.closeStream((Closeable)outStream);
        }
        catch (Exception e) {
            this.closeStream(pStream);
            this.closeStream((Closeable)outStream);
            catch (Throwable throwable) {
                this.closeStream(pStream);
                this.closeStream((Closeable)outStream);
                throw throwable;
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "writeOnetimeKeyToResponse", "End. - ret:" + ret);
        return ret;
    }

    private boolean checkSessionID(String sessionID) {
        String LOG_SUBTITLE = "checkSessionID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "checkSessionID", "Start. - sessionID:" + sessionID);
        boolean ret = false;
        if (sessionID != null && sessionID.length() > 0) {
            ret = true;
        }
        if (!ret) {
            STD_LOGGER.error(this.LOG_TITLE, "checkSessionID", LOG_FUNCTION, "Global session ID(HCS session ID) is invalid. sessionID: " + sessionID);
        }
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "checkSessionID", "End. - ret:" + ret);
        return ret;
    }

    private boolean checkUserID(String userID) {
        String LOG_SUBTITLE = "checkUserID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "checkUserID", "Start. - userID:" + userID);
        boolean ret = true;
        try {
            SJcAccountChkUty.chkUserName(userID);
        }
        catch (SJcException e) {
            STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "checkUserID", "User name is invalid.", e);
            ret = false;
        }
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "checkUserID", "End. - ret:" + ret);
        return ret;
    }

    private boolean checkGroupID(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "checkGroupID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "checkGroupID", "Start.");
        boolean ret = false;
        String[] HicGroups = (String[])userInfoMap.get(HIC_KEY_GROUP_ID);
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "checkGroupID", "Start. - HicGroups:" + HicGroups);
        if (HicGroups != null) {
            ArrayList<String> list = new ArrayList<String>();
            String[] listStr = new String[]{};
            String[] SNGroupLists = SJcUserGroupInfoUty.getUserGroupList();
            block0: for (int i = 0; i < HicGroups.length; ++i) {
                for (int a = 0; a < SNGroupLists.length; ++a) {
                    if (!SNGroupLists[a].equals(HicGroups[i])) continue;
                    list.add(HicGroups[i]);
                    continue block0;
                }
            }
            listStr = new String[list.size()];
            if ((listStr = list.toArray(listStr)).length != 0) {
                userInfoMap.put(HIC_KEY_GROUP_ID, listStr);
                ret = true;
            }
        }
        if (!ret) {
            STD_LOGGER.error(this.LOG_TITLE, "checkGroupID", LOG_FUNCTION, "Group ID is invalid.");
        }
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "checkGroupID", "End. - ret:" + ret);
        return ret;
    }

    private boolean existRoleID(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "existRoleID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "existRoleID", "Start.");
        boolean result = false;
        try {
            if (this.isNullRoleID(userInfoMap)) {
                return result;
            }
            String[] HicRole = this.getHicRoleIDs(userInfoMap);
            String[] SnRoles = this.convAclPermissionToSnRoleId(HicRole);
            if (SnRoles == null) {
                STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "existRoleID", "convert error.");
                return result;
            }
            String[] matchedRoles = this.getMatchedRoles(SnRoles);
            if (matchedRoles == null) {
                STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "existRoleID", "All RoleID is unmatch.");
                return result;
            }
            String[] matchedRolesPlusDefault = this.setDefaultRole(matchedRoles);
            userInfoMap.put(HIC_KEY_ROLE_ID, matchedRolesPlusDefault);
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "existRoleID", "SnRoles(len):" + SnRoles.length + " matchedRoles(len):" + matchedRolesPlusDefault.length);
            this.printMap(userInfoMap, HIC_KEY_ROLE_ID);
            result = true;
        }
        catch (Throwable th) {
            STD_LOGGER.error(this.LOG_TITLE, "existRoleID", LOG_FUNCTION, "Throwable occured.", th);
            result = false;
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "existRoleID", "End. - ret:" + result);
        return result;
    }

    private String[] setDefaultRole(String[] matchedRoles) {
        String[] returnArray = null;
        ArrayList<String> list = new ArrayList<String>();
        for (String val : matchedRoles) {
            list.add(val);
        }
        list.add(SJbaseRole.STORAGE_ADMINISTRATOR_VIEW_ONLY.getName());
        returnArray = list.toArray(new String[0]);
        return returnArray;
    }

    private String[] getMatchedRoles(String[] SnRoles) {
        String LOG_SUBTITLE = "getMatchedRoles";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "getMatchedRoles", "Start.");
        String[] results = null;
        try {
            ArrayList<String> matchedList = new ArrayList<String>();
            for (String role : SnRoles) {
                if (!SJcRoleInfoUty.isExistRole(role)) continue;
                matchedList.add(role);
            }
            if (matchedList.size() != 0) {
                results = new String[matchedList.size()];
                results = matchedList.toArray(results);
            }
        }
        catch (Throwable th) {
            STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "getMatchedRoles", "Throwable occured.", th);
            return null;
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "getMatchedRoles", "End.");
        return results;
    }

    private String[] convAclPermissionToSnRoleId(String[] aclPermissionArray) throws Throwable {
        String LOG_SUBTITLE = "convAclPermissionToSnRoleId";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "convAclPermissionToSnRoleId", "Start.");
        String[] roleIDs = null;
        try {
            ArrayList<String> roleIdList = new ArrayList<String>();
            Properties props = null;
            try {
                props = SJcFileUty.loadProperties(SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_EXTAUTH, "HCSPermission.properties");
            }
            catch (SJcException ex) {
                STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "convAclPermissionToSnRoleId", "Failed to read properties.", ex);
                throw ex;
            }
            if (null == props) {
                STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "convAclPermissionToSnRoleId", "properties is null.");
                return null;
            }
            for (String aclPermission : aclPermissionArray) {
                String roleName = props.getProperty(aclPermission);
                if (null == roleName || "".equals(roleName)) {
                    STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "convAclPermissionToSnRoleId", "roleName in null or empty. permission name:" + aclPermission);
                    return null;
                }
                roleIdList.add(roleName);
            }
            if (roleIdList.isEmpty()) {
                return null;
            }
            roleIDs = new String[roleIdList.size()];
            roleIDs = roleIdList.toArray(roleIDs);
        }
        catch (SJcException sjex) {
            throw sjex;
        }
        catch (Throwable th) {
            STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "convAclPermissionToSnRoleId", "Throwable occured.", th);
            throw th;
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "convAclPermissionToSnRoleId", "End.");
        return roleIDs;
    }

    private boolean checkLocalization(String localization) {
        String LOG_SUBTITLE = "checkLocalization";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "checkLocalization", "Start. - localization:" + localization);
        boolean ret = true;
        if (!("0".equals(localization) || "1".equals(localization) || "2".equals(localization))) {
            ret = false;
        }
        if (!ret) {
            STD_LOGGER.error(this.LOG_TITLE, "checkLocalization", LOG_FUNCTION, "Localization is invalid. localization: " + localization);
        }
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "checkLocalization", "End. - ret:" + ret);
        return ret;
    }

    private void logout(String hcsSessionID) {
        String LOG_SUBTITLE = "logout";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "logout", "Start.");
        List<Object> list = new ArrayList();
        SJbaseUserSessionManager userSessionMgr = (SJbaseUserSessionManager)SJcSingletonManagerUty.getSingleton(SJbaseUserSessionManager.class);
        if (userSessionMgr == null) {
            STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "logout", "user session manager is null.");
            return;
        }
        list = userSessionMgr.getAllUserSession();
        if (list.isEmpty()) {
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "logout", "user session is not found.");
            return;
        }
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "logout", "list size:" + list.size());
        for (SJbaseUserSessionInterface sJbaseUserSessionInterface : list) {
            String token;
            HashMap<String, Object> authObj = sJbaseUserSessionInterface.getAuthObject();
            if (authObj == null || !hcsSessionID.equals(token = (String)authObj.get(HIC_KEY_SESSION_ID))) continue;
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "logout", "hcsSessionID is match. hcsSessionID:" + hcsSessionID);
            try {
                userSessionMgr.logout(sJbaseUserSessionInterface.getSessionID());
            }
            catch (SJcException sjcex) {
                STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "logout", "logout failed.", sjcex);
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "logout", "End.");
    }

    private void closeStream(Closeable s) {
        String LOG_SUBTITLE = "closeStream";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "closeStream", "Start. - s:" + s);
        if (null != s) {
            try {
                s.close();
            }
            catch (IOException e) {
                STD_LOGGER.error(LOG_FUNCTION, this.LOG_TITLE, "closeStream", "Failed to close stream.", e.getCause());
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "closeStream", "End.");
    }

    private String getHICUserInfoStr(HashMap<String, Object> userInfo) {
        StringBuffer sb = new StringBuffer();
        String key = HIC_KEY_HDVM_USER_ID;
        Object val = userInfo.get(key);
        sb.append("[" + key + "=" + val + "]");
        key = HIC_KEY_USER_ID;
        val = userInfo.get(key);
        sb.append("[" + key + "=" + val + "]");
        key = HIC_KEY_GROUP_ID;
        val = userInfo.get(key);
        try {
            String[] groupIDs = (String[])val;
            sb.append("[" + key + "=" + Arrays.asList(groupIDs) + "]");
        }
        catch (Exception cce) {
            sb.append("[" + key + "=" + val + "]");
        }
        return sb.toString();
    }

    private void printMap(HashMap<String, Object> map, String[] mapKeys) {
        String LOG_SUBTITLE = "printMap";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "Start.");
        for (String key : mapKeys) {
            this.printMap(map, key);
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "End.");
    }

    private void printMap(HashMap<String, Object> map, String key) {
        String LOG_SUBTITLE = "printMap";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        if (null == key || "".equals(key)) {
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "mapKey is null or empty.");
            return;
        }
        Object obj = map.get(key);
        if (obj == null) {
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "<" + key + ">:[obj is null.]");
            return;
        }
        if (key.equals(HIC_KEY_ROLE_ID)) {
            this.printMapStringArray(map, key);
        }
        if (key.equals(HIC_KEY_RSG_ID)) {
            this.printMapBitSet(map, key);
        }
        if (key.equals(HIC_KEY_ALL_RSG)) {
            this.printMapBoolean(map, key);
        }
        if (key.equals(HIC_KEY_GROUP_ID)) {
            this.printMapStringArray(map, key);
        }
    }

    private void printMapBitSet(HashMap<String, Object> map, String key) {
        String LOG_SUBTITLE = "printMap";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        BitSet value = (BitSet)map.get(key);
        if (null == value) {
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "value is null.");
            return;
        }
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "<" + key + ">:size:" + value.size() + " len:" + value.length());
        StringBuffer line = new StringBuffer();
        String str = "<" + key + ">:";
        line.append(str);
        String hexString = this.convBitSet2HexString(value);
        line.append(hexString);
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", line.toString());
    }

    private String convBitSet2HexString(BitSet value) {
        int j;
        String returnValue = "";
        int NUM = value.size();
        String[] strArray = new String[NUM];
        for (int i = 0; i < strArray.length; ++i) {
            boolean bl = value.get(i);
            strArray[i] = bl ? "1" : "0";
        }
        String[] bit4Array = new String[NUM / 4];
        int idx = 0;
        for (int i = 0; i < strArray.length; i += j) {
            StringBuffer buf = new StringBuffer();
            for (j = 0; j < 4; ++j) {
                buf.append(strArray[i + j]);
            }
            bit4Array[idx] = buf.toString();
            ++idx;
        }
        String[] hexStrings = new String[bit4Array.length];
        for (int i = 0; i < bit4Array.length; ++i) {
            hexStrings[i] = this.convBit2Hex(bit4Array[i]);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bit4Array.length; ++i) {
            buf.append(hexStrings[i]);
        }
        returnValue = buf.toString();
        return returnValue;
    }

    private String convBit2Hex(String target) {
        String returnValue = "";
        int intVal = 0;
        char[] array = target.toCharArray();
        intVal = Integer.valueOf(String.valueOf(array[0])) * 2 * 2 * 2;
        intVal += Integer.valueOf(String.valueOf(array[1])) * 2 * 2;
        intVal += Integer.valueOf(String.valueOf(array[2])) * 2;
        returnValue = Integer.toHexString(intVal += Integer.valueOf(String.valueOf(array[3])).intValue());
        return returnValue;
    }

    private void printMapBoolean(HashMap<String, Object> map, String key) {
        String LOG_SUBTITLE = "printMap";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        Boolean value = (Boolean)map.get(key);
        STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "<" + key + ">:[" + value.toString() + "]");
    }

    private void printMapStringArray(HashMap<String, Object> map, String key) {
        String LOG_SUBTITLE = "printMap";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        String[] values = (String[])map.get(key);
        if (null == values || 0 == values.length) {
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "values is null or empty.");
            return;
        }
        for (String val : values) {
            STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "printMap", "<" + key + ">:[" + val + "]");
        }
    }
}

