/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.httpcli;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.com.SJhtclPluginUty;
import sanproject.sn2.httpcli.request.inf.SJhtclRequestInterface;
import sanproject.sn2.httpcli.response.SJhtclResponseError;
import sanproject.sn2.httpcli.response.inf.SJhtclResponseInterface;

public class SJsvlHttpCliReceiverServlet
extends HttpServlet
implements Servlet {
    public static final String LOG_FUNCTION = "HTTP_CLI";
    public static final String LOG_TITLE = SJsvlHttpCliReceiverServlet.class.getSimpleName();
    private static final int PARAM_SIZE_MAX = 256;
    private static final int ALL_PARAMS_SIZE_MAX = 1021;
    private static final int PARAM_COUNT_MAX = 10;
    private static Integer count = new Integer(0);

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.sendError(404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HashMap responseMap;
        Integer n;
        Integer n2;
        String LOG_SUBTITLE = "doPost";
        SJcLoggerInterface htclLogger = SJhtclHttpCliUty.getHtclLogger();
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "doPost", "Start.");
        int svlMaxCount = SJcEnvUty.getProperty2int("SN_HTCL_COMMAND_MAX_COUNT", 20);
        Integer n3 = count;
        synchronized (n3) {
            n2 = count;
            n = count = Integer.valueOf(count + 1);
        }
        if (svlMaxCount > 0 && count > svlMaxCount) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Servlet execute count is over. -MAX:" + svlMaxCount);
            responseMap = SJhtclHttpCliUty.getErrorMapBase((String)"107006");
            SJhtclResponseError resCls = new SJhtclResponseError();
            resCls.flushResponse(req, res, responseMap);
        } else {
            try {
                req.setCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, LOG_TITLE, "doPost", e);
            }
            try {
                String responseKeyType;
                SJhtclResponseInterface resCls;
                responseMap = null;
                if (!this.checkParameters(req)) {
                    responseMap = SJhtclHttpCliUty.getErrorMapBase((String)"107003");
                }
                String servletVer = "00-01-00";
                if (responseMap == null && !this.checkUserAgent(req, servletVer)) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Header error occurred.");
                    responseMap = SJhtclHttpCliUty.getErrorMapBase((String)"107002");
                }
                if (responseMap == null) {
                    res.setHeader("X-SN-Version", servletVer);
                    String act = req.getParameter("act");
                    SJhtclRequestInterface reqCls = SJhtclPluginUty.getRequestPlugin((String)act);
                    if (reqCls != null) {
                        responseMap = reqCls.processRequest(req);
                    } else {
                        htclLogger.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Failed to proccess command. -act:" + act);
                        responseMap = SJhtclHttpCliUty.getErrorMapBase((String)"107004");
                    }
                }
                if ((resCls = SJhtclPluginUty.getResponsePlugin((String)(responseKeyType = (String)responseMap.get("ResponseKeyType")))) == null) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Response plugin is not found.");
                    responseMap = SJhtclHttpCliUty.getErrorMapBase((String)"107007");
                    resCls = new SJhtclResponseError();
                }
                resCls.flushResponse(req, res, responseMap);
            }
            catch (Throwable th) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Servlet error occurred.", th);
            }
        }
        n3 = count;
        synchronized (n3) {
            n2 = count;
            n = count = Integer.valueOf(count - 1);
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "doPost", "End.");
    }

    private boolean checkParameters(HttpServletRequest req) {
        String LOG_SUBTITLE = "checkParameters";
        SJcLoggerInterface htclLogger = SJhtclHttpCliUty.getHtclLogger();
        boolean res = true;
        String act = req.getParameter("act");
        Map map = req.getParameterMap();
        if (act == null) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "Value of \"act\" is null.");
            res = false;
        } else if (SJhtclParameterUty.containsMultiByte((Map)map)) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "Request map contains multibyte charactor.");
            res = false;
        } else if (map.size() > 10) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "Request parameter count is over 10.");
            res = false;
        } else if (!this.checkAllParamsSize(map)) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "Request parameter size is too big.");
            res = false;
        }
        return res;
    }

    private boolean checkParamSize(String param) {
        boolean res = true;
        if (SJhtclParameterUty.getStringSizeAtByte((String)param) > 256) {
            res = false;
        }
        return res;
    }

    private boolean checkAllParamsSize(Map<String, Object> params) {
        boolean res = true;
        int size = 0;
        for (String key : params.keySet()) {
            String param = SJhtclParameterUty.getStrFromMap(params, (String)key);
            if ((size += SJhtclParameterUty.getStringSizeAtByte((String)param)) <= 1021 && this.checkParamSize(param)) continue;
            res = false;
            break;
        }
        return res;
    }

    private boolean checkUserAgent(HttpServletRequest req, String svpMicroVer) {
        boolean result = true;
        boolean isCheckUA = SJcEnvUty.getProperty2boolean("SN_HTCL_USER_AGENT_CHECK", true);
        if (!isCheckUA) {
            return true;
        }
        String userAgent = req.getHeader("User-Agent");
        if (userAgent == null) {
            result = false;
        } else if (!userAgent.startsWith("HSS-CLI/")) {
            result = false;
        }
        return result;
    }
}

