/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.webapi;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.generated.svp.APIInfo;
import sanproject.sn2.generated.svp.EchoCommand;
import sanproject.sn2.generated.svp.ObjectFactory;
import sanproject.sn2.generated.svp.RAIDSVPServerMessage;
import sanproject.sn2.generated.svp.Response;
import sanproject.sn2.generated.svp.ResultList;
import sanproject.sn2.servlet.webapi.SJsvlHCSBaseServlet;
import sanproject.sn2.servlet.webapi.SJsvlHCSServletUty;
import sanproject.sn2.servlet.webapi.def.SJsvlErrorCode;
import sanproject.sn2.servlet.webapi.def.SJsvlHcsCommandStatus;
import sanproject.sn2.servlet.webapi.exception.SJsvlWebApiException;

public class SJsvlLogout
extends SJsvlHCSBaseServlet {
    private static final long serialVersionUID = 0L;
    private static final String API_VERSION = "1.0";
    private static final String COMMAND_NAME = "Logout";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doPost", "Start.");
        try {
            response.setContentType("text/xml");
            this.logout(request, response);
        }
        catch (SJsvlWebApiException wapiex) {
            response.sendError(wapiex.getRspCd());
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doPost", "End.");
    }

    private void logout(HttpServletRequest request, HttpServletResponse response) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "logout";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "logout", "Start.");
        String sessionId = null;
        try {
            sessionId = SJsvlHCSServletUty.getSessionId(request);
            SJsvlHCSServletUty.checkSessionIdFormat(sessionId);
            SJbaseUserSessionManager sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getSingleton(SJbaseUserSessionManager.class);
            if (null == sessionManager) {
                STD_LOGGER.error("WebApi", this.LOG_TITLE, "logout", SJsvlErrorCode.SESSION_MANAGER_NOTFOUND.name());
                throw new SJsvlWebApiException(SJsvlErrorCode.SESSION_MANAGER_NOTFOUND);
            }
            sessionManager.logout(sessionId);
            STD_LOGGER.info("WebApi", this.LOG_TITLE, "logout", "logout succeed. -GlobalSessionID:" + sessionId);
        }
        catch (SJsvlWebApiException wapiex) {
            throw wapiex;
        }
        catch (Exception ex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "logout", SJsvlErrorCode.LOGOUT_ERROR.name() + " - sessionId:" + sessionId, ex);
        }
        SJsvlHCSServletUty.setResponseBody(response, this.createResponseMessage());
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "logout", "End. - sessionId:" + sessionId);
    }

    private RAIDSVPServerMessage createResponseMessage() {
        String LOG_SUBTITLE = "createResponseMessage";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createResponseMessage", "Start.");
        RAIDSVPServerMessage serverMessage = null;
        ObjectFactory factory = new ObjectFactory();
        serverMessage = factory.createRAIDSVPServerMessage();
        APIInfo apiinfo = factory.createAPIInfo();
        apiinfo.setVersion(API_VERSION);
        Response response = factory.createResponse();
        EchoCommand command = factory.createEchoCommand();
        command.setName(COMMAND_NAME);
        command.setStatus(SJsvlHcsCommandStatus.COMPLETED.getStatus());
        command.setResult("");
        command.setResultsource("");
        command.setMessageid("");
        ResultList resultList = factory.createResultList();
        response.setEchoCommand(command);
        response.setResultList(resultList);
        serverMessage.setAPIInfo(apiinfo);
        serverMessage.setResponse(response);
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createResponseMessage", "End.");
        return serverMessage;
    }
}

