/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.applet;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import sanproject.client.applet.RJTitleApplet;
import sanproject.client.com.RJcEventQueue;
import sanproject.client.com.utility.RJcAsciiToString;
import sanproject.client.openldevguard.utility.RuntimeUtilities;
import sanproject.serverux.data.RmiClassLibVersionSx;

public final class RJStartupController {
    public static final String DEFAULT_WINDOW_TITLE = "WebConsole";
    public static final String PROPERTY_NAME = System.getProperty("user.home") + File.separator + ".webconsole" + File.separator + "webconsole.properties";
    private static ApplicationThreadGroup threadGroup;
    private static Properties properties;
    private transient Applet applet;
    private static final int shutdownKey = 704;
    private static final int shutdownkey2 = 68;
    private static RJStartupController controller;
    private static String[] CNV_A2SList;

    public static void main(final String[] stringArray) {
        Object object = new UncaughtExceptionHandler(){

            public void foundUncaughtException(UncaughtExceptionEvent uncaughtExceptionEvent) {
                Thread thread = uncaughtExceptionEvent.getThread();
                Throwable throwable = uncaughtExceptionEvent.getThrowable();
                System.err.println("*** found uncaught exception ***");
                System.err.println("thread : " + thread);
                throwable.printStackTrace(System.err);
            }
        };
        RJStartupController.addUncatchedExceptionHandler((UncaughtExceptionHandler)object);
        object = new Thread((ThreadGroup)threadGroup, "WebConsole main"){

            public void run() {
                RJStartupController.convertSystemPropertyFrom(stringArray);
                RJStartupController.convertSYSPRM_ASCII2String(CNV_A2SList);
                RJcEventQueue.pushEventQueue();
                RJTitleApplet rJTitleApplet = new RJTitleApplet();
                RJStartupController.setShutDownSystem(rJTitleApplet);
                rJTitleApplet.isStandalone = true;
                controller = new RJStartupController(rJTitleApplet);
                controller.startup();
            }
        };
        ((Thread)object).start();
    }

    private RJStartupController(Applet applet) {
        this.applet = applet;
    }

    protected WindowListener createApplicationWindowListener() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                boolean bl = true;
                if (bl && window.isActive()) {
                    ((RJTitleApplet)RJStartupController.this.applet).appExit();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent windowEvent) {
                int n = 0;
                try {
                    RJStartupController.this.saveSettings();
                    RJStartupController.this.invokeDestroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    n = -1;
                }
                finally {
                    System.exit(n);
                }
            }
        };
        return windowAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeInit() {
        Thread thread;
        Thread thread2 = thread = new Thread("init call thread"){

            public void run() {
                RJStartupController.this.applet.init();
            }
        };
        synchronized (thread2) {
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
        }
    }

    protected void invokeStart() {
        Thread thread = new Thread("start call thread"){

            public void run() {
                RJStartupController.this.applet.start();
                RJStartupController.this.applet.invalidate();
                RJStartupController.this.applet.validate();
                RJStartupController.this.applet.repaint();
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeStop() {
        Thread thread;
        Thread thread2 = thread = new Thread("stop call thread"){

            public void run() {
                RJStartupController.this.applet.stop();
            }
        };
        synchronized (thread2) {
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeDestroy() {
        Thread thread;
        Thread thread2 = thread = new Thread("destroy call thread"){

            public void run() {
                RJStartupController.this.applet.destroy();
            }
        };
        synchronized (thread2) {
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettings() {
        String string = System.getProperty("WebConsole.properties", PROPERTY_NAME);
        System.out.println("load properties... [" + string + "]");
        File file = new File(string);
        Properties properties = RJStartupController.properties;
        synchronized (properties) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                RJStartupController.properties.load(fileInputStream);
            }
            catch (Exception exception) {
                System.err.println("load properties failure [" + file + "].");
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveSettings() {
        Object object;
        Object object2;
        JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(this.applet);
        if (jFrame != null) {
            jFrame.setExtendedState(0);
            object2 = jFrame.getLocation();
            object = "" + String.valueOf(((Point)object2).x) + "," + String.valueOf(((Point)object2).y) + "";
            RJStartupController.setProperty("WebConsole.location", (String)object);
            object2 = jFrame.getSize();
            object = "" + String.valueOf(((Dimension)object2).width) + "," + String.valueOf(((Dimension)object2).height) + "";
            RJStartupController.setProperty("WebConsole.size", (String)object);
        }
        object2 = System.getProperty("WebConsole.properties", PROPERTY_NAME);
        System.out.println("save properties... [" + (String)object2 + "]");
        object = new File((String)object2);
        Properties properties = RJStartupController.properties;
        synchronized (properties) {
            OutputStream outputStream = null;
            try {
                Object object3;
                if (!((File)object).exists()) {
                    object3 = ((File)object).getParentFile();
                    ((File)object3).mkdirs();
                    ((File)object).createNewFile();
                }
                RmiClassLibVersionSx rmiClassLibVersionSx = new RmiClassLibVersionSx();
                object3 = "WebConsole version : " + rmiClassLibVersionSx.strRmiClassVersion + "(" + rmiClassLibVersionSx.strIRev + ")" + "";
                outputStream = new FileOutputStream((File)object);
                RJStartupController.properties.store(outputStream, (String)object3);
            }
            catch (Exception exception) {
                System.err.println("save properties failure [" + object + "].");
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    private void startup() {
        this.loadSettings();
        this.invokeInit();
        Object object = this.createApplicationWindowListener();
        Object object2 = this.getApplicationWindowTitle();
        boolean bl = this.isApplicationWindowResizable();
        Serializable serializable = this.getInitializeWindowLocation();
        Dimension dimension = this.getInitializeWindowSize();
        JFrame jFrame = new JFrame((String)object2);
        jFrame.setName("WebConsoleMainWindow");
        RJcEventQueue.addTopWindow(jFrame);
        Dimension dimension2 = this.applet.getToolkit().getScreenSize();
        if (dimension2.width < serializable.x + dimension.width) {
            serializable.x = dimension2.width - dimension.width;
        }
        if (dimension2.height < serializable.y + dimension.height) {
            serializable.y = dimension2.height - dimension.height;
        }
        ((RJTitleApplet)this.applet).setParent(jFrame);
        Container container = jFrame.getContentPane();
        container.add(this.applet);
        jFrame.setDefaultCloseOperation(0);
        jFrame.setLocation((Point)serializable);
        jFrame.setSize(dimension);
        jFrame.setResizable(bl);
        jFrame.addWindowListener((WindowListener)object);
        this.invokeStart();
        object = RJStartupController.getProperty("WebConsole.show_heapmemory", "false");
        object2 = Boolean.valueOf((String)object);
        bl = (Boolean)object2;
        if (bl && (serializable = (JFrame)SwingUtilities.getWindowAncestor(this.applet)) != null) {
            RuntimeUtilities.showHeapSizeWindow((Frame)serializable);
        }
    }

    private boolean isApplicationWindowResizable() {
        String string = System.getProperty("WebConsole.resizable");
        Boolean bl = Boolean.valueOf(string);
        boolean bl2 = bl;
        return bl2;
    }

    private String getApplicationWindowTitle() {
        String string = System.getProperty("WebConsole.title", DEFAULT_WINDOW_TITLE);
        return string;
    }

    private Point getInitializeWindowLocation() {
        int n;
        int n2;
        Object object;
        String string = RJStartupController.getProperty("WebConsole.location");
        try {
            object = string.split(",");
            try {
                n2 = Integer.parseInt(object[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            try {
                n = Integer.parseInt(object[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        catch (Exception exception) {
            n2 = 0;
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n < 0) {
            n = 0;
        }
        object = new Point(n2, n);
        return object;
    }

    private Dimension getInitializeWindowSize() {
        int n;
        int n2;
        Object object;
        String string = RJStartupController.getProperty("WebConsole.size");
        try {
            object = string.split(",");
            try {
                n2 = Integer.parseInt(object[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 820;
            }
            try {
                n = Integer.parseInt(object[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 718;
            }
        }
        catch (Exception exception) {
            n2 = 820;
            n = 718;
        }
        object = new Dimension(n2, n);
        return object;
    }

    public static void addUncatchedExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        threadGroup.addUncatchedExceptionHandler(uncaughtExceptionHandler);
    }

    public static void removeUncatchedExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        threadGroup.removeUncatchedExceptionHandler(uncaughtExceptionHandler);
    }

    public static String getProperty(String string) {
        String string2 = RJStartupController.getProperty(string, null);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String string, String string2) {
        String string3;
        Properties properties = System.getProperties();
        if (properties.containsKey(string)) {
            string3 = properties.getProperty(string, string2);
        } else {
            Properties properties2 = RJStartupController.properties;
            synchronized (properties2) {
                string3 = RJStartupController.properties.getProperty(string, string2);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object setProperty(String string, String string2) {
        Object object;
        Properties properties = RJStartupController.properties;
        synchronized (properties) {
            object = RJStartupController.properties.setProperty(string, string2);
        }
        return object;
    }

    public static Object removeProperty(String string) {
        Object object = properties.remove(string);
        return object;
    }

    private static void convertSystemPropertyFrom(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            String[] stringArray2 = string3.split("=");
            try {
                string2 = stringArray2[0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            try {
                string = stringArray2[1];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = "";
            }
            if (string2.equals("")) continue;
            System.setProperty(string2, string);
        }
    }

    private static void setShutDownSystem(Component component) {
        System.out.println("[Applet] [ForceShutdown] [SystemSet]");
        Toolkit toolkit = component.getToolkit();
        toolkit.addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent aWTEvent) {
                KeyEvent keyEvent;
                int n = 0;
                if (aWTEvent instanceof KeyEvent && ((n = (keyEvent = (KeyEvent)aWTEvent).getModifiersEx()) & 0x2C0) == 704 && keyEvent.getKeyCode() == 68) {
                    System.out.println("[Applet] [ForceShutdown] [Doing]!!");
                    System.exit(0);
                }
            }
        }, 8L);
    }

    private static void convertSYSPRM_ASCII2String(String[] stringArray) {
        try {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = System.getProperty(stringArray[i], null);
                    if (string == null) {
                        string = System.getProperty("jnlp." + stringArray[i], null);
                    }
                    if (string == null || string.length() <= 0) continue;
                    String string2 = RJcAsciiToString.change(string);
                    System.setProperty(stringArray[i], string2);
                    System.out.println("[Applet] [ConvertSYSPRM] [" + stringArray[i] + "]");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        CNV_A2SList = new String[]{"PRD"};
        Object object = Thread.currentThread();
        ThreadGroup threadGroup = ((Thread)object).getThreadGroup();
        RJStartupController.threadGroup = new ApplicationThreadGroup(threadGroup);
        object = new Defaults();
        properties = new Properties((Properties)object);
    }

    private static final class ApplicationThreadGroup
    extends ThreadGroup {
        private transient Set handlers = new HashSet();

        protected ApplicationThreadGroup(ThreadGroup threadGroup) {
            super(threadGroup, "WebConsole threads");
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            this.fireFoundUncatchedException(thread, throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUncatchedExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
            if (uncaughtExceptionHandler != null) {
                Set set = this.handlers;
                synchronized (set) {
                    this.handlers.add(uncaughtExceptionHandler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUncatchedExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
            if (this.handlers.contains(uncaughtExceptionHandler)) {
                Set set = this.handlers;
                synchronized (set) {
                    this.handlers.remove(uncaughtExceptionHandler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireFoundUncatchedException(Thread thread, Throwable throwable) {
            HashSet hashSet;
            Object object = this.handlers;
            synchronized (object) {
                hashSet = new HashSet(this.handlers);
            }
            if (!hashSet.isEmpty()) {
                object = new UncaughtExceptionEvent(this, thread, throwable);
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    UncaughtExceptionHandler uncaughtExceptionHandler = (UncaughtExceptionHandler)iterator.next();
                    uncaughtExceptionHandler.foundUncaughtException((UncaughtExceptionEvent)object);
                }
            }
        }
    }

    public static final class Defaults
    extends Properties {
        public static final int WINDOW_X = 0;
        public static final int WINDOW_Y = 0;
        public static final int WINDOW_WIDTH = 820;
        public static final int WINDOW_HEIGHT = 718;

        public Defaults() {
            String string = "" + String.valueOf(0) + "," + String.valueOf(0) + "";
            this.setProperty("WebConsole.location", string);
            string = "" + String.valueOf(820) + "," + String.valueOf(718) + "";
            this.setProperty("WebConsole.size", string);
        }
    }

    public static class UncaughtExceptionEvent
    extends EventObject {
        private transient Thread thread;
        private Throwable throwable;

        protected UncaughtExceptionEvent(Object object, Thread thread, Throwable throwable) {
            super(object);
            this.thread = thread;
            this.throwable = throwable;
        }

        public Thread getThread() {
            Thread thread = this.thread;
            return thread;
        }

        public Throwable getThrowable() {
            Throwable throwable = this.throwable;
            return throwable;
        }
    }

    public static interface UncaughtExceptionHandler
    extends EventListener {
        public void foundUncaughtException(UncaughtExceptionEvent var1);
    }
}

