/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo.com;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.swing.JPanel;
import sanproject.client.base.RJBasePanel;
import sanproject.client.baseinfo.com.RJBaseInfoDef;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJComWaitingDialog;
import sanproject.client.data.RJDataCache;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataControlDoing;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.data.RJDataMsg;
import sanproject.client.data.RJDataPGPart;
import sanproject.client.data.RJDataPathPart;
import sanproject.client.data.RJDataPortPart;

public abstract class RJBaseInfoAbsDataSupplier
implements RJBaseInfoDef {
    protected RJDataControl controller;
    protected RJDataControlDoing controlDoing;
    protected RJDataCache controlCache;
    protected RJDataPGPart controlPGPart;
    protected RJDataLDEVPart controlLDEVPart;
    protected RJDataPortPart controlPortPart;
    protected RJDataPathPart controlPathPart;
    private Stack parentPanel = new Stack();
    private int messageShow = 0;
    protected String osName = System.getProperty("os.name");
    protected Stack waitingDialogComponent = new Stack();
    protected boolean stayController = true;
    protected RJBasePanel basePanel = null;
    RJComWaitingDialog waitingDialog = null;

    public RJBaseInfoAbsDataSupplier(RJBasePanel rJBasePanel) {
        this.basePanel = rJBasePanel;
        this.controller = RJDataControl.getDataControl();
        if (this.controller != null) {
            this.controlDoing = this.controller.getControlDoing();
            this.controlCache = this.controller.getCache();
            this.controlPGPart = this.controller.getPGPart();
            this.controlLDEVPart = this.controller.getLDEVPart();
            this.controlPortPart = this.controller.getPortPart();
            this.controlPathPart = this.controller.getPathPart();
        }
    }

    public RJDataControl getDataControl() {
        return this.controller;
    }

    public RJDataChange getChangeTbl() {
        return this.controller.GetChangeTbl();
    }

    public String getOSName() {
        return this.osName;
    }

    public boolean isWindows() {
        boolean bl = false;
        if (this.osName.startsWith("Windows")) {
            bl = true;
        }
        return bl;
    }

    public boolean isStayController() {
        return this.stayController;
    }

    public void setStayController(boolean bl) {
        this.stayController = bl;
    }

    public void showMessage() {
        ++this.messageShow;
    }

    public void hideMessage() {
        --this.messageShow;
    }

    public boolean isMessageShow() {
        boolean bl = false;
        if (this.messageShow > 0) {
            bl = true;
        }
        return bl;
    }

    public RJComWaitingDialog createWaitingDialog(Component component) {
        Window window = this.searchWindow(component);
        RJComWaitingDialog rJComWaitingDialog = this.controller.getStartParamClass().createWaitingDialog2(window);
        return rJComWaitingDialog;
    }

    public void setWaitingDialogComponent() {
        Component component = this.controlCache.getWaitingDialogComponent();
        this.waitingDialogComponent.push(component);
        boolean bl = true;
        Window window = this.searchWindow(this.getParentPanel());
        if (window == null || !window.isVisible()) {
            bl = false;
            window = null;
        }
        this.controlCache.setShowWaitingDialog(bl);
        this.controlCache.setWaitingDialogComponent(window);
        this.stayController = true;
    }

    public void resetWaitingDialogComponent() {
        Component component = (Component)this.waitingDialogComponent.pop();
        this.controlCache.setShowWaitingDialog(true);
        this.controlCache.setWaitingDialogComponent(component);
        this.stayController = false;
    }

    public void waitCursor() {
        this.waitCursor(this.getParentPanel());
    }

    public void waitCursor(Component component) {
        RJCom.waitCursor(component);
    }

    public void defaultCursor() {
        this.defaultCursor(this.getParentPanel());
    }

    public void defaultCursor(Component component) {
        RJCom.defCursor(component);
    }

    public Window searchWindow(Component component) {
        Window window = null;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Window)) continue;
            window = (Window)component2;
            break;
        }
        return window;
    }

    public RJDataMsg getMessage(int n) {
        return RJCom.getMsg(this.controller, n / 100000, n % 100000);
    }

    public int showMessage(Component component, RJDataMsg rJDataMsg, int n, Object[] objectArray, Object object) {
        ++this.messageShow;
        int n2 = RJComDialog.show(component, rJDataMsg, n, objectArray, object);
        --this.messageShow;
        return n2;
    }

    public boolean showMessage(Component component, RJDataMsg rJDataMsg) {
        boolean bl = false;
        Window window = this.searchWindow(component);
        ++this.messageShow;
        bl = window instanceof Frame ? RJComUty.SetMsg((Frame)window, rJDataMsg) : RJComUty.SetMsg((Dialog)window, rJDataMsg);
        --this.messageShow;
        return bl;
    }

    public JPanel getParentPanel() {
        JPanel jPanel = null;
        try {
            jPanel = (JPanel)this.parentPanel.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return jPanel;
    }

    public void pushParentPanel(JPanel jPanel) {
        this.parentPanel.push(jPanel);
    }

    public void popParentPanel() {
        try {
            this.parentPanel.pop();
            this.controlCache.setWaitingDialogComponent(this.getParentPanel());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void putLog(String string, String string2, String string3) {
        RJCom.putLog(string, string2, string3, 0);
    }

    public String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n).toUpperCase();
        return string.substring(string.length() - n2);
    }

    public int getVenderID() {
        int n = 0;
        if (this.controller != null) {
            n = this.controller.getStartParamClass().getVenderID();
        }
        return n;
    }

    public boolean isTabOption(int n, int n2) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().getTABOption(n, n2);
        }
        return bl;
    }

    public boolean isPermission(int n, int n2) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().getPermissionTABOption(n, n2);
        }
        return bl;
    }

    public boolean isPP(String string) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getPPKeyData().CheckPP(string);
        }
        return bl;
    }

    protected void confirm() {
        this.confirm("unknown");
    }

    protected void confirm(String string) {
        this.confirm(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void confirm(String string, String string2) {
        Window window = this.searchWindow(this.getParentPanel());
        if (string != null && string.equals("getLPRControler") || window != null && !window.isVisible()) {
            window = null;
        }
        try {
            this.stayController = true;
            this.waitDC(window);
        }
        finally {
            this.stayController = false;
        }
        ArrayList arrayList = this.getEndStatus(string);
        if (this.isError(arrayList, string, string2)) {
            this.showErrorMessage((Integer)arrayList.get(0), (Integer)arrayList.get(1));
        }
    }

    protected void showErrorMessage(int n, int n2) {
        RJDataMsg rJDataMsg = this.getMessage(n, n2);
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
        ++this.messageShow;
        RJComDialog.show(this.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        --this.messageShow;
        int n3 = this.getErrorLevel(rJDataMsg);
        RJComFuncPanel rJComFuncPanel = (RJComFuncPanel)this.getParentPanel();
        rJComFuncPanel.endRequest(n3);
    }

    protected ArrayList getEndStatus(String string) {
        return this.controller.getEndStatus();
    }

    protected boolean isError(ArrayList arrayList, String string, String string2) {
        boolean bl = false;
        int n = (Integer)arrayList.get(0);
        int n2 = (Integer)arrayList.get(1);
        this.putLog("[BaseInfo]", "[confirm]", string + ", " + string2 + " (" + n + ", " + n2 + ")");
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    protected int getErrorLevel(RJDataMsg rJDataMsg) {
        int n = rJDataMsg.getErrorLevel();
        return n;
    }

    protected void waitControl() {
        while (this.controlDoing.getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitDC(Component component) {
        boolean bl = false;
        if (component != null) {
            this.waitingDialog = this.createWaitingDialog(component);
            bl = true;
        }
        this.waitProc(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitProc(boolean bl) {
        if (bl) {
            Runnable_WaitDC runnable_WaitDC = new Runnable_WaitDC(this.controller);
            try {
                this.waitingDialog.show(runnable_WaitDC);
            }
            finally {
                this.waitingDialog.dispose();
            }
        } else {
            while (!this.controller.EndData) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public RJDataMsg getMessage(ArrayList arrayList) {
        RJDataMsg rJDataMsg = this.getMessage((Integer)arrayList.get(0), (Integer)arrayList.get(1));
        return rJDataMsg;
    }

    public RJDataMsg getMessage(int n, int n2) {
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
        return rJDataMsg;
    }

    public void terminate() {
    }

    public static void setNextFocus(Container container, Container container2) {
        container.setFocusTraversalPolicy(container2.getFocusTraversalPolicy());
    }

    private class Runnable_WaitDC
    implements Runnable {
        RJDataControl DC = null;

        Runnable_WaitDC(RJDataControl rJDataControl) {
            this.DC = rJDataControl;
        }

        public void run() {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (!this.DC.EndData) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    System.out.print(exception.toString());
                }
            }
        }
    }
}

