/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ftp;

import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import sanproject.client.com.RJcAbsGuideConst;
import sanproject.client.com.RJcConst;
import sanproject.client.ftp.RJftpDef;

public class RJftpASCIITextField
extends JTextField
implements RJftpDef,
DocumentListener,
FocusListener {
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance();
    private String init_str = "";
    boolean forceEdit = false;

    public RJftpASCIITextField() {
        this(10);
    }

    public RJftpASCIITextField(int n) {
        this(n, null);
    }

    public RJftpASCIITextField(int n, String string) {
        super(n);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setText(string);
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    private boolean checkWidth(int n) {
        boolean bl = false;
        if (this.getText().length() + n >= this.getColumns()) {
            bl = true;
        }
        return bl;
    }

    public void setItalic(boolean bl) {
        if (bl) {
            this.setFont(new Font(null, 3, 12));
        } else {
            this.setFont(new Font(null, 0, 12));
        }
    }

    public void setBlue(boolean bl) {
        if (bl) {
            this.setForeground(RJcConst.modifyColor);
        } else {
            this.setForeground(RJcAbsGuideConst.stdFgClr);
        }
    }

    public boolean chgSts() {
        String string = super.getText();
        return this.forceEdit || !this.init_str.equals(string);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void update() {
        this.setBlue(this.chgSts());
        this.setItalic(this.chgSts());
    }

    public void setText(String string) {
        this.releaseListener();
        if (string == null) {
            string = "";
        }
        this.init_str = string;
        super.setText(string);
        this.setBlue(false);
        this.setItalic(false);
        this.setListener();
    }

    public void setForceEdit(boolean bl) {
        this.forceEdit = bl;
    }

    public void setListener() {
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
    }

    public void releaseListener() {
        Document document = this.getDocument();
        DocumentListener[] documentListenerArray = ((PlainDocument)document).getDocumentListeners();
        for (int i = 0; i < documentListenerArray.length; ++i) {
            if (!documentListenerArray[i].getClass().toString().equals(this.getClass().toString())) continue;
            document.removeDocumentListener(this);
        }
        this.removeFocusListener(this);
    }

    protected class NumberDocument
    extends PlainDocument {
        protected NumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && !string.equals("")) {
                if (attributeSet == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        String string2 = string.substring(0, i + 1);
                        if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN && !RJftpASCIITextField.this.checkWidth(i)) continue;
                        string = string.substring(0, i);
                        break;
                    }
                } else {
                    int n2 = string.length();
                }
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

