/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.util.Date;
import sanproject.client.monitor.com.RJHihAbstractDataSupplier;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDateFormat;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.common.Robj_interface_MonMonitoringData;

public abstract class RJHihMonitoringTermInfo {
    private static final RJHihDateFormat timeFormat = new RJHihDateFormat("[yyyy/MM/dd HH:mm]");
    public static final int MINUTE15 = 15;
    public static final int MINUTE1 = 1;
    public static final int MINUTE_DAY = 1440;
    public static final int MODE_FROMTO = 0;
    public static final int MODE_REALTIME = 1;
    public static final int SEC_MINUTE = 60;
    protected RJHihDataSupplier supplier;
    protected Date startTime = null;
    protected Date endTime = null;
    protected int intervalTime = -1;
    protected boolean errorShow = false;
    private Date fromTime = null;
    private Date toTime = null;
    protected int spinTickSpacing;
    protected int sliderTickSpacing;
    protected int labelTickSpacing;
    protected boolean realTimeEnabled = false;
    protected int mode;
    protected int realTimeInterval;
    protected Object[] realTimeItems;

    public RJHihMonitoringTermInfo(RJHihAbstractDataSupplier rJHihAbstractDataSupplier) {
        this.supplier = (RJHihDataSupplier)rJHihAbstractDataSupplier;
    }

    public Date getStartTime() {
        Date date = null;
        if (this.startTime != null) {
            date = (Date)this.startTime.clone();
        }
        return date;
    }

    public Date getEndTime() {
        Date date = null;
        if (this.endTime != null) {
            date = (Date)this.endTime.clone();
        }
        return date;
    }

    public int getIntervalTime() {
        return this.intervalTime;
    }

    public void setMonitoringTime(Date date, Date date2) {
        this.fromTime = null;
        String string = null;
        if (date != null) {
            this.fromTime = (Date)date.clone();
            string = timeFormat.format(date);
        }
        this.toTime = null;
        String string2 = null;
        if (date2 != null) {
            this.toTime = (Date)date2.clone();
            string2 = timeFormat.format(date2);
        }
        String string3 = this.getClass().getName();
        string3 = string3.substring(string3.lastIndexOf(46) + 1);
        String string4 = string3 + ": " + string + " - " + string2;
        this.supplier.putLog("[Monitor]", "[Display Time]", string4);
    }

    public void setMonitoringTime(RJHihTimePair rJHihTimePair) {
        this.setMonitoringTime(rJHihTimePair.getFromTime(), rJHihTimePair.getToTime());
    }

    public RJHihTimePair getMonitoringTime() {
        RJHihTimePair rJHihTimePair = null;
        if (this.fromTime != null && this.toTime != null) {
            rJHihTimePair = new RJHihTimePair(this.fromTime, this.toTime, this.intervalTime);
        }
        return rJHihTimePair;
    }

    public boolean isErrorShow() {
        return this.errorShow;
    }

    public void setErrorShow(boolean bl) {
        this.errorShow = bl;
    }

    public Date getFromTime() {
        Date date = null;
        if (this.fromTime != null) {
            date = (Date)this.fromTime.clone();
        }
        return date;
    }

    public Date getToTime() {
        Date date = null;
        if (this.toTime != null) {
            date = (Date)this.toTime.clone();
        }
        return date;
    }

    public int getSpinTickSpacing() {
        return this.spinTickSpacing;
    }

    public int getSliderTickSpacing() {
        return this.sliderTickSpacing;
    }

    public int getLabelTickSpacing() {
        return this.labelTickSpacing;
    }

    public boolean isRealTimeEnabled() {
        return this.realTimeEnabled;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getRealTimeInterval() {
        return this.realTimeInterval;
    }

    public void setRealTimeInterval(int n) {
        this.realTimeInterval = n;
    }

    public Object[] getRealTimeItems() {
        return this.realTimeItems;
    }

    protected void adjustTime(long l) {
        Date date = null;
        Date date2 = null;
        if (this.startTime != null && this.endTime != null) {
            date2 = this.endTime;
            date = new Date(Math.max(this.startTime.getTime(), date2.getTime() - l));
        }
        this.setMonitoringTime(date, date2);
    }

    public void updateTime(Robj_interface_MonMonitoringData robj_interface_MonMonitoringData) {
        this.startTime = null;
        this.endTime = null;
        this.intervalTime = 0;
        if (robj_interface_MonMonitoringData != null && robj_interface_MonMonitoringData.isExist()) {
            this.startTime = robj_interface_MonMonitoringData.getStartDate();
            this.endTime = robj_interface_MonMonitoringData.getEndDate();
            this.intervalTime = robj_interface_MonMonitoringData.getInterval() / 60;
        }
        this.adjustTime(this.getDefaultTerm());
        this.setErrorShow(false);
    }

    public abstract long getDefaultTerm();

    public abstract int getRangeKind();
}

