/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.dctl.extent;

import java.util.logging.Level;
import sanproject.client.openldevguard.dctl.RJODGDDataControl;
import sanproject.client.openldevguard.dctl.RJODGDException;
import sanproject.client.openldevguard.dctl.com.ExtentNumberInterface;
import sanproject.client.openldevguard.dctl.com.ManageReadData;
import sanproject.client.openldevguard.dctl.com.Utility;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.serverux.dataimpl.ODGDgetExtDetail;
import sanproject.serverux.dataimpl.ODGDgetExtDetailContents;
import sanproject.serverux.dataimpl.ODGDgetExtentDetail_IN;
import sanproject.serverux.dataimpl.ODGDgetExtentDetail_OUT;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class ManageExtentInfo
extends ManageReadData {
    private static final long LBA_TO_KB = 2L;
    private static final long MB_TO_LBA = 2048L;
    private static final GetDataExtentInfo NULL_DATA_EXTENT = new GetDataExtentInfo(-1);
    private final RJODGDDataControl druDataControl;
    private final GetDataExtentInfo originalCompareData;
    private int ldkcNumber;
    private int cuNumber;
    private int ldevNumber;
    private int hasLdkcNumber;
    private int hasCuNumber;
    private int hasLdevNumber;
    private long maxLbaSize;
    private long vmaSize;

    public ManageExtentInfo(RJODGDDataControl rJODGDDataControl) {
        super(0, "ExtentInfo", rJODGDDataControl, COMP_EXTID, NULL_DATA_EXTENT);
        this.druDataControl = rJODGDDataControl;
        this.originalCompareData = new GetDataExtentInfo(-1);
    }

    private long convertLbaToKByte(long l) {
        return l / 2L;
    }

    private long convertMByteToLba(long l) {
        return l * 2048L;
    }

    private long getLbaSize(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return getDataExtentInfo.lbaSize;
    }

    protected Object[] getData() throws Exception {
        SanRmiInputInterface sanRmiInputInterface = this.makeSanRmiInputInterface();
        ODGDgetExtentDetail_OUT oDGDgetExtentDetail_OUT = (ODGDgetExtentDetail_OUT)this.getRmiData(sanRmiInputInterface);
        ODGDgetExtDetail oDGDgetExtDetail = oDGDgetExtentDetail_OUT.getExtDetail();
        this.hasLdkcNumber = oDGDgetExtDetail.byLDKC;
        this.hasCuNumber = Utility.convertLdevNumberToCu(oDGDgetExtDetail.cuLdev);
        this.hasLdevNumber = Utility.convertLdevNumberToLdev(oDGDgetExtDetail.cuLdev);
        return oDGDgetExtDetail.extDetailContents;
    }

    protected boolean isSupport() {
        return true;
    }

    protected Exception makeException(int n, int n2) {
        return new RJODGDException(n, n2);
    }

    protected Object makeOriginalCompareData(int n, int n2, int n3) {
        this.originalCompareData.extID = n;
        return this.originalCompareData;
    }

    protected Object makeOriginalData(Object object) {
        return new GetDataExtentInfo((ODGDgetExtDetailContents)object);
    }

    protected SanRmiInputInterface makeSanRmiInputInterface() {
        ODGDgetExtentDetail_IN oDGDgetExtentDetail_IN = new ODGDgetExtentDetail_IN();
        int n = Utility.convertCuAndLdevToLdevNumber(this.cuNumber, this.ldevNumber);
        oDGDgetExtentDetail_IN.setParameter((byte)this.ldkcNumber, n);
        return oDGDgetExtentDetail_IN;
    }

    public int getLdkcNumber() {
        return this.hasLdkcNumber;
    }

    public int getCuNumber() {
        return this.hasCuNumber;
    }

    public int getLdevNumber() {
        return this.hasLdevNumber;
    }

    public void initExtentInfo(int n, int n2, int n3, long l, long l2) throws RJODGDException {
        this.ldkcNumber = n;
        this.cuNumber = n2;
        this.ldevNumber = n3;
        this.maxLbaSize = l;
        this.vmaSize = this.convertMByteToLba(l2);
        try {
            StringBuffer stringBuffer = new StringBuffer("    ");
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(".initData()");
            Logger.put(Level.FINE, this.logName, stringBuffer.toString());
            long l3 = System.currentTimeMillis();
            this.initData();
            long l4 = System.currentTimeMillis();
            StringBuffer stringBuffer2 = new StringBuffer("    initData() return. <Time = ");
            stringBuffer2.append(l4 - l3).append(" ms>");
            Logger.put(Level.FINE, this.logName, stringBuffer2.toString());
        }
        catch (RJODGDException rJODGDException) {
            Logger.put(Level.WARNING, this.logName, rJODGDException.getMessage());
            throw rJODGDException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.put(Level.WARNING, this.logName, exception.getMessage());
            throw new RJODGDException(9210, 7060);
        }
    }

    public long getCapacity(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return this.convertLbaToKByte(getDataExtentInfo.lbaSize);
    }

    public long getExtentRangeMax() {
        return this.maxLbaSize - this.vmaSize;
    }

    public byte getGuard(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return getDataExtentInfo.attribute;
    }

    public long getLbaEnd(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return getDataExtentInfo.startLBA + getDataExtentInfo.lbaSize - 1L;
    }

    public long getLbaStart(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return getDataExtentInfo.startLBA;
    }

    public byte getShredPattern(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return getDataExtentInfo.shredPattern;
    }

    public byte getShredProgress(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return getDataExtentInfo.shredProgress;
    }

    public byte getShredState(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return getDataExtentInfo.shredStatus;
    }

    public int getTerm(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return getDataExtentInfo.extTerm;
    }

    public int getTotalExtent() {
        return this.getOriginalDataAll().size();
    }

    public boolean isSetExtent(int n) {
        GetDataExtentInfo getDataExtentInfo = (GetDataExtentInfo)this.getOriginalDataObject(n);
        return !getDataExtentInfo.equals(NULL_DATA_EXTENT);
    }

    private static class GetDataExtentInfo
    extends ODGDgetExtDetailContents
    implements ExtentNumberInterface {
        public GetDataExtentInfo(int n) {
            this.extID = n;
        }

        public GetDataExtentInfo(ODGDgetExtDetailContents oDGDgetExtDetailContents) {
            this.extID = oDGDgetExtDetailContents.extID;
            this.attribute = oDGDgetExtDetailContents.attribute;
            this.startLBA = oDGDgetExtDetailContents.startLBA;
            this.lbaSize = oDGDgetExtDetailContents.lbaSize;
            this.extTerm = oDGDgetExtDetailContents.extTerm;
            this.shredProgress = oDGDgetExtDetailContents.shredProgress;
            this.shredPattern = oDGDgetExtDetailContents.shredPattern;
            this.shredStatus = oDGDgetExtDetailContents.shredStatus;
        }

        public int getExtentId() {
            return this.extID;
        }
    }
}

