/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public abstract class ApplicationProperties {
    public static final String BASE_DIRECTORY = ".webconsole";
    private Properties mpptProperties = new Properties();

    public ApplicationProperties() {
        this(null);
    }

    public ApplicationProperties(Properties properties) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                this.mpptProperties.setProperty(string, string2);
            }
        }
    }

    public abstract String getPropertyFileName();

    public abstract String getPropertyFileHeader();

    public final String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public final String getProperty(String string) {
        String string2 = this.mpptProperties.getProperty(string);
        return string2;
    }

    public final void list(PrintStream printStream) {
        this.mpptProperties.list(printStream);
    }

    public final void list(PrintWriter printWriter) {
        this.mpptProperties.list(printWriter);
    }

    public final synchronized void load() throws IOException {
        File file = this.getPropertyFile();
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                this.setProperty(string, string2);
            }
        }
    }

    public final Enumeration propertyNames() {
        Enumeration<?> enumeration = this.mpptProperties.propertyNames();
        return enumeration;
    }

    public final synchronized Object setProperty(String string, String string2) {
        Object object = this.mpptProperties.setProperty(string, string2);
        return object;
    }

    public final synchronized void store() throws IOException {
        String string = this.getPropertyFileHeader();
        File file = this.getPropertyFile();
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.mpptProperties.store(fileOutputStream, string);
        fileOutputStream.close();
    }

    public final Object remove(Object object) {
        Object object2 = this.mpptProperties.remove(object);
        return object2;
    }

    public final String getPropertyDirectoryPath() {
        String string = System.getProperty("user.home") + File.separator + BASE_DIRECTORY;
        return string;
    }

    private File getPropertyFile() {
        String string = this.getPropertyFileName();
        String string2 = this.getPropertyDirectoryPath();
        File file = new File(string2, string);
        return file;
    }
}

