/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.cimxml;

import com.ws.cim.xmlcim.CIMXMLElementsParser;
import com.ws.wbem.CloseableAddableIterator;
import java.io.InputStream;
import java.util.ArrayList;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.EnumerateResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CIMXMLResponseStreamParser {
    private String mCIMVersion;
    private String mDTDVersion;
    private final XMLInputFactory mFactory = XMLInputFactory.newInstance();
    private String mMessageID;
    private String mProtocolVersion;

    public CIMXMLResponseStreamParser() {
        this.mFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }

    protected CloseableIterator<CIMClass> enumerateClasses(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"CLASS".equals(startTag.getLocalPart())) break;
                    caIterator.add((Object)CIMXMLElementsParser.parseClass((XMLStreamReader)reader, (CIMObjectPath)target));
                }
            }
            eventType = reader.next();
        }
        reader.close();
        caIterator.done();
        return caIterator;
    }

    protected CloseableIterator<CIMObjectPath> enumerateClassNames(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        int eventType = reader.next();
        QName startTag = null;
        String className = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"CLASSNAME".equals(startTag.getLocalPart())) break;
                    className = reader.getAttributeValue(null, "NAME");
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("CLASSNAME")) break;
                    caIterator.add((Object)new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), className, null));
                }
            }
            eventType = reader.next();
        }
        reader.close();
        caIterator.done();
        return caIterator;
    }

    protected CloseableIterator<CIMInstance> enumerateInstances(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        int eventType = reader.next();
        QName startTag = null;
        CIMObjectPath instanceName = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("INSTANCENAME".equals(startTag.getLocalPart())) {
                        instanceName = CIMXMLElementsParser.parseInstanceName((XMLStreamReader)reader, (CIMObjectPath)target);
                    }
                    if (!"INSTANCE".equals(startTag.getLocalPart())) break;
                    caIterator.add((Object)CIMXMLElementsParser.parseInstance((XMLStreamReader)reader, (CIMObjectPath)instanceName));
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("INSTANCENAME")) break;
                    break;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        caIterator.done();
        return caIterator;
    }

    public String getCIMVersion() {
        return this.mCIMVersion;
    }

    protected CIMClass getClass(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CIMClass returnClass = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"CLASS".equals(startTag.getLocalPart())) break;
                    returnClass = CIMXMLElementsParser.parseClass((XMLStreamReader)reader, (CIMObjectPath)target);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("CLASS")) break;
                    return returnClass;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return returnClass;
    }

    public String getDTDVersion() {
        return this.mDTDVersion;
    }

    protected CIMInstance getInstance(XMLStreamReader reader, CIMObjectPath target) throws WBEMException {
        CIMInstance returnInstance = null;
        try {
            int eventType = reader.next();
            QName startTag = null;
            while (eventType != 8) {
                switch (eventType) {
                    case 1: {
                        startTag = reader.getName();
                        if (null == startTag || !"INSTANCE".equals(startTag.getLocalPart())) break;
                        returnInstance = CIMXMLElementsParser.parseInstance((XMLStreamReader)reader, (CIMObjectPath)target);
                        break;
                    }
                    case 2: {
                        QName qName = reader.getName();
                        if (!qName.getLocalPart().equals("INSTANCE")) break;
                        return returnInstance;
                    }
                }
                eventType = reader.next();
            }
            reader.close();
        }
        catch (XMLStreamException ex) {
            System.out.println(ex);
        }
        return returnInstance;
    }

    public String getMessageID() {
        return this.mMessageID;
    }

    public String getProtocolVersion() {
        return this.mProtocolVersion;
    }

    protected EnumerateResponse<CIMObjectPath> openInstancePaths(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        boolean isEndOfSequence = false;
        String enumerationContext = null;
        String paramName = null;
        String paramValue = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("INSTANCEPATH".equals(startTag.getLocalPart())) {
                        caIterator.add((Object)CIMXMLElementsParser.parseInstancePath((XMLStreamReader)reader, (CIMObjectPath)target));
                    }
                    if ("PARAMVALUE".equals(startTag.getLocalPart())) {
                        paramName = reader.getAttributeValue(null, "NAME");
                        break;
                    }
                    if (!"VALUE".equals(startTag.getLocalPart())) break;
                    paramValue = reader.getElementText();
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("PARAMVALUE")) break;
                    if ("EndOfSequence".equals(paramName)) {
                        isEndOfSequence = Boolean.parseBoolean(paramValue);
                        break;
                    }
                    if (!"EnumerationContext".equals(paramName)) break;
                    enumerationContext = paramValue;
                    break;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        caIterator.done();
        return new EnumerateResponse(enumerationContext, (CloseableIterator)caIterator, isEndOfSequence);
    }

    protected EnumerateResponse<CIMInstance> openInstances(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        boolean isEndOfSequence = false;
        String enumerationContext = null;
        String paramName = null;
        String paramValue = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("INSTANCE".equals(startTag.getLocalPart())) {
                        caIterator.add((Object)CIMXMLElementsParser.parseInstance((XMLStreamReader)reader, (CIMObjectPath)target));
                    }
                    if ("PARAMVALUE".equals(startTag.getLocalPart())) {
                        paramName = reader.getAttributeValue(null, "NAME");
                        break;
                    }
                    if (!"VALUE".equals(startTag.getLocalPart())) break;
                    paramValue = reader.getElementText();
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("PARAMVALUE")) break;
                    if ("EndOfSequence".equals(paramName)) {
                        isEndOfSequence = Boolean.parseBoolean(paramValue);
                        break;
                    }
                    if (!"EnumerationContext".equals(paramName)) break;
                    enumerationContext = paramValue;
                    break;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        caIterator.done();
        return new EnumerateResponse(enumerationContext, (CloseableIterator)caIterator, isEndOfSequence);
    }

    protected EnumerateResponse<CIMInstance> openInstancesWithPath(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator(5L, Integer.MAX_VALUE);
        boolean isEndOfSequence = false;
        String enumerationContext = null;
        String paramName = null;
        String paramValue = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("VALUE.INSTANCEWITHPATH".equals(startTag.getLocalPart())) {
                        caIterator.add((Object)CIMXMLElementsParser.parseValueInstanceWithPath((XMLStreamReader)reader, (CIMObjectPath)target));
                        break;
                    }
                    if ("PARAMVALUE".equals(startTag.getLocalPart())) {
                        paramName = reader.getAttributeValue(null, "NAME");
                        break;
                    }
                    if (!"VALUE".equals(startTag.getLocalPart())) break;
                    paramValue = reader.getElementText();
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("PARAMVALUE")) break;
                    if ("EndOfSequence".equals(paramName)) {
                        isEndOfSequence = Boolean.parseBoolean(paramValue);
                        break;
                    }
                    if (!"EnumerationContext".equals(paramName)) break;
                    enumerationContext = paramValue;
                    break;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        caIterator.done();
        return new EnumerateResponse(enumerationContext, (CloseableIterator)caIterator, isEndOfSequence);
    }

    public Object parseSimpleResponse(InputStream in, CIMObjectPath target) throws XMLStreamException, WBEMException {
        String operationResponseName = null;
        XMLStreamReader reader = this.mFactory.createXMLStreamReader(in);
        WBEMOperation operation = null;
        int eventType = reader.next();
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    QName startTag = reader.getName();
                    if (null == startTag) break;
                    if ("CIM".equals(startTag.getLocalPart())) {
                        this.mCIMVersion = reader.getAttributeValue(null, "CIMVERSION");
                        this.mDTDVersion = reader.getAttributeValue(null, "DTDVERSION");
                        break;
                    }
                    if ("MESSAGE".equals(startTag.getLocalPart())) {
                        this.mMessageID = reader.getAttributeValue(null, "ID");
                        this.mProtocolVersion = reader.getAttributeValue(null, "PROTOCOLVERSION");
                        break;
                    }
                    if ("IRETURNVALUE".equals(startTag.getLocalPart())) {
                        if (null != operationResponseName) {
                            switch (operationResponseName) {
                                case "Associators": {
                                    operation = WBEMOperation.ASSOCIATORS;
                                    return CIMXMLElementsParser.parseObjectWithPathArray((XMLStreamReader)reader, (CIMObjectPath)target);
                                }
                                case "References": {
                                    operation = WBEMOperation.REFERENCES;
                                    return CIMXMLElementsParser.parseObjectWithPathArray((XMLStreamReader)reader, (CIMObjectPath)target);
                                }
                                case "OpenAssociatorInstances": {
                                    operation = WBEMOperation.OPENASSOCIATORS;
                                    return this.openInstancesWithPath(reader, target);
                                }
                                case "OpenEnumerateInstances": {
                                    operation = WBEMOperation.OPENENUMERATEINSTANCES;
                                    return this.openInstancesWithPath(reader, target);
                                }
                                case "OpenReferenceInstances": {
                                    operation = WBEMOperation.OPENREFERENCES;
                                    return this.openInstancesWithPath(reader, target);
                                }
                                case "PullInstancesWithPath": {
                                    operation = WBEMOperation.PULLINSTANCESWITHPATH;
                                    return this.openInstancesWithPath(reader, target);
                                }
                                case "CreateInstance": {
                                    operation = WBEMOperation.CREATEINSTANCE;
                                    return CIMXMLElementsParser.parseInstanceName((XMLStreamReader)reader, (CIMObjectPath)target);
                                }
                                case "EnumerateClasses": {
                                    operation = WBEMOperation.ENUMERATECLASSES;
                                    return this.enumerateClasses(reader, target);
                                }
                                case "EnumerateClassNames": {
                                    operation = WBEMOperation.ENUMERATECLASSNAMES;
                                    return this.enumerateClassNames(reader, target);
                                }
                                case "EnumerateInstances": {
                                    operation = WBEMOperation.ENUMERATEINSTANCES;
                                    return this.enumerateInstances(reader, target);
                                }
                                case "EnumerateQualifiers": {
                                    operation = WBEMOperation.ENUMERATEQUALIFIERTYPES;
                                    return CIMXMLElementsParser.parseQualifierTypes((XMLStreamReader)reader, (CIMObjectPath)target);
                                }
                                case "ExecQuery": {
                                    operation = WBEMOperation.EXECUTEQUERY;
                                    return CIMXMLElementsParser.parseObjectWithPathArray((XMLStreamReader)reader, (CIMObjectPath)target);
                                }
                                case "GetClass": {
                                    operation = WBEMOperation.GETCLASS;
                                    return this.getClass(reader, target);
                                }
                                case "GetInstance": {
                                    operation = WBEMOperation.GETINSTANCE;
                                    return this.getInstance(reader, target);
                                }
                                case "GetQualifier": {
                                    operation = WBEMOperation.GETQUALIFIERTYPE;
                                    return CIMXMLElementsParser.parseQualifierType((XMLStreamReader)reader, (CIMObjectPath)target, (int)eventType);
                                }
                                case "PullInstancePaths": {
                                    operation = WBEMOperation.PULLINSTANCES;
                                    return this.openInstancePaths(reader, target);
                                }
                                case "OpenQueryInstances": {
                                    operation = WBEMOperation.OPENQUERYINSTANCES;
                                    return this.openInstances(reader, target);
                                }
                                case "PullInstances": {
                                    operation = WBEMOperation.PULLINSTANCES;
                                    return this.openInstances(reader, target);
                                }
                            }
                            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)("unknown operation: " + operationResponseName), (WBEMOperation)WBEMOperation.CLOSEENUMERATION, (String)"");
                        }
                        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)("unknown operation: " + operationResponseName), (WBEMOperation)WBEMOperation.CLOSEENUMERATION, (String)"");
                    }
                    if ("IMETHODRESPONSE".equals(startTag.getLocalPart())) {
                        operationResponseName = reader.getAttributeValue(null, "NAME");
                        break;
                    }
                    if (!"ERROR".equals(startTag.getLocalPart())) break;
                    throw CIMXMLElementsParser.parseError((XMLStreamReader)reader, (CIMObjectPath)target, (WBEMOperation)(operation == null ? WBEMOperation.ENUMERATEINSTANCES : operation), (String)target.getObjectName());
                }
                case 2: {
                    QName endTag = reader.getName();
                    if (!"IMETHODRESPONSE".equals(endTag.getLocalPart()) || null == operationResponseName) break;
                    switch (operationResponseName) {
                        case "CloseEnumeration": {
                            operation = WBEMOperation.CLOSEENUMERATION;
                            return null;
                        }
                        case "CreateClass": {
                            operation = WBEMOperation.CREATECLASS;
                            return null;
                        }
                        case "DeleteClass": {
                            operation = WBEMOperation.DELETECLASS;
                            return null;
                        }
                        case "DeleteInstance": {
                            operation = WBEMOperation.DELETEINSTANCE;
                            return null;
                        }
                        case "DeleteQualifier": {
                            operation = WBEMOperation.DELETEQUALIFIERTYPE;
                            return null;
                        }
                        case "ModifyClass": {
                            operation = WBEMOperation.MODIFYCLASS;
                            return null;
                        }
                        case "ModifyInstance": {
                            operation = WBEMOperation.MODIFYINSTANCE;
                            return null;
                        }
                        case "SetQualifier": {
                            operation = WBEMOperation.CREATEQUALIFIERTYPE;
                            return null;
                        }
                    }
                    break;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)("unknown operation: " + operationResponseName), (WBEMOperation)WBEMOperation.CLOSEENUMERATION, (String)"");
    }

    public Object parseInvokeMethodResponse(InputStream in, CIMObjectPath target, ArrayList<CIMArgument<?>> outArgs) throws XMLStreamException, WBEMException {
        String methodName = null;
        Object returnValue = null;
        XMLStreamReader reader = this.mFactory.createXMLStreamReader(in);
        int eventType = reader.next();
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    QName startTag = reader.getName();
                    if (null == startTag) break;
                    if ("CIM".equals(startTag.getLocalPart())) {
                        this.mCIMVersion = reader.getAttributeValue(null, "CIMVERSION");
                        this.mDTDVersion = reader.getAttributeValue(null, "DTDVERSION");
                    } else if ("MESSAGE".equals(startTag.getLocalPart())) {
                        this.mMessageID = reader.getAttributeValue(null, "ID");
                        this.mProtocolVersion = reader.getAttributeValue(null, "PROTOCOLVERSION");
                    } else if ("PARAMVALUE".equals(startTag.getLocalPart())) {
                        outArgs.add(CIMXMLElementsParser.parseParamValue((XMLStreamReader)reader, (CIMObjectPath)target));
                    } else if ("RETURNVALUE".equals(startTag.getLocalPart())) {
                        returnValue = CIMXMLElementsParser.parseReturnValue((XMLStreamReader)reader, (CIMObjectPath)target);
                    }
                    if ("ERROR".equals(startTag.getLocalPart())) {
                        throw CIMXMLElementsParser.parseError((XMLStreamReader)reader, (CIMObjectPath)target, (WBEMOperation)WBEMOperation.INVOKEMETHOD, methodName);
                    }
                    if (!"METHODRESPONSE".equals(startTag.getLocalPart())) break;
                    methodName = reader.getAttributeValue(null, "NAME");
                    break;
                }
                case 2: {
                    QName endTag = reader.getName();
                    if (!"METHODRESPONSE".equals(endTag.getLocalPart())) break;
                    return returnValue;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        throw WBEMOperationErrors.getOperationNotSupportedByWBEMServerException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.INVOKEMETHOD, methodName);
    }
}

