/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim;

import com.ws.cim.CIMMapping;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.wbem.WBEMException;

public class CIMMappingFactory {
    private static final String FILE_NAME = "com.ws.cim.CIMMappingFactory";
    private static final String NAME_KEY = "mappings";
    private static final String FORMAT_KEY = "formats";

    public static CIMMapping getMapping(String ID) throws WBEMException {
        String propName;
        if (ID == null) {
            throw new IllegalArgumentException("CIMMappingFactory: The mapping can not be null!");
        }
        Properties properties = CIMMappingFactory.loadProperties(FILE_NAME);
        String propValue = properties.getProperty(propName = "mappings." + ID.toLowerCase());
        if (propValue == null || !propValue.equalsIgnoreCase(ID)) {
            throw new IllegalArgumentException(properties.getProperty("ERROR_MAPPING_NOT_SUPPORTED"));
        }
        propName = propValue.toLowerCase() + "." + NAME_KEY + ".class";
        String classname = properties.getProperty(propName);
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            throw new WBEMException(1, properties.getProperty("ERROR_MAPPING_CLASS_LOAD_FAILED"));
        }
        CIMMapping wc = null;
        try {
            Class[] paramTypes = new Class[]{};
            Object[] paramList = new Object[]{};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            wc = (CIMMapping)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            Throwable ax = ex.getTargetException();
            if (ax instanceof WBEMException) {
                WBEMException cex = (WBEMException)ax;
                throw cex;
            }
            throw new WBEMException(1, properties.getProperty("ERROR_MAPPING_CLASS_LOAD_FAILED"), null, ax);
        }
        catch (Exception ex) {
            throw new WBEMException(1, properties.getProperty("ERROR_MAPPING_CLASS_LOAD_FAILED"), null, (Throwable)ex);
        }
        return wc;
    }

    public static String[] getSupportedMappings() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Properties properties = CIMMappingFactory.loadProperties(FILE_NAME);
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (!k.startsWith(NAME_KEY)) continue;
                String value = properties.getProperty(k);
                String formatKey = value.toLowerCase() + "." + FORMAT_KEY;
                String formats = properties.getProperty(formatKey);
                ret.add(value + " - " + formats);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static Properties loadProperties(String bundle) {
        Properties props = new Properties();
        PropertyResourceBundle prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, new Locale("", ""));
        if (prb != null) {
            Enumeration<String> en = prb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                if (key == null) continue;
                try {
                    String val = prb.getString(key);
                    props.setProperty(key, val);
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    private CIMMappingFactory() {
    }
}

