/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen;

import com.ws.cim.CIMMappingBase;
import com.ws.cim.codegen.cmpi.CMPICodeGenerator;
import com.ws.utilities.Resources;
import javax.cim.CIMClass;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;

public class CMapping
extends CIMMappingBase {
    public static final String FORMAT_CMPI = "CMPI";
    public static final String ERROR_INVALID_FORMAT = "Invalid Format";
    private String mOutdir;
    private boolean mQuiet;
    private Resources mProperties;

    @Override
    public void close() throws Exception {
        String[] remove = new String[]{"Version_Number", "store", "Logfile.", "Snapshot."};
        this.removeTempFiles(this.mQuiet, this.mOutdir, remove);
    }

    @Override
    public String getCustomPropertyDescription(String cpName) {
        return this.mProperties.loadString(cpName);
    }

    @Override
    public String[] getCustomPropertyNames(String format) {
        if (format.equalsIgnoreCase(FORMAT_CMPI)) {
            return new String[]{"q"};
        }
        return null;
    }

    @Override
    public void initialize(String outdir) throws Exception {
        this.mOutdir = outdir;
        this.mQuiet = false;
        this.mProperties = new Resources("com.ws.cim.codegen.CMapping");
    }

    @Override
    public void produceMappedElement(CIMElement element) throws Exception {
        if (element instanceof CIMClass) {
            CIMClass cClass = (CIMClass)element;
            if (cClass.hasQualifierValue("Abstract", (Object)Boolean.TRUE) || cClass.hasQualifierValue("Indication", (Object)Boolean.TRUE)) {
                return;
            }
            CMPICodeGenerator cmpi = new CMPICodeGenerator((CIMClass)element, this.mOutdir);
            cmpi.generateCode();
        }
    }

    @Override
    public void produceMappedInstance(CIMInstance instance) throws Exception {
    }

    @Override
    public void setFormat(String format) {
        if (!format.equals(FORMAT_CMPI)) {
            throw new IllegalArgumentException(ERROR_INVALID_FORMAT);
        }
    }

    @Override
    public void setProperty(String name, String value) {
        if ("q".equals(name)) {
            this.mQuiet = true;
        }
    }
}

