/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.cmpi.CCodeWriter;
import com.ws.cim.codegen.cmpi.CDataMember;
import com.ws.cim.codegen.cmpi.CFunction;
import com.ws.cim.codegen.cmpi.CHeaderCodeGenerator;
import com.ws.cim.codegen.cmpi.C_SourceFileGenerator;
import javax.cim.CIMClass;

public class CMPICodeGenerator {
    private static final String DEPRECATED = "Deprecated";
    private static final String DESCRIPTION = "Description";
    private CIMClass mCIMClass;
    private String mOutdir;
    private CCodeWriter cw;

    private CMPICodeGenerator(String pOutdir) {
        this.mOutdir = pOutdir;
        this.cw = new CCodeWriter(this.mOutdir);
    }

    public CMPICodeGenerator(CIMClass pClass, String pOutputdir) throws Exception {
        this(pOutputdir);
        this.mCIMClass = pClass;
    }

    public String getClassDescription() {
        StringBuffer description = new StringBuffer();
        if (this.mCIMClass.hasQualifier(DESCRIPTION)) {
            description.append(this.mCIMClass.getQualifierValue(DESCRIPTION));
            if (this.mCIMClass.hasQualifier(DEPRECATED)) {
                description.append(" \n \n@deprecated\t");
                String[] deprecatedValues = (String[])this.mCIMClass.getQualifier(DEPRECATED).getValue();
                for (int i = 0; i < deprecatedValues.length; ++i) {
                    description.append(deprecatedValues[i]);
                    if (i >= deprecatedValues.length - 1) continue;
                    description.append(",");
                }
            }
        }
        return description.toString();
    }

    public void generateCode() throws Exception {
        try {
            CHeaderCodeGenerator chcg = new CHeaderCodeGenerator(this.mCIMClass, this.mOutdir);
            chcg.generateCode();
            C_SourceFileGenerator c_sourceFile = new C_SourceFileGenerator(this.mCIMClass);
            this.cw.setClassName(this.mCIMClass.getName());
            for (CDataMember dataMember : c_sourceFile.getDataMembers()) {
                this.cw.addDataMember(dataMember);
            }
            for (CFunction func : c_sourceFile.getFunctions()) {
                this.cw.addMethod(func);
            }
            this.cw.write(this.mCIMClass.getName() + ".c");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

