/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48.client;

import com.ws.cim.codegen.java.JavaCodeWriter;
import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaDataConstant;
import com.ws.cim.codegen.java.JavaDataMember;
import com.ws.cim.codegen.java.JavaEnums;
import com.ws.cim.codegen.java.JavaMethod;
import com.ws.cim.codegen.java.JavaMethodBody;
import com.ws.cim.codegen.jsr48.AbstractCodeGenerator;
import com.ws.cim.codegen.jsr48.JavaArgument;
import java.util.ArrayList;

public class CIMBaseCodeGenerator
extends AbstractCodeGenerator {
    private final JavaCodeWriter cw;
    private final ArrayList<JavaMethod> mMethod;
    private final ArrayList<String> mImport;
    private final ArrayList<JavaEnums> mEnums;
    private String mPackageName;

    public CIMBaseCodeGenerator(String pOutdir, String pPackageName) {
        this.cw = new JavaCodeWriter(pOutdir);
        this.mPackageName = pPackageName;
        this.mMethod = new ArrayList();
        this.mImport = new ArrayList();
        this.mEnums = new ArrayList();
        this.setImports();
        this.setConstants();
        this.setDataMembers();
        this.setMethods();
        this.mImports.addAll(this.mImport);
        this.mMethods.addAll(this.mMethod);
    }

    public void setPackageName(String pPackageName) {
        this.mPackageName = pPackageName;
    }

    @Override
    public void setMethods() {
        this.addConstructorMethod();
        this.addOverloadedConstructorMethod();
        this.addGetWBEMClientMethod();
        this.addSetWBEMClientMethod();
        this.addGetCIMInstanceMethod();
        this.addSetCIMInstanceMethod();
        this.addUpdateMethod();
        this.addUpdate2Method();
        this.addDeleteMethod();
        this.addGetPropertyMethod();
        this.addGetArrayPropertyMethod();
        this.addGetAssociationPropertyMethod();
        this.addSetPropertyMethod();
        this.addSetPropertyValueMethod();
        this.addSetArrayPropertyMethod();
        this.addGetBaseKeysMethod();
        this.addGetObjectPathMethod();
        this.addGetArrayIndexMethod();
        this.addGetBaseVersionMethod();
        this.addToStringMethod();
    }

    @Override
    public void setImports() {
        this.mImport.add("javax.wbem.client.WBEMClient");
        this.mImport.add("javax.wbem.WBEMException");
        this.mImport.add("javax.cim.CIMObjectPath");
        this.mImport.add("javax.cim.CIMInstance");
        this.mImport.add("javax.cim.CIMProperty");
        this.mImport.add("java.io.Serializable");
        this.mImport.add("java.util.Arrays");
        this.mImport.add("java.util.List");
        this.mImport.add("java.util.ListIterator");
        this.mImport.add("java.util.Vector");
        this.mImport.add("javax.cim.CIMDataType");
    }

    @Override
    public void setConstants() {
        String comment = "Required data constant for java 1.5";
        this.mDataConstants.add(new JavaDataConstant("Required data constant for java 1.5", JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "long", "serialVersionUID", "1L"));
    }

    @Override
    public void setDataMembers() {
        String comment = "Handler for the CIMInstance object";
        this.mDataMembers.add(new JavaDataMember(comment, JavaCodeWriterConstants.TYPE.PROTECTED, false, false, "CIMInstance", "mCimInstance", "null"));
        comment = "Handler for the WBEMClient object";
        this.mDataMembers.add(new JavaDataMember(comment, JavaCodeWriterConstants.TYPE.PROTECTED, false, false, "WBEMClient", "mWBEMClient", "null"));
    }

    public ArrayList<JavaEnums> getEnums() {
        return this.mEnums;
    }

    private void addConstructorMethod() {
        String comment = "This default constructor takes no parameters and creates an empty instance of CIMBase.";
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("super();");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This default constructor takes no parameters and creates an empty instance of CIMBase.", JavaCodeWriterConstants.TYPE.PUBLIC, false, null, "CIMBase", null, null, body.toString());
        this.mMethod.add(m);
    }

    private void addOverloadedConstructorMethod() {
        String comment = "This constructor takes the specified Handle and CIMInstance and creates a CIMBase. \n \n@param\tpHandle\thandle to the WBEMClient \n@param\tpInstance\thandle to the CIMInstance being managed ";
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pHandle", "WBEMClient"));
        argList.add(new JavaArgument(false, "pInstance", "CIMInstance"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("super();");
        lData.add("\n\t\tmWBEMClient = pHandle;");
        lData.add("\n\t\tmCimInstance = pInstance;");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This constructor takes the specified Handle and CIMInstance and creates a CIMBase. \n \n@param\tpHandle\thandle to the WBEMClient \n@param\tpInstance\thandle to the CIMInstance being managed ", JavaCodeWriterConstants.TYPE.PUBLIC, false, null, "CIMBase", argList, null, body.toString());
        this.mMethod.add(m);
    }

    private void addGetWBEMClientMethod() {
        String comment = "This method returns the CIMBase's WBEMClient. \n \n@return\thandle to the WBEMClient";
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("return(mWBEMClient);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method returns the CIMBase's WBEMClient. \n \n@return\thandle to the WBEMClient", JavaCodeWriterConstants.TYPE.PUBLIC, false, "WBEMClient", "getWBEMClient", null, null, body.toString());
        this.mMethod.add(m);
    }

    private void addSetWBEMClientMethod() {
        String comment = "This method sets the CIMBase's WBEMClient to the specified value. \n \n@param\tpHandle\thandle to the WBEMClient \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("IllegalArgumentException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pHandle", "WBEMClient"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("mWBEMClient = pHandle;");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method sets the CIMBase's WBEMClient to the specified value. \n \n@param\tpHandle\thandle to the WBEMClient \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "setWBEMClient", argList, null, body.toString());
        this.mMethod.add(m);
    }

    private void addGetCIMInstanceMethod() {
        String comment = "This method returns the CIMBase's CIMInstance. \n \n@return\thandle to the CIMInstance being managed";
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("return(mCimInstance);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method returns the CIMBase's CIMInstance. \n \n@return\thandle to the CIMInstance being managed", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CIMInstance", "getCIMInstance", null, null, body.toString());
        this.mMethod.add(m);
    }

    private void addSetCIMInstanceMethod() {
        String comment = "This method sets the CIMBase's CIMInstance to the specified value. \n \n@param\tpInstance\thandle to the CIMInstance being managed \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("IllegalArgumentException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pInstance", "CIMInstance"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("mCimInstance = pInstance;");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method sets the CIMBase's CIMInstance to the specified value. \n \n@param\tpInstance\thandle to the CIMInstance being managed \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "setCIMInstance", argList, throwsList, body.toString());
        this.mMethod.add(m);
    }

    private void addUpdateMethod() {
        String comment = "This method makes the remote call to update the CIMInstance in the WBEMClient. \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("WBEMException");
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("CIMProperty<?>[] cp = mCimInstance.getProperties();");
        lData.add("\n\t\tString[] properList = null;");
        lData.add("\n\t\tif(cp != null) {");
        lData.add("\n\t\t\tproperList = new String[cp.length];");
        lData.add("\n\t\t\tint ndx = 0;");
        lData.add("\n\t\t\tfor(CIMProperty<?> pe: cp) {");
        lData.add("\n\t\t\t\tproperList[ndx] = pe.getName();");
        lData.add("\n\t\t\t\tndx++;");
        lData.add("\n\t\t\t}");
        lData.add("\n\t\t}");
        lData.add("\n\t\tmWBEMClient.modifyInstance(mCimInstance, properList);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method makes the remote call to update the CIMInstance in the WBEMClient. \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "update", null, throwsList, body.toString());
        this.mMethod.add(m);
    }

    private void addUpdate2Method() {
        String comment = "This method makes the remote call to update the specified CIMProperty of the CIMInstance in the WBEMClient. \n \n@param\tpPropName\tproperty name to update in the CIMInstance \n@param\tpValue\tproperty value to update in the CIMProperty \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pPropName", "String"));
        argList.add(new JavaArgument(false, "pValue", "Object"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("mWBEMClient.setProperty(pPropName, pValue.toString());");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method makes the remote call to update the specified CIMProperty of the CIMInstance in the WBEMClient. \n \n@param\tpPropName\tproperty name to update in the CIMInstance \n@param\tpValue\tproperty value to update in the CIMProperty \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "update", argList, throwsList, body.toString());
        this.mMethod.add(m);
    }

    private void addDeleteMethod() {
        String comment = "This method makes the remote call to delete the CIMInstance in the WBEMClient. \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("WBEMException");
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("mWBEMClient.deleteInstance(getObjectPath());");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method makes the remote call to delete the CIMInstance in the WBEMClient. \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "delete", null, throwsList, body.toString());
        this.mMethod.add(m);
    }

    private void addGetPropertyMethod() {
        String comment = "This is a convenience method for use by subclasses to get the Object contained in the given CIMProperty's CIMValue. NOTE: The Object returned may be null. \n \n@param\tpPropName\tproperty name whose value should be retrieved \n \n@return\tobject contained in the CIMProperty's";
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pPropName", "String"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("try {");
        lData.add("\n\t\t\treturn (mCimInstance.getProperty(pPropName).getValue());");
        lData.add("\n\t\t} catch (NullPointerException npe) {");
        lData.add("\n\t\t}");
        lData.add("\n\t\treturn ((Object)null);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This is a convenience method for use by subclasses to get the Object contained in the given CIMProperty's CIMValue. NOTE: The Object returned may be null. \n \n@param\tpPropName\tproperty name whose value should be retrieved \n \n@return\tobject contained in the CIMProperty's", JavaCodeWriterConstants.TYPE.PUBLIC, false, "Object", "getProperty", argList, null, body.toString());
        this.mMethod.add(m);
    }

    private void addGetArrayPropertyMethod() {
        String comment = "This is a convenience method for use by subclasses to get the String[] equivalent to the Vector contained in the given CIMProperty. NOTE: The String[] returned may be null. \n \n@param\tpPropName\tproperty name to get the value for \n@param\tpValueArr\tproperty Values qualifier data \n@param\tpValueMapArr\tproperty ValueMap qualifier data \n \n@return\tcontainer of constants for property value ";
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pPropName", "String"));
        argList.add(new JavaArgument(false, "pValueArr", "String[]"));
        argList.add(new JavaArgument(false, "pValueMapArr", "Object[]"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("List<?> propList = null;");
        lData.add("\n\t\ttry {");
        lData.add("\n\t\t\tpropList = ((List<?>)mCimInstance.getProperty(pPropName).getValue());");
        lData.add("\n\t\t} catch (NullPointerException npe) {");
        lData.add("\n\n\t\t}");
        lData.add("\n\t\tif(propList != null) {");
        lData.add("\n\t\t\tString[] returnArr;");
        lData.add("\n\t\t\treturnArr = new String[propList.size()];");
        lData.add("\n\t\t\tListIterator<?> listIterator = propList.listIterator();");
        lData.add("\n\t\t\tint counter = 0;");
        lData.add("\n\t\t\twhile (listIterator.hasNext()) {");
        lData.add("\n\t\t\t\treturnArr[counter] = pValueArr[getArrayIndex(pValueMapArr, listIterator.next())];");
        lData.add("\n\t\t\t\tcounter++;");
        lData.add("\n\t\t\t}");
        lData.add("\n\t\t\treturn (returnArr);");
        lData.add("\n\t\t}");
        lData.add("\n\t\treturn ((String[])null);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This is a convenience method for use by subclasses to get the String[] equivalent to the Vector contained in the given CIMProperty. NOTE: The String[] returned may be null. \n \n@param\tpPropName\tproperty name to get the value for \n@param\tpValueArr\tproperty Values qualifier data \n@param\tpValueMapArr\tproperty ValueMap qualifier data \n \n@return\tcontainer of constants for property value ", JavaCodeWriterConstants.TYPE.PUBLIC, false, "String[]", "getArrayProperty", argList, null, body.toString());
        this.mMethod.add(m);
    }

    private void addGetAssociationPropertyMethod() {
        String comment = "This method gets the CIMInstance referenced by the property value (i.e. the object path specified) and sets it in the specified Class. This method is used by accessor methods of Association properties. \n \n@param\tpCop\tobject path for the CIMInstance \n@param\tpBase\tBase container for CIMInstance retrieved \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("WBEMException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pCop", "CIMObjectPath"));
        argList.add(new JavaArgument(false, "pBase", "CIMBase"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("\n\t\tCIMInstance cI = mWBEMClient.getInstance(pCop, null);");
        lData.add("\n\t\tpBase.setCIMInstance(cI);");
        lData.add("\n\t\tpBase.setWBEMClient(mWBEMClient);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method gets the CIMInstance referenced by the property value (i.e. the object path specified) and sets it in the specified Class. This method is used by accessor methods of Association properties. \n \n@param\tpCop\tobject path for the CIMInstance \n@param\tpBase\tBase container for CIMInstance retrieved \n \n@throws WBEMException - is what all WBEM Operations return when there is an error.", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "getAssociationProperty", argList, throwsList, body.toString());
        this.mMethod.add(m);
    }

    private void addSetPropertyMethod() {
        String comment = "This is a convenience method for use by subclasses to set a CIMValue containing the specified Object value in the CIMProperty of the specified name. \n \n@param\tpPropName\tproperty name to set a new value for \n@param\tpPropValue\tproperty value to update in the CIMInstance \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("IllegalArgumentException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pPropName", "String"));
        argList.add(new JavaArgument(false, "pPropValue", "Object"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("try {");
        lData.add("\n\t\t\tif(pPropName.equals(\"\") || pPropName == null || pPropValue == null) {");
        lData.add("\n\t\t\t\tthrow new IllegalArgumentException();");
        lData.add("\n\t\t\t}");
        lData.add("\n\t\t\tString[] strArr = {pPropValue.toString()};");
        lData.add("\n\t\t\tmWBEMClient.modifyInstance(mCimInstance, strArr);");
        lData.add("\n\t\t} catch (WBEMException e) {");
        lData.add("\n\t\t\te.printStackTrace();");
        lData.add("\n\t\t}");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This is a convenience method for use by subclasses to set a CIMValue containing the specified Object value in the CIMProperty of the specified name. \n \n@param\tpPropName\tproperty name to set a new value for \n@param\tpPropValue\tproperty value to update in the CIMInstance \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "setProperty", argList, throwsList, body.toString());
        this.mMethod.add(m);
    }

    private void addSetPropertyValueMethod() {
        String comment = "This is a convenience method for use by subclass setter methods  to set a handled instance property value  \n \n@param\tpPropName\tproperty name to set a new value for \n \n@param\tpDType\tthe data type for the property to set \n@param\tpPropValue\tproperty value to update in the handled instance \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("IllegalArgumentException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pPropName", "String"));
        argList.add(new JavaArgument(false, "pDType", "CIMDataType"));
        argList.add(new JavaArgument(false, "pPropValue", "Object"));
        if (!this.mImport.contains("javax.cim.CIMDataType")) {
            this.mImport.add("javax.cim.CIMDataType");
        }
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("if(pPropName.equals(\"\") || pPropName == null || pPropValue == null) {");
        lData.add("\n\t\t\tthrow new IllegalArgumentException();");
        lData.add("\n\t\t}");
        lData.add("\n\t\tCIMProperty<?>[] updatedProp = { new CIMProperty<Object>(pPropName, pDType, pPropValue)");
        lData.add("\n\t\t};");
        lData.add("\n\t\tCIMInstance derivedInst = mCimInstance.deriveInstance(updatedProp);");
        lData.add("\n\t\tsetCIMInstance(derivedInst);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This is a convenience method for use by subclass setter methods  to set a handled instance property value  \n \n@param\tpPropName\tproperty name to set a new value for \n \n@param\tpDType\tthe data type for the property to set \n@param\tpPropValue\tproperty value to update in the handled instance \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.", JavaCodeWriterConstants.TYPE.PROTECTED, false, "void", "setPropertyValue", argList, throwsList, body.toString());
        this.mMethod.add(m);
    }

    private void addSetArrayPropertyMethod() {
        String comment = " This is a convenience method for use by subclasses to set a CIMValue containing a Vector equivalent to the specified String[] in the CIMProperty of the specified name. \n \n@param\tpPropName\tproperty name to get the value for \n@param\tpValueArr\tproperty Values qualifier data \n@param\tpValueMapArr\tproperty ValueMap qualifier data \n@param\tpPropValues\tproperty value to set in the CIMInstance \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.";
        ArrayList<String> throwsList = new ArrayList<String>();
        throwsList.add("IllegalArgumentException");
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pPropName", "String"));
        argList.add(new JavaArgument(false, "pValueArr", "String[]"));
        argList.add(new JavaArgument(false, "pValueMapArr", "Object[]"));
        argList.add(new JavaArgument(false, "pPropValues", "String[]"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("Vector<Object> vPropValue = new Vector<Object>(pPropValues.length);");
        lData.add("\n\t\tfor(int i=0; i<pPropValues.length; i++) {");
        lData.add("\n\t\t\tvPropValue.addElement(pValueMapArr[getArrayIndex(pValueArr,pPropValues[i])]);");
        lData.add("\n\t\t}");
        lData.add("\n\t\tsetProperty(pPropName, vPropValue);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod(" This is a convenience method for use by subclasses to set a CIMValue containing a Vector equivalent to the specified String[] in the CIMProperty of the specified name. \n \n@param\tpPropName\tproperty name to get the value for \n@param\tpValueArr\tproperty Values qualifier data \n@param\tpValueMapArr\tproperty ValueMap qualifier data \n@param\tpPropValues\tproperty value to set in the CIMInstance \n \n@throws IllegalArgumentException - If the argument passed is illegal or in appropriate.", JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "setArrayProperty", argList, throwsList, body.toString());
        this.mMethod.add(m);
    }

    private void addGetBaseKeysMethod() {
        String comment = "This method returns a string array of the Key qualified property name(s) in the CIMInstance. This is needed to build the CIMObjectPath for the CIMInstance if it does not contain any qualifier information. \n \n@return\tarray of the key qualified property names";
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("return ((String[])null);");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method returns a string array of the Key qualified property name(s) in the CIMInstance. This is needed to build the CIMObjectPath for the CIMInstance if it does not contain any qualifier information. \n \n@return\tarray of the key qualified property names", JavaCodeWriterConstants.TYPE.PUBLIC, false, "String[]", "getBaseKeys", null, null, body.toString());
        this.mMethod.add(m);
    }

    private void addGetObjectPathMethod() {
        String comment = "This method returns the CIMObjectPath of the class's CIMInstance. \n \n@return\tobject path for the CIMInstance";
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("return mCimInstance.getObjectPath();");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method returns the CIMObjectPath of the class's CIMInstance. \n \n@return\tobject path for the CIMInstance", JavaCodeWriterConstants.TYPE.PUBLIC, false, "CIMObjectPath", "getObjectPath", null, null, body.toString());
        this.mMethod.add(m);
    }

    private void addGetArrayIndexMethod() {
        String comment = "This convenience method returns the index of the specified object in the specified array, or -1 if the object is not contained in the array. \n \n@param\tpObjArr\tObject array to find index of Object in \n@param\tpObj\tObject to find index of in Object array \n \n@return\tindex of Object in Object array";
        ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
        argList.add(new JavaArgument(false, "pObjArr", "Object[]"));
        argList.add(new JavaArgument(false, "pObj", "Object"));
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("List<?> arrList = Arrays.asList(pObjArr);");
        lData.add("\n\t\treturn(arrList.indexOf(pObj));");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This convenience method returns the index of the specified object in the specified array, or -1 if the object is not contained in the array. \n \n@param\tpObjArr\tObject array to find index of Object in \n@param\tpObj\tObject to find index of in Object array \n \n@return\tindex of Object in Object array", JavaCodeWriterConstants.TYPE.PUBLIC, false, "int", "getArrayIndex", argList, null, body.toString());
        this.mMethod.add(m);
    }

    private void addGetBaseVersionMethod() {
        String comment = "This method returns the CIM class's Version qualifier value, or '-1' if it does not have this qualifier. \n \n@return\tVersion qualifier value or \"-1\" if there isn't one ";
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("return (\"-1\");");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method returns the CIM class's Version qualifier value, or '-1' if it does not have this qualifier. \n \n@return\tVersion qualifier value or \"-1\" if there isn't one ", JavaCodeWriterConstants.TYPE.PUBLIC, false, "String", "getBaseVersion", null, null, body.toString());
        this.mMethod.add(m);
    }

    private void addToStringMethod() {
        String comment = "This method returns a string representation of the CIMBase. This method is intended for debug purposes and the format of the string may vary from implementation to implementation. The string returned may be empty, but may not be null. \n \n@return\tstring representation of the Base";
        ArrayList<String> lData = new ArrayList<String>();
        lData.add("return (mCimInstance.toString());");
        JavaMethodBody body = new JavaMethodBody(null, lData);
        JavaMethod m = new JavaMethod("This method returns a string representation of the CIMBase. This method is intended for debug purposes and the format of the string may vary from implementation to implementation. The string returned may be empty, but may not be null. \n \n@return\tstring representation of the Base", JavaCodeWriterConstants.TYPE.PUBLIC, false, "String", "toString", null, null, body.toString());
        this.mMethod.add(m);
    }

    public void generateCode() throws Exception {
        this.cw.setFileComment("This code was generated by WS SDK Pro");
        this.cw.setPackageName(this.mPackageName);
        for (JavaDataConstant dce : this.mDataConstants) {
            this.cw.addDataConstant(dce);
        }
        for (JavaDataMember dme : this.mDataMembers) {
            this.cw.addDataMember(dme);
        }
        for (JavaMethod me : this.mMethods) {
            this.cw.addMethod(me);
        }
        String description = "This Class implements the CIMBaseInterface interface class. It is the base Class of all generated Java source code. ";
        ArrayList<String> iList = new ArrayList<String>();
        iList.add("CIMBaseInterface");
        iList.add("Serializable");
        this.cw.setClassInfo(true, "This Class implements the CIMBaseInterface interface class. It is the base Class of all generated Java source code. ", "CIMBase", null, iList);
        this.cw.setImports(this.mImport);
        this.cw.write("CIMBase.java");
    }
}

