/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.v3;

import com.ws.cim3.utilities.CIMUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim3.CIMElement;
import javax.cim3.CIMEnumeration;
import javax.cim3.CIMEnumerationEntry;
import javax.cim3.CIMMethod;
import javax.cim3.CIMObjectPath;
import javax.cim3.CIMQualifier;
import javax.cim3.CIMStructure;

public class V3MOFMapping {
    private static final String PACKAGE_PATH = "PackagePath";
    private static final String INSTANCE_ID = "InstanceID";
    private static final String VALUES = "Values";
    private static final String VALUE_MAP = "ValueMap";
    private static final String INDICATION = "Indication";
    private static final String COMPOSITION = "Composition";
    private static final String Q_OCTET_STRING = "OctetString";
    private static final String Q_REFERENCE = "reference";
    private static final String Q_EMBEDDED_INSTANCE = "EmbeddedInstance";
    private String mVersion = null;
    private boolean mIsRemoveDeprecated = true;
    private boolean mIsPutInDirs = false;
    private final String mOutdir;
    private List<String> mFilteredSchemaList;
    private final ArrayList<String> mIncludeList;

    public V3MOFMapping(String outDir) {
        this.mOutdir = outDir;
        this.mFilteredSchemaList = null;
        this.mIncludeList = new ArrayList();
        this.mIncludeList.add("Qualifiers.mof");
    }

    public void close() {
        this.writeIncludeFile(this.mIncludeList);
    }

    public void mapIt(javax.cim.CIMElement element, Properties props) throws Exception {
        try {
            String str;
            if (props.containsKey("d")) {
                this.mIsRemoveDeprecated = false;
            }
            if (props.containsKey("p")) {
                this.mIsPutInDirs = true;
            }
            if (props.containsKey("f") && null != (str = props.getProperty("f", null))) {
                this.mFilteredSchemaList = Arrays.asList(str.split("\\s*,\\s*"));
            }
            if (props.containsKey("v")) {
                this.mVersion = props.getProperty("v", null);
            }
            if (element instanceof CIMClass) {
                this.convertClass((CIMClass)element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertClass(CIMClass clazz) throws IOException {
        String schemaName = clazz.getName().substring(0, clazz.getName().indexOf("_"));
        if (this.mIsRemoveDeprecated && clazz.hasQualifier("Deprecated")) {
            System.out.println("\tSkipping Deprecated class " + clazz.getName());
        } else if (null != this.mFilteredSchemaList && this.mFilteredSchemaList.contains(schemaName)) {
            System.out.println("\tSkipping Filtered class " + clazz.getName());
        } else {
            ArrayList enums = new ArrayList();
            if (clazz.hasQualifierValue(INDICATION, (Object)true)) {
                CIMStructure cs = this.convertIndicationToStructure(clazz);
                this.writeFile((CIMElement)cs);
            } else if (clazz.isAssociation()) {
                javax.cim3.CIMClass newClass = new javax.cim3.CIMClass(this.convertObjectPath(clazz.getObjectPath()), clazz.getSuperClassName(), this.convertQualifiers(clazz.getQualifiers(), "self", false, clazz.hasQualifier(COMPOSITION), false), this.convertProperties(clazz.getProperties(), enums), this.convertMethods(clazz.getMethods(), enums), null, enums.toArray(new CIMEnumeration[enums.size()]), true, true);
                this.writeFile((CIMElement)newClass);
            } else {
                javax.cim3.CIMClass newClass = new javax.cim3.CIMClass(this.convertObjectPath(clazz.getObjectPath()), clazz.getSuperClassName(), this.convertQualifiers(clazz.getQualifiers(), "self", false, clazz.hasQualifier(COMPOSITION), false), this.convertProperties(clazz.getProperties(), enums), this.convertMethods(clazz.getMethods(), enums), null, enums.toArray(new CIMEnumeration[enums.size()]), false, true);
                this.writeFile((CIMElement)newClass);
            }
        }
    }

    void writeIncludeFile(ArrayList<String> list) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.mOutdir + File.separator + "cim_schema.mof"));
            for (String l : list) {
                writer.write("#pragma include(\"" + l + "\")\n");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    void writeFile(CIMElement e) throws IOException {
        String fileName = e.getName() + ".mof";
        String outDir = this.mOutdir;
        String pathDir = "";
        if (this.mIsPutInDirs) {
            String PackagePath = null;
            if (e instanceof javax.cim3.CIMClass) {
                PackagePath = (String)((javax.cim3.CIMClass)e).getQualifierValue(PACKAGE_PATH);
            } else if (e instanceof CIMStructure) {
                PackagePath = (String)((CIMStructure)e).getQualifierValue(PACKAGE_PATH);
            }
            if (null != PackagePath) {
                int start = PackagePath.indexOf("::");
                if (-1 != start) {
                    String subString = PackagePath.substring(start + 2);
                    int stop = subString.indexOf("::");
                    pathDir = -1 != stop ? subString.substring(0, stop) : subString;
                }
                pathDir = pathDir + File.separator;
            }
        }
        String outName = this.mOutdir + File.separator + pathDir + fileName;
        this.mIncludeList.add(pathDir + fileName);
        new File(outDir).mkdirs();
        BufferedWriter writer = new BufferedWriter(new FileWriter(outName));
        writer.write(e.toString());
        writer.flush();
        writer.close();
    }

    CIMQualifier<?>[] convertQualifiers(javax.cim.CIMQualifier<?>[] qualifiers, String elementName, boolean isProp, boolean isComposite, boolean isKey) {
        String[] removeList = new String[]{"association", "indication", "aggregation", "alias", "composition", "nullvalue", "propagated", "schema", "translatable", "syntax", "syntaxtype", "triggertype", "unknownvalues", "unsupportedvalues", "weak", "exception", "structure", "embeddedinstance", Q_REFERENCE, "valuemap", "values"};
        List<String> rList = Arrays.asList(removeList);
        String[] oclList = new String[]{"classconstraint", "methodconstraint", "propertyconstraint", "maxlen", "maxvalue", "minlen", "minvalue"};
        List<String> oList = Arrays.asList(oclList);
        boolean hasUnits = false;
        CIMQualifier unitsQualifier = null;
        boolean hasPUnit = false;
        ArrayList<String> oclValueList = new ArrayList<String>();
        ArrayList<CIMQualifier> l = new ArrayList<CIMQualifier>();
        for (javax.cim.CIMQualifier<?> q : qualifiers) {
            if (null == q.getName()) continue;
            String lcName = q.getName().toLowerCase();
            if ("punit".equalsIgnoreCase(q.getName())) {
                hasPUnit = true;
            }
            if (rList.contains(lcName)) continue;
            if (lcName.equalsIgnoreCase("Override")) {
                l.add(new CIMQualifier(q.getName(), javax.cim3.CIMDataType.BOOLEAN_T, (Object)true));
                continue;
            }
            if (lcName.equalsIgnoreCase("Aggregate")) {
                l.add(new CIMQualifier("AggregationKind", new javax.cim3.CIMDataType(18, "CIM_AggregationKindEnum", false), (Object)(isComposite ? COMPOSITION : "Shared")));
                continue;
            }
            if (oList.contains(lcName)) {
                String[] value;
                if (lcName.equalsIgnoreCase("MaxValue")) {
                    oclValueList.add(elementName + " <= " + q.getValue().toString());
                    continue;
                }
                if (lcName.equalsIgnoreCase("MinValue")) {
                    oclValueList.add(elementName + " >= " + q.getValue().toString());
                    continue;
                }
                if (lcName.equalsIgnoreCase("MaxLen")) {
                    oclValueList.add(elementName + ".size <= " + q.getValue().toString());
                    continue;
                }
                if (lcName.equalsIgnoreCase("MinLen")) {
                    oclValueList.add(elementName + ".size >= " + q.getValue().toString());
                    continue;
                }
                for (String s : value = (String[])q.getValue()) {
                    oclValueList.add(s);
                }
                continue;
            }
            if ("umlpackagepath".equalsIgnoreCase(lcName)) {
                l.add(new CIMQualifier(PACKAGE_PATH, this.convertDataType(q.getDataType(), q.getValue(), false), q.getValue()));
                continue;
            }
            if (lcName.equalsIgnoreCase("static")) {
                if (isProp) continue;
                l.add(new CIMQualifier(q.getName(), this.convertDataType(q.getDataType(), q.getValue(), false), q.getValue()));
                continue;
            }
            if ("version".equalsIgnoreCase(lcName) && null != this.mVersion) {
                l.add(new CIMQualifier(q.getName(), this.convertDataType(q.getDataType(), this.mVersion, false), (Object)this.mVersion));
                continue;
            }
            if ("units".equalsIgnoreCase(lcName)) {
                hasUnits = true;
                Hashtable<String, String> t = new Hashtable<String, String>();
                t.put("Amps", "ampere");
                t.put("Amp", "ampere");
                t.put("Amps at 120 Volts", "ampere / 120 * volt");
                t.put("Bits", "bit");
                t.put("Bits per Second", "bit / second");
                t.put("Bytes", "byte");
                t.put("Bytes per Second", "byte / second");
                t.put("BTU per Hour", "BTU / hour");
                t.put("Days", "Day");
                t.put("Feet", "foot");
                t.put("GigaBits", "gigabit");
                t.put("Hertz", "hertz");
                t.put("Hours", "hour");
                t.put("Hundredths of a Second", "second * 10^-2");
                t.put("Hundredths of Seconds", " second * 10^-2");
                t.put("Hundredths of Second", " second * 10^-2");
                t.put("Hundredths of Percent", " percent * 10^-2");
                t.put("Inches", "inch");
                t.put("KiloBytes", "1024 * byte");
                t.put("KiloBits Per Second", "bit * 10^3 / second");
                t.put("KiloBits per Second", "bit * 10^3 / second");
                t.put("KiloBytes per Second", " byte * 1024 / second");
                t.put("MegaHertz", "hertz * 10^6");
                t.put("MegaBytes", "byte * 10^6");
                t.put("MicroSeconds", "second * 10^-6");
                t.put("MilliSeconds", "second * 10^-3");
                t.put("MilliVolts", "volt * 10^-3");
                t.put("MilliWatts", "watt * 10^-3");
                t.put("MilliWattHours", "watt * 10^-3 / hour");
                t.put("Minutes", "minute");
                t.put("NanoSeconds", "nanosecond");
                t.put("Percent", "Percent");
                t.put("Percentage", "Percent");
                t.put("Pounds", "pound");
                t.put("Seconds", "second");
                t.put("seconds", "second");
                t.put("Tenths of Decibels", "decibel * 10^-1");
                t.put("Tenths of Seconds", "second * 10^-1");
                t.put("Thousandths", "10^-3");
                t.put("250 nanoseconds", "250 * nanosecond");
                String unitsValue = (String)q.getValue();
                if (t.containsKey(unitsValue)) {
                    unitsValue = (String)t.get(unitsValue);
                } else {
                    System.out.println("\tWARNING: Do not know how to change units value: " + unitsValue + "\n\tLeaving value as original in new PUnit qualifier value");
                }
                unitsQualifier = new CIMQualifier("PUnit", javax.cim3.CIMDataType.STRING_T, (Object)unitsValue);
                continue;
            }
            if ("key".equalsIgnoreCase(lcName)) {
                if (!isKey) continue;
                l.add(new CIMQualifier(q.getName(), this.convertDataType(q.getDataType(), q.getValue(), false), q.getValue()));
                continue;
            }
            l.add(new CIMQualifier(q.getName(), this.convertDataType(q.getDataType(), q.getValue(), false), q.getValue()));
        }
        if (!oclValueList.isEmpty()) {
            l.add(new CIMQualifier("OCL", javax.cim3.CIMDataType.STRING_ARRAY_T, (Object)oclValueList.toArray(new String[oclValueList.size()])));
        }
        if (!hasPUnit && hasUnits) {
            l.add(unitsQualifier);
        }
        return l.toArray(new CIMQualifier[l.size()]);
    }

    javax.cim3.CIMProperty<?>[] convertProperties(CIMProperty<?>[] props) {
        ArrayList<javax.cim3.CIMProperty> l = new ArrayList<javax.cim3.CIMProperty>();
        for (CIMProperty<?> p : props) {
            l.add(new javax.cim3.CIMProperty(p.getName(), this.convertDataType(p.getDataType(), p.getValue(), false), p.getValue(), p.isKey()));
        }
        return l.toArray(new javax.cim3.CIMProperty[l.size()]);
    }

    javax.cim3.CIMClassProperty<?>[] convertProperties(CIMClassProperty<?>[] props, ArrayList<CIMEnumeration<?>> enums) {
        ArrayList<javax.cim3.CIMClassProperty> l = new ArrayList<javax.cim3.CIMClassProperty>();
        for (CIMClassProperty<?> p : props) {
            if (this.mIsRemoveDeprecated && p.hasQualifier("Deprecated")) {
                System.out.println("\tSkipping Deprecated property " + p.getName());
                continue;
            }
            javax.cim3.CIMDataType dt = this.convertDataType(p.getDataType(), p.getValue(), false);
            Object value = p.getValue();
            if (p.hasQualifier(Q_EMBEDDED_INSTANCE)) {
                dt = new javax.cim3.CIMDataType(15, (String)p.getQualifierValue(Q_EMBEDDED_INSTANCE), dt.isArray());
            }
            if (p.hasQualifier(Q_REFERENCE)) {
                dt = dt.isArray() ? new javax.cim3.CIMDataType(14, (String)p.getQualifierValue(Q_REFERENCE), true) : new javax.cim3.CIMDataType(14, (String)p.getQualifierValue(Q_REFERENCE), false);
            }
            if (p.hasQualifier(Q_OCTET_STRING)) {
                dt = dt.isArray() ? javax.cim3.CIMDataType.OCTETSTRING_ARRAY_T : javax.cim3.CIMDataType.OCTETSTRING_T;
                if (null != value) {
                    // empty if block
                }
            }
            boolean isKey = p.getName().equalsIgnoreCase(INSTANCE_ID);
            CIMQualifier<?>[] qualifiers = this.convertQualifiers(p.getQualifiers(), p.getName(), true, false, isKey);
            if (p.hasQualifier(VALUE_MAP) || p.hasQualifier(VALUES)) {
                String classname = p.getName() + "Enum";
                CIMEnumeration<?> ce = this.createEnumeration(classname, p.getDataType(), (String[])p.getQualifierValue(VALUES), (String[])p.getQualifierValue(VALUE_MAP), qualifiers);
                enums.add(ce);
                dt = new javax.cim3.CIMDataType(18, classname, dt.isArray());
                if (null != value) {
                    value = ce.getEntryName(value);
                }
            }
            l.add(new javax.cim3.CIMClassProperty(p.getName(), dt, value, qualifiers, isKey, p.isPropagated()));
        }
        return l.toArray(new javax.cim3.CIMClassProperty[l.size()]);
    }

    CIMMethod<?>[] convertMethods(javax.cim.CIMMethod<?>[] methods, ArrayList<CIMEnumeration<?>> enums) {
        ArrayList<CIMMethod> l = new ArrayList<CIMMethod>();
        for (javax.cim.CIMMethod<?> m : methods) {
            if (this.mIsRemoveDeprecated && m.hasQualifier("Deprecated")) {
                System.out.println("\tSkipping Deprecated method " + m.getName());
                continue;
            }
            javax.cim3.CIMDataType dt = this.convertDataType(m.getDataType(), null, false);
            if (m.hasQualifier(Q_EMBEDDED_INSTANCE)) {
                dt = dt.isArray() ? new javax.cim3.CIMDataType(15, (String)m.getQualifierValue(Q_EMBEDDED_INSTANCE), true) : new javax.cim3.CIMDataType(15, (String)m.getQualifierValue(Q_EMBEDDED_INSTANCE), false);
            }
            if (m.hasQualifier(Q_REFERENCE)) {
                dt = dt.isArray() ? new javax.cim3.CIMDataType(14, (String)m.getQualifierValue(Q_REFERENCE), true) : new javax.cim3.CIMDataType(14, (String)m.getQualifierValue(Q_REFERENCE), false);
            }
            if (m.hasQualifier(Q_OCTET_STRING)) {
                dt = dt.isArray() ? javax.cim3.CIMDataType.OCTETSTRING_ARRAY_T : javax.cim3.CIMDataType.OCTETSTRING_T;
            }
            CIMQualifier<?>[] qualifiers = this.convertQualifiers(m.getQualifiers(), m.getName(), false, false, false);
            if (m.hasQualifier(VALUE_MAP) || m.hasQualifier(VALUES)) {
                String classname = m.getName() + "Enum";
                CIMEnumeration<?> ce = this.createEnumeration(classname, m.getDataType(), (String[])m.getQualifierValue(VALUES), (String[])m.getQualifierValue(VALUE_MAP), qualifiers);
                enums.add(ce);
                dt = new javax.cim3.CIMDataType(18, classname, dt.isArray());
            }
            javax.cim3.CIMParameter<?>[] param = this.convertParameters(m.getParameters(), enums);
            l.add(new CIMMethod(m.getName(), dt, qualifiers, param, m.isPropagated()));
        }
        return l.toArray(new CIMMethod[l.size()]);
    }

    javax.cim3.CIMParameter<?>[] convertParameters(CIMParameter<?>[] params, ArrayList<CIMEnumeration<?>> enums) {
        ArrayList<javax.cim3.CIMParameter> l = new ArrayList<javax.cim3.CIMParameter>();
        for (CIMParameter<?> p : params) {
            javax.cim3.CIMDataType dt = this.convertDataType(p.getDataType(), null, false);
            if (p.hasQualifier(Q_EMBEDDED_INSTANCE)) {
                dt = dt.isArray() ? new javax.cim3.CIMDataType(20, (String)p.getQualifierValue(Q_EMBEDDED_INSTANCE), true) : new javax.cim3.CIMDataType(20, (String)p.getQualifierValue(Q_EMBEDDED_INSTANCE), false);
            }
            if (p.hasQualifier(Q_REFERENCE)) {
                dt = dt.isArray() ? new javax.cim3.CIMDataType(14, (String)p.getQualifierValue(Q_REFERENCE), true) : new javax.cim3.CIMDataType(14, (String)p.getQualifierValue(Q_REFERENCE), false);
            }
            if (p.hasQualifier(Q_OCTET_STRING)) {
                dt = dt.isArray() ? javax.cim3.CIMDataType.OCTETSTRING_ARRAY_T : javax.cim3.CIMDataType.OCTETSTRING_T;
            }
            CIMQualifier<?>[] qualifiers = this.convertQualifiers(p.getQualifiers(), p.getName(), false, false, false);
            if (p.hasQualifier(VALUE_MAP) || p.hasQualifier(VALUES)) {
                String classname = p.getName() + "Enum";
                CIMEnumeration<?> ce = this.createEnumeration(classname, p.getDataType(), (String[])p.getQualifierValue(VALUES), (String[])p.getQualifierValue(VALUE_MAP), qualifiers);
                enums.add(ce);
                dt = new javax.cim3.CIMDataType(18, classname, dt.isArray());
            }
            l.add(new javax.cim3.CIMParameter(p.getName(), dt, qualifiers));
        }
        return l.toArray(new javax.cim3.CIMParameter[l.size()]);
    }

    CIMObjectPath convertObjectPath(javax.cim.CIMObjectPath path) {
        return new CIMObjectPath(path.getScheme(), path.getHost(), path.getPort(), path.getNamespace(), path.getObjectName(), this.convertProperties(path.getKeys()));
    }

    javax.cim3.CIMDataType convertDataType(CIMDataType t, Object value, boolean forceScalar) {
        javax.cim3.CIMDataType newType = null;
        switch (t.getType()) {
            case 9: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.BOOLEAN_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.BOOLEAN_T;
                break;
            }
            case 13: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.STRING_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.STRING_T;
                break;
            }
            case 17: {
                CIMClass cc = (CIMClass)value;
                if (t.isArray() && !forceScalar) {
                    newType = new javax.cim3.CIMDataType(16, cc.getName(), true);
                    break;
                }
                newType = new javax.cim3.CIMDataType(16, cc.getName(), false);
                break;
            }
            case 12: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.DATETIME_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.DATETIME_T;
                break;
            }
            case -1: {
                break;
            }
            case 15: {
                CIMInstance cc = (CIMInstance)value;
                if (t.isArray() && !forceScalar) {
                    newType = new javax.cim3.CIMDataType(16, cc.getClassName(), true);
                    break;
                }
                newType = new javax.cim3.CIMDataType(16, cc.getClassName(), false);
                break;
            }
            case 10: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.REAL32_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.REAL32_T;
                break;
            }
            case 11: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.REAL64_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.REAL64_T;
                break;
            }
            case 14: {
                newType = new javax.cim3.CIMDataType(t.getType(), t.getRefClassName(), t.isArray());
                break;
            }
            case 3: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.SINT16_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.SINT16_T;
                break;
            }
            case 5: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.SINT32_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.SINT32_T;
                break;
            }
            case 7: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.SINT64_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.SINT64_T;
                break;
            }
            case 1: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.SINT8_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.SINT8_T;
                break;
            }
            case 8: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.STRING_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.STRING_T;
                break;
            }
            case 2: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.UINT16_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.UINT16_T;
                break;
            }
            case 4: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.UINT32_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.UINT32_T;
                break;
            }
            case 6: {
                if (t.isArray() && !forceScalar) {
                    newType = javax.cim3.CIMDataType.UINT64_ARRAY_T;
                    break;
                }
                newType = javax.cim3.CIMDataType.UINT64_T;
                break;
            }
            case 0: {
                newType = t.isArray() && !forceScalar ? javax.cim3.CIMDataType.UINT8_ARRAY_T : javax.cim3.CIMDataType.UINT8_T;
            }
        }
        return newType;
    }

    private CIMStructure convertIndicationToStructure(CIMClass clazz) {
        ArrayList structs = new ArrayList();
        ArrayList enums = new ArrayList();
        CIMQualifier<?>[] quals = this.convertQualifiers(clazz.getQualifiers(), "self", false, clazz.hasQualifier(COMPOSITION), false);
        javax.cim3.CIMClassProperty<?>[] props = this.convertProperties(clazz.getProperties(), enums);
        return new CIMStructure(this.convertObjectPath(clazz.getObjectPath()), clazz.getSuperClassName(), quals, props, structs.toArray(new CIMStructure[structs.size()]), enums.toArray(new CIMEnumeration[enums.size()]));
    }

    CIMEnumeration<?> createEnumeration(String name, CIMDataType type, String[] values, String[] valueMap, CIMQualifier<?>[] qualifiers) {
        if (null != values && values.length != valueMap.length) {
            System.out.println("ERROR: Not createing Enumeration due to value/valueMap length not matching");
            return null;
        }
        ArrayList<CIMEnumerationEntry> entries = new ArrayList<CIMEnumerationEntry>();
        for (int i = 0; i < valueMap.length; ++i) {
            if (valueMap[i].contains("..")) continue;
            javax.cim3.CIMDataType dt = this.convertDataType(type, valueMap[i], true);
            Object value = CIMUtilities.convertStringToProperType((javax.cim3.CIMDataType)dt, (String)valueMap[i]);
            if (null != values) {
                if (null == values[i]) continue;
                entries.add(new CIMEnumerationEntry(this.createIdentifier(values[i]), dt, value, null));
                continue;
            }
            if (null == valueMap[i]) continue;
            entries.add(new CIMEnumerationEntry(this.createIdentifier(valueMap[i]), dt, null, null));
        }
        CIMQualifier[] newQuals = new CIMQualifier[1];
        for (CIMQualifier<?> q : qualifiers) {
            if (!"description".equalsIgnoreCase(q.getName())) continue;
            newQuals[0] = q;
        }
        return new CIMEnumeration(new CIMObjectPath(name), this.convertDataType(type, null, true), null, entries.toArray(new CIMEnumerationEntry[entries.size()]), newQuals);
    }

    String createIdentifier(String str) {
        return str.replaceAll("[ \\/():;=~`!@#$%^&*]", "_");
    }
}

