/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi;

import com.ws.cim.CIMMappingBase;
import com.ws.cim.xmi.XMIGenerator;
import javax.cim.CIMClass;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;

public class XMIMapping
extends CIMMappingBase {
    public static final String FORMAT_XML = "xml";
    public static final String ERROR_INVALID_FORMAT = "Invalid Format";
    private String mFormat;
    private String mOutdir;
    private XMIGenerator mXMIGenerator;
    private boolean mQuiet = false;

    @Override
    public void initialize(String outdir) throws Exception {
        this.mFormat = FORMAT_XML;
        this.mOutdir = outdir;
        this.mXMIGenerator = new XMIGenerator(this.mOutdir);
    }

    @Override
    public void close() throws Exception {
        this.mXMIGenerator.writeXMIFile();
        String[] remove = new String[]{"Version_Number", "store", "Logfile.", "Snapshot.", ".xml"};
        this.removeTempFiles(this.mQuiet, this.mOutdir, remove);
    }

    @Override
    public void produceMappedElement(CIMElement pElement) throws Exception {
        if (pElement instanceof CIMClass && this.mFormat.equalsIgnoreCase(FORMAT_XML)) {
            this.mXMIGenerator.generateXMI((CIMClass)pElement);
        }
    }

    @Override
    public void produceMappedInstance(CIMInstance instance) throws Exception {
    }

    @Override
    public void setFormat(String format) {
        if (!format.equalsIgnoreCase(FORMAT_XML)) {
            throw new IllegalArgumentException(ERROR_INVALID_FORMAT);
        }
        this.mFormat = FORMAT_XML;
    }

    @Override
    public void setProperty(String name, String value) {
        if ("q".equals(name)) {
            this.mQuiet = true;
        }
    }

    @Override
    public String[] getCustomPropertyNames(String format) {
        return new String[]{"q"};
    }

    @Override
    public String getCustomPropertyDescription(String cpName) {
        if ("q".equals(cpName)) {
            return "This option will supress all output (not including exceptions)";
        }
        return null;
    }
}

