/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.base;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import sanproject.client.applet.RJTitleApplet;
import sanproject.client.base.RJBasePanel;
import sanproject.client.base.RJbConst;
import sanproject.client.base.RJbEventAdapter;
import sanproject.client.base.RJbFuncIDList;
import sanproject.client.base.RJbGuideConst;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcFuncPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcIDManager;
import sanproject.client.com.RJcPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataStartParam;

public abstract class RJbBasePanel
extends RJcPanel
implements RJbGuideConst {
    private Color menuFgClr = this.getGuideColor("MenuFgClr");
    private Color menuBgClr = this.getGuideColor("MenuBgClr");
    protected Color basePanelBgClr = this.getGuideColor("BasePanelBgClr");
    protected RJcIDManager idManager = RJcIDManager.createManager(RJbFuncIDList.getFuncIDList());
    protected JPanel decorationPanel;
    protected JDialog venderDlg;
    protected JDialog versionDlg;
    protected String startTab;
    String[] banner_Name;
    RJTitleApplet m_App;
    protected BaseMenu menuAction;
    protected JMenu menuFunction;
    private static int basePanel_Width = 640;
    private static int basePanel_Height = 500;
    private static int statusBar_Height = 0;
    private static int ppStsBar_Width = 270;
    protected JLabel ppSimLabel;
    MakePanelRunnable makeRun = null;

    public RJbBasePanel() {
        super(new BorderLayout());
        this.idManager.setParent(this);
    }

    public void add(Component component, Object object) {
    }

    protected void initInstance() {
        this.setPreferredSize(new Dimension(basePanel_Width, basePanel_Height));
        super.add((Component)this.createNorthPanel(), "North");
        super.add((Component)this.getOperationPanel(), "Center");
        super.add((Component)this.createBottomPanel(), "South");
        this.idManager.setItemListener(new RJbEventAdapter(){

            public void eventAction(AWTEvent aWTEvent) {
                ItemEvent itemEvent = (ItemEvent)aWTEvent;
                RJbBasePanel.this.makePanelRun(itemEvent);
            }
        });
    }

    private void makePanelRun(ItemEvent itemEvent) {
        if (!this.chkWin()) {
            if (RJTitleApplet.startFlag) {
                if (this.makeRun == null) {
                    this.makeRun = new MakePanelRunnable();
                }
                this.makeRun.setEvent(itemEvent);
                SwingUtilities.invokeLater(this.makeRun);
            } else {
                this.makePanel(itemEvent);
            }
        } else {
            this.makePanel(itemEvent);
        }
    }

    private boolean chkWin() {
        String string = System.getProperty("os.name");
        boolean bl = false;
        if (string != null) {
            bl = string.toUpperCase().indexOf("WINDOWS") != -1;
        }
        return bl;
    }

    protected void startUp() {
        if (!this.startTab.equals("")) {
            this.idManager.initSelectedID(this.startTab);
        }
    }

    protected JPanel createNorthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.decorationPanel = this.createDecorationPanel();
        jPanel.setBackground(this.basePanelBgClr);
        jPanel.add((Component)this.decorationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createMenuPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    protected JPanel createDecorationPanel() {
        DecorationPanel decorationPanel = new DecorationPanel(new BorderLayout());
        return decorationPanel;
    }

    protected JPanel createMenuPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 161));
        jPanel.setBackground(this.basePanelBgClr);
        jPanel.setBorder(border);
        jPanel.add((Component)this.createMenuBar(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createMenuBar_L(), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBackground(this.menuBgClr);
        jMenuBar.setOpaque(true);
        jMenuBar.setBorderPainted(false);
        this.menuAction = new BaseMenu("Base/MenuAction");
        BaseMenuItem baseMenuItem = new BaseMenuItem("Base/MenuRefresh");
        baseMenuItem.setModel(this.getRefreshButton().getModel());
        baseMenuItem.setIcon(this.getMenuIcon(RJBasePanel.REFRESH_IMG));
        this.menuAction.add(baseMenuItem);
        this.menuAction.addSeparator();
        BaseMenuItem baseMenuItem2 = new BaseMenuItem("Base/MenuExit");
        RJDataStartParam rJDataStartParam = RJDataControl.getDataControl().getStartParamClass();
        if (rJDataStartParam.getCombinationMode() == 1) {
            baseMenuItem2 = new BaseMenuItem("Base/MenuExit_HI");
        }
        baseMenuItem2.setModel(this.getExitButton().getModel());
        baseMenuItem2.setIcon(this.getMenuIcon(RJBasePanel.EXIT_IMG));
        this.menuAction.add(baseMenuItem2);
        jMenuBar.add(this.menuAction);
        RJcIDManager rJcIDManager = RJcIDManager.getManager();
        this.menuFunction = (JMenu)rJcIDManager.getMenuItem();
        this.menuFunction.setText(this.getGuideText("Base/MenuFunction"));
        jMenuBar.add(this.menuFunction);
        return jMenuBar;
    }

    protected JPanel createMenuBar_L() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(this.basePanelBgClr);
        jPanel.add((Component)this.getStatusLamp(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 1), 0, 0));
        jPanel.add((Component)this.getLockIcon(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 1), 0, 0));
        jPanel.add((Component)this.getModifyButton(), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 1), 0, 0));
        jPanel.add((Component)this.getAuditoButton(), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        jPanel.add((Component)this.createUsrNamePanel(), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        jPanel.add((Component)this.getExitButton(), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 1), 0, 0));
        return jPanel;
    }

    protected JPanel createUsrNamePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 161));
        jPanel.setBackground(this.basePanelBgClr);
        jPanel.setBorder(border);
        jPanel.add((Component)this.getUserLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 1), 0, 0));
        jPanel.add((Component)this.getUser(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 8), 0, 0));
        return jPanel;
    }

    protected JPanel createBottomPanel() {
        RJcPanel rJcPanel = new RJcPanel(new GridBagLayout());
        rJcPanel.setBackground(this.basePanelBgClr);
        rJcPanel.setPreferredSize(new Dimension(rJcPanel.getWidth(), statusBar_Height));
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        RJDataStartParam rJDataStartParam = rJDataControl.getStartParamClass();
        boolean bl = rJDataControl.getRMIObject().isAdministrator();
        boolean bl2 = rJDataStartParam.getTABOption(18, 1);
        boolean bl3 = rJDataStartParam.getVenderID() == 99;
        int n = 0;
        int n2 = 0;
        JLabel jLabel = new JLabel();
        rJcPanel.add((Component)jLabel, new GridBagConstraints(n2, n, 1, 1, 0.1, 0.1, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        ++n2;
        if (bl && bl2 || bl3) {
            this.ppSimLabel = this.createStatusComp(0);
            rJcPanel.add((Component)this.ppSimLabel, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 13, 3, new Insets(2, 0, 0, 0), 0, 0));
            ++n2;
        }
        return rJcPanel;
    }

    protected JLabel createStatusComp(int n) {
        JLabel jLabel = new JLabel("", n);
        jLabel.setBackground(this.basePanelBgClr);
        jLabel.setOpaque(false);
        jLabel.setFont(RJComFont.BOLD_FONT);
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 161));
        jLabel.setBorder(border);
        jLabel.setPreferredSize(new Dimension(ppStsBar_Width, jLabel.getHeight()));
        return jLabel;
    }

    protected Icon getMenuIcon(String string) {
        return this.getMenuIcon(string, true);
    }

    protected Icon getMenuIcon(String string, boolean bl) {
        ImageIcon imageIcon = (ImageIcon)RJCom.createImgIcon(RJDataControl.getDataControl(), string);
        MenuIcon menuIcon = null;
        menuIcon = new MenuIcon(imageIcon.getImage(), bl);
        return menuIcon;
    }

    protected abstract void makePanel(ItemEvent var1);

    protected abstract JLabel getStatusLamp();

    protected abstract JLabel getUserLabel();

    protected abstract JLabel getUser();

    protected abstract JButton getBasicInfoButton();

    protected abstract JButton getRefreshButton();

    protected abstract JToggleButton getModifyButton();

    protected abstract JButton getExitButton();

    protected abstract JPanel getOperationPanel();

    protected abstract JLabel getLockIcon();

    protected abstract JButton getAuditoButton();

    protected abstract int getOEMTypeDetail();

    protected abstract int getVenderID();

    protected RJcFuncPanel newInstance(String string) {
        RJcFuncPanel rJcFuncPanel = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            rJcFuncPanel = (RJcFuncPanel)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.putLog("[BasePanel]", "[reflect]", "[" + string + "] " + classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.putLog("[BasePanel]", "[reflect]", "[" + string + "] " + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.putLog("[BasePanel]", "[reflect]", "[" + string + "] " + invocationTargetException);
            throw (RuntimeException)new RuntimeException().initCause(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.putLog("[BasePanel]", "[reflect]", "[" + string + "] " + illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.putLog("[BasePanel]", "[reflect]", "[" + string + "] " + illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            this.putLog("[BasePanel]", "[reflect]", "[" + string + "] " + instantiationException);
        }
        return rJcFuncPanel;
    }

    public void putLog(String string, String string2, String string3) {
        RJCom.putLog(string, string2, string3, 0);
    }

    protected String getGuideText(String string) {
        String string2 = RJcGuide.text(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    protected Color getGuideColor(String string) {
        Color color = RJcGuide.color(string);
        return color;
    }

    protected Icon getGuideIcon(String string) {
        String string2 = this.getGuideText(string + "Icon");
        ImageIcon imageIcon = (ImageIcon)RJCom.createImgIcon(string2);
        ImageIcon imageIcon2 = new ImageIcon(imageIcon.getImage());
        return imageIcon2;
    }

    public boolean goURL(String string) {
        boolean bl = true;
        try {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    protected class MenuIcon
    extends ImageIcon {
        private static final int w = 18;
        private static final int h = 18;
        private boolean enable = true;

        public MenuIcon(Image image) {
            this(image, true);
        }

        public MenuIcon(Image image, boolean bl) {
            super(image);
            this.enable = bl;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            float f = 1.0f;
            if (!this.enable) {
                f = 0.4f;
            }
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(alphaComposite);
            graphics2D.drawImage(this.getImage(), n, n2, 18, 18, component);
            alphaComposite = AlphaComposite.getInstance(3, 1.0f);
            graphics2D.setComposite(alphaComposite);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    class DecorationPanel
    extends JPanel {
        Image bg = null;
        Image pd = null;
        Image cp = null;
        int I01 = 0;
        int I02 = 0;

        public DecorationPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.setPreferredSize(new Dimension(200, 36));
            int n = RJbBasePanel.this.getOEMTypeDetail();
            String[] stringArray = RJbConst.Image_HIJ;
            if (n == 2) {
                stringArray = RJbConst.Image_HIE;
            } else if (n == 3) {
                stringArray = RJbConst.Image_HPJ;
            } else if (n == 4) {
                stringArray = RJbConst.Image_HPE;
            }
            this.bg = this.getPicture(RJbBasePanel.this.banner_Name[1], stringArray[1]);
            this.I01 = this.bg.getWidth(this);
            this.I02 = this.bg.getHeight(this);
            this.pd = this.getPicture(RJbBasePanel.this.banner_Name[0], stringArray[0]);
            this.cp = this.getPicture(RJbBasePanel.this.banner_Name[2], stringArray[2]);
        }

        public void paintComponent(Graphics graphics) {
            if (this.I01 <= 0 || this.I02 <= 0) {
                return;
            }
            Image image = this.bg.getScaledInstance(RJbBasePanel.this.decorationPanel.getWidth(), RJbBasePanel.this.decorationPanel.getHeight(), 4);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 1);
            mediaTracker.addImage(this.pd, 1);
            mediaTracker.addImage(this.cp, 1);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            graphics.drawImage(image, 0, 0, this);
            graphics.drawImage(this.pd, 0, 0, this);
            graphics.drawImage(this.cp, RJbBasePanel.this.decorationPanel.getWidth() - this.cp.getWidth(this), 0, this);
        }

        private Image getPicture(String string, String string2) {
            Image image = null;
            try {
                URL uRL;
                if (string != null && string.length() > 0) {
                    System.out.println("[Base] [getImage] [" + string + "]");
                    uRL = new URL(string);
                    image = new ImageIcon(uRL).getImage();
                }
                if (image == null || this.checkPicSize(image)) {
                    System.out.println("[Base] [getImage(Failure)] ");
                    uRL = this.getClass().getResource("image/" + string2);
                    image = new ImageIcon(uRL).getImage();
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            return image;
        }

        private boolean checkPicSize(Image image) {
            return image.getWidth(this) <= 0 || image.getHeight(this) <= 0;
        }
    }

    class BaseToggleButton
    extends JToggleButton {
        private String tipText;
        private String tipSelText;
        private boolean mouseIn = false;

        BaseToggleButton(String string) {
            this.setFont(RJcConst.normalFont);
            this.setActionCommand(string);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(24, 24));
            this.setIcon(RJbBasePanel.this.getGuideIcon(string));
            this.setSelectedIcon(RJbBasePanel.this.getGuideIcon(string + "Sel"));
            this.tipText = RJbBasePanel.this.getGuideText(string);
            this.tipSelText = RJbBasePanel.this.getGuideText(string + "Sel");
            this.setToolTipText(this.tipText);
            this.setBackground(RJbBasePanel.this.getGuideColor("BasePanelBgClr"));
            if (this.tipSelText != null) {
                this.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        int n = itemEvent.getStateChange();
                        String string = n == 1 ? BaseToggleButton.this.tipSelText : BaseToggleButton.this.tipText;
                        BaseToggleButton.this.setToolTipText(string);
                    }
                });
            }
        }
    }

    class BaseButton
    extends JButton {
        private boolean mouseIn = false;

        BaseButton(String string) {
            this.setFont(RJcConst.normalFont);
            this.setActionCommand(string);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(24, 24));
            this.setIcon(RJbBasePanel.this.getGuideIcon(string));
            this.setToolTipText(RJbBasePanel.this.getGuideText(string));
            this.setBackground(RJbBasePanel.this.getGuideColor("BasePanelBgClr"));
        }
    }

    class BaseCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private String normalText;
        private String selectText;

        BaseCheckBoxMenuItem(String string) {
            this.setFont(RJcConst.normalFont);
            this.setActionCommand(string);
            this.normalText = RJbBasePanel.this.getGuideText(string);
            this.selectText = RJbBasePanel.this.getGuideText(string + "Sel");
            this.setText(this.normalText);
            this.setForeground(RJbBasePanel.this.getGuideColor(string));
            this.setBackground(RJbBasePanel.this.menuBgClr);
            if (this.selectText != null) {
                this.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        int n = itemEvent.getStateChange();
                        String string = n == 1 ? BaseCheckBoxMenuItem.this.selectText : BaseCheckBoxMenuItem.this.normalText;
                        BaseCheckBoxMenuItem.this.setText(string);
                    }
                });
            }
        }
    }

    class BaseMenuItem
    extends JMenuItem {
        BaseMenuItem(String string) {
            this.setFont(RJcConst.normalFont);
            this.setActionCommand(string);
            this.setText(RJbBasePanel.this.getGuideText(string));
            this.setForeground(RJbBasePanel.this.getGuideColor(string));
            this.setBackground(RJbBasePanel.this.menuBgClr);
        }

        BaseMenuItem(String string, Icon icon) {
            this(string);
            this.setIcon(icon);
        }
    }

    class BaseMenu
    extends JMenu {
        BaseMenu(String string) {
            this.setFont(RJcConst.normalFont);
            this.setActionCommand(string);
            this.setText(RJbBasePanel.this.getGuideText(string));
            this.setForeground(RJbBasePanel.this.getGuideColor(string));
            this.setBackground(RJbBasePanel.this.menuBgClr);
        }

        public void addSeparator() {
            JSeparator jSeparator = new JSeparator();
            super.add(jSeparator);
        }
    }

    private class MakePanelRunnable
    implements Runnable {
        ItemEvent e = null;

        private MakePanelRunnable() {
        }

        public void run() {
            RJbBasePanel.this.makePanelRun(this.e);
        }

        public void setEvent(ItemEvent itemEvent) {
            this.e = itemEvent;
        }
    }
}

