/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.swing.JPanel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcException;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataControlDoing;
import sanproject.client.data.RJDataMsg;
import sanproject.serverux.data.GetDataInput;
import sanproject.serverux.data.GetDataInputParam;

public abstract class RJcAbsDataSupplier
implements RJcConst {
    protected RJDataControl controller;
    protected RJDataControlDoing controlDoing;
    private Stack parentPanel = new Stack();
    private int messageShow = 0;
    protected String osName = System.getProperty("os.name");
    protected boolean stayController = false;
    private boolean editMode = false;

    public RJcAbsDataSupplier() {
        this(null);
    }

    public RJcAbsDataSupplier(RJDataControl rJDataControl) {
        this.controller = rJDataControl;
        if (rJDataControl != null) {
            this.controlDoing = rJDataControl.getControlDoing();
        }
    }

    public RJDataControl getDataControl() {
        return this.controller;
    }

    public RJDataChange getChangeTbl() {
        return this.controller.getChangeTbl();
    }

    public String getOSName() {
        return this.osName;
    }

    public boolean isWindows() {
        boolean bl = false;
        if (this.osName.startsWith("Windows")) {
            bl = true;
        }
        return bl;
    }

    public boolean isDragAndDropOKforWindows() {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().isDragAndDropOKforWindows();
        }
        return bl;
    }

    public int getVenderID() {
        int n = 0;
        if (this.controller != null) {
            n = this.controller.getStartParamClass().getVenderID();
        }
        return n;
    }

    public boolean isTabOption(int n, int n2) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().getTABOption(n, n2);
        }
        return bl;
    }

    public boolean isPermission(int n, int n2) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().getPermissionTABOption(n, n2);
        }
        return bl;
    }

    public boolean isPP(String string) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getPPKeyData().CheckPP(string);
        }
        return bl;
    }

    public boolean isStayController() {
        return this.stayController;
    }

    public void setStayController(boolean bl) {
        this.stayController = bl;
    }

    public void showMessage() {
        ++this.messageShow;
    }

    public void hideMessage() {
        --this.messageShow;
    }

    public boolean isMessageShow() {
        boolean bl = false;
        if (this.messageShow > 0) {
            bl = true;
        }
        return bl;
    }

    public void waitCursor(Component component) {
        RJCom.waitCursor(component);
    }

    public void disableWindow() {
    }

    public void defaultCursor(Component component) {
        RJCom.defCursor(component);
    }

    public Window searchWindow(Component component) {
        Window window = null;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Window)) continue;
            window = (Window)component2;
            break;
        }
        return window;
    }

    public RJDataMsg getMessage(int n) {
        return RJCom.getMsg(this.controller, n / 100000, n % 100000);
    }

    public int showMessage(Component component, RJDataMsg rJDataMsg, int n, Object[] objectArray, Object object) {
        ++this.messageShow;
        this.putLog("[Com]", "[showMessage]", rJDataMsg.getMessage());
        int n2 = RJComDialog.show(component, rJDataMsg, n, objectArray, object);
        --this.messageShow;
        return n2;
    }

    public boolean showMessage(Component component, RJDataMsg rJDataMsg) {
        boolean bl = false;
        Window window = this.searchWindow(component);
        ++this.messageShow;
        bl = window instanceof Frame ? RJComUty.SetMsg((Frame)window, rJDataMsg) : RJComUty.SetMsg((Dialog)window, rJDataMsg);
        --this.messageShow;
        return bl;
    }

    public JPanel getParentPanel() {
        JPanel jPanel = null;
        try {
            jPanel = (JPanel)this.parentPanel.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return jPanel;
    }

    public void pushParentPanel(RJComFuncPanel rJComFuncPanel) {
        this.parentPanel.push(rJComFuncPanel);
    }

    public void popParentPanel() {
        try {
            this.parentPanel.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public boolean getEditMode() {
        boolean bl = this.editMode;
        if (this.controller != null) {
            bl = RJCom.getEditMode(this.controller);
        }
        return bl;
    }

    public boolean cancel() {
        this.waitControl();
        this.controller.Cancel();
        return true;
    }

    public void putLog(String string, String string2, String string3) {
        if (this.controller != null) {
            RJCom.putLog(this.controller, string, string2, string3, 0);
        }
        System.out.println(string + " " + string2 + " " + string3);
    }

    public String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n).toUpperCase();
        return string.substring(string.length() - n2);
    }

    public void setEditMode(boolean bl) {
        this.editMode = bl;
    }

    public Object getOneDataInf(GetDataInputParam getDataInputParam) throws RJcException {
        ArrayList<GetDataInputParam> arrayList = new ArrayList<GetDataInputParam>();
        arrayList.add(getDataInputParam);
        ArrayList arrayList2 = this.getDataInf(arrayList);
        Object e = arrayList2.get(0);
        return e;
    }

    public ArrayList getDataInf(ArrayList arrayList) throws RJcException {
        GetDataInput getDataInput = new GetDataInput();
        getDataInput.iFuncListCnt = arrayList.size();
        getDataInput.inputPrm = arrayList.toArray(new GetDataInputParam[0]);
        this.waitControl();
        this.controller.getDataInf(getDataInput);
        this.confirm("getDataInf");
        ArrayList arrayList2 = this.controller.getDataInfData();
        return arrayList2;
    }

    public void setObject(Object object) {
        this.controller.setObject(object);
    }

    protected void confirm() throws RJcException {
        this.confirm("unknown");
    }

    protected void confirm(String string) throws RJcException {
        this.confirm(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void confirm(String string, String string2) throws RJcException {
        this.disableWindow();
        JPanel jPanel = this.getParentPanel();
        try {
            this.stayController = true;
            this.controller.waitDC(jPanel);
        }
        finally {
            this.stayController = false;
        }
        ArrayList arrayList = this.getEndStatusList(string);
        if (this.isError(arrayList, string, string2)) {
            this.errorReset();
            RJDataMsg rJDataMsg = this.getMessage(arrayList);
            RJcException rJcException = new RJcException(rJDataMsg.getMessage());
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            ++this.messageShow;
            RJComDialog.show(this.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            --this.messageShow;
            int n = this.getErrorLevel(rJDataMsg);
            RJComFuncPanel rJComFuncPanel = (RJComFuncPanel)this.getParentPanel();
            rJComFuncPanel.endRequest(n);
            throw rJcException;
        }
    }

    protected ArrayList getEndStatusList(String string) {
        ArrayList arrayList = this.getEndStatus(string);
        return arrayList;
    }

    protected ArrayList getEndStatus(String string) {
        return this.controller.getEndStatus();
    }

    protected boolean isError(ArrayList arrayList, String string, String string2) {
        boolean bl = false;
        int n = (Integer)arrayList.get(0);
        int n2 = (Integer)arrayList.get(1);
        this.putLog("[Com]", "[confirm]", string + ", " + string2 + " (" + n + ", " + n2 + ")");
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    protected int getErrorLevel(RJDataMsg rJDataMsg) {
        int n = rJDataMsg.getErrorLevel();
        return n;
    }

    protected void waitControl() {
        while (this.controlDoing.getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public RJDataMsg getMessage(ArrayList arrayList) {
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, (Integer)arrayList.get(0), (Integer)arrayList.get(1));
        return rJDataMsg;
    }

    protected void errorReset() {
    }

    public void terminate() {
    }

    public static void setNextFocus(Container container, Container container2) {
        container.setFocusTraversalPolicy(container2.getFocusTraversalPolicy());
    }
}

