/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import sanproject.client.com.RJCom;

class RJcEventLockControl {
    private HashMap targetTopWindows = new HashMap(4, 1.0f);
    private Stack lockStack = new Stack();

    public void addTopWindow(Window window) {
        this.targetTopWindows.put(window.getName(), window);
    }

    public void lockWindow(Window window) {
        LockSet lockSet = new LockSet(window, this.targetTopWindows);
        this.lockStack.push(lockSet);
    }

    public void unlockWindow(Window window) {
        LockSet lockSet;
        if (!this.lockStack.isEmpty() && (lockSet = (LockSet)this.lockStack.peek()).getName().equals(window.getName())) {
            this.lockStack.pop();
        }
    }

    public boolean isLock(String string) {
        LockSet lockSet;
        boolean bl = false;
        if (!this.lockStack.isEmpty() && (lockSet = (LockSet)this.lockStack.peek()).contains(string)) {
            bl = true;
        }
        return bl;
    }

    class LockSet
    extends HashSet {
        private String name;

        LockSet(Window window, HashMap hashMap) {
            super(4, 1.0f);
            this.name = window.getName();
            Window window2 = this.getTopWindow(window);
            this.setLockWindow(window2);
            if (hashMap != null) {
                HashMap hashMap2 = (HashMap)hashMap.clone();
                hashMap2.remove(window2.getName());
                Collection collection = hashMap2.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Window window3 = (Window)iterator.next();
                    this.setLockWindow(window3);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        private Window getTopWindow(Window window) {
            Window window2 = window;
            if (window != null) {
                while (window.getOwner() != null) {
                    window2 = window;
                    window = window.getOwner();
                }
            }
            return window2;
        }

        private void setLockWindow(Window window) {
            if (window.isShowing()) {
                this.add(window.getName());
                RJCom.putLog("[Com]", "[EventQueue]", "Lock Window = " + window.getName(), 0);
            }
            Window[] windowArray = window.getOwnedWindows();
            for (int i = 0; i < windowArray.length; ++i) {
                this.setLockWindow(windowArray[i]);
            }
        }
    }
}

