/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.restoreview.ComponentParser;
import sanproject.client.com.restoreview.DefaultTableComponentParser;
import sanproject.client.com.restoreview.TableComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.com.restoreview.ViewRestorer;
import sanproject.client.com.restoreview.utility.TableComponentUtilities;

public class DefaultTableViewRestorer
implements ViewRestorer {
    static final int COLUMN_WIDTH_RESTORE = 4096;
    public static final int ALL_COLUMN_WIDTH_RESTORE = 12288;
    private int miRestoreMode;
    private JTable mclsSaveTable;
    private TableComponentParser mclsComponentParser;

    public DefaultTableViewRestorer() {
        this.initInstance();
    }

    public DefaultTableViewRestorer(JTable jTable) throws UnsupportedComponentException {
        this();
        this.saveViewComponent(jTable);
    }

    private void initInstance() {
        int n = 0;
        n |= 1;
        try {
            this.setRestoreMode(n);
        }
        catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
            throw new RuntimeException();
        }
        this.mclsComponentParser = this.createDefaultComponentParser();
    }

    protected void finalize() throws Throwable {
        this.mclsSaveTable = null;
        this.mclsComponentParser = null;
        super.finalize();
    }

    public void saveViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JTable)) {
            String string = "Any components other than 'javax.swing.JTable' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        try {
            Object[] objectArray;
            int n;
            int n2;
            TableColumnModel tableColumnModel;
            JTable jTable = (JTable)component;
            this.mclsSaveTable = TableComponentUtilities.createCopyTable(jTable);
            TableComponentParser tableComponentParser = (TableComponentParser)this.getComponentParser();
            tableComponentParser.setAnalysisComponent(this.mclsSaveTable);
            int[] nArray = jTable.getSelectedRows();
            if (nArray != null) {
                tableColumnModel = jTable.getColumnModel();
                n2 = tableColumnModel.getColumnCount();
                for (n = 0; n < nArray.length; ++n) {
                    int n3;
                    int n4 = nArray[n];
                    objectArray = new Object[n2];
                    for (n3 = 0; n3 < n2; ++n3) {
                        TableColumn tableColumn = tableColumnModel.getColumn(n3);
                        int n5 = tableColumn.getModelIndex();
                        objectArray[n5] = jTable.getValueAt(n4, n3);
                    }
                    n3 = tableComponentParser.searchTableRow(objectArray);
                    if (n3 == -1) continue;
                    this.mclsSaveTable.addRowSelectionInterval(n3, n3);
                }
            }
            tableColumnModel = jTable.getColumnModel();
            n2 = tableColumnModel.getColumnCount();
            for (n = 0; n < n2; ++n) {
                TableColumn tableColumn = tableColumnModel.getColumn(n);
                objectArray = tableColumn.getIdentifier();
                TableColumn tableColumn2 = tableComponentParser.findColumn(objectArray);
                if (tableColumn2 == null) continue;
                int n6 = tableColumn.getPreferredWidth();
                tableColumn2.setPreferredWidth(n6);
            }
        }
        catch (Exception exception) {
            System.err.println("[Default Table]Save View Failure");
            exception.printStackTrace();
            this.releaseSavedViewComponent();
        }
    }

    public void restoreViewComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JTable)) {
            String string = "Any components other than 'javax.swing.JTable' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        try {
            if (this.hasSavedViewComponent()) {
                int n;
                int n2;
                Object object;
                int n3;
                Object object2;
                JTable jTable = (JTable)component;
                jTable.clearSelection();
                TableComponentParser tableComponentParser = (TableComponentParser)this.getComponentParser();
                tableComponentParser.setAnalysisComponent(jTable);
                int n4 = this.getRestoreMode();
                if ((n4 & 1) > 0 && (object2 = this.mclsSaveTable.getSelectedRows()) != null) {
                    for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
                        int n5 = this.mclsSaveTable.getColumnCount();
                        object = new Object[n5];
                        for (n2 = 0; n2 < n5; ++n2) {
                            object[n2] = this.mclsSaveTable.getValueAt((int)object2[n3], n2);
                        }
                        n = tableComponentParser.searchTableRow((Object[])object);
                        if (n == -1) continue;
                        jTable.addRowSelectionInterval(n, n);
                    }
                }
                if ((n4 & 0x1000) > 0) {
                    object2 = this.mclsSaveTable.getColumnModel();
                    n3 = object2.getColumnCount();
                    for (n = 0; n < n3; ++n) {
                        object = object2.getColumn(n);
                        Object object3 = ((TableColumn)object).getIdentifier();
                        int n6 = n2 = (n4 & 0x3000) > 0 ? 1 : 0;
                        if (n2 == 0) continue;
                        int n7 = ((TableColumn)object).getPreferredWidth();
                        TableColumn tableColumn = tableComponentParser.findColumn(object3);
                        tableColumn.setPreferredWidth(n7);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("[Default Table]Restore View Failure");
            exception.printStackTrace();
        }
    }

    public void setRestoreMode(int n) throws UnsupportedRestoreModeException {
        if (!this.isSupportedRestoreMode(n)) {
            String string = "The parameter which is not supported was specified [" + n + "].";
            throw new UnsupportedRestoreModeException(string);
        }
        this.miRestoreMode = n;
    }

    public int getRestoreMode() {
        return this.miRestoreMode;
    }

    public void setComponentParser(ComponentParser componentParser) throws IllegalArgumentException {
        if (componentParser == null || !(componentParser instanceof TableComponentParser)) {
            String string = "Any components other than 'restoreview.TableComponentParser' are not supported.";
            throw new IllegalArgumentException(string);
        }
        this.mclsComponentParser = (TableComponentParser)componentParser;
    }

    public ComponentParser getComponentParser() {
        return this.mclsComponentParser;
    }

    public boolean isSupportedRestoreMode(int n) {
        int n2 = n;
        n2 &= 0xFFFFFFFE;
        return (n2 &= 0xFFFFCFFF) == 0;
    }

    public boolean hasSavedViewComponent() {
        return this.mclsSaveTable != null;
    }

    public void releaseSavedViewComponent() {
        this.mclsSaveTable = null;
    }

    protected TableComponentParser createDefaultComponentParser() {
        return new DefaultTableComponentParser();
    }

    protected JTable getSavedViewComponent() {
        return this.mclsSaveTable;
    }
}

