/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur;

import sanproject.client.com.RJCom;
import sanproject.client.hur.RJHurDataControl;
import sanproject.client.hur.RJHurGuide;
import sanproject.client.hur.RJHurMacro;
import sanproject.client.hur.RJHurPresetChangeJNLGrpOptionData;
import sanproject.serverux.dataimpl.HURchange1MirrorOption;
import sanproject.serverux.dataimpl.RJiHURget1JNLG;
import sanproject.serverux.dataimpl.RJiHURgetJNLG1Mirror;

public class RJHurPresetChangeMirrorOptionData
extends RJHurPresetChangeJNLGrpOptionData
implements RJHurMacro {
    private RJHurDataControl hurDC;
    private RJHurGuide guid = null;
    private RJiHURgetJNLG1Mirror rmi1Mirror = null;
    public int transfer;
    public String strTransfer = "";
    public int lineSpeed = 0;
    public String strLineSpeed = "";
    public int failure = 0;
    public String strFailure = "";

    public RJHurPresetChangeMirrorOptionData(RJHurDataControl rJHurDataControl, RJiHURget1JNLG rJiHURget1JNLG, RJiHURgetJNLG1Mirror rJiHURgetJNLG1Mirror, RJHurGuide rJHurGuide) {
        this.hurDC = rJHurDataControl;
        this.guid = rJHurGuide;
        this.rmi1JNLGrp = rJiHURget1JNLG;
        this.rmi1Mirror = rJiHURgetJNLG1Mirror;
        this.presetDataInit(rJiHURgetJNLG1Mirror);
    }

    public Object convertRMI() {
        HURchange1MirrorOption hURchange1MirrorOption = new HURchange1MirrorOption();
        hURchange1MirrorOption.jnlgLdkc = this.rmi1JNLGrp.ldkc;
        hURchange1MirrorOption.jnlg = this.rmi1JNLGrp.jnlGrpNumber;
        hURchange1MirrorOption.mirrorID = this.rmi1Mirror.mirrorID;
        hURchange1MirrorOption.sn = this.rmi1Mirror.pairSerialNumber;
        hURchange1MirrorOption.modelID = this.rmi1Mirror.modelID;
        hURchange1MirrorOption.rcuLdkc = this.rmi1Mirror.ldkcNo;
        hURchange1MirrorOption.transferRate = this.transfer;
        hURchange1MirrorOption.pathBlockWatchTime = this.pathWatch | this.unitPathWatch;
        hURchange1MirrorOption.forward = this.forward;
        hURchange1MirrorOption.lineSpeed = this.lineSpeed;
        hURchange1MirrorOption.failure = this.failure;
        return hURchange1MirrorOption;
    }

    public Object getRMIData() {
        return this.rmi1Mirror;
    }

    public int getJnlgNumber() {
        return this.rmi1JNLGrp.jnlGrpNumber;
    }

    public int getLdkcOfJnlg() {
        return this.rmi1JNLGrp.ldkc;
    }

    public int getJnlgIsite() {
        return this.rmi1JNLGrp.iSite;
    }

    public int getJnlgMulti() {
        return this.rmi1JNLGrp.multi;
    }

    public int getJnlgAttribute() {
        return this.rmi1JNLGrp.attribute;
    }

    public int getMirrorAttribute() {
        return this.rmi1Mirror.attr;
    }

    public boolean isMirrorStatusActiveInJNLG() {
        boolean bl = false;
        for (int i = 0; i < this.rmi1JNLGrp.mirrors.size(); ++i) {
            RJiHURgetJNLG1Mirror rJiHURgetJNLG1Mirror = (RJiHURgetJNLG1Mirror)this.rmi1JNLGrp.mirrors.get(i);
            if (rJiHURgetJNLG1Mirror.status != 16) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isMirrorStatusActive() {
        boolean bl = false;
        if (this.rmi1Mirror.status == 16) {
            bl = true;
        }
        return bl;
    }

    public boolean isMirrorStatusDelta_M(boolean bl) {
        boolean bl2 = false;
        if (this.rmi1Mirror.attr == 1) {
            if (this.rmi1Mirror.delta == 1 || this.rmi1Mirror.delta == 3) {
                bl2 = true;
            }
            if (!bl2 && !bl && this.rmi1Mirror.delta == 2) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean isMirrorStatusDelta_R() {
        boolean bl = false;
        if (this.rmi1Mirror.attr == 2 && this.rmi1Mirror.delta == 1) {
            bl = true;
        }
        return bl;
    }

    public void setFailure(int n) {
        this.failure = n;
        this.convertFailureIntToString();
    }

    private void presetDataInit(RJiHURgetJNLG1Mirror rJiHURgetJNLG1Mirror) {
        this.transfer = rJiHURgetJNLG1Mirror.transferRate;
        this.convertTransferIntToString();
        this.lineSpeed = rJiHURgetJNLG1Mirror.lineSpeed;
        this.checkLineSpeed();
        this.failure = rJiHURgetJNLG1Mirror.failure;
        this.convertFailureIntToString();
        this.pathWatch = rJiHURgetJNLG1Mirror.pathBlockWatchTime & 0x3F;
        this.unitPathWatch = rJiHURgetJNLG1Mirror.pathBlockWatchTime & 0xC0;
        this.mirStatus = this.hurDC.checkDeltaMirror(this.rmi1Mirror.status, this.rmi1Mirror.delta);
        this.forward = 0;
        this.forwardInitialize(rJiHURgetJNLG1Mirror.attr, rJiHURgetJNLG1Mirror.forward);
    }

    private void convertTransferIntToString() {
        switch (this.transfer) {
            case 1500: {
                this.strTransfer = RJHurGuide.text("High");
                break;
            }
            case 500: {
                this.strTransfer = RJHurGuide.text("Medium");
                break;
            }
            case 150: {
                this.strTransfer = RJHurGuide.text("Low");
                break;
            }
            default: {
                this.strTransfer = RJHurGuide.text("Low");
                this.transfer = 150;
                System.out.println("[HUR] PresetChangeJNLGrpOptionData Illegal transfer!!");
            }
        }
    }

    private void checkLineSpeed() {
        boolean bl = false;
        for (int i = 1; i < RJHurMacro.LINESPEED_COMBO_VALUE.length; ++i) {
            if (this.lineSpeed != RJHurMacro.LINESPEED_COMBO_VALUE[i]) continue;
            bl = true;
            this.strLineSpeed = Integer.toString(this.lineSpeed);
            break;
        }
        if (!bl) {
            this.strLineSpeed = "*" + Integer.toString(this.lineSpeed);
            System.out.println("[HUR] PresetChangeMirrorOptionData, lineSpeed=" + this.lineSpeed);
        }
    }

    private void convertFailureIntToString() {
        switch (this.failure) {
            case 0: {
                this.strFailure = RJHurGuide.text("JNLOP_None");
                break;
            }
            case 1: {
                this.strFailure = RJHurGuide.text("JNLOP_Entire");
                break;
            }
            default: {
                this.strFailure = "*" + this.failure;
                System.out.println("[HUR] PresetChangeJNLGrpOptionData, failure=" + this.failure);
                RJCom.putLog(this.hurDC.getCommonDC(), this.hurDC.getPPString(), "ChangeJNLOption", "failure=" + this.failure, 0);
            }
        }
    }

    public void convertTransferStringToInt(String string) {
        if (string.equals(RJHurGuide.text("High"))) {
            this.transfer = 1500;
        } else if (string.equals(RJHurGuide.text("Medium"))) {
            this.transfer = 500;
        } else if (string.equals(RJHurGuide.text("Low"))) {
            this.transfer = 150;
        }
        this.convertTransferIntToString();
    }
}

