/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ldevguard.dctl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import sanproject.client.com.RJCom;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.ldevguard.dctl.RJDGDDataControl;
import sanproject.client.ldevguard.dctl.RJDGDException;
import sanproject.client.ldevguard.gui.RJDGDApplyEndListener;
import sanproject.client.ldevguard.gui.logging.Logger;

public class RJDGDApplyThread
extends Thread {
    public static final int STS_INITIALIZED = 16;
    public static final int STS_EXECUTE = 32;
    public static final int STS_END = 48;
    protected int ERP_NORMAL = 0;
    protected int ERP_CLIENT = 9210;
    protected int ERP_HIC = 9205;
    protected int ERC_NORMAL = 0;
    private static final int MSG_APPLYNMLEND = 0;
    private static final int MSG_UNKNOWN_ERR = 7060;
    private static final int MSG_NO_ENDDATA = 7060;
    private static final int MSG_SRVREQ_NG = 7060;
    private static final int MSG_ENDDATA_UNMATCH = 7060;
    private static final int MSG_NO_ENDLISTENER = 7060;
    private final String logName = "ApplyThread";
    private int _status;
    private RJDataControl _dctl;
    private RJDGDDataControl _dgdDctl;
    private ArrayList _applyData = new ArrayList();
    private ArrayList _applyEndListener = new ArrayList();

    public RJDGDApplyThread(RJDGDDataControl rJDGDDataControl) throws RJDGDException {
        this._dgdDctl = rJDGDDataControl;
        this.ERP_CLIENT = 9210;
        this.ERP_HIC = 9205;
        List list = this._dgdDctl.getApplyData();
        this._applyData.addAll(list);
        List list2 = this._dgdDctl.getApplyEndListener();
        if (list2.isEmpty()) {
            throw new RJDGDException(this.ERP_CLIENT, 7060, "No ApplyEndListener.");
        }
        this._applyEndListener.addAll(list2);
        this._status = 16;
    }

    public void setDataControl(RJDataControl rJDataControl) {
        this._dctl = rJDataControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = true;
        RJDGDException rJDGDException = new RJDGDException(this.ERP_CLIENT, 0);
        try {
            Object object;
            Logger.put(Level.INFO, "ApplyThread", "Apply Start");
            this._status = 32;
            this.waitCtl();
            Iterator iterator = this._applyData.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                this._dctl.setObject(object);
            }
            this.apply2Control();
            this.waitCtl();
            object = this._dctl.getApply2Data();
            if (object == null) {
                Logger.put(Level.INFO, "ApplyThread", "Fatal Error! getApply2Data() == null");
                throw new RJDGDException(this.ERP_CLIENT, 7060, "No ApplyEnd Data.");
            }
            if (!(object instanceof Object[])) {
                object = new Object[]{object};
            }
            try {
                this._dgdDctl.createErrInfo((Object[])object);
            }
            catch (ClassCastException classCastException) {
                String string = classCastException.getMessage();
                Logger.put(Level.INFO, "ApplyThread", string);
                throw new RJDGDException(this.ERP_CLIENT, 7060, "ApplyEnd Data Unmatch.(" + string + ")");
            }
        }
        catch (RJDGDException rJDGDException2) {
            rJDGDException = rJDGDException2;
            bl = false;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            Logger.put(Level.INFO, "ApplyThread", "Exception: " + string);
            exception.printStackTrace();
            rJDGDException = new RJDGDException(this.ERP_CLIENT, 7060);
            bl = false;
        }
        finally {
            int n = rJDGDException.getPosition();
            int n2 = rJDGDException.getCode();
            RJDataMsg rJDataMsg = RJCom.getMsg(this._dctl, n, n2);
            Logger.put(Level.INFO, "ApplyThread", "applyEnd Status=" + bl + "(" + n + ":" + n2 + ")");
            this._status = 48;
            Iterator iterator = this._applyEndListener.iterator();
            while (iterator.hasNext()) {
                ((RJDGDApplyEndListener)iterator.next()).applyEnd(bl, rJDataMsg);
            }
        }
    }

    public int getStatus() {
        return this._status;
    }

    private void apply2Control() throws RJDGDException {
        this.waitCtl();
        if (this._dctl.Apply2Start()) {
            while (!this._dctl.EndData) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        } else {
            Logger.put(Level.INFO, "ApplyThread", "Apply2Start() failure.");
            throw new RJDGDException(this.ERP_CLIENT, 7060, "Apply2Start() failure.");
        }
        this.waitCtl();
        ArrayList arrayList = this._dctl.getEndStatus();
        int n = (Integer)arrayList.get(0);
        int n2 = (Integer)arrayList.get(1);
        if (n != this.ERP_NORMAL) {
            throw new RJDGDException(n, n2);
        }
    }

    public void waitCtl() {
        while (this._dctl.getControlDoing().getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }
}

