/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import sanproject.client.com.RJcComboAdapter;
import sanproject.client.com.RJcComboBoxModel;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcLabelPanel;
import sanproject.client.com.RJcPanel;
import sanproject.client.pool.RJPoolApplyItem;
import sanproject.client.pool.RJPoolComboBox;
import sanproject.client.pool.RJPoolGuideDef;
import sanproject.client.pool.RJPoolNumberField;

public class RJPoolInfoDialogPanel
extends RJcPanel
implements RJPoolGuideDef {
    private RJPoolNumberField poolIdField = new RJPoolNumberField(3);
    private RJPoolComboBox thresholdCombo = new RJPoolComboBox();
    private RJcComboBoxModel thresholdModel = new RJcComboBoxModel();
    private RJPoolComboBox attributeCombo = new RJPoolComboBox();
    private JButton setButton = null;
    private RJPoolApplyItem item = null;
    private int poolId;
    private String[] attributeList = new String[]{RJcGuide.text("Pool/InfoDialogAttrQs"), RJcGuide.text("Pool/InfoDialogAttrAOU")};

    public RJPoolInfoDialogPanel() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        RJcLabelPanel rJcLabelPanel = new RJcLabelPanel("Pool/InfoDlgPoolIdLbl");
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(this.createPoolIdField());
        rJcCushionPanel.setBackground(RJcGuide.color("Pool/InfoDlgPoolIdPanelBgClr"));
        Dimension dimension = rJcCushionPanel.getPreferredSize();
        rJcCushionPanel.setPreferredSize(new Dimension(220, dimension.height));
        RJcLabelPanel rJcLabelPanel2 = new RJcLabelPanel("Pool/InfoDlgThresholdLbl");
        RJcCushionPanel rJcCushionPanel2 = new RJcCushionPanel(this.createThresholdCombo());
        rJcCushionPanel2.setBackground(RJcGuide.color("Pool/InfoDlgThresholdPanelBgClr"));
        RJcLabelPanel rJcLabelPanel3 = new RJcLabelPanel("Pool/InfoDlgAttrLbl");
        RJcCushionPanel rJcCushionPanel3 = new RJcCushionPanel(this.createAttributeCombo());
        rJcCushionPanel3.setBackground(RJcGuide.color("Pool/InfoDlgAttrPanelBgClr"));
        this.add((Component)rJcLabelPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.add((Component)rJcCushionPanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        this.add((Component)rJcLabelPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.add((Component)rJcCushionPanel2, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        this.add((Component)rJcLabelPanel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.add((Component)rJcCushionPanel3, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
    }

    public void showPanel(RJPoolApplyItem rJPoolApplyItem, int n) {
        this.item = rJPoolApplyItem;
        this.poolId = rJPoolApplyItem.getPoolId();
        if (this.poolId >= 0) {
            this.poolIdField.setValue(this.poolId);
        } else {
            this.poolIdField.setEnabled(true);
            this.poolIdField.setEditable(true);
            this.attributeCombo.setEnabled(false);
            rJPoolApplyItem.setKind(n);
            if (n == 1) {
                rJPoolApplyItem.setGrainSize(1);
                rJPoolApplyItem.setThreshold(80);
            } else {
                rJPoolApplyItem.setGrainSize(168);
                rJPoolApplyItem.setThreshold(70);
            }
        }
        this.initThresholdList(rJPoolApplyItem, n);
    }

    private void initThresholdList(RJPoolApplyItem rJPoolApplyItem, int n) {
        int n2 = rJPoolApplyItem.getUsedPercent();
        int n3 = 5;
        n2 = (n2 + n3) / n3 * n3;
        int n4 = Math.max(n == 1 ? 20 : 5, n2);
        int n5 = rJPoolApplyItem.getThreshold();
        int n6 = Math.max(n4, n5);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = n4; i <= 95; i += n3) {
            arrayList.add(new Integer(i));
        }
        this.thresholdModel.setItems(arrayList);
        this.thresholdCombo.setSelectedItem(null);
        this.thresholdCombo.setEnabled(true);
        this.thresholdCombo.setSelectedItem(new Integer(n6));
    }

    private void poolIdField_caretUpdate(CaretEvent caretEvent) {
        if (this.poolIdField.isEnabled()) {
            this.item.setPoolId(-1);
            Integer n = this.poolIdField.getValue();
            if (n != null) {
                this.item.setPoolId(n);
            }
        }
    }

    private void thresholdComboSelected(ItemEvent itemEvent) {
        if (this.thresholdCombo.isEnabled()) {
            Integer n = (Integer)this.thresholdCombo.getSelectedItem();
            if (this.item.getThreshold() != n.intValue()) {
                this.item.setThreshold(n);
            }
        }
    }

    public void setSetButton(JButton jButton) {
        this.setButton = jButton;
    }

    private JPanel createPoolIdField() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.poolIdField.setEnabled(false);
        this.poolIdField.setEditable(false);
        this.poolIdField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                RJPoolInfoDialogPanel.this.poolIdField_caretUpdate(caretEvent);
            }
        });
        CommentLabel commentLabel = new CommentLabel("Pool/InfoDlgPoolIdCommentLbl");
        jPanel.add((Component)this.poolIdField, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)commentLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createThresholdCombo() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.thresholdCombo.setModel((ComboBoxModel)this.thresholdModel);
        this.thresholdCombo.setEnabled(false);
        this.thresholdCombo.addItemListener(new RJcComboAdapter(){

            public void itemStateSelected(ItemEvent itemEvent) {
                RJPoolInfoDialogPanel.this.thresholdComboSelected(itemEvent);
            }
        });
        jPanel.add((Component)this.thresholdCombo, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new CommentLabel("Pool/InfoDlgThresholdCommentLbl"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createAttributeCombo() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        RJcComboBoxModel rJcComboBoxModel = new RJcComboBoxModel(this.attributeList);
        this.attributeCombo.setModel((ComboBoxModel)rJcComboBoxModel);
        this.attributeCombo.setSelectedItem(this.attributeList[0]);
        this.attributeCombo.setEnabled(false);
        jPanel.add((Component)this.attributeCombo, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new CommentLabel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        return jPanel;
    }

    public void selectAttribute(int n) {
        this.attributeCombo.setSelectedItem(this.attributeList[n - 1]);
    }

    class CommentLabel
    extends JLabel {
        CommentLabel() {
            this("");
        }

        CommentLabel(String string) {
            this.setText(RJcGuide.text(string));
            this.setForeground(RJcGuide.color(string));
            this.setPreferredSize(new Dimension(48, 24));
        }
    }
}

