/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.smi.cache.RMIObjectCache;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public final class ModelInfo {
    private static final Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private String productID;
    private final String modelName;
    private final String iSCSIUnique;
    private final int maxISCSIPort;
    private final int maxFB4;
    private final short maxThinPool;
    private int modelID;
    private String productName;
    private boolean isUnified;

    ModelInfo(RMIObjectCache rmoObj) throws WBEMException {
        try {
            Properties props = new Properties();
            Class<?> clz = this.getClass();
            ClassLoader clzLdr = clz.getClassLoader();
            String resource = clz.getPackage().getName().replaceAll("\\.", "/") + "/" + clz.getSimpleName() + ".properties";
            InputStream strm = clzLdr.getResourceAsStream(resource);
            if (null == strm) {
                throw new WBEMException("could not find " + clz.getSimpleName() + ".properties");
            }
            props.load(strm);
            SanResponse resp = rmoObj.keyValueAPI_InvokeKeyValueAPI("SANreadStorageInfo", true);
            try {
                this.productID = resp.getString("ProductId");
                this.productName = resp.getString("ProductName");
                this.isUnified = resp.getBoolean("IsUnified");
                logger.log(Level.INFO, "{0}:{1}\tProductID: {2}{1}\tProductName: {3}{1}\tisUnified: {4}", new Object[]{"SANreadStorageInfo", System.lineSeparator(), this.productID, this.productName, this.isUnified});
            }
            catch (SanDataException sde) {
                throw new WBEMException(1, "Unable to get \"ProductId\" from SANreadStorageInfo", null, (Throwable)sde);
            }
            if (null == this.productID) {
                throw new WBEMException("SANreadStorageInforeturned null");
            }
            String modelInfo = props.getProperty(this.productID);
            if (null == modelInfo) {
                String msg = String.format("Unknown product ID: %s", this.productID);
                logger.severe(msg);
                throw new WBEMException(msg);
            }
            logger.log(Level.FINE, "ModelInfo: {0}", modelInfo);
            String[] data = modelInfo.split(",");
            if (data.length != 6) {
                String msg = String.format("Invalid model info format: %s", modelInfo);
                logger.severe(msg);
                throw new WBEMException(msg);
            }
            this.modelName = data[0];
            this.modelID = Integer.parseInt(data[1]);
            this.iSCSIUnique = data[2];
            this.maxISCSIPort = Integer.parseInt(data[3]);
            this.maxFB4 = Integer.parseInt(data[4]);
            this.maxThinPool = Short.parseShort(data[5]);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Unable to get data from back end: " + t, null, t);
        }
    }

    public String getiSCSIUnique() {
        return this.iSCSIUnique;
    }

    public int getMaxFB4() {
        return this.maxFB4;
    }

    public int getMaxISCSIPort() {
        return this.maxISCSIPort;
    }

    public short getMaxThinPool() {
        return this.maxThinPool;
    }

    protected int getModelID() {
        return this.modelID;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getProductID() {
        return this.productID;
    }

    protected String getProductName() {
        return this.productName;
    }

    protected boolean isUnified() {
        return this.isUnified;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModelInfo [productID=");
        builder.append(this.productID);
        builder.append(", modelName=");
        builder.append(this.modelName);
        builder.append("]");
        return builder.toString();
    }
}

