/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.ResourceGroupInfoVersionChecker;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.ExternalChassisArrayGroup;
import com.hitachi.smi.common.PGInfo;
import com.hitachi.smi.common.ResourceGroupInfo;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.Wait4ProcessTasks;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import sanproject.common.Robj_interface_BASICVerAllPG;
import sanproject.common.Robj_interface_BASICVerLDEVInNormalPG;
import sanproject.common.Robj_interface_BASICVerLDEVInVirtualPG;
import sanproject.common.Robj_interface_BASICVerNormalPG;
import sanproject.common.Robj_interface_BASICVerVirtualPG;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_VerLeaf;

public class PGBranchChecker
extends AbstractVersionChecker
implements ResourceGroupInfoVersionChecker.RSGUpdateCallback {
    private static final int MAX_NORMAL_PGS = 2048;

    protected PGBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.BASIC, this);
        ResourceGroupInfoVersionChecker.registerForRSGUpdates(ResourceGroupInfo.SearchType.PG, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAGorPG2Map(AbstractMap<Integer, List<Integer>> map2Add2, int fb4, int pg, boolean computeAG) {
        List<Integer> list = map2Add2.get(fb4);
        if (null == list) {
            AbstractMap<Integer, List<Integer>> abstractMap = map2Add2;
            synchronized (abstractMap) {
                list = map2Add2.get(fb4);
                if (null == list) {
                    list = new ArrayList<Integer>();
                    map2Add2.put(fb4, list);
                }
            }
        }
        int ag = -1;
        if (computeAG) {
            ag = ChassisArrayGroup.makeArrayGroup(fb4, pg, 1);
        }
        if (!computeAG || ag >= 0) {
            List<Integer> list2 = list;
            synchronized (list2) {
                list.add(computeAG ? ag : pg);
            }
        }
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        this.CompareAllPGBranch((Robj_interface_BASICVerAllPG)currentChildren[1], (Robj_interface_BASICVerAllPG)prevChildren[1]);
    }

    private void CompareAllPGBranch(Robj_interface_BASICVerAllPG current, Robj_interface_BASICVerAllPG prior) {
        if (current.getNVer() != prior.getNVer() || current.getNSummaryVer() != prior.getNSummaryVer()) {
            CacheCompareThread worker;
            int x;
            mLogger.info("Detected change in ALL PG version");
            HashMap<Integer, List<Integer>> addedPGs = new HashMap<Integer, List<Integer>>();
            HashMap<Integer, List<Integer>> removedPGs = new HashMap<Integer, List<Integer>>();
            HashMap<Integer, List<Integer>> modifiedPGs = new HashMap<Integer, List<Integer>>();
            HashMap<Integer, List<Integer>> addedVDEVs = new HashMap<Integer, List<Integer>>();
            HashMap<Integer, List<Integer>> removedVDEVs = new HashMap<Integer, List<Integer>>();
            HashMap<Integer, List<Integer>> modifiedVDEVs = new HashMap<Integer, List<Integer>>();
            Robj_interface_VerLeaf[] currentPaths = current.getObjChildren();
            Robj_interface_VerLeaf[] priorPaths = prior.getObjChildren();
            int max_pgs = currentPaths.length;
            Wait4ProcessTasks task = new Wait4ProcessTasks(max_pgs);
            for (x = 0; x < 2048; x = (int)((short)(x + 1))) {
                worker = new CacheCompareThread(task, (Robj_interface_BASICVerNormalPG)currentPaths[x], (Robj_interface_BASICVerNormalPG)priorPaths[x], addedPGs, removedPGs, modifiedPGs, addedVDEVs, removedVDEVs, modifiedVDEVs);
                ProcessTask.addTask(worker);
            }
            for (x = 2048; x < max_pgs; ++x) {
                worker = new CacheCompareThread(task, (Robj_interface_BASICVerVirtualPG)currentPaths[x], (Robj_interface_BASICVerVirtualPG)priorPaths[x], addedPGs, removedPGs, modifiedPGs, addedVDEVs, removedVDEVs, modifiedVDEVs);
                ProcessTask.addTask(worker);
            }
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.fine("Waiting for compare threads to complete");
            }
            task.processingDone();
            if (mLogger.isLoggable(Level.INFO)) {
                mLogger.fine("Compare threads have completed");
            }
            if (modifiedPGs != null && !modifiedPGs.isEmpty()) {
                this.processModifiedPG(modifiedPGs);
            }
            if (removedPGs != null && !removedPGs.isEmpty()) {
                this.processRemovedPG(removedPGs);
            }
            if (addedPGs != null && !addedPGs.isEmpty()) {
                this.processAddedPG(addedPGs);
            }
            if (modifiedVDEVs != null && !modifiedVDEVs.isEmpty()) {
                this.processModifiedVDEV(modifiedVDEVs);
            }
            if (removedVDEVs != null && !removedVDEVs.isEmpty()) {
                this.processRemovedVDEV(removedVDEVs);
            }
            if (addedVDEVs != null && !addedVDEVs.isEmpty()) {
                this.processAddedVDEV(addedVDEVs);
            }
            mLogger.info("Done with ALL PG version");
        }
    }

    private void compareLDEVInNormalPG(Robj_interface_RJiPGIndex pgIndex, Robj_interface_BASICVerLDEVInNormalPG[] currentLDEVPG, Robj_interface_BASICVerLDEVInNormalPG[] priorLDEVPG, HashMap<Integer, List<Integer>> addedVDEVS, HashMap<Integer, List<Integer>> removedVDEVs, HashMap<Integer, List<Integer>> modifiedVDEVs) {
        mLogger.log(Level.FINE, "currentLDEVPG: {0}, priorLDEVPG: {1}", new Object[]{currentLDEVPG != null ? Integer.valueOf(currentLDEVPG.length) : "null", priorLDEVPG != null ? Integer.valueOf(priorLDEVPG.length) : "null"});
        if (currentLDEVPG != null || priorLDEVPG != null) {
            if (currentLDEVPG == null && priorLDEVPG != null) {
                this.addAGorPG2Map(removedVDEVs, pgIndex.getIFB4(), pgIndex.getIPG(), true);
            } else if (currentLDEVPG != null && priorLDEVPG == null) {
                this.addAGorPG2Map(addedVDEVS, pgIndex.getIFB4(), pgIndex.getIPG(), true);
            } else if (currentLDEVPG != null && priorLDEVPG != null) {
                for (int index = 0; index < currentLDEVPG.length; ++index) {
                    mLogger.severe("currentLDEVPG[" + index + "] == " + (null == currentLDEVPG[index] ? "null" : Integer.valueOf(currentLDEVPG[index].getNVer())) + ", priorLDEVPG[" + index + "] == " + (null == priorLDEVPG[index] ? "null" : Integer.valueOf(priorLDEVPG[index].getNVer())));
                    if (currentLDEVPG[index] == null && priorLDEVPG[index] == null) continue;
                    if (currentLDEVPG[index] == null && priorLDEVPG[index] != null) {
                        this.addAGorPG2Map(removedVDEVs, pgIndex.getIFB4(), pgIndex.getIPG(), true);
                        continue;
                    }
                    if (currentLDEVPG[index] != null && priorLDEVPG[index] == null) {
                        this.addAGorPG2Map(addedVDEVS, pgIndex.getIFB4(), pgIndex.getIPG(), true);
                        continue;
                    }
                    if (currentLDEVPG[index].getNVer() == priorLDEVPG[index].getNVer()) continue;
                    this.addAGorPG2Map(modifiedVDEVs, pgIndex.getIFB4(), pgIndex.getIPG(), true);
                }
            }
        }
    }

    private void compareLDEVInVirtualPG(Robj_interface_RJiPGIndex pgIndex, Robj_interface_BASICVerLDEVInVirtualPG[] currentLDEVPG, Robj_interface_BASICVerLDEVInVirtualPG[] priorLDEVPG, HashMap<Integer, List<Integer>> addedVDEVs, HashMap<Integer, List<Integer>> removedVDEVs, HashMap<Integer, List<Integer>> modifiedVDEVs) {
        if (currentLDEVPG == null && priorLDEVPG == null) {
            return;
        }
        if (currentLDEVPG == null && priorLDEVPG != null) {
            this.addAGorPG2Map(removedVDEVs, pgIndex.getIFB4(), pgIndex.getIPG(), true);
        } else if (currentLDEVPG != null && priorLDEVPG == null) {
            this.addAGorPG2Map(addedVDEVs, pgIndex.getIFB4(), pgIndex.getIPG(), true);
        } else if (currentLDEVPG != null && priorLDEVPG != null) {
            for (int index = 0; index < currentLDEVPG.length; ++index) {
                if (currentLDEVPG[index] == null && priorLDEVPG[index] == null) continue;
                if (currentLDEVPG[index] == null && priorLDEVPG[index] != null) {
                    this.addAGorPG2Map(removedVDEVs, pgIndex.getIFB4(), pgIndex.getIPG(), true);
                    continue;
                }
                if (currentLDEVPG[index] != null && priorLDEVPG[index] == null) {
                    this.addAGorPG2Map(addedVDEVs, pgIndex.getIFB4(), pgIndex.getIPG(), true);
                    continue;
                }
                if (currentLDEVPG[index].getNVer() == priorLDEVPG[index].getNVer()) continue;
                this.addAGorPG2Map(modifiedVDEVs, pgIndex.getIFB4(), pgIndex.getIPG(), true);
            }
        }
    }

    private void CompareNormalPG(Robj_interface_BASICVerNormalPG currentPGVer, Robj_interface_BASICVerNormalPG priorPGVer, HashMap<Integer, List<Integer>> addedPGs, HashMap<Integer, List<Integer>> removedPGs, HashMap<Integer, List<Integer>> modifiedPGs, HashMap<Integer, List<Integer>> addedVDEVS, HashMap<Integer, List<Integer>> removedVDEVs, HashMap<Integer, List<Integer>> modifiedVDEVs) {
        Robj_interface_RJiPGIndex pgIndex = null;
        Robj_interface_BASICVerLDEVInNormalPG[] currentLDEVPG = null;
        Robj_interface_BASICVerLDEVInNormalPG[] priorLDEVPG = null;
        if (currentPGVer == null && priorPGVer == null) {
            return;
        }
        if (currentPGVer == null && priorPGVer != null) {
            pgIndex = priorPGVer.getIndex();
            mLogger.log(Level.INFO, "Detected removal in Normal PG {0}-{1} version", new Object[]{pgIndex.getIFB4(), pgIndex.getIPG()});
            priorLDEVPG = (Robj_interface_BASICVerLDEVInNormalPG[])priorPGVer.getObjChildren();
            this.addAGorPG2Map(removedPGs, pgIndex.getIFB4(), pgIndex.getIPG(), false);
        } else if (currentPGVer != null && priorPGVer == null) {
            pgIndex = currentPGVer.getIndex();
            mLogger.log(Level.INFO, "Detected addition in Normal PG {0}-{1} version", new Object[]{pgIndex.getIFB4(), pgIndex.getIPG()});
            currentLDEVPG = (Robj_interface_BASICVerLDEVInNormalPG[])currentPGVer.getObjChildren();
            this.addAGorPG2Map(addedPGs, pgIndex.getIFB4(), pgIndex.getIPG(), false);
        } else if (currentPGVer.getNVer() != priorPGVer.getNVer() || currentPGVer.getNSummaryVer() != priorPGVer.getNSummaryVer()) {
            pgIndex = currentPGVer.getIndex();
            mLogger.log(Level.INFO, "Detected modify in Normal PG {0}-{1} version", new Object[]{pgIndex.getIFB4(), pgIndex.getIPG()});
            currentLDEVPG = (Robj_interface_BASICVerLDEVInNormalPG[])currentPGVer.getObjChildren();
            priorLDEVPG = (Robj_interface_BASICVerLDEVInNormalPG[])priorPGVer.getObjChildren();
            this.addAGorPG2Map(modifiedPGs, pgIndex.getIFB4(), pgIndex.getIPG(), false);
        }
        this.compareLDEVInNormalPG(pgIndex, currentLDEVPG, priorLDEVPG, addedVDEVS, removedVDEVs, modifiedVDEVs);
    }

    private void CompareVirtualPG(Robj_interface_BASICVerVirtualPG currentPaths, Robj_interface_BASICVerVirtualPG priorPaths, HashMap<Integer, List<Integer>> added, HashMap<Integer, List<Integer>> removed, HashMap<Integer, List<Integer>> modified, HashMap<Integer, List<Integer>> addedVDEVs, HashMap<Integer, List<Integer>> removedVDEVs, HashMap<Integer, List<Integer>> modifiedVDEVs) {
        Robj_interface_RJiPGIndex pgIndex = null;
        Robj_interface_BASICVerLDEVInVirtualPG[] currentLDEVPG = null;
        Robj_interface_BASICVerLDEVInVirtualPG[] priorLDEVPG = null;
        if (null == currentPaths && null == priorPaths) {
            return;
        }
        if (currentPaths == null && priorPaths != null) {
            mLogger.info("Detected removal in Virtual PG version");
            pgIndex = priorPaths.getIndex();
            priorLDEVPG = (Robj_interface_BASICVerLDEVInVirtualPG[])priorPaths.getObjChildren();
            this.addAGorPG2Map(removed, pgIndex.getIFB4(), pgIndex.getIPG(), false);
        } else if (currentPaths != null && priorPaths == null) {
            mLogger.info("Detected addition in Virtual PG version");
            pgIndex = currentPaths.getIndex();
            currentLDEVPG = (Robj_interface_BASICVerLDEVInVirtualPG[])currentPaths.getObjChildren();
            this.addAGorPG2Map(added, pgIndex.getIFB4(), pgIndex.getIPG(), false);
        } else if (currentPaths.getNVer() != priorPaths.getNVer() || currentPaths.getNSummaryVer() != priorPaths.getNSummaryVer()) {
            mLogger.info("Detected modify in Virtual PG version");
            pgIndex = currentPaths.getIndex();
            currentLDEVPG = (Robj_interface_BASICVerLDEVInVirtualPG[])currentPaths.getObjChildren();
            priorLDEVPG = (Robj_interface_BASICVerLDEVInVirtualPG[])priorPaths.getObjChildren();
            this.addAGorPG2Map(modified, pgIndex.getIFB4(), pgIndex.getIPG(), false);
        }
        this.compareLDEVInVirtualPG(pgIndex, currentLDEVPG, priorLDEVPG, addedVDEVs, removedVDEVs, modifiedVDEVs);
    }

    private AbstractMap<Integer, List<Integer>> convertPGMap2AGMap(HashMap<Integer, List<Integer>> map2Convert) {
        HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>();
        Set<Integer> keys = map2Convert.keySet();
        if (null != keys) {
            for (Integer key : keys) {
                List<Integer> pgVals = map2Convert.get(key);
                for (Integer pg : pgVals) {
                    this.addAGorPG2Map(map, key, pg, true);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTreeSet(TreeSet<String> elements, HashMap<Integer, List<Integer>> map) {
        for (String aPG : elements) {
            Object[] fb4PG = aPG.split("-");
            if (2 == fb4PG.length) {
                List<Object> list;
                Integer fb4 = Integer.parseInt(fb4PG[0]);
                Integer pg = Integer.parseInt(fb4PG[1]);
                HashMap<Integer, List<Integer>> hashMap = map;
                synchronized (hashMap) {
                    if (!map.containsKey(fb4)) {
                        list = new ArrayList();
                        map.put(fb4, list);
                    } else {
                        list = map.get(fb4);
                    }
                }
                list.add(pg);
                continue;
            }
            mLogger.log(Level.SEVERE, "{0} could not be parsed properly: {1}", new Object[]{aPG, Arrays.toString(fb4PG)});
        }
    }

    private void processAddedPG(HashMap<Integer, List<Integer>> added) {
        if (!added.isEmpty()) {
            Serializable[] paths = PGInfo.addPGInfoToCache(added, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PG, (Serializable[])paths);
            paths = null;
            Serializable[] ecags = ExternalChassisArrayGroup.addExternalCAGFromCache(added, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.ECAG, (Serializable[])ecags);
            Object var3_3 = null;
        }
    }

    private void processAddedVDEV(AbstractMap<Integer, List<Integer>> added) {
        try {
            Serializable[] cags = ChassisArrayGroup.addCAGToCache(added, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.VDEV, (Serializable[])cags);
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying add CAG to cache.", e);
        }
    }

    private void processModifiedPG(AbstractMap<Integer, List<Integer>> modified) {
        Serializable[] paths = PGInfo.modifyPGInfoInCache(modified, this.getSerialNumber());
        CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PG, (Serializable[])paths);
        Serializable[] ecags = ExternalChassisArrayGroup.modifyECAGInCache(modified, this.getSerialNumber());
        CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.ECAG, (Serializable[])ecags);
    }

    private void processModifiedVDEV(AbstractMap<Integer, List<Integer>> modified) {
        try {
            Serializable[] cags = ChassisArrayGroup.modifyCAGInCache(modified, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.VDEV, (Serializable[])cags);
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying modify CAG from cache.", e);
        }
    }

    private void processRemovedPG(HashMap<Integer, List<Integer>> removed) {
        if (!removed.isEmpty()) {
            Serializable[] paths = PGInfo.removePGInfoFromCache(removed, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PG, (Serializable[])paths);
            Serializable[] ecags = ExternalChassisArrayGroup.removeExternalCAGFromCache(removed, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.ECAG, (Serializable[])ecags);
        }
    }

    private void processRemovedVDEV(AbstractMap<Integer, List<Integer>> removed) {
        if (!removed.isEmpty()) {
            try {
                Serializable[] cags = ChassisArrayGroup.removeCAGFromCache(removed, this.getSerialNumber());
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.VDEV, (Serializable[])cags);
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "Exception occurred trying modify CAG in cache.", e);
            }
        }
    }

    private void processVDEVs(HashMap<Integer, List<Integer>> added, HashMap<Integer, List<Integer>> removed) {
        AbstractMap<Integer, List<Integer>> addedVDEVs = this.convertPGMap2AGMap(added);
        AbstractMap<Integer, List<Integer>> removedVDEVs = this.convertPGMap2AGMap(removed);
        if (null != removedVDEVs && !removedVDEVs.isEmpty()) {
            this.processRemovedVDEV(removedVDEVs);
        }
        if (null != addedVDEVs && !addedVDEVs.isEmpty()) {
            this.processAddedVDEV(addedVDEVs);
        }
    }

    @Override
    public void RSGUpdated(ResourceGroupInfo.SearchType type, TreeSet<String> addedElements, TreeSet<String> removedElements) {
        HashMap<Integer, List<Integer>> added = new HashMap<Integer, List<Integer>>();
        HashMap<Integer, List<Integer>> removed = new HashMap<Integer, List<Integer>>();
        Iterator<String> iter = addedElements.iterator();
        while (iter.hasNext()) {
            String thisVal = iter.next();
            if (!removedElements.remove(thisVal)) continue;
            iter.remove();
        }
        this.parseTreeSet(addedElements, added);
        this.parseTreeSet(removedElements, removed);
        this.processAddedPG(added);
        this.processRemovedPG(removed);
        this.processVDEVs(added, removed);
    }

    private class CacheCompareThread
    implements Task {
        private final Robj_interface_BASICVerNormalPG currentNormal;
        private final Robj_interface_BASICVerNormalPG previousNormal;
        private final Robj_interface_BASICVerVirtualPG currentVirtual;
        private final Robj_interface_BASICVerVirtualPG previousVirtual;
        private final HashMap<Integer, List<Integer>> addedPGs;
        private final HashMap<Integer, List<Integer>> removedPGs;
        private final HashMap<Integer, List<Integer>> modifiedPGs;
        private final Wait4ProcessTasks task;
        private final HashMap<Integer, List<Integer>> addedVDEVS;
        private final HashMap<Integer, List<Integer>> removedVDEVs;
        private final HashMap<Integer, List<Integer>> modifiedVDEVs;

        public CacheCompareThread(Wait4ProcessTasks task, Robj_interface_BASICVerNormalPG current, Robj_interface_BASICVerNormalPG previous, HashMap<Integer, List<Integer>> addedPGs, HashMap<Integer, List<Integer>> removedPGs, HashMap<Integer, List<Integer>> modifiedPGs, HashMap<Integer, List<Integer>> addedVDEVs, HashMap<Integer, List<Integer>> removedVDEVs, HashMap<Integer, List<Integer>> modifiedVDEVs) {
            this(task, current, previous, null, null, addedPGs, removedPGs, modifiedPGs, addedVDEVs, removedVDEVs, modifiedVDEVs);
        }

        private CacheCompareThread(Wait4ProcessTasks task, Robj_interface_BASICVerNormalPG currentNormal, Robj_interface_BASICVerNormalPG previousNormal, Robj_interface_BASICVerVirtualPG currentVirtual, Robj_interface_BASICVerVirtualPG previousVirtual, HashMap<Integer, List<Integer>> addedPGs, HashMap<Integer, List<Integer>> removedPGs, HashMap<Integer, List<Integer>> modifiedPGs, HashMap<Integer, List<Integer>> addedVDEVs, HashMap<Integer, List<Integer>> removedVDEVs, HashMap<Integer, List<Integer>> modifiedVDEVs) {
            this.currentNormal = currentNormal;
            this.currentVirtual = currentVirtual;
            this.previousNormal = previousNormal;
            this.previousVirtual = previousVirtual;
            this.addedPGs = addedPGs;
            this.removedPGs = removedPGs;
            this.modifiedPGs = modifiedPGs;
            this.addedVDEVS = addedVDEVs;
            this.removedVDEVs = removedVDEVs;
            this.modifiedVDEVs = modifiedVDEVs;
            this.task = task;
        }

        public CacheCompareThread(Wait4ProcessTasks task, Robj_interface_BASICVerVirtualPG current, Robj_interface_BASICVerVirtualPG previous, HashMap<Integer, List<Integer>> addedPGs, HashMap<Integer, List<Integer>> removedPGs, HashMap<Integer, List<Integer>> modifiedPGs, HashMap<Integer, List<Integer>> addedVDEVs, HashMap<Integer, List<Integer>> removedVDEVs, HashMap<Integer, List<Integer>> modifiedVDEVs) {
            this(task, null, null, current, previous, addedPGs, removedPGs, modifiedPGs, addedVDEVs, removedVDEVs, modifiedVDEVs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                if (null != this.currentNormal || null != this.previousNormal) {
                    PGBranchChecker.this.CompareNormalPG(this.currentNormal, this.previousNormal, this.addedPGs, this.removedPGs, this.modifiedPGs, this.addedVDEVS, this.removedVDEVs, this.modifiedVDEVs);
                } else if (null != this.currentVirtual || null != this.previousVirtual) {
                    PGBranchChecker.this.CompareVirtualPG(this.currentVirtual, this.previousVirtual, this.addedPGs, this.removedPGs, this.modifiedPGs, this.addedVDEVS, this.removedVDEVs, this.modifiedVDEVs);
                }
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                AbstractVersionChecker.mLogger.log(Level.SEVERE, "Exception comparing PGs", t);
            }
            finally {
                this.task.taskProcessed();
            }
        }
    }
}

