/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.RMIObjectMapping;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_POOLgetAOUVolRelationSx2;
import sanproject.common.Robj_interface_POOLgetAOUVolRelationSx4;
import sanproject.common.Robj_interface_POOLgetAOUVolRelationSx_IN;
import sanproject.common.Robj_interface_POOLgetAOUVolRelationSx_OUT;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class DeviceNumberAOUProcessor {
    private static Map<String, DeviceNumberAOUProcessor> singleton = new HashMap<String, DeviceNumberAOUProcessor>();
    private long lastUpdated = -1L;
    private List<DeviceNumberAOUInfo> aouInfo = new ArrayList<DeviceNumberAOUInfo>();

    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException, RemoteException, GetRmiException, SANRmiException {
        DeviceNumberAOUProcessor.cache(rmiMapping, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping rmiMapping, boolean force) throws WBEMException, RemoteException, GetRmiException, SANRmiException {
        DeviceNumberAOUProcessor processor = DeviceNumberAOUProcessor.getDeviceNumberAOUProcessor(rmiMapping.getSerialNumber());
        boolean shouldUpdate = force;
        if (!shouldUpdate) {
            DeviceNumberAOUProcessor deviceNumberAOUProcessor = processor;
            synchronized (deviceNumberAOUProcessor) {
                if (-1L == processor.lastUpdated) {
                    processor.lastUpdated = System.currentTimeMillis();
                    shouldUpdate = true;
                } else {
                    long current = System.currentTimeMillis();
                    if (TimeUnit.SECONDS.convert(current - processor.lastUpdated, TimeUnit.MILLISECONDS) > 30L) {
                        processor.lastUpdated = current;
                        shouldUpdate = true;
                    }
                }
            }
        }
        if (shouldUpdate) {
            processor.update(rmiMapping);
        }
    }

    public static DeviceNumberAOUInfo findAOUInfo(DeviceNumber dnNumber) {
        DeviceNumberAOUProcessor aouProcessor = DeviceNumberAOUProcessor.getDeviceNumberAOUProcessor(dnNumber.getSerialNumber());
        return aouProcessor.find(dnNumber.getDn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DeviceNumberAOUProcessor getDeviceNumberAOUProcessor(String serialNumber) {
        DeviceNumberAOUProcessor t = singleton.get(serialNumber);
        if (null == t) {
            Map<String, DeviceNumberAOUProcessor> map = singleton;
            synchronized (map) {
                t = singleton.get(serialNumber);
                if (null == t) {
                    t = new DeviceNumberAOUProcessor(serialNumber);
                    singleton.put(serialNumber, t);
                }
            }
        }
        return t;
    }

    private DeviceNumberAOUProcessor(String deviceSerialNumber) {
    }

    public DeviceNumberAOUInfo find(BaseDeviceNumber bdn) {
        return this.find(bdn.getDn());
    }

    public DeviceNumberAOUInfo find(long dnNumber) {
        List<DeviceNumberAOUInfo> list = this.aouInfo;
        int index = Collections.binarySearch(list, new DeviceNumberAOUInfo(null, dnNumber));
        DeviceNumberAOUInfo ret = index >= 0 ? list.get(index) : null;
        return ret;
    }

    public DeviceNumberAOUInfo find(String dnNumber) throws NumberFormatException {
        return this.find(Long.parseLong(dnNumber));
    }

    private void update(RMIObjectMapping rmiMapping) throws SANRmiException, RemoteException, WBEMException {
        Logger cacheLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        Robj_interface_POOLgetAOUVolRelationSx_IN inArg = (Robj_interface_POOLgetAOUVolRelationSx_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.POOLGETAOUVOLRELATIONSX_IN);
        Robj_interface_RJiLDEVIndex[] indexes = rmiObj.getLDEVIndex();
        inArg.setLdevInfo(indexes);
        Robj_interface_POOLgetAOUVolRelationSx_OUT outArg = (Robj_interface_POOLgetAOUVolRelationSx_OUT)rmiObj.getCmnData(inArg);
        Robj_interface_POOLgetAOUVolRelationSx2[] volRelations = outArg.getDataObjectSx();
        cacheLogger.log(Level.INFO, "Processing {0} AOUVolInfo elements on {1}", new Object[]{volRelations.length, rmiMapping.getSerialNumber()});
        ArrayList<DeviceNumberAOUInfo> infoList = new ArrayList<DeviceNumberAOUInfo>();
        for (Robj_interface_POOLgetAOUVolRelationSx2 volRelation : volRelations) {
            DeviceNumberAOUInfo info = new DeviceNumberAOUInfo(rmiMapping.getSerialNumber(), volRelation);
            infoList.add(info);
        }
        Collections.sort(infoList);
        cacheLogger.log(Level.INFO, "Processing of AOUVolInfo done for {0}", rmiMapping.getSerialNumber());
        this.aouInfo = infoList;
    }

    public static class DeviceNumberAOUInfo
    extends AbstractBaseCommonObject
    implements Comparable<DeviceNumberAOUInfo> {
        private static final long serialVersionUID = 1L;
        private final long containingDN;
        private long aouVolUsed;
        private short tieringControlFlag;
        private short poolID;
        private short dataSaving;

        private DeviceNumberAOUInfo(String serialNumber, long dn) {
            super(serialNumber);
            this.containingDN = dn;
        }

        public DeviceNumberAOUInfo(String serialNumber, Robj_interface_POOLgetAOUVolRelationSx2 volRelation) {
            this(serialNumber, BaseDeviceNumber.makeUniqueDN(volRelation.getSLDKC(), volRelation.getSCU(), volRelation.getSLDEV()));
            this.aouVolUsed = volRelation.getLAouVolUsed() * 1024L;
            this.tieringControlFlag = volRelation.getSPbTSMControlFlag();
            this.poolID = volRelation.getSPoolId();
            this.dataSaving = ((Robj_interface_POOLgetAOUVolRelationSx4)volRelation).getSDataSaving();
        }

        @Override
        public int compareTo(DeviceNumberAOUInfo other) {
            return this.containingDN == other.containingDN ? 0 : (this.containingDN < other.containingDN ? -1 : 1);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeviceNumberAOUInfo other = (DeviceNumberAOUInfo)obj;
            if (this.aouVolUsed != other.aouVolUsed) {
                return false;
            }
            if (this.containingDN != other.containingDN) {
                return false;
            }
            if (this.poolID != other.poolID) {
                return false;
            }
            return this.tieringControlFlag == other.tieringControlFlag;
        }

        public long getAouVolUsed() {
            return this.aouVolUsed;
        }

        public long getContainingDN() {
            return this.containingDN;
        }

        public int getDataSaving() {
            return this.dataSaving;
        }

        public short getPoolID() {
            return this.poolID;
        }

        public short getTieringControlFlag() {
            return this.tieringControlFlag;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.aouVolUsed ^ this.aouVolUsed >>> 32);
            result = 31 * result + (int)(this.containingDN ^ this.containingDN >>> 32);
            result = 31 * result + this.poolID;
            result = 31 * result + this.tieringControlFlag;
            return result;
        }

        public boolean isCompressed() {
            return 1 == this.dataSaving || 2 == this.dataSaving;
        }

        public boolean isTierRelocationFrozen() {
            return (this.getTieringControlFlag() & 0x80) != 0;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DeviceNumberAOUInfo [poolID=");
            builder.append(this.poolID);
            builder.append(", containingDN=");
            builder.append(this.containingDN);
            builder.append(", aouVolUsed=");
            builder.append(this.aouVolUsed);
            builder.append(", tieringControlFlag=");
            builder.append(this.tieringControlFlag);
            builder.append("]");
            return builder.toString();
        }
    }
}

