/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

public enum DiskDriveStatus {
    NORMAL(0, 2, "OK", 5),
    FAILED(1, 6, "Error", 25),
    BLOCKED(2, 11, "In Service", 20),
    WARNING(3, 5, "Predictive Failure", 15),
    CORRECTION(4, 3, "Degraded(Correction Copying)", 5),
    DRIVECOPYING(6, 3, "Degraded(Drive Copying)", 5),
    SPARING(8, 3, "Degraded(Dynamic Sparing)", 5),
    BACKING(10, 3, "Degraded(Copy Backing)", 5),
    FREE(12, 2, "OK", 5),
    RESERVED(13, 2, "OK", 5),
    INCOMPLETE(14, 4, "Stressed(Copy incomplete)", 5),
    UNKNOWN(-1, 0, "UNKNOWN", 0);

    int status;
    int opStatus;
    String statusDescr;
    int health;

    public static DiskDriveStatus getStatus(int statusVal) {
        DiskDriveStatus ret = UNKNOWN;
        for (DiskDriveStatus iter : DiskDriveStatus.values()) {
            if (statusVal != iter.getStatus()) continue;
            ret = iter;
            break;
        }
        return ret;
    }

    public final int getStatus() {
        return this.status;
    }

    public final int getOpStatus() {
        return this.opStatus;
    }

    public final String getStatusDescr() {
        return this.statusDescr;
    }

    public final int getHealth() {
        return this.health;
    }

    private DiskDriveStatus(int status, int opStatus, String statusDescr, int health) {
        this.status = status;
        this.opStatus = opStatus;
        this.statusDescr = statusDescr;
        this.health = health;
    }
}

