/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.cache.comparator.ISCSIreadAllPortInfoComparator;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.ws.wbem.CloseableAddableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.wbem.WBEMException;

public class ISCSIreadAllPortInfo
extends AbstractBaseCommonObject
implements Comparable<ISCSIreadAllPortInfo> {
    private static final long serialVersionUID = 1L;
    private static final Class<ISCSIreadAllPortInfo[]> clz = ISCSIreadAllPortInfo[].class;
    private static final int[] EMPTYIP = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int id;
    private int tcpPortNumber;
    private boolean availableSelectiveAck;
    private boolean availableDelayedAck;
    private int tcpWindowSize;
    private int ethernetMtuSize;
    private int keepAliveTimer;
    private int[] ipv4Address;
    private int[] ipv4SubnetMask;
    private int[] ipv4DefaultGateway;
    private boolean ipv6;
    private boolean ipv6LinkLocalAutoMode;
    private int[] ipv6LinkLocalManualAddress;
    private boolean ipv6GlobalAutoMode;
    private int[] ipv6GlobalManualAddress;
    private int[] ipv6DefGatewayAssignedAddress;
    private boolean vLANAvailableTagging;
    private int vLANId;
    private boolean nsServer;
    private IPType nsServerIPType;
    private int[] nsServerIPv4Address;
    private int[] nsServerIPv6Address;
    private int nsServerTCPPortNumber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException {
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<ISCSIreadAllPortInfo> clazz = ISCSIreadAllPortInfo.class;
            synchronized (ISCSIreadAllPortInfo.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<ISCSIreadAllPortInfo> callback = new ClosableAddableIteratorCB<ISCSIreadAllPortInfo>();
                    ISCSIreadAllPortInfo.getUnCached(rmiObj, callback, -1);
                    ArrayList<ISCSIreadAllPortInfo> iSCSIPorts = new ArrayList<ISCSIreadAllPortInfo>();
                    CloseableAddableIterator<ISCSIreadAllPortInfo> iter = callback.getWrappedCloseableAddableIter();
                    while (iter.hasNext()) {
                        ISCSIreadAllPortInfo iSCSIPort = (ISCSIreadAllPortInfo)iter.next();
                        iSCSIPorts.add(iSCSIPort);
                    }
                    CacheLib.addItemsToCache(iSCSIPorts, clz, rmiMapping.getSerialNumber());
                } else {
                    cacheLogger.log(Level.SEVERE, "{0} is already in the cache", clz);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            cacheLogger.log(Level.SEVERE, "{0} is already in the cache", clz);
        }
    }

    public static ISCSIreadAllPortInfo find(RMIObjectCache rmiObj, int portID) throws WBEMException {
        FindMethodCallbackHandler<ISCSIreadAllPortInfo> callback = new FindMethodCallbackHandler<ISCSIreadAllPortInfo>();
        ISCSIreadAllPortInfo.getISCSIAllPortInfo(rmiObj, callback, portID);
        return callback.getReturnValue();
    }

    private static void getISCSIAllPortInfo(IteratorCallback<ISCSIreadAllPortInfo> callback, int portID) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                ISCSIreadAllPortInfo.getISCSIAllPortInfo(mapObj.getRMIObject(), callback, portID);
                continue;
            }
            providerLogger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static void getISCSIAllPortInfo(RMIObjectCache rmiObj, IteratorCallback<ISCSIreadAllPortInfo> callback, int portID) throws WBEMException {
        ISCSIreadAllPortInfo.getISCSIAllPortInfo(rmiObj, callback, portID, false);
    }

    public static void getISCSIAllPortInfo(RMIObjectCache rmiObj, IteratorCallback<ISCSIreadAllPortInfo> callback, int portID, boolean uncached) throws WBEMException {
        if (null == rmiObj) {
            ISCSIreadAllPortInfo.getISCSIAllPortInfo(callback, portID);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!uncached && cache.isCached(clz)) {
            ISCSIreadAllPortInfo[] ports = (ISCSIreadAllPortInfo[])cache.getCachedObject(clz);
            if (null != ports) {
                ISCSIreadAllPortInfoComparator<ISCSIreadAllPortInfo> comparator = new ISCSIreadAllPortInfoComparator<ISCSIreadAllPortInfo>(portID);
                for (ISCSIreadAllPortInfo port : ports) {
                    if (!comparator.isMatch(port)) continue;
                    callback.returnItem(port);
                    if (-1 != portID) break;
                }
            }
            callback.done();
        } else {
            LogRecord record;
            if (uncached) {
                record = new LogRecord(Level.WARNING, "iSCSIReadPortInfo on {0} called to get uncached info");
            } else {
                record = new LogRecord(Level.WARNING, "iSCSIReadPortInfo not cached on {0}, performance issue");
                record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
                record.setThrown(new Exception(record.getMessage()));
            }
            cacheLogger.log(record);
            ISCSIreadAllPortInfo.getUnCached(rmiObj, callback, portID);
        }
    }

    private static void getUnCached(RMIObjectCache rmiObj, IteratorCallback<ISCSIreadAllPortInfo> callback, int portID) throws WBEMException {
        String serialNumber = rmiObj.getSMISMappingContainer().getSerialNumber();
        try {
            providerLogger.log(Level.INFO, "Entered getUncached ISCSIreadAllPortInfo for {0}", serialNumber);
            SanResponse responseData = rmiObj.keyValueAPI_InvokeKeyValueAPI("iSCSIreadAllPortInfo", true);
            SanList ports = responseData.getList("iScsiPorts");
            providerLogger.log(Level.INFO, "Found {0} port infos", ports.size());
            ISCSIreadAllPortInfoComparator<ISCSIreadAllPortInfo> comparator = new ISCSIreadAllPortInfoComparator<ISCSIreadAllPortInfo>(portID);
            Iterator iter = ports.iterator();
            while (iter.hasNext()) {
                ISCSIreadAllPortInfo iSCSIPort = new ISCSIreadAllPortInfo(serialNumber, (SanObject)iter.next());
                if (!ResourceRestriction.isPortUsable(serialNumber, (short)iSCSIPort.getId())) continue;
                if (comparator.isMatch(iSCSIPort)) {
                    callback.returnItem(iSCSIPort);
                    continue;
                }
                cacheLogger.log(Level.FINE, "Skipping unmanaged endpt port {0}", iSCSIPort.getId());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            Throwable temp = t;
            while (null != temp.getCause()) {
                temp = temp.getCause();
            }
            throw new WBEMException(1, t.toString() + " getting iSCSI ports", null, temp);
        }
        finally {
            if (null != callback) {
                callback.done();
            }
            cacheLogger.log(Level.INFO, "leaving getUncached network conditions for {0}", serialNumber);
        }
    }

    public static void update(String serialNumber, List<ISCSIreadAllPortInfo> added, List<ISCSIreadAllPortInfo> modified, List<ISCSIreadAllPortInfo> removed) throws WBEMException {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
        if (null == device) {
            cacheLogger.log(Level.SEVERE, "Update called for device {0} but no device with that serial number is being managed", serialNumber);
            return;
        }
        final RMIObjectCache rmiObj = device.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            List cached;
            ISCSIreadAllPortInfo[] cachedArray = (ISCSIreadAllPortInfo[])cache.getCachedObject(clz);
            if (null != cachedArray) {
                cached = new ArrayList<ISCSIreadAllPortInfo>(Arrays.asList(cachedArray));
                cachedArray = null;
            } else {
                cached = Collections.emptyList();
            }
            cacheLogger.log(Level.FINE, "Cache has {0} ISCSIreadAllPortInfo", cached.size());
            final ClosableAddableIteratorCB callback = new ClosableAddableIteratorCB();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ISCSIreadAllPortInfo.getUnCached(rmiObj, callback, -1);
                    }
                    catch (WBEMException we) {
                        callback.exceptionOccurred(we);
                    }
                    catch (Throwable t) {
                        while (null != t.getCause()) {
                            t = t.getCause();
                        }
                        callback.exceptionOccurred(new WBEMException(1, "Exception getting uncached elements during update", null, t));
                    }
                }
            };
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("ISCSIreadAllPortInfo updater");
            t.start();
            Collections.sort(cached);
            CloseableAddableIterator iter = callback.getWrappedCloseableAddableIter();
            while (iter.hasNext()) {
                ISCSIreadAllPortInfo nonCachedPort = (ISCSIreadAllPortInfo)iter.next();
                int index = Collections.binarySearch(cached, nonCachedPort);
                if (index >= 0) {
                    ISCSIreadAllPortInfo cachedPort = (ISCSIreadAllPortInfo)cached.remove(index);
                    if (nonCachedPort.equals(cachedPort)) continue;
                    StringBuilder msg = new StringBuilder("ISCSIreadAllPortInfo ");
                    msg.append(cachedPort.getId());
                    msg.append(" changed");
                    if (cacheLogger.isLoggable(Level.FINER)) {
                        msg.append(System.lineSeparator());
                        msg.append("Cached:");
                        msg.append(System.lineSeparator());
                        msg.append(cachedPort);
                        msg.append("Modified:");
                        msg.append(System.lineSeparator());
                        msg.append(nonCachedPort);
                    } else {
                        cacheLogger.log(Level.FINE, msg.toString());
                    }
                    modified.add(new ISCSIreadAllPortInfo(cachedPort));
                    cachedPort.copy(nonCachedPort);
                    continue;
                }
                cacheLogger.log(Level.FINE, "ISCSITargetPort {0} added", nonCachedPort.getId());
                added.add(nonCachedPort);
            }
            removed.addAll(cached);
            if (cacheLogger.isLoggable(Level.FINER) && !removed.isEmpty()) {
                cacheLogger.log(Level.FINER, "Removed ISCSITargetPort{0}{1}", new Object[]{System.lineSeparator(), removed});
            }
        } else {
            cacheLogger.log(Level.SEVERE, "ISCSIPort is not cached for {0}, will cache now", serialNumber);
            ISCSIreadAllPortInfo.cache(device);
        }
    }

    public ISCSIreadAllPortInfo(ISCSIreadAllPortInfo toBeCopied) {
        super(toBeCopied.getSerialNumber());
        this.copy(toBeCopied);
    }

    private ISCSIreadAllPortInfo(String serialNumber, SanObject port) throws WBEMException {
        super(serialNumber);
        try {
            this.id = port.getInt("Id");
            this.tcpPortNumber = port.getInt("TcpPortNumber");
            this.availableSelectiveAck = port.getBoolean("AvailableSelectiveAck");
            this.availableDelayedAck = port.getBoolean("AvailableDelayedAck");
            this.tcpWindowSize = port.getInt("TcpWindowSize");
            this.ethernetMtuSize = port.getObj("EthernetMtuSize").getInt("Mtu");
            this.keepAliveTimer = port.getInt("KeepAliveTimer");
            SanObject ipv4Obj = port.getObj("Ipv4");
            this.ipv4Address = ipv4Obj.getIntArray("IpAddress");
            this.ipv4SubnetMask = ipv4Obj.getIntArray("SubNetMask");
            this.ipv4DefaultGateway = ipv4Obj.getIntArray("DefaultGateway");
            SanObject ipv6Obj = port.getObj("Ipv6");
            this.ipv6 = ipv6Obj.getBoolean("Available");
            if (this.ipv6) {
                SanObject linkLocal = ipv6Obj.getObj("LinkLocalAddress");
                this.ipv6LinkLocalAutoMode = linkLocal.getBoolean("AutoMode");
                this.ipv6LinkLocalManualAddress = linkLocal.getIntArray("ManualAddress");
            } else {
                this.ipv6LinkLocalAutoMode = false;
                this.ipv6LinkLocalManualAddress = EMPTYIP;
            }
            SanObject globalObj = ipv6Obj.getObj("GlobalAddress");
            this.ipv6GlobalAutoMode = globalObj.getBoolean("AutoMode");
            this.ipv6GlobalManualAddress = globalObj.getIntArray("ManualAddress");
            SanObject tempObj = ipv6Obj.getObj("DefaultGateway");
            this.ipv6DefGatewayAssignedAddress = tempObj.getIntArray("AssignedAddress");
            tempObj = port.getObj("Vlan");
            this.vLANAvailableTagging = tempObj.getBoolean("AvailableTagging");
            this.vLANId = tempObj.getInt("Id");
            tempObj = port.getObj("iSnsServer");
            this.nsServer = tempObj.getBoolean("Enabled");
            this.nsServerIPType = tempObj.getInt("IpType") == 0 ? IPType.IPv4 : IPType.IPv6;
            this.nsServerIPv4Address = tempObj.getIntArray("Ipv4Address");
            this.nsServerIPv6Address = tempObj.getIntArray("Ipv6Address");
            this.nsServerTCPPortNumber = tempObj.getInt("TcpPortNumber");
        }
        catch (SanDataException sde) {
            throw new WBEMException(1, "Error getting data from iSCSI ports", null, (Throwable)sde);
        }
    }

    @Override
    public int compareTo(ISCSIreadAllPortInfo o) {
        int otherID = o.getId();
        return this.id == otherID ? 0 : (this.id < otherID ? -1 : 1);
    }

    private String convert2IPv4String(int[] ipv4Address) {
        StringBuilder ret = new StringBuilder();
        for (int ipSect : ipv4Address) {
            if (0 != ret.length()) {
                ret = ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
            }
            ret = ret.append(ipSect);
        }
        return ret.toString();
    }

    private String convert2IPv6String(int[] ipv6Address) {
        StringBuilder ret = new StringBuilder();
        for (int ipSect : ipv6Address) {
            if (0 != ret.length()) {
                ret = ret.append(':');
            }
            ret = ret.append(Integer.toHexString(ipSect));
        }
        return ret.toString();
    }

    private void copy(ISCSIreadAllPortInfo toBeCopied) {
        this.id = toBeCopied.getId();
        this.tcpPortNumber = toBeCopied.tcpPortNumber;
        this.availableSelectiveAck = toBeCopied.availableSelectiveAck;
        this.availableDelayedAck = toBeCopied.availableDelayedAck;
        this.tcpWindowSize = toBeCopied.tcpWindowSize;
        this.ethernetMtuSize = toBeCopied.ethernetMtuSize;
        this.keepAliveTimer = toBeCopied.keepAliveTimer;
        int[] tempArray = toBeCopied.ipv4Address;
        this.ipv4Address = Arrays.copyOf(tempArray, tempArray.length);
        tempArray = toBeCopied.ipv4SubnetMask;
        this.ipv4SubnetMask = Arrays.copyOf(tempArray, tempArray.length);
        tempArray = toBeCopied.ipv4DefaultGateway;
        this.ipv4DefaultGateway = Arrays.copyOf(tempArray, tempArray.length);
        this.ipv6 = toBeCopied.ipv6;
        this.ipv6LinkLocalAutoMode = toBeCopied.ipv6LinkLocalAutoMode;
        tempArray = toBeCopied.ipv6LinkLocalManualAddress;
        this.ipv6LinkLocalManualAddress = Arrays.copyOf(tempArray, tempArray.length);
        this.ipv6GlobalAutoMode = toBeCopied.ipv6GlobalAutoMode;
        tempArray = toBeCopied.ipv6GlobalManualAddress;
        this.ipv6GlobalManualAddress = Arrays.copyOf(tempArray, tempArray.length);
        tempArray = toBeCopied.ipv6DefGatewayAssignedAddress;
        this.ipv6DefGatewayAssignedAddress = Arrays.copyOf(tempArray, tempArray.length);
        this.vLANAvailableTagging = toBeCopied.vLANAvailableTagging;
        this.vLANId = toBeCopied.vLANId;
        this.nsServer = toBeCopied.nsServer;
        this.nsServerIPType = toBeCopied.nsServerIPType;
        tempArray = toBeCopied.nsServerIPv4Address;
        this.nsServerIPv4Address = Arrays.copyOf(tempArray, tempArray.length);
        tempArray = toBeCopied.nsServerIPv6Address;
        this.nsServerIPv6Address = Arrays.copyOf(tempArray, tempArray.length);
        this.nsServerTCPPortNumber = toBeCopied.nsServerTCPPortNumber;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ISCSIreadAllPortInfo other = (ISCSIreadAllPortInfo)obj;
        if (this.availableDelayedAck != other.availableDelayedAck) {
            return false;
        }
        if (this.availableSelectiveAck != other.availableSelectiveAck) {
            return false;
        }
        if (this.ethernetMtuSize != other.ethernetMtuSize) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (!Arrays.equals(this.ipv4Address, other.ipv4Address)) {
            return false;
        }
        if (!Arrays.equals(this.ipv4DefaultGateway, other.ipv4DefaultGateway)) {
            return false;
        }
        if (!Arrays.equals(this.ipv4SubnetMask, other.ipv4SubnetMask)) {
            return false;
        }
        if (this.ipv6 != other.ipv6) {
            return false;
        }
        if (!Arrays.equals(this.ipv6DefGatewayAssignedAddress, other.ipv6DefGatewayAssignedAddress)) {
            return false;
        }
        if (this.ipv6GlobalAutoMode != other.ipv6GlobalAutoMode) {
            return false;
        }
        if (!Arrays.equals(this.ipv6GlobalManualAddress, other.ipv6GlobalManualAddress)) {
            return false;
        }
        if (this.ipv6LinkLocalAutoMode != other.ipv6LinkLocalAutoMode) {
            return false;
        }
        if (!Arrays.equals(this.ipv6LinkLocalManualAddress, other.ipv6LinkLocalManualAddress)) {
            return false;
        }
        if (this.keepAliveTimer != other.keepAliveTimer) {
            return false;
        }
        if (this.nsServer != other.nsServer) {
            return false;
        }
        if (this.nsServerIPType != other.nsServerIPType) {
            return false;
        }
        if (!Arrays.equals(this.nsServerIPv4Address, other.nsServerIPv4Address)) {
            return false;
        }
        if (!Arrays.equals(this.nsServerIPv6Address, other.nsServerIPv6Address)) {
            return false;
        }
        if (this.nsServerTCPPortNumber != other.nsServerTCPPortNumber) {
            return false;
        }
        if (this.tcpPortNumber != other.tcpPortNumber) {
            return false;
        }
        if (this.tcpWindowSize != other.tcpWindowSize) {
            return false;
        }
        if (this.vLANAvailableTagging != other.vLANAvailableTagging) {
            return false;
        }
        return this.vLANId == other.vLANId;
    }

    public int getEthernetMtuSize() {
        return this.ethernetMtuSize;
    }

    public int getId() {
        return this.id;
    }

    public int[] getIpv4Address() {
        return this.ipv4Address;
    }

    public String getIpv4AddressStr() {
        return this.convert2IPv4String(this.getIpv4Address());
    }

    public int[] getIpv4DefaultGateway() {
        return this.ipv4DefaultGateway;
    }

    public String getIpv4DefaultGatewayStr() {
        return this.convert2IPv4String(this.getIpv4DefaultGateway());
    }

    public int[] getIpv4SubnetMask() {
        return this.ipv4SubnetMask;
    }

    public int[] getIpv6DefGatewayAssignedAddress() {
        return this.ipv6DefGatewayAssignedAddress;
    }

    public String getIpv6GlobalLinkLocalAddressStr() {
        return this.convert2IPv6String(this.ipv6LinkLocalManualAddress);
    }

    public int[] getIpv6GlobalManualAddress() {
        return this.ipv6GlobalManualAddress;
    }

    public String getIpv6GlobalManualAddressStr() {
        return this.convert2IPv6String(this.ipv6GlobalManualAddress);
    }

    public int[] getIpv6LinkLocalManualAddress() {
        return this.ipv6LinkLocalManualAddress;
    }

    public int getKeepAliveTimer() {
        return this.keepAliveTimer;
    }

    public IPType getNsServerIPType() {
        return this.nsServerIPType;
    }

    public int[] getNsServerIPv4Address() {
        return this.nsServerIPv4Address;
    }

    public int[] getNsServerIPv6Address() {
        return this.nsServerIPv6Address;
    }

    public int getNsServerTCPPortNumber() {
        return this.nsServerTCPPortNumber;
    }

    public int getTcpPortNumber() {
        return this.tcpPortNumber;
    }

    public int getTcpWindowSize() {
        return this.tcpWindowSize;
    }

    public int getvLANId() {
        return this.vLANId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.availableDelayedAck ? 1231 : 1237);
        result = 31 * result + (this.availableSelectiveAck ? 1231 : 1237);
        result = 31 * result + this.ethernetMtuSize;
        result = 31 * result + this.id;
        result = 31 * result + Arrays.hashCode(this.ipv4Address);
        result = 31 * result + Arrays.hashCode(this.ipv4DefaultGateway);
        result = 31 * result + Arrays.hashCode(this.ipv4SubnetMask);
        result = 31 * result + (this.ipv6 ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.ipv6DefGatewayAssignedAddress);
        result = 31 * result + (this.ipv6GlobalAutoMode ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.ipv6GlobalManualAddress);
        result = 31 * result + (this.ipv6LinkLocalAutoMode ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.ipv6LinkLocalManualAddress);
        result = 31 * result + this.keepAliveTimer;
        result = 31 * result + (this.nsServer ? 1231 : 1237);
        result = 31 * result + (this.nsServerIPType == null ? 0 : this.nsServerIPType.hashCode());
        result = 31 * result + Arrays.hashCode(this.nsServerIPv4Address);
        result = 31 * result + Arrays.hashCode(this.nsServerIPv6Address);
        result = 31 * result + this.nsServerTCPPortNumber;
        result = 31 * result + this.tcpPortNumber;
        result = 31 * result + this.tcpWindowSize;
        result = 31 * result + (this.vLANAvailableTagging ? 1231 : 1237);
        result = 31 * result + this.vLANId;
        return result;
    }

    public boolean isAvailableDelayedAck() {
        return this.availableDelayedAck;
    }

    public boolean isAvailableSelectiveAck() {
        return this.availableSelectiveAck;
    }

    public boolean isIpv6() {
        return this.ipv6;
    }

    public boolean isIpv6GlobalAutoMode() {
        return this.ipv6GlobalAutoMode;
    }

    public boolean isIpv6LinkLocalAutoMode() {
        return this.ipv6LinkLocalAutoMode;
    }

    public boolean isNsServer() {
        return this.nsServer;
    }

    public boolean isvLANAvailableTagging() {
        return this.vLANAvailableTagging;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ISCSIreadAllPortInfo [id=");
        builder.append(this.id);
        builder.append(", tcpPortNumber=");
        builder.append(this.tcpPortNumber);
        builder.append(", ");
        if (this.ipv4Address != null) {
            builder.append("ipv4Address=");
            builder.append(Arrays.toString(this.ipv4Address));
            builder.append(", ");
        }
        builder.append("availableSelectiveAck=");
        builder.append(this.availableSelectiveAck);
        builder.append(", availableDelayedAck=");
        builder.append(this.availableDelayedAck);
        builder.append(", tcpWindowSize=");
        builder.append(this.tcpWindowSize);
        builder.append(", ethernetMtuSize=");
        builder.append(this.ethernetMtuSize);
        builder.append(", keepAliveTimer=");
        builder.append(this.keepAliveTimer);
        builder.append(", ");
        if (this.ipv4SubnetMask != null) {
            builder.append("ipv4SubnetMask=");
            builder.append(Arrays.toString(this.ipv4SubnetMask));
            builder.append(", ");
        }
        if (this.ipv4DefaultGateway != null) {
            builder.append("ipv4DefaultGateway=");
            builder.append(Arrays.toString(this.ipv4DefaultGateway));
            builder.append(", ");
        }
        builder.append("ipv6=");
        builder.append(this.ipv6);
        builder.append(", ipv6LinkLocalAutoMode=");
        builder.append(this.ipv6LinkLocalAutoMode);
        builder.append(", ");
        if (this.ipv6LinkLocalManualAddress != null) {
            builder.append("ipv6LinkLocalManualAddress=");
            builder.append(Arrays.toString(this.ipv6LinkLocalManualAddress));
            builder.append(", ");
        }
        builder.append("ipv6GlobalAutoMode=");
        builder.append(this.ipv6GlobalAutoMode);
        builder.append(", ");
        if (this.ipv6GlobalManualAddress != null) {
            builder.append("ipv6GlobalManualAddress=");
            builder.append(Arrays.toString(this.ipv6GlobalManualAddress));
            builder.append(", ");
        }
        if (this.ipv6DefGatewayAssignedAddress != null) {
            builder.append("ipv6DefGatewayAssignedAddress=");
            builder.append(Arrays.toString(this.ipv6DefGatewayAssignedAddress));
            builder.append(", ");
        }
        builder.append("vLANAvailableTagging=");
        builder.append(this.vLANAvailableTagging);
        builder.append(", vLANId=");
        builder.append(this.vLANId);
        builder.append(", nsServer=");
        builder.append(this.nsServer);
        builder.append(", ");
        if (this.nsServerIPType != null) {
            builder.append("nsServerIPType=");
            builder.append((Object)this.nsServerIPType);
            builder.append(", ");
        }
        if (this.nsServerIPv4Address != null) {
            builder.append("nsServerIPv4Address=");
            builder.append(Arrays.toString(this.nsServerIPv4Address));
            builder.append(", ");
        }
        if (this.nsServerIPv6Address != null) {
            builder.append("nsServerIPv6Address=");
            builder.append(Arrays.toString(this.nsServerIPv6Address));
            builder.append(", ");
        }
        builder.append("nsServerTCPPortNumber=");
        builder.append(this.nsServerTCPPortNumber);
        builder.append("]");
        return builder.toString();
    }

    public static enum IPType {
        IPv4,
        IPv6;

    }
}

