/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.cache.comparator.ISCSIPortConditionsComparator;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.ws.wbem.CloseableAddableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.wbem.WBEMException;

public class ISCSIreadPortNetworkConditions
extends AbstractBaseCommonObject
implements Comparable<ISCSIreadPortNetworkConditions> {
    private static final long serialVersionUID = 1L;
    private static final Class<ISCSIreadPortNetworkConditions[]> clz = ISCSIreadPortNetworkConditions[].class;
    int id;
    int[] macAddress;
    int LinkedMtu;
    int[] linkLocalAddress;
    StatusCode localStatus;
    int[] globalAddress;
    StatusCode globalStatus;
    int[] gatewayAddress;
    StatusCode gatewayStatus;
    private String macAddressStr;

    static ISCSIreadPortNetworkConditions find(RMIObjectCache rmiObj, short portID) throws WBEMException {
        FindMethodCallbackHandler<ISCSIreadPortNetworkConditions> callback = new FindMethodCallbackHandler<ISCSIreadPortNetworkConditions>();
        List<Short> portIDs = Arrays.asList(portID);
        ISCSIreadPortNetworkConditions.getISCSIPortNetworkConditions(rmiObj, callback, portIDs);
        return callback.getReturnValue();
    }

    private static List<Short> findISCSIPorts(final RMIObjectCache rmiObj) throws WBEMException {
        providerLogger.log(Level.SEVERE, "ISCSIreadPortNetworkConditions needs to determine which ports are iSCSI, this is a performance issue");
        ArrayList<Short> ret = new ArrayList<Short>();
        final ClosableAddableIteratorCB callback = new ClosableAddableIteratorCB();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    FCPort.getFCPorts(rmiObj, callback, false, true, null, null);
                }
                catch (WBEMException e) {
                    callback.exceptionOccurred(e);
                }
                catch (Throwable t) {
                    WBEMException e = new WBEMException(1, t.toString(), null, t);
                    callback.exceptionOccurred(e);
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("iSCSIreadPort getting FCPorts");
        t.start();
        try {
            CloseableAddableIterator iter = callback.getWrappedCloseableAddableIter();
            while (iter.hasNext()) {
                FCPort fcPort = (FCPort)iter.next();
                if (!fcPort.isRequestedType(FCPort.PortTypeRequested.iSCSI)) continue;
                ret.add(fcPort.getPort());
                int max = rmiObj.getSMIModelInfo().getMaxISCSIPort();
                if (ret.size() != max) continue;
                iter.done();
                break;
            }
        }
        catch (Throwable e) {
            while (null != e.getCause()) {
                if (e instanceof WBEMException) {
                    throw (WBEMException)e.getCause();
                }
                e = e.getCause();
            }
            throw new WBEMException(1, "Unexpected: " + e.toString(), null, e);
        }
        return ret;
    }

    private static void getISCSIPortNetworkConditions(IteratorCallback<ISCSIreadPortNetworkConditions> callback, List<Short> portIDs) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                ISCSIreadPortNetworkConditions.getISCSIPortNetworkConditions(mapObj.getRMIObject(), callback, portIDs);
                continue;
            }
            providerLogger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    private static void getISCSIPortNetworkConditions(RMIObjectCache rmiObj, IteratorCallback<ISCSIreadPortNetworkConditions> callback, List<Short> portIDs) throws WBEMException {
        if (null == rmiObj) {
            ISCSIreadPortNetworkConditions.getISCSIPortNetworkConditions(callback, portIDs);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            ISCSIreadPortNetworkConditions[] ports = (ISCSIreadPortNetworkConditions[])cache.getCachedObject(clz);
            if (null != ports) {
                ISCSIPortConditionsComparator<ISCSIreadPortNetworkConditions> comparator = null == portIDs || 0 == portIDs.size() ? new ISCSIPortConditionsComparator<ISCSIreadPortNetworkConditions>() : new ISCSIPortConditionsComparator(portIDs);
                for (ISCSIreadPortNetworkConditions port : ports) {
                    if (!ResourceRestriction.isPortUsable(port.getSerialNumber(), (short)port.getId())) continue;
                    if (comparator.isMatch(port)) {
                        callback.returnItem(port);
                        continue;
                    }
                    providerLogger.log(Level.FINE, "Skipping unmanaged port {0}", port.getId());
                }
            }
            callback.done();
        } else {
            ISCSIreadPortNetworkConditions.getUnCached(rmiObj, callback, portIDs);
        }
    }

    private static void getUnCached(RMIObjectCache rmiObj, IteratorCallback<ISCSIreadPortNetworkConditions> callback, List<Short> portIDs) throws WBEMException {
        List<Short> portIDs2Find = null == portIDs || portIDs.isEmpty() ? ISCSIreadPortNetworkConditions.findISCSIPorts(rmiObj) : portIDs;
        String serialNumber = rmiObj.getSMISMappingContainer().getSerialNumber();
        try {
            cacheLogger.log(Level.INFO, "Entered getUncached PortNetworkConditions looking for  ports {0}, on device {1}", new Object[]{portIDs, serialNumber});
            SanRemote sanRemote = rmiObj.keyValueAPI_GetSanRemote();
            SanData generalParameter = rmiObj.keyValueAPI_GetStorageInfoParam(sanRemote, "127.0.0.1");
            rmiObj.addAccountInfo(generalParameter);
            SanRequest request = sanRemote.newRequest(generalParameter, "iSCSIreadPortNetworkConditions");
            cacheLogger.log(Level.INFO, "Invoking {0}", "iSCSIreadPortNetworkConditions");
            SanList ports = request.newList("iScsiPorts");
            for (Short portID : portIDs2Find) {
                SanObject id = ports.addObj();
                id.putInt("Id", portID.intValue());
            }
            SanResponse responseData = rmiObj.keyValueAPI_Invoke("iSCSIreadPortNetworkConditions", sanRemote, generalParameter, request, true);
            ports = responseData.getList("iScsiPorts");
            cacheLogger.log(Level.INFO, "Found {0} ports", ports.size());
            ISCSIPortConditionsComparator<ISCSIreadPortNetworkConditions> comparator = new ISCSIPortConditionsComparator<ISCSIreadPortNetworkConditions>(portIDs2Find);
            Iterator iter = ports.iterator();
            while (iter.hasNext()) {
                ISCSIreadPortNetworkConditions iSCSIPort = new ISCSIreadPortNetworkConditions(serialNumber, (SanObject)iter.next());
                if (!comparator.isMatch(iSCSIPort)) continue;
                callback.returnItem(iSCSIPort);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            Throwable temp = t;
            while (null != temp.getCause()) {
                temp = temp.getCause();
            }
            throw new WBEMException(1, t.toString() + " getting iSCSI ports", null, temp);
        }
        finally {
            if (null != callback) {
                callback.done();
            }
            cacheLogger.log(Level.INFO, "leaving getUncached network conditions for {0}", serialNumber);
        }
    }

    public ISCSIreadPortNetworkConditions(ISCSIreadPortNetworkConditions toBeCopied) {
        super(toBeCopied.getSerialNumber());
        this.copy(toBeCopied);
    }

    private ISCSIreadPortNetworkConditions(String serialNumber, SanObject port) throws WBEMException {
        super(serialNumber);
        try {
            this.id = port.getInt("Id");
            this.macAddress = port.getIntArray("MacAddress");
            StringBuilder result = new StringBuilder();
            for (int element : this.macAddress) {
                result = result.append(Integer.toString((element & 0xFF) + 256, 16).substring(1).toUpperCase());
            }
            this.macAddressStr = result.toString();
            result = null;
            this.LinkedMtu = port.getObj("EthernetMtuSize").getInt("LinkedMtu");
            SanObject ipV6 = port.getObj("Ipv6");
            SanObject tObj = ipV6.getObj("LinkLocalAddress");
            this.linkLocalAddress = tObj.getIntArray("AutoAddress");
            this.localStatus = this.getStatus(tObj.getInt("StatusCode"));
            tObj = ipV6.getObj("GlobalAddress");
            this.globalAddress = tObj.getIntArray("AutoAddress");
            this.globalStatus = this.getStatus(tObj.getInt("StatusCode"));
            tObj = ipV6.getObj("DefaultGateway");
            this.gatewayAddress = tObj.getIntArray("CurrentAddress");
            this.gatewayStatus = this.getStatus(tObj.getInt("StatusCode"));
        }
        catch (SanDataException sde) {
            throw new WBEMException(1, "Error getting data from iSCSI ports", null, (Throwable)sde);
        }
    }

    @Override
    public int compareTo(ISCSIreadPortNetworkConditions o) {
        int otherID = o.getId();
        return this.id == otherID ? 0 : (this.id < otherID ? -1 : 1);
    }

    private void copy(ISCSIreadPortNetworkConditions toBeCopied) {
        this.id = toBeCopied.getId();
        this.macAddress = Arrays.copyOf(toBeCopied.macAddress, toBeCopied.macAddress.length);
        this.macAddressStr = toBeCopied.macAddressStr;
        this.LinkedMtu = toBeCopied.LinkedMtu;
        this.linkLocalAddress = Arrays.copyOf(toBeCopied.linkLocalAddress, toBeCopied.linkLocalAddress.length);
        this.localStatus = toBeCopied.localStatus;
        this.globalAddress = Arrays.copyOf(toBeCopied.globalAddress, toBeCopied.globalAddress.length);
        this.globalStatus = toBeCopied.globalStatus;
        this.gatewayAddress = Arrays.copyOf(toBeCopied.gatewayAddress, toBeCopied.gatewayAddress.length);
        this.gatewayStatus = toBeCopied.gatewayStatus;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ISCSIreadPortNetworkConditions other = (ISCSIreadPortNetworkConditions)obj;
        if (this.LinkedMtu != other.LinkedMtu) {
            return false;
        }
        if (!Arrays.equals(this.gatewayAddress, other.gatewayAddress)) {
            return false;
        }
        if (this.gatewayStatus != other.gatewayStatus) {
            return false;
        }
        if (!Arrays.equals(this.globalAddress, other.globalAddress)) {
            return false;
        }
        if (this.globalStatus != other.globalStatus) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (!Arrays.equals(this.linkLocalAddress, other.linkLocalAddress)) {
            return false;
        }
        if (this.localStatus != other.localStatus) {
            return false;
        }
        return Arrays.equals(this.macAddress, other.macAddress);
    }

    public int[] getGatewayAddress() {
        return this.gatewayAddress;
    }

    public StatusCode getGatewayStatus() {
        return this.gatewayStatus;
    }

    public int[] getGlobalAddress() {
        return this.globalAddress;
    }

    public StatusCode getGlobalStatus() {
        return this.globalStatus;
    }

    public int getId() {
        return this.id;
    }

    public int getLinkedMtu() {
        return this.LinkedMtu;
    }

    public int[] getLinkLocalAddress() {
        return this.linkLocalAddress;
    }

    public StatusCode getLinkLocalStatus() {
        return this.localStatus;
    }

    public int[] getMacAddress() {
        return this.macAddress;
    }

    public String getMacAddressAsString() {
        return this.macAddressStr;
    }

    private StatusCode getStatus(int value) {
        StatusCode status;
        switch (value) {
            case 1: {
                status = StatusCode.Acquiring;
                break;
            }
            case 2: {
                status = StatusCode.Preferred;
                break;
            }
            case 3: {
                status = StatusCode.Invalid;
                break;
            }
            case 4: {
                status = StatusCode.Duplicated;
                break;
            }
            default: {
                cacheLogger.log(Level.SEVERE, "{0} is not a valid status code", value);
                status = StatusCode.Invalid;
            }
        }
        return status;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.LinkedMtu;
        result = 31 * result + Arrays.hashCode(this.gatewayAddress);
        result = 31 * result + (this.gatewayStatus == null ? 0 : this.gatewayStatus.hashCode());
        result = 31 * result + Arrays.hashCode(this.globalAddress);
        result = 31 * result + (this.globalStatus == null ? 0 : this.globalStatus.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + Arrays.hashCode(this.linkLocalAddress);
        result = 31 * result + (this.localStatus == null ? 0 : this.localStatus.hashCode());
        result = 31 * result + Arrays.hashCode(this.macAddress);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ISCSIreadPortNetworkConditions [id=");
        builder.append(this.id);
        builder.append(", macAddressStr=");
        builder.append(this.macAddressStr);
        if (this.macAddress != null) {
            builder.append("macAddress=");
            builder.append(Arrays.toString(this.macAddress));
            builder.append(", ");
        }
        builder.append("LinkedMtu=");
        builder.append(this.LinkedMtu);
        builder.append(", ");
        if (this.linkLocalAddress != null) {
            builder.append("linkLocalAddress=");
            builder.append(Arrays.toString(this.linkLocalAddress));
            builder.append(", ");
        }
        if (this.localStatus != null) {
            builder.append("localStatus=");
            builder.append((Object)this.localStatus);
            builder.append(", ");
        }
        if (this.globalAddress != null) {
            builder.append("globalAddress=");
            builder.append(Arrays.toString(this.globalAddress));
            builder.append(", ");
        }
        if (this.globalStatus != null) {
            builder.append("globalStatus=");
            builder.append((Object)this.globalStatus);
            builder.append(", ");
        }
        if (this.gatewayAddress != null) {
            builder.append("gatewayAddress=");
            builder.append(Arrays.toString(this.gatewayAddress));
            builder.append(", ");
        }
        if (this.gatewayStatus != null) {
            builder.append("gatewayStatus=");
            builder.append((Object)this.gatewayStatus);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum StatusCode {
        Acquiring(1),
        Preferred(2),
        Invalid(3),
        Duplicated(4);

        int value;

        private StatusCode(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

