/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.IndicationHandler;
import com.hitachi.smi.common.ProviderLibs;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import javax.wbem.WBEMException;

public class IndicationManager {
    private final IndicationHandler mImplementation;
    private final ConcurrentHashMap<String, Integer> mSubscriptionList;

    public IndicationManager(IndicationHandler impl) {
        this.mImplementation = impl;
        this.mSubscriptionList = new ConcurrentHashMap();
    }

    public synchronized int activate(String pIndicationFilter) {
        String indicationFilter = ProviderLibs.collapseSpaces(pIndicationFilter);
        int newNumSubscriptions = 1;
        Integer numSubscriptions = this.mSubscriptionList.get(indicationFilter);
        if (null != numSubscriptions) {
            newNumSubscriptions = numSubscriptions + 1;
        }
        this.mSubscriptionList.put(indicationFilter, new Integer(newNumSubscriptions));
        return newNumSubscriptions;
    }

    public void authorize(String pIndicationFilter) throws WBEMException {
        String indicationFilter = ProviderLibs.collapseSpaces(pIndicationFilter);
        if (null == indicationFilter) {
            throw new IllegalArgumentException();
        }
        Object[] mSupportedIndicationFilters = this.mImplementation.getSupportedIndications();
        if (null != mSupportedIndicationFilters) {
            for (String string : mSupportedIndicationFilters) {
                if (!string.equalsIgnoreCase(indicationFilter)) continue;
                return;
            }
        }
        throw new WBEMException("Provider does not support the requested indication filter: " + indicationFilter + ", supported filters: " + Arrays.toString(mSupportedIndicationFilters));
    }

    public synchronized int deactivate(String pIndicationFilter) {
        String indicationFilter = ProviderLibs.collapseSpaces(pIndicationFilter);
        int newNumSubscriptions = 0;
        Integer numSubscriptions = this.mSubscriptionList.get(indicationFilter);
        if (null != numSubscriptions && numSubscriptions > 1) {
            newNumSubscriptions = numSubscriptions - 1;
        }
        if (0 == newNumSubscriptions) {
            this.mSubscriptionList.remove(indicationFilter);
        } else {
            this.mSubscriptionList.put(indicationFilter, new Integer(newNumSubscriptions));
        }
        return newNumSubscriptions;
    }
}

