/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.cache.comparator.HitachiCacheComparator;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public abstract class IteratorCallbackIMPL<E extends AbstractBaseCommonObject>
implements IteratorCallback<E> {
    protected boolean mIsObjectPath = false;
    protected CustomCloseableIterator<?> mIter = null;
    protected CIMObjectPath mOP = null;
    protected String[] mPropertyList = null;
    protected ReferenceInfo mRefInfo = null;

    protected IteratorCallbackIMPL(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
        this.mIter = iter;
        this.mIsObjectPath = isObjectPath;
        this.mRefInfo = refInfo;
        this.mOP = op;
        this.mPropertyList = propertyList;
    }

    @Override
    public void done() {
        this.mIter.done();
    }

    @Override
    public void exceptionOccurred(WBEMException thrown) {
        this.mIter.setException(thrown);
        this.mIter.close();
    }

    @Override
    public abstract boolean returnItem(E var1);

    @Override
    public void returnItems(E[] items) {
        this.returnItems((AbstractBaseCommonObject[])items, null);
    }

    @Override
    public void returnItems(E[] items, HitachiCacheComparator<E> comparator) {
        block4: {
            block5: {
                if (items == null) break block4;
                if (items.length >= 2) break block5;
                if (items.length != 1) break block4;
                E item = items[0];
                if (null != comparator && !comparator.isMatch(item)) break block4;
                this.returnItem(item);
                break block4;
            }
            TaskProcessor task = new TaskProcessor("Callback iterator for " + (null == this.mOP ? "-" : this.mOP.getObjectName()), items.length);
            for (E item : items) {
                if (task.shouldStop()) continue;
                WorkerThread worker = new WorkerThread(this, task, item, comparator, item.getClass().getSimpleName());
                task.addTask(worker);
            }
            while (!task.shouldStop()) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    if (!HitachiCacheMangerService.isShuttingDown()) continue;
                    task.setStop(true);
                }
            }
        }
        this.done();
    }

    protected static class WorkerThread
    implements Task {
        private final E mItem;
        private final TaskProcessor mTheTask;
        private final HitachiCacheComparator<E> mComparator;
        private String mThreadName;
        final /* synthetic */ IteratorCallbackIMPL this$0;

        public WorkerThread(TaskProcessor theTask, E item, HitachiCacheComparator<E> comparator) {
            this(var1_1, theTask, (AbstractBaseCommonObject)item, comparator, null);
        }

        public WorkerThread(TaskProcessor theTask, E item, HitachiCacheComparator<E> comparator, String threadName) {
            this.this$0 = var1_1;
            this.mItem = item;
            this.mTheTask = theTask;
            this.mComparator = comparator;
            this.mThreadName = threadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            if (null != this.mThreadName) {
                Thread.currentThread().setName(this.mThreadName);
            }
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = null == this.mComparator || this.mComparator.isMatch(this.mItem) ? this.this$0.returnItem(this.mItem) : true)) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, "Exception while processing items", null, (Throwable)e);
                this.this$0.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                this.mTheTask.taskDone();
            }
        }
    }
}

