/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_LDEVStatisticInfo;
import sanproject.common.Robj_interface_LDEVStatisticInfoEx;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class LDEVStats {
    private static boolean checkEXProperty = true;
    private UnsignedInteger64 mReadIOs = null;
    private UnsignedInteger64 mReadHits = null;
    private UnsignedInteger64 mReadTrans = null;
    private UnsignedInteger64 mWriteIOs = null;
    private UnsignedInteger64 mWriteHits = null;
    private UnsignedInteger64 mWriteTrans = null;
    private Date mTargetTime = null;
    private UnsignedInteger64 mTotalIOs = null;
    private BaseDeviceNumber bdn;
    private UnsignedInteger64 mReadIOTime;
    private UnsignedInteger64 mWriteIOTime;

    public static void getAllStats(RMIObjectCache rmiObj, CloseableAddableIterator<LDEVStats> callback) throws RemoteException, SANRmiException, WBEMException {
        CommonClassAsList<DeviceNumber> dnCB = new CommonClassAsList<DeviceNumber>();
        DeviceNumber.getDNs(rmiObj, dnCB, false, true, null);
        LinkedList<DeviceNumber> dns = dnCB.getReturnValue();
        Robj_interface_RJiLDEVIndex[] indexes = ProviderLibs.deviceNumbersToLDEVIndexArray(rmiObj, dns);
        LDEVStats.getLDEVStats(rmiObj, indexes, callback);
    }

    public static void getLDEVStats(RMIObjectCache rmiObj, Robj_interface_RJiLDEVIndex[] ldevs2GetStats4, CloseableAddableIterator<LDEVStats> callback) throws RemoteException, SANRmiException, WBEMException {
        if (ldevs2GetStats4.length > 0) {
            Robj_interface_LDEVStatisticInfo[] statArray = rmiObj.getLDEVStatisticInfo(ldevs2GetStats4);
            if (statArray.length > 0) {
                String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
                TaskProcessor task = new TaskProcessor("LDEVStats: " + serialNum, statArray.length);
                for (Robj_interface_LDEVStatisticInfo stat : statArray) {
                    if (task.shouldStop()) {
                        callback.done();
                        break;
                    }
                    WorkerThread worker = new WorkerThread(callback, serialNum, stat, task);
                    task.addTask(worker);
                }
            } else {
                callback.done();
            }
        } else {
            callback.done();
        }
    }

    private LDEVStats() {
    }

    public LDEVStats(BaseDeviceNumber dn) throws WBEMException, RemoteException, SANRmiException {
        this();
        this.bdn = dn;
        this.getStatsInfo(dn);
    }

    private LDEVStats(String serialNum, Robj_interface_LDEVStatisticInfo stat) throws RemoteException, GetRmiException, WBEMException {
        this();
        this.bdn = new BaseDeviceNumber(serialNum, stat.getSLDKC(), stat.getSLDEV(), stat.getSCU(), 625);
        this.setValues(new Robj_interface_LDEVStatisticInfo[]{stat});
    }

    public BaseDeviceNumber getDN() {
        return this.bdn;
    }

    public UnsignedInteger64 getGetTotalIOs() {
        return this.mTotalIOs;
    }

    public UnsignedInteger64 getReadHitStatistic() {
        return this.mReadHits;
    }

    public UnsignedInteger64 getReadIOStatistic() throws WBEMException {
        return this.mReadIOs;
    }

    public UnsignedInteger64 getReadIOTime() {
        return this.mReadIOTime;
    }

    public UnsignedInteger64 getReadTransRateStatistic() {
        return this.mReadTrans;
    }

    private void getStatsInfo(BaseDeviceNumber dn) throws WBEMException, RemoteException, SANRmiException {
        RMIObjectCache rmiobj = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getRMIObject();
        ArrayList<Robj_interface_RJiLDEVIndex> ldevs = new ArrayList<Robj_interface_RJiLDEVIndex>();
        Robj_interface_RJiLDEVIndex ldev = null;
        ldev = (Robj_interface_RJiLDEVIndex)rmiobj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
        ldev.setSLDKC(dn.getLdkc());
        ldev.setSCU(dn.getCu());
        ldev.setSLDEV(dn.getLdev());
        ldevs.add(ldev);
        Robj_interface_RJiLDEVIndex[] arg0 = ldevs.toArray(new Robj_interface_RJiLDEVIndex[ldevs.size()]);
        this.setValues(rmiobj.getLDEVStatisticInfo(arg0));
    }

    public Date getTargetTime() {
        return this.mTargetTime;
    }

    public UnsignedInteger64 getWriteHitStatistic() {
        return this.mWriteHits;
    }

    public UnsignedInteger64 getWriteIOStatistic() {
        return this.mWriteIOs;
    }

    public UnsignedInteger64 getWriteIOTime() {
        return this.mWriteIOTime;
    }

    public UnsignedInteger64 getWriteTransRateStatistic() {
        return this.mWriteTrans;
    }

    private void setValues(Robj_interface_LDEVStatisticInfo[] infos) {
        BigInteger writeTrans;
        BigInteger readTrans;
        BigInteger readHits = readTrans = BigInteger.ZERO;
        BigInteger readIOs = readTrans;
        BigInteger writeHits = writeTrans = BigInteger.ZERO;
        BigInteger writeIOs = writeTrans;
        BigInteger writeIOTime = BigInteger.ZERO;
        BigInteger readIOTime = BigInteger.ZERO;
        for (Robj_interface_LDEVStatisticInfo info : infos) {
            readIOs = readIOs.add(BigInteger.valueOf(info.getReadIOStatistic()));
            readHits = readHits.add(BigInteger.valueOf(info.getReadHitStatistic()));
            readTrans = readTrans.add(BigInteger.valueOf(info.getReadTransRateStatistic()));
            writeIOs = writeIOs.add(BigInteger.valueOf(info.getWriteIOStatistic()));
            writeHits = writeHits.add(BigInteger.valueOf(info.getWriteHitStatistic()));
            writeTrans = writeTrans.add(BigInteger.valueOf(info.getWriteTransRateStatistic()));
            if (null == this.mTargetTime) {
                this.mTargetTime = info.getTargetTime();
            }
            if (!checkEXProperty) continue;
            try {
                Robj_interface_LDEVStatisticInfoEx t = (Robj_interface_LDEVStatisticInfoEx)info;
                readIOTime = readIOTime.add(BigInteger.valueOf(t.getReadIOTimeStatistic()));
                writeIOTime = writeIOTime.add(BigInteger.valueOf(t.getWriteIOTimeStatistic()));
            }
            catch (Throwable t) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.log(Level.SEVERE, "Error getting data from LDEVStatisticInfoEx cast, Read/Write IO Time is unavailable", t);
                checkEXProperty = false;
            }
        }
        this.mReadIOs = new UnsignedInteger64(readIOs);
        this.mReadHits = new UnsignedInteger64(readHits);
        this.mReadTrans = new UnsignedInteger64(readTrans);
        this.mWriteIOs = new UnsignedInteger64(writeIOs);
        this.mWriteHits = new UnsignedInteger64(writeHits);
        this.mWriteTrans = new UnsignedInteger64(writeTrans);
        BigInteger total = readIOs.add(writeIOs);
        this.mTotalIOs = new UnsignedInteger64(total);
        this.mReadIOTime = new UnsignedInteger64(readIOTime);
        this.mWriteIOTime = new UnsignedInteger64(writeIOTime);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LDEVStats [mReadIOs=");
        builder.append(this.mReadIOs);
        builder.append(", mReadHits=");
        builder.append(this.mReadHits);
        builder.append(", mReadTrans=");
        builder.append(this.mReadTrans);
        builder.append(", mWriteIOs=");
        builder.append(this.mWriteIOs);
        builder.append(", mWriteHits=");
        builder.append(this.mWriteHits);
        builder.append(", mWriteTrans=");
        builder.append(this.mWriteTrans);
        builder.append(", mTargetTime=");
        builder.append(this.mTargetTime);
        builder.append(", mTotalIOs=");
        builder.append(this.mTotalIOs);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final CloseableAddableIterator<LDEVStats> callback;
        private final Robj_interface_LDEVStatisticInfo stat;
        private final TaskProcessor theTask;
        private final String serialNum;

        public WorkerThread(CloseableAddableIterator<LDEVStats> callback, String serialNum, Robj_interface_LDEVStatisticInfo stat, TaskProcessor task) {
            this.callback = callback;
            this.stat = stat;
            this.theTask = task;
            this.serialNum = serialNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                if (!this.theTask.shouldStop()) {
                    LDEVStats ret = new LDEVStats(this.serialNum, this.stat);
                    this.callback.add((Object)ret);
                }
            }
            catch (Throwable e) {
                WBEMException we;
                if (e.getClass().isInstance(WBEMException.class)) {
                    we = (WBEMException)e;
                } else {
                    Throwable t = e;
                    while (null != t.getCause()) {
                        t = t.getCause();
                    }
                    we = new WBEMException(1, "Exception while processing items", null, t);
                }
                this.callback.setException(we);
                this.theTask.setStop(true);
            }
            finally {
                int counter = this.theTask.taskDone();
                if (counter < 1) {
                    this.callback.done();
                }
            }
        }
    }
}

