/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheStarter;
import com.hitachi.smi.cache.DeviceData;
import com.hitachi.smi.cache.HealthStateMonitor;
import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderProperties;
import com.ws.wbem.jserver.DaemonThreadFactory;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;
import sanproject.common.Robj_interface_DISKgetSubsystemInfoEx2;
import sanproject.serverux.data.GetRmiException;

public class RMIObjectMapping {
    private static final Map<String, String> virtual2RealMap = new HashMap<String, String>();
    private static AbstractSet<DeviceData> managedDevices = new HashSet<DeviceData>();
    private static Map<String, RMIObjectMapping> rmiObjects = new HashMap<String, RMIObjectMapping>();
    private static final String VENDOR_HITACHI = "HITACHI";
    private static final String MGT_CONSOLE_HITACHI = "Device Manager WebService";
    private static String embeddedSerial = null;
    private static Exception exceptionOccurred = null;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private volatile Robj_interface_DISKgetSubsystemInfoEx2 mSysInfo = null;
    private RMIObjectCache rmiObj;
    private String mVendor = "UNKNOWN";
    private String mModel = "UNKNOWN";
    private volatile String mSerialNumber = "UNKNOWN";
    private String mMgtConsole = "UNKNOWN";
    private String StorageVolumeName = null;

    public static Collection<RMIObjectMapping> getAllRMIObjectMappings() {
        return rmiObjects.values();
    }

    public static RMIObjectMapping getEmbeddedRMIObjectMapping() {
        if (ProviderProperties.isEmbedded()) {
            while (null == embeddedSerial) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    mLogger.log(Level.INFO, "Sleep interuptted waiting for embedded serial", e);
                }
            }
            return RMIObjectMapping.getRMIObjectMapping(embeddedSerial);
        }
        throw new IllegalArgumentException("getEmbeddedRMIObjectMapping() can only be used when in embedded mode");
    }

    public static final RMIObjectMapping getRMIObjectMapping(String serialNumber) {
        String realSerial;
        RMIObjectMapping ret = rmiObjects.get(serialNumber);
        if (null == ret && null != (realSerial = virtual2RealMap.get(serialNumber))) {
            ret = rmiObjects.get(realSerial);
        }
        return ret;
    }

    public static void initializeRMIMapping(ProviderHandle handle) throws WBEMException {
        RMIObjectMapping.populateManagedDevices(handle);
        if (0 == managedDevices.size()) {
            throw new WBEMException("Unable to find any devices to manage");
        }
        Thread t = new Thread((Runnable)new RMIInitializerThread(), "RMI object initializer thread");
        t.setDaemon(true);
        t.start();
    }

    private static final int populateManagedDevices(ProviderHandle handle) throws WBEMException {
        boolean stop = false;
        int count = 0;
        while (!stop) {
            try {
                DeviceData dev;
                if (ProviderProperties.isEmbedded()) {
                    dev = new DeviceData();
                    stop = true;
                } else {
                    dev = new DeviceData(++count);
                }
                managedDevices.add(dev);
            }
            catch (FileNotFoundException fne) {
                if (1 == count && !ProviderProperties.isEmbedded()) {
                    int seconds = ProviderProperties.getLockWaitTime();
                    mLogger.log(Level.SEVERE, "Unable to locate required properties file, will retry in {0} seconds", seconds);
                    count = 0;
                    try {
                        Thread.sleep(seconds * 1000);
                    }
                    catch (InterruptedException ie) {}
                    continue;
                }
                stop = true;
            }
        }
        return count;
    }

    static final boolean setVirtual2RealMapping(String virtSerial, String realSerial) {
        boolean ret;
        String val = virtual2RealMap.get(virtSerial);
        if (null != val) {
            ret = val.equalsIgnoreCase(realSerial);
        } else {
            virtual2RealMap.put(virtSerial, realSerial);
            ret = true;
        }
        return ret;
    }

    public RMIObjectMapping(DeviceData dd) throws WBEMException {
        try {
            this.rmiObj = new RMIObjectCache(dd, this);
            this.getStorageSystemName();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Unable to get RMI connection to " + dd.getDeviceHostName(), null, e);
        }
    }

    public UnsignedInteger16 getHostMode(byte pHost) {
        boolean isHitachiSystem = this.isHitachiSystem();
        UnsignedInteger16 ret = ProviderConstants.UINT16_ZED;
        switch (pHost) {
            case 0: {
                ret = ProviderConstants.UINT16_ZED;
                break;
            }
            case 1: {
                ret = ProviderConstants.UINT16_ONE;
                break;
            }
            case 5: {
                ret = ProviderConstants.UINT16_FIVE;
                break;
            }
            case 7: {
                ret = ProviderConstants.UINT16_SEVEN;
                break;
            }
            case 9: {
                ret = ProviderConstants.UINT16_NINE;
                break;
            }
            case 10: {
                ret = ProviderConstants.UINT16_TEN;
                break;
            }
            case 12: {
                ret = ProviderConstants.UINT16_TWELVE;
                break;
            }
            case 15: {
                ret = new UnsignedInteger16(15);
                break;
            }
            case 33: {
                ret = new UnsignedInteger16(33);
                break;
            }
            case 44: {
                ret = new UnsignedInteger16(44);
                break;
            }
            case 76: {
                ret = new UnsignedInteger16(76);
                break;
            }
            case 3: {
                if (isHitachiSystem) {
                    ret = ProviderConstants.UINT16_THREE;
                    break;
                }
                mLogger.log(Level.SEVERE, "Host mode is 0x03 but shouldn't be");
                break;
            }
            case 8: {
                if (isHitachiSystem) {
                    mLogger.log(Level.SEVERE, "Host mode is 0x08 but shouldn't be");
                    break;
                }
                ret = ProviderConstants.UINT16_EIGHT;
            }
        }
        return ret;
    }

    public String getMgtConsoleName() throws Exception {
        if (this.mMgtConsole == null || this.mMgtConsole.equals("UNKNOWN")) {
            this.isHitachiSystem();
        }
        return this.mMgtConsole;
    }

    public String getModel() throws WBEMException {
        if ("UNKNOWN".equals(this.mModel)) {
            VendorAndType vt = this.getVendorAndType();
            if (VendorAndType.HITACHI_HM800 == vt || VendorAndType.HITACHI_HM850 == vt) {
                this.mModel = this.getRMIObject().getSMIHm8XXModelName();
            } else {
                mLogger.log(Level.SEVERE, "Unknown model detected: {0}", (Object)vt);
            }
        }
        return this.mModel;
    }

    public UnsignedInteger16 getPortRole(Byte pPortKind) {
        UnsignedInteger16 ret;
        switch (pPortKind) {
            case 0: {
                ret = ProviderConstants.UINT16_ZED;
                break;
            }
            case 3: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 4: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 5: {
                ret = ProviderConstants.UINT16_TWO;
                break;
            }
            case 6: {
                ret = ProviderConstants.UINT16_TWO;
                break;
            }
            default: {
                ret = ProviderConstants.UINT16_ZED;
            }
        }
        return ret;
    }

    public RMIObjectCache getRMIObject() throws WBEMException {
        if (null == this.rmiObj) {
            throw new WBEMException("No RMI object for device with serial number " + this.mSerialNumber);
        }
        return this.rmiObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() throws WBEMException {
        String ret = this.mSerialNumber;
        if ("UNKNOWN".equals(ret)) {
            RMIObjectMapping rMIObjectMapping = this;
            synchronized (rMIObjectMapping) {
                ret = this.mSerialNumber;
                if ("UNKNOWN".equals(ret)) {
                    Robj_interface_DISKgetSubsystemInfoEx2 info = this.getSubsystemInfo();
                    if (null != info) {
                        ret = String.valueOf(info.getStrDKCFullSerialNumber());
                    } else {
                        WBEMException we = null;
                        we = null == exceptionOccurred ? new WBEMException(1, "Serial number is NULL") : new WBEMException(1, "Serial number is NULL", null, (Throwable)exceptionOccurred);
                        throw we;
                    }
                }
                this.mSerialNumber = ret;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getStorageSystemName() throws WBEMException {
        if (null == this.StorageVolumeName) {
            RMIObjectMapping rMIObjectMapping = this;
            synchronized (rMIObjectMapping) {
                if (null == this.StorageVolumeName) {
                    this.isHitachiSystem();
                    String model = this.getModel();
                    String serialNumber = this.getSerialNumber();
                    this.StorageVolumeName = model + "." + serialNumber;
                }
            }
        }
        return this.StorageVolumeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Robj_interface_DISKgetSubsystemInfoEx2 getSubsystemInfo() {
        if (this.mSysInfo != null) return this.mSysInfo;
        Class<RMIObjectMapping> clazz = RMIObjectMapping.class;
        synchronized (RMIObjectMapping.class) {
            if (this.mSysInfo != null) return this.mSysInfo;
            if (null != this.rmiObj) {
                Throwable e = null;
                try {
                    this.mSysInfo = (Robj_interface_DISKgetSubsystemInfoEx2)this.rmiObj.getSubsystemInfoEx();
                }
                catch (RemoteException re) {
                    e = re;
                }
                catch (GetRmiException ge) {
                    e = ge;
                }
                if (null != this.mSysInfo) return this.mSysInfo;
                mLogger.log(Level.SEVERE, "SVP getSubSystemInfo returned null", e);
            } else {
                mLogger.log(Level.SEVERE, "Unable to get system info, RMI object null");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mSysInfo;
        }
    }

    public String getVendor() throws Exception {
        if (this.mVendor == null || this.mVendor.equals("UNKNOWN")) {
            this.isHitachiSystem();
        }
        return this.mVendor;
    }

    public VendorAndType getVendorAndType() throws WBEMException {
        String vendor;
        VendorAndType ret = VendorAndType.DEFAULT;
        String storageType = this.getRMIObject().smisGetStorageType();
        try {
            vendor = this.getVendor();
        }
        catch (Exception e) {
            vendor = "UNKNOWN";
        }
        if (VENDOR_HITACHI.equals(vendor)) {
            if ("HM800".equals(storageType)) {
                ret = VendorAndType.HITACHI_HM800;
            } else if ("HM850".equals(storageType)) {
                ret = VendorAndType.HITACHI_HM850;
            }
        }
        return ret;
    }

    public boolean isHitachiSystem() {
        boolean ret = true;
        if (this.rmiObj != null) {
            this.setVendorString();
            this.setMgtConsole();
        } else {
            mLogger.log(Level.SEVERE, "unable to determine vendor, no connection");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMgtConsole() {
        if (null == this.mMgtConsole || this.mMgtConsole.equals("UNKNOWN")) {
            RMIObjectMapping rMIObjectMapping = this;
            synchronized (rMIObjectMapping) {
                if (null == this.mMgtConsole || this.mMgtConsole.equals("UNKNOWN")) {
                    try {
                        VendorAndType vt = this.getVendorAndType();
                        if (VendorAndType.HITACHI_HM800 == vt || VendorAndType.HITACHI_HM850 == vt) {
                            this.mMgtConsole = MGT_CONSOLE_HITACHI;
                        }
                    }
                    catch (WBEMException e) {
                        mLogger.log(Level.WARNING, "Failed to get vendor type will default to UNKNOWN", e);
                        this.mMgtConsole = "UNKNOWN";
                    }
                }
            }
        }
    }

    private synchronized void setVendorString() {
        if (null == this.mVendor || this.mVendor.equals("UNKNOWN")) {
            this.mVendor = VENDOR_HITACHI;
        }
    }

    public String toString() {
        return this.mSerialNumber;
    }

    public static enum VendorAndType {
        HITACHI_HM800,
        HITACHI_HM850,
        DEFAULT;

    }

    private static final class RMIInitializerThread
    implements Runnable {
        static List<CacheStarter> threads = new ArrayList<CacheStarter>();
        private ExecutorService exec = null;

        private RMIInitializerThread() {
        }

        private final void initializeRMIObjects() {
            Iterator iter = managedDevices.iterator();
            while (iter.hasNext()) {
                DeviceData dd = (DeviceData)iter.next();
                mLogger.log(Level.INFO, "Attempting to connect to {0}", dd.getDeviceHostName());
                try {
                    RMIObjectMapping mapping = new RMIObjectMapping(dd);
                    String serialNum = mapping.getSerialNumber();
                    mLogger.log(Level.INFO, "Connected to {0} it will be referred to as {1} now", new Object[]{dd.getDeviceHostName(), serialNum});
                    if (ProviderProperties.isEmbedded()) {
                        embeddedSerial = serialNum;
                    }
                    CacheStarter cs = new CacheStarter(mapping);
                    this.exec.execute(cs);
                    threads.add(cs);
                    rmiObjects.put(serialNum, mapping);
                    iter.remove();
                }
                catch (WBEMException we) {
                    mLogger.log(Level.SEVERE, "Could not get RMI object for " + dd.getDeviceHostName(), we);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RMIInitializerThread rMIInitializerThread = this;
            synchronized (rMIInitializerThread) {
                if (null == this.exec) {
                    this.exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() < 2 ? 2 : Runtime.getRuntime().availableProcessors(), (ThreadFactory)new DaemonThreadFactory());
                }
            }
            boolean firstRun = true;
            mLogger.info("RMI initializer starting to populate cache for " + managedDevices.size() + " managed devices");
            while (0 != managedDevices.size()) {
                if (firstRun) {
                    firstRun = false;
                } else {
                    try {
                        int wait = ProviderProperties.getVersionCheckIntervalSeconds();
                        mLogger.log(Level.INFO, "Waiting for {0} managed devices...", managedDevices.size());
                        Thread.sleep(wait * 1000);
                    }
                    catch (InterruptedException e) {
                        mLogger.log(Level.WARNING, "Sleep interrupted - non-fatal", e);
                    }
                }
                try {
                    this.initializeRMIObjects();
                }
                catch (Throwable t) {
                    mLogger.log(Level.SEVERE, "Unexpected exception while initailizing RMI Objects", t);
                }
            }
            int count = -1;
            while (0 != threads.size() && !HitachiCacheMangerService.isShuttingDown()) {
                this.validateCacheStatus();
                int numLeft = threads.size();
                if (0 == numLeft) continue;
                if (0 == ++count % 15) {
                    mLogger.log(Level.INFO, "{0} CacheStarters are not done, waiting...", numLeft);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    mLogger.log(Level.WARNING, "Sleep interrupted - non-fatal", e);
                }
            }
            threads = null;
            this.exec.shutdownNow();
            this.exec = null;
            HealthStateMonitor.startHealthStateMonitor();
            mLogger.info("RMI Initializer thread exiting.");
        }

        private void validateCacheStatus() {
            Iterator<CacheStarter> iter = threads.iterator();
            mLogger.log(Level.FINE, "Validating {0} cache threads", threads.size());
            while (iter.hasNext()) {
                CacheStarter cs = iter.next();
                if (cs.isProcessing()) continue;
                if (!cs.isProcessingError()) {
                    iter.remove();
                    continue;
                }
                if (cs.isCacheStarterReAddedToThreadPool()) continue;
                cs.CacheStarterReAddedToThreadPool();
                this.exec.execute(cs);
            }
        }
    }
}

