/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.instrumentation.ReferenceInterface;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class ReferenceInfo {
    private CIMObjectPath mReference1;
    private CIMObjectPath mReference2;
    private final String mRef1Role;
    private final String mRef2Role;
    private final String[] mPropertyList;
    private final boolean mIsObjectPath;
    private final ReferenceInterface mRefInterface;

    public ReferenceInfo(CIMObjectPath reference1, CIMObjectPath reference2, String ref1Role, String ref2Role, String[] pPropertyList, boolean pIsObjectPath, ReferenceInterface pRefInterface) throws WBEMException {
        if (reference1 != null && reference2 != null) {
            throw new WBEMException(1, "ReferenceInfo CTOR: Either the reference1 or reference2must be null");
        }
        if (pRefInterface == null) {
            throw new WBEMException(1, "ReferenceInfo CTOR: ReferenceInterface can not be null");
        }
        this.mReference1 = reference1;
        this.mReference2 = reference2;
        this.mRef1Role = ref1Role;
        this.mRef2Role = ref2Role;
        this.mPropertyList = pPropertyList;
        this.mIsObjectPath = pIsObjectPath;
        this.mRefInterface = pRefInterface;
    }

    public synchronized void addReference(CustomCloseableIterator<?> iter, CIMObjectPath pReference) {
        boolean ref1Null = true;
        if (null == this.mReference1) {
            this.mReference1 = pReference;
        } else {
            ref1Null = false;
            this.mReference2 = pReference;
        }
        this.mRefInterface.AddReference(iter, pReference, this);
        if (ref1Null) {
            this.mReference1 = null;
        } else {
            this.mReference2 = null;
        }
    }

    public synchronized String[] getPropertyList() {
        return this.mPropertyList;
    }

    public synchronized CIMObjectPath getReference1() {
        return this.mReference1;
    }

    public synchronized String getReference1Role() {
        return this.mRef1Role;
    }

    public synchronized CIMObjectPath getReference2() {
        return this.mReference2;
    }

    public synchronized String getReference2Role() {
        return this.mRef2Role;
    }

    public synchronized boolean isObjectPath() {
        return this.mIsObjectPath;
    }
}

