/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class AllocatedSnapshotTargetResourcesInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo || !isObjectPath) {
                    CIMInstance theInst = this.generateInstance(op, propertyList, device.getRMIObject());
                    if (null != refInfo) {
                        refInfo.addReference(iter, theInst.getObjectPath());
                        continue;
                    }
                    iter.add(theInst);
                    continue;
                }
                iter.add(this.generateObjectPath(op, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        String caption = "HITACHI_AllocatedSnapshotTargetResources".substring("HITACHI_".length());
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("CollectionDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"SNIA:Target Volumes"}, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)caption, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_AllocatedSnapshotTargetResources");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String instID = this.getInstanceID(rmiObj.getSMISMappingContainer());
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_AllocatedSnapshotTargetResources", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String thisInstID = this.getInstanceID(device);
            if (!thisInstID.equalsIgnoreCase(instID)) {
                throw new WBEMException(6, op.toString());
            }
            CIMInstance inst = this.generateInstance(op, propertyList, device.getRMIObject());
            return inst;
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private String getInstanceID(RMIObjectMapping device) throws Exception {
        StringBuilder instID = new StringBuilder(device.getStorageSystemName());
        instID.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        instID.append("SnapshotTarget");
        return instID.toString();
    }
}

