/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class ArrayGroupInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ArrayGroup", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ArrayGroup added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ArrayGroup", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ArrayGroup deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ArrayGroup", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                ChassisArrayGroup cag = (ChassisArrayGroup)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
                RMIObjectCache rmiObj = device.getRMIObject();
                ChassisArrayGroup newInst = ChassisArrayGroup.find(rmiObj, cag.getChassisArrayID(), null, null, false);
                if (newInst != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a VDEV that with Device ID: " + cag.getChassisArrayID());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ArrayGroup modified indication instance", t);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            int fb4 = -1;
            int pg = -1;
            int vdev = -1;
            int ag = -1;
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"SystemName", "InstanceID"});
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    mLogger.log(Level.SEVERE, "Enumerate called with non-null expectedValues, however; insf. # of managed devices found. Found {0}devices, expectedVals: {1}", new Object[]{devices.size(), expectedValues});
                    iter.done();
                    return;
                }
                String expInstID = (String)expectedValues.get("InstanceID");
                if (expInstID != null) {
                    Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                    fb4 = rets[0];
                    ag = rets[1];
                } else {
                    String deviceID = (String)expectedValues.get("DeviceID");
                    if (null != deviceID) {
                        if (devices.size() != 1) {
                            mLogger.log(Level.SEVERE, "");
                            if (null == iter) return;
                            iter.done();
                            return;
                        }
                        DeviceNumber dn = DeviceNumber.find(deviceID, devices.get(0).getRMIObject());
                        if (dn == null) {
                            mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, no device infoavailable. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_StoragePool", expectedValues, devices.size()});
                            if (null == iter) return;
                            iter.done();
                            return;
                        }
                        fb4 = dn.getFb4();
                        pg = dn.getPg();
                        vdev = dn.getVdev();
                    } else {
                        Integer expPG;
                        Integer expFB4 = (Integer)expectedValues.get("fb4");
                        if (null != expFB4) {
                            fb4 = expFB4;
                        }
                        if (null != (expPG = (Integer)expectedValues.get("pg"))) {
                            pg = expPG;
                        }
                    }
                }
            }
            Iterator<RMIObjectMapping> i$ = devices.iterator();
            while (i$.hasNext()) {
                RMIObjectMapping device = i$.next();
                PassthruIterator deviceIter = new PassthruIterator(iter);
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(deviceIter, isObjectPath, refInfo, op, propertyList, ag);
                ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, isObjectPath, fb4, pg, vdev, ag);
            }
            return;
        }
        catch (WBEMException we) {
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        try {
            CIMInstance instRet = null;
            if (null != op && null != cag) {
                CIMProperty[] retProps;
                CIMProperty[] keys = retOP.getKeys();
                String name = String.valueOf(cag.getChassis()) + "." + cag.getArrayGroup();
                if (null == propList || propList.length > 0) {
                    ArrayList<CIMProperty> props = new ArrayList<CIMProperty>();
                    props.add(keys[0]);
                    props.add(keys[1]);
                    props.add(keys[2]);
                    props.add(keys[3]);
                    UnsignedInteger16 value = cag.getConsistsOf(null);
                    props.add(new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)value, false));
                    UnsignedInteger64 cvNumBlocks = cag.getNumberOfBlocks();
                    props.add(new CIMProperty("NumberOfBlocks", CIMDataType.UINT64_T, (Object)cvNumBlocks, false));
                    props.add(new CIMProperty("ExtentStripeLength", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ONE, false));
                    boolean raid1Plus = true;
                    if (cag.getRaidLevel().compareTo("UNKNOWN") == 0 || cag.getRaidLevel().equalsIgnoreCase("RAID0")) {
                        raid1Plus = false;
                    }
                    props.add(new CIMProperty("IsConcatenated", CIMDataType.BOOLEAN_T, (Object)(!raid1Plus ? 1 : 0), false));
                    String rl = cag.getRaidLevel();
                    props.add(new CIMProperty("ErrorMethodology", CIMDataType.STRING_T, (Object)rl, false));
                    UnsignedInteger64 cvBlocKSize = cag.getBlockSize();
                    props.add(new CIMProperty("BlockSize", CIMDataType.UINT64_T, (Object)cvBlocKSize, false));
                    UnsignedInteger64 cvConsumableBlocks = cag.getConsumableblocks();
                    props.add(new CIMProperty("ConsumableBlocks", CIMDataType.UINT64_T, (Object)cvConsumableBlocks, false));
                    props.add(new CIMProperty("IsBasedOnUnderlyingRedundancy", CIMDataType.BOOLEAN_T, (Object)raid1Plus, false));
                    props.add(new CIMProperty("SequentialAccess", CIMDataType.BOOLEAN_T, (Object)false, false));
                    UnsignedInteger16[] cvExtentStatus = new UnsignedInteger16[]{ProviderConstants.UINT16_SIX};
                    props.add(new CIMProperty("ExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)cvExtentStatus, false));
                    props.add(new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)raid1Plus, false));
                    int valDataRedundency = ProviderLibs.getDataRedudancy(cag.getRaidLevel());
                    UnsignedInteger16 cvDataRedundancy = new UnsignedInteger16(valDataRedundency);
                    props.add(new CIMProperty("DataRedundancy", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false));
                    int valPackageRedundancy = ProviderLibs.getPackageRedudancy(cag.getRaidLevel());
                    UnsignedInteger16 cvPackageRedundancy = new UnsignedInteger16(valPackageRedundancy);
                    props.add(new CIMProperty("PackageRedundancy", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false));
                    props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false));
                    props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, false));
                    props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false));
                    props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
                    props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false));
                    props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false));
                    props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
                    props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderLibs.getHealthState4CAG(cag.getSerialNumber(), cag.getFb4(), cag.getPg()), false));
                    props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)name, false));
                    props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)name, false));
                    props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)name, false));
                    String[] extentDiscriminator = 65 <= cag.getFb4() && cag.getFb4() <= 96 || 16485 <= cag.getFb4() && cag.getFb4() <= 16516 ? new String[]{"SNIA:Intermediate", "SNIA:Composite"} : new String[]{"SNIA:Pool Component", "SNIA:Composite"};
                    props.add(new CIMProperty("ExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)extentDiscriminator, false));
                    retProps = props.toArray(new CIMProperty[props.size()]);
                } else {
                    retProps = new CIMProperty[]{};
                }
                instRet = new CIMInstance(retOP, retProps).filterProperties(propList);
            }
            return instRet;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        CIMObjectPath ret;
        block5: {
            ProviderLibs.validateVARArgs(new Class[]{ChassisArrayGroup.class}, o, "HITACHI_ArrayGroup");
            ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
            ret = null;
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
            try {
                String systemName;
                if (null == op) break block5;
                try {
                    systemName = device.getStorageSystemName();
                }
                catch (Throwable th) {
                    throw new WBEMException(1, th.toString(), null, th);
                }
                String deviceID = cag.getChassisArrayID();
                CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_ArrayGroup", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true)};
                ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ArrayGroup", keys, op.getXmlSchemaName());
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            String sysNameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == deviceIDKeyVal || null == sysNameKeyVal || null == ccName || !ccName.equals("HITACHI_ArrayGroup") || null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
            ChassisArrayGroup data = ChassisArrayGroup.find(device.getRMIObject(), false, deviceIDKeyVal);
            if (data != null) {
                return this.generateInstance(op, propertyList, data);
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_ArrayGroup".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_ArrayGroup".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_ArrayGroup".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.VDEV, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.VDEV, this, null);
        }
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        private final int mArrayGroup;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, int ag) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mArrayGroup = ag;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E cag = item;
                        if (this.mArrayGroup != -1) {
                            ret = ((ChassisArrayGroup)cag).getArrayGroup() != this.mArrayGroup;
                        }
                        if (-1 != this.mArrayGroup && (this.mArrayGroup == -1 || ret)) break block7;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, ArrayGroupInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block7;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(ArrayGroupInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block7;
                        }
                        this.mIter.add(ArrayGroupInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, cag));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

